/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.model.ext;

import com.tssap.j2ee.model.ext.SemanticCheckerHelper;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.core.resources.IFile;

public class SapConfigSemanticChecker {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$tssap$j2ee$model$ext$SapConfigSemanticChecker == null ? (class$com$tssap$j2ee$model$ext$SapConfigSemanticChecker = SapConfigSemanticChecker.class$("com.tssap.j2ee.model.ext.SapConfigSemanticChecker")) : class$com$tssap$j2ee$model$ext$SapConfigSemanticChecker));
    private static final int MAX_STRING = 1300;
    private static final int MAX_CONFIG_ENTRY_LENGTH = 256;
    private static final String[] FORBIDDEN_CONFIGNAME_CHARS = new String[]{"%", "[", "]", "#", "/"};
    private static final String FORBIDDEN_CONFIGNAME_CHARS_AS_STRING = "'%', '[', ']', '#', '/'";
    static /* synthetic */ Class class$com$tssap$j2ee$model$ext$SapConfigSemanticChecker;

    public static void semanticCheck(IFile file) {
        String METHOD = "semanticCheck()";
        try {
            SemanticCheckerHelper.removeAllMarkers(file);
            Properties properties = SapConfigSemanticChecker.semanticCheckParseFile(file);
            if (properties != null) {
                SapConfigSemanticChecker.semanticCheckStringLength(file, properties);
                SapConfigSemanticChecker.semanticCheckForbiddenCharacters(file, properties);
            }
        }
        catch (Exception e) {
            TRACER.error("semanticCheck()", "Problems in semantic-check: " + e.toString(), (Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties semanticCheckParseFile(IFile file) {
        METHOD = "semanticCheckParseFile()";
        in = null;
        try {
            try {
                properties = new Properties();
                in = file.getContents();
                properties.load(in);
                var4_5 = properties;
                var6_6 = null;
            }
            catch (Exception e) {
                SemanticCheckerHelper.addMarker(file, "Can not parse properties-file: " + e.toString(), -1, 2, false);
                SapConfigSemanticChecker.TRACER.warning("semanticCheckParseFile()", "Problems in semantic-check, can not parse file '" + file.getName() + "'. Reason: " + e.toString(), (Throwable)e);
                var6_7 = null;
                try {
                    if (in == null) return null;
                    in.close();
                    return null;
                }
                catch (Exception e) {
                    SapConfigSemanticChecker.TRACER.warning("semanticCheckParseFile()", "Can not close file-handle for file '" + file.getName() + "'. There might be problems, that the file can not be accessed any more. If such problems happen you should restart the IDE.", (Throwable)e);
                    return null;
                }
            }
        }
        catch (Throwable var5_12) {
            var6_8 = null;
            ** try [egrp 2[TRYBLOCK] [2 : 127->138)] { 
lbl28:
            // 1 sources

            if (in == null) throw var5_12;
            in.close();
            throw var5_12;
lbl31:
            // 1 sources

            catch (Exception e) {
                SapConfigSemanticChecker.TRACER.warning("semanticCheckParseFile()", "Can not close file-handle for file '" + file.getName() + "'. There might be problems, that the file can not be accessed any more. If such problems happen you should restart the IDE.", (Throwable)e);
            }
            throw var5_12;
        }
        ** try [egrp 2[TRYBLOCK] [2 : 127->138)] { 
lbl36:
        // 1 sources

        if (in == null) return var4_5;
        in.close();
        return var4_5;
lbl39:
        // 1 sources

        catch (Exception e) {
            SapConfigSemanticChecker.TRACER.warning("semanticCheckParseFile()", "Can not close file-handle for file '" + file.getName() + "'. There might be problems, that the file can not be accessed any more. If such problems happen you should restart the IDE.", (Throwable)e);
        }
        return var4_5;
    }

    private static void semanticCheckStringLength(IFile file, Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String value = properties.getProperty(name);
            if (name.length() > 256) {
                SemanticCheckerHelper.addMarker(file, "The property-name '" + name + "' is too long. It must not exceed " + 256 + "characters.", -1, 2, false);
            }
            if (value.length() <= 1300) continue;
            SemanticCheckerHelper.addMarker(file, "The property-value '" + value + "' for the property-name '" + name + "' is too long. It must not exceed " + 1300 + "characters.", -1, 2, false);
        }
    }

    private static void semanticCheckForbiddenCharacters(IFile file, Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            if (!SapConfigSemanticChecker.containsForbiddenCharacter(name)) continue;
            SemanticCheckerHelper.addMarker(file, "The property-name '" + name + "' contains forbidden characters. The following characters are not allowed: " + FORBIDDEN_CONFIGNAME_CHARS_AS_STRING, -1, 2, false);
        }
    }

    private static final boolean containsForbiddenCharacter(String s) {
        int i = 0;
        while (i < FORBIDDEN_CONFIGNAME_CHARS.length) {
            if (s.indexOf(FORBIDDEN_CONFIGNAME_CHARS[i]) >= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

