/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.model.ext;

import com.tssap.j2ee.model.ext.TypeSignatureWrapper;
import java.util.ArrayList;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;

public class JavaAnalyzer {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static TypeSignatureWrapper getMethodReturnType(IJavaProject javaProject, String className, String methodName) throws Exception {
        return JavaAnalyzer.getMethodReturnType(javaProject, className, methodName, EMPTY_STRING_ARRAY);
    }

    public static TypeSignatureWrapper getMethodReturnType(IJavaProject javaProject, String className, String methodName, String[] methodParameter) throws Exception {
        IType type = javaProject.findType(className);
        if (type == null) {
            throw new Exception("Can not find class '" + className + "' in the classpath.");
        }
        String[] methodParameterSignature = new String[methodParameter.length];
        int i = 0;
        while (i < methodParameter.length) {
            methodParameterSignature[i] = JavaAnalyzer.getSignatureForTypeInsideType(type, methodParameter[i]);
            ++i;
        }
        IMethod method = type.getMethod(methodName, methodParameterSignature);
        TypeSignatureWrapper typeSignature = new TypeSignatureWrapper(type, method.getReturnType());
        return typeSignature;
    }

    public static String getSignatureForTypeInsideType(IType outside, String inside) throws Exception {
        String modifiedInside = inside;
        if (modifiedInside.lastIndexOf(46) >= 0) {
            modifiedInside = modifiedInside.substring(modifiedInside.lastIndexOf(46) + 1);
        }
        String signature = Signature.createTypeSignature((String)modifiedInside, (boolean)false);
        return signature;
    }

    public static boolean hasPublicEmptyConstructor(IJavaProject javaProject, String fullClassName) throws Exception {
        IType type = javaProject.findType(fullClassName);
        boolean noConstructors = true;
        IMethod[] methods = type.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].isConstructor()) {
                noConstructors = false;
                if (Flags.isPublic((int)methods[i].getFlags()) && methods[i].getNumberOfParameters() == 0) {
                    return true;
                }
            }
            ++i;
        }
        return noConstructors;
    }

    public static IField[] getPublicFields(IJavaProject javaProject, String fullClassName, boolean recursive) throws Exception {
        String superclassName;
        ArrayList<IField> resultList = new ArrayList<IField>();
        IType type = javaProject.findType(fullClassName);
        IField[] fields = type.getFields();
        int i = 0;
        while (i < fields.length) {
            if (Flags.isPublic((int)fields[i].getFlags()) && !Flags.isStatic((int)fields[i].getFlags())) {
                resultList.add(fields[i]);
            }
            ++i;
        }
        if (recursive && (superclassName = type.getSuperclassName()) != null) {
            IField[] superFields = JavaAnalyzer.getPublicFields(javaProject, superclassName, recursive);
            int i2 = 0;
            while (i2 < superFields.length) {
                resultList.add(superFields[i2]);
                ++i2;
            }
        }
        IField[] result = new IField[resultList.size()];
        resultList.toArray(result);
        return result;
    }
}

