/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.complib.xml;

import com.sap.tc.complib.xml.Attribute;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public final class XMLWriter {
    public static final String ATTR_XMLNS = "xmlns";
    public static final String ATTR_XMLNS_XSI = "xmlns:xsi";
    public static final String ATTR_XSI_LOCATION = "xsi:schemaLocation";
    public static final String XSI_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    private OutputStream out;
    private StringBuffer sb = new StringBuffer();
    private String rootTag;
    private int tabLevel = 0;
    private char[] indent = new char[33];
    private boolean wrapAttributes;
    private static final int MAX_INDENT_LEVEL = 32;

    public XMLWriter() {
        Arrays.fill(this.indent, '\t');
    }

    public XMLWriter(OutputStream out) {
        this();
        this.out = out;
    }

    public void wrapAttributeLists(boolean enable) {
        this.wrapAttributes = enable;
    }

    public void beginDocument() {
        this.sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
    }

    public void beginDocument(String publicID, String dtdLocation) {
        this.sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
        if (publicID != null && dtdLocation != null) {
            this.sb.append("<!DOCTYPE ").append(this.rootTag);
            this.sb.append(" PUBLIC \"").append(publicID).append("\"");
            this.sb.append(" \"").append(dtdLocation).append("\"");
            this.sb.append(">\r\n");
        }
    }

    public void endDocument() {
        this.undent();
        this.sb.append("</").append(this.rootTag).append(">");
    }

    public void writeRootTag(String tagName) {
        this.rootTag = tagName;
        this.sb.append("<").append(this.rootTag).append(">\r\n");
        this.indent();
    }

    public void writeRootTag(String tagName, Attribute[] attributes) {
        this.rootTag = tagName;
        this.sb.append("<").append(this.rootTag);
        if (attributes != null) {
            this.writeAttributes(attributes);
        }
        this.sb.append(">\r\n");
        this.indent();
    }

    public void writeRootTag(String tagName, String namespaceURI, String schemaLocation, Attribute[] attributes) {
        this.rootTag = tagName;
        this.sb.append("<").append(this.rootTag);
        if (attributes != null) {
            this.writeAttributes(attributes);
        }
        if (namespaceURI != null && schemaLocation != null) {
            this.sb.append(" xmlns=\"").append(namespaceURI);
            this.sb.append("\" xmlns:xsi=\"").append(XSI_NAMESPACE);
            this.sb.append("\" xsi:schemaLocation=\"").append(namespaceURI).append(" ");
            this.sb.append(schemaLocation).append("\"");
        }
        this.sb.append(">\r\n");
        this.indent();
    }

    public void beginTag(String tagName) {
        this.sb.append(this.indent, 0, this.tabLevel);
        this.sb.append("<").append(tagName).append(">\r\n");
        this.indent();
    }

    public void beginTag(String tagName, Attribute[] attributes) {
        this.sb.append(this.indent, 0, this.tabLevel);
        this.sb.append("<").append(tagName);
        if (attributes != null) {
            this.writeAttributes(attributes);
        }
        this.sb.append(">\r\n");
        this.indent();
    }

    public void endTag(String tagName) {
        this.undent();
        this.sb.append(this.indent, 0, this.tabLevel);
        this.sb.append("</").append(tagName).append(">\r\n");
    }

    public void writeTag(String tagName, String value) {
        this.sb.append(this.indent, 0, this.tabLevel);
        this.sb.append("<").append(tagName);
        if (value != null) {
            this.sb.append(">");
            this.sb.append(XMLWriter.encodeXml(value));
            this.sb.append("</").append(tagName).append(">\r\n");
        } else {
            this.sb.append("/>\r\n");
        }
    }

    public void writeTag(String tagName, String value, Attribute[] attributes) {
        this.sb.append(this.indent, 0, this.tabLevel);
        this.sb.append("<").append(tagName);
        if (attributes != null) {
            this.writeAttributes(attributes);
        }
        if (value != null) {
            this.sb.append(">");
            this.sb.append(XMLWriter.encodeXml(value));
            this.sb.append("</").append(tagName).append(">\r\n");
        } else {
            this.sb.append("/>\r\n");
        }
    }

    public void writeTag(String tagName, int value) {
        this.sb.append(this.indent, 0, this.tabLevel);
        this.sb.append("<").append(tagName).append(">");
        this.sb.append(Integer.toString(value));
        this.sb.append("</").append(tagName).append(">\r\n");
    }

    public void writeTag(String tagName, long value) {
        this.sb.append(this.indent, 0, this.tabLevel);
        this.sb.append("<").append(tagName).append(">");
        this.sb.append(Long.toString(value));
        this.sb.append("</").append(tagName).append(">\r\n");
    }

    public void writeEmptyTag(String tagName) {
        this.sb.append(this.indent, 0, this.tabLevel);
        this.sb.append("<").append(tagName).append("/>\r\n");
    }

    public void writeEmptyTag(String tagName, Attribute[] attributes) {
        this.sb.append(this.indent, 0, this.tabLevel);
        this.sb.append("<").append(tagName);
        if (attributes != null) {
            this.writeAttributes(attributes);
        }
        this.sb.append("/>\r\n");
    }

    public void write(String content) {
        this.sb.append(content);
    }

    public void serialize() throws IOException {
        if (this.out != null && this.sb.length() > 0) {
            try {
                this.out.write(this.sb.toString().getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                throw new IllegalStateException("Java runtime does not support UTF-8 encoded strings");
            }
            this.sb.setLength(0);
        }
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.flush();
            this.out.close();
        }
    }

    public String toString() {
        return this.sb.toString();
    }

    public static String encodeXml(String plainText) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < plainText.length()) {
            switch (plainText.charAt(i)) {
                case '&': {
                    buffer.append("&amp;");
                    break;
                }
                case '<': {
                    buffer.append("&lt;");
                    break;
                }
                case '>': {
                    buffer.append("&gt;");
                    break;
                }
                case '\'': {
                    buffer.append("&apos;");
                    break;
                }
                case '\"': {
                    buffer.append("&quot;");
                    break;
                }
                default: {
                    buffer.append(plainText.charAt(i));
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    private void indent() {
        if (this.tabLevel < 32) {
            ++this.tabLevel;
        }
    }

    private void undent() {
        if (this.tabLevel > 0) {
            --this.tabLevel;
        }
    }

    private void writeAttributes(Attribute[] attributes) {
        int attrCount = attributes.length;
        int i = 0;
        while (i < attrCount) {
            Attribute a = attributes[i];
            if (a != null && a.name != null && a.name.length() > 0) {
                if (this.wrapAttributes && this.tabLevel < 32) {
                    this.sb.append("\r\n");
                    this.sb.append(this.indent, 0, this.tabLevel + 2);
                }
                this.sb.append(" ").append(a.name);
                this.sb.append("=\"");
                this.sb.append(XMLWriter.encodeXml(a.value)).append("\"");
            }
            ++i;
        }
    }
}

