/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.complib.xml;

import com.sap.tc.complib.xml.Initializable;
import com.sap.tc.complib.xml.ParserException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class ParserAdapter
extends DefaultHandler {
    private Initializable root = null;

    public ParserAdapter(Initializable root) {
        this.root = root;
    }

    public void startElement(String uri, String name, String qualifiedName, Attributes attributes) throws SAXException {
        this.root.startTag(qualifiedName, attributes);
    }

    public void endElement(String uri, String name, String qualifiedName) throws SAXException {
        this.root.endTag(qualifiedName);
    }

    public void characters(char[] chars, int start, int length) {
        this.root.tagValue(chars, start, length);
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        return this.root.resolveEntity(publicId, systemId);
    }

    public void parse(InputStream in) throws SAXException, IOException {
        InputSource source = new InputSource(in);
        XMLReader parser = this.createXMLReader();
        parser.setContentHandler(this);
        parser.setEntityResolver(this);
        this.root.startDocument();
        parser.parse(source);
        this.root.endDocument();
        this.root.buffer = null;
    }

    private XMLReader createXMLReader() {
        XMLReader saxParser;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                saxParser = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
                saxParser.setFeature("http://xml.org/sax/features/namespaces", true);
            }
            catch (SAXNotRecognizedException ex) {
                throw new ParserException("Parser does not support namespace handling.");
            }
            catch (SAXNotSupportedException ex) {
                throw new ParserException("Parser does not support namespace handling.");
            }
            catch (SAXException ex) {
                throw new ParserException("Failed to instantiate XML parser.");
            }
            catch (FactoryConfigurationError ex) {
                throw new ParserException("Failed to instantiate parser factory.");
            }
            catch (ParserConfigurationException ex) {
                throw new ParserException("Failed to instantiate XML parser");
            }
            Object var9_3 = null;
            Thread.currentThread().setContextClassLoader(cl);
        }
        catch (Throwable throwable) {
            Object var9_4 = null;
            Thread.currentThread().setContextClassLoader(cl);
            throw throwable;
        }
        return saxParser;
    }
}

