/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.complib.xml;

import com.sap.tc.complib.validate.MissingElementException;
import com.sap.tc.complib.validate.ValidationException;
import com.sap.tc.complib.xml.Attribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class Initializable {
    protected static final int INIT = 0;
    protected static final int RECOVERY_MODE = 1;
    protected static final int ROOT = 2;
    protected int state = 0;
    protected String recoverTagName;
    protected int recoverMode;
    protected List _extensions;
    protected List _attributes;
    protected String _schemaVersion;
    protected String _apiVersion;
    protected boolean _initialized;
    protected boolean clearBuffer = false;
    protected boolean isEmpty = true;
    protected StringBuffer buffer = new StringBuffer(1024);

    protected void tagValue(char[] chars, int start, int length) {
        if (this.clearBuffer) {
            this.clearBuffer = false;
            this.isEmpty = true;
            this.buffer.setLength(0);
        }
        this.isEmpty = false;
        this.buffer.append(chars, start, length);
    }

    protected boolean isEmptyTag() {
        return this.isEmpty;
    }

    protected String getStringValue() {
        this.clearBuffer = true;
        return this.buffer.toString().trim();
    }

    protected String getStringValue(boolean trim) {
        this.clearBuffer = true;
        return trim ? this.buffer.toString().trim() : this.buffer.toString();
    }

    protected int getIntegerValue() {
        this.clearBuffer = true;
        return Integer.parseInt(this.buffer.toString().trim());
    }

    protected long getLongValue() {
        this.clearBuffer = true;
        return Long.parseLong(this.buffer.toString().trim());
    }

    protected float getFloatValue() {
        this.clearBuffer = true;
        return Float.parseFloat(this.buffer.toString().trim());
    }

    protected double getDoubleValue() {
        this.clearBuffer = true;
        return Double.parseDouble(this.buffer.toString().trim());
    }

    protected boolean getBooleanValue() {
        this.clearBuffer = true;
        String s = this.buffer.toString().trim();
        return s.equals("true") || s.equals("1");
    }

    protected List getAttributes(Attributes attributes) {
        int n = attributes.getLength();
        ArrayList<Attribute> attr = new ArrayList<Attribute>();
        if (n > 0) {
            int i = 0;
            while (i < n) {
                attr.add(new Attribute(attributes.getQName(i), attributes.getValue(i)));
                ++i;
            }
        }
        return attr;
    }

    protected void setAttribute(String name, String value) {
        Iterator iter = this._attributes.iterator();
        while (iter.hasNext()) {
            Attribute attr = (Attribute)iter.next();
            if (!attr.name.equals(name)) continue;
            attr.value = value;
            return;
        }
        this._attributes.add(new Attribute(name, value));
    }

    protected void removeAttribute(String name) {
        Iterator iter = this._attributes.iterator();
        while (iter.hasNext()) {
            Attribute attr = (Attribute)iter.next();
            if (!attr.name.equals(name)) continue;
            iter.remove();
            return;
        }
    }

    protected Attribute[] getAttributes() {
        return this._attributes.toArray(new Attribute[this._attributes.size()]);
    }

    protected void dropTagValue() {
        this.clearBuffer = false;
        this.isEmpty = true;
        this.buffer.setLength(0);
    }

    protected boolean getBooleanValue(String stringValue, String attrName, String element) throws SAXException {
        if ("yes".equalsIgnoreCase(stringValue) || "true".equalsIgnoreCase(stringValue)) {
            return true;
        }
        if ("no".equalsIgnoreCase(stringValue) || "false".equalsIgnoreCase(stringValue)) {
            return false;
        }
        throw new SAXException("Illegal value '" + stringValue + "'  of boolean attribute '" + attrName + "' of element '" + element + "'");
    }

    protected void checkMandatoryAttribute(String attrValue, String attrName, String parentTag) throws SAXException {
        if (attrValue == null) {
            throw new SAXException("Mandatory attribute '" + attrName + "' missing in '" + parentTag + "'");
        }
    }

    protected void checkMandatoryAttributeNotEmpty(String attrValue, String attrName, String parentTag) throws SAXException {
        if (attrValue == null || attrValue.length() == 0) {
            throw new SAXException("Mandatory attribute '" + attrName + "' missing or empty in '" + parentTag + "'");
        }
    }

    protected String getMissingTagMessage(String missingTag, String parentTag) {
        return "missing mandatory tag: <" + missingTag + "> in parent tag <" + parentTag + ">";
    }

    protected String getIllegalAttributeMessage(String attrName, String attrValue, String tagName) {
        return "Illegal attribute of tag <" + tagName + "> found. Name: '" + attrName + "'  value: '" + attrValue + "'";
    }

    protected void checkPropertyNotEmptyOrNull(String propertyValue, String propertyName, String owner) throws MissingElementException {
        if (propertyValue != null && propertyValue.length() > 0) {
            return;
        }
        throw new MissingElementException("property '" + propertyName + "' of " + owner + " is empty or missing (null).", propertyName);
    }

    protected void checkPropertyNotNull(Object propertyValue, String propertyName, String owner) throws MissingElementException {
        if (propertyValue == null) {
            String message = "property '" + propertyName + "' of " + owner + " is empty or missing (null).";
            throw new MissingElementException(message, propertyName);
        }
    }

    protected void checkPropertyNotEmptyOrNull(Map propertyValue, String propertyName, String owner) throws ValidationException {
        if (propertyValue != null && propertyValue.size() > 0) {
            return;
        }
        throw new MissingElementException("Collection '" + propertyName + "' of " + owner + " is empty or missing (null).", propertyName);
    }

    protected void checkPropertyNotEmptyOrNull(Collection propertyValue, String propertyName, String owner) throws ValidationException {
        if (propertyValue != null && propertyValue.size() > 0) {
            return;
        }
        throw new MissingElementException("Collection '" + propertyName + "' of " + owner + " is empty or missing (null).", propertyName);
    }

    protected boolean doSerialize(String schemaVersion, String minSchemaVersion) {
        return schemaVersion == null || schemaVersion.compareTo(minSchemaVersion) >= 0;
    }

    public boolean _isSchemaAllowed() {
        return !this._initialized || this._schemaVersion.compareTo(this._apiVersion) >= 0;
    }

    public boolean _isSchemaAllowed(String schemaVersion) {
        return !this._initialized || schemaVersion.compareTo(this._apiVersion) >= 0;
    }

    public String _getSchemaVersion() {
        return this._schemaVersion;
    }

    public void _setSchemaVersion(String schemaVersion) {
        this._schemaVersion = schemaVersion;
        this._apiVersion = schemaVersion;
    }

    public String _getAPIVersion() {
        return this._apiVersion;
    }

    public boolean _isInitialized() {
        return this._initialized;
    }

    protected void startDocument() {
        this._initialized = true;
    }

    protected void endDocument() {
    }

    protected abstract void startTag(String var1, Attributes var2) throws SAXException;

    protected abstract boolean endTag(String var1) throws SAXException;

    protected InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        return null;
    }
}

