/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.complib.validate.graph;

import com.sap.tc.complib.BuildVariant;
import com.sap.tc.complib.Compartment;
import com.sap.tc.complib.DevelopmentConfiguration;
import com.sap.tc.complib.validate.ValidationException;
import com.sap.tc.complib.validate.graph.Graph;
import com.sap.tc.complib.validate.graph.InvalidNodeException;
import com.sap.tc.complib.validate.graph.VariantCollisionException;
import java.util.Iterator;
import java.util.Map;

public class VariantUsageChecker {
    private Graph m_graph = new Graph();

    public VariantUsageChecker(DevelopmentConfiguration config) throws ValidationException {
        Map compartments = config.getCompartments();
        if (compartments != null) {
            Iterator compIter = compartments.values().iterator();
            while (compIter.hasNext()) {
                Compartment comp = (Compartment)compIter.next();
                Map variants = comp.getBuildVariants();
                if (variants == null) continue;
                Iterator varIter = variants.values().iterator();
                while (varIter.hasNext()) {
                    BuildVariant variant = (BuildVariant)varIter.next();
                    Map varMapping = variant.getVariantMapping();
                    if (varMapping == null) continue;
                    Iterator iterMapped = varMapping.keySet().iterator();
                    while (iterMapped.hasNext()) {
                        String mappedCompartmentName = (String)iterMapped.next();
                        String mappedVariantName = (String)varMapping.get(mappedCompartmentName);
                        Compartment mappedCompartment = (Compartment)compartments.get(mappedCompartmentName);
                        if (mappedCompartment == null) {
                            String msg = "Inconsistent variant mapping. Variant \"" + variant.getName() + "\" of compartment \"" + comp.getName() + "\" is mapped to the not existing compartmet \"" + mappedCompartmentName + "\"";
                            throw new ValidationException(msg);
                        }
                        Map variantsOfMapped = mappedCompartment.getBuildVariants();
                        if (variantsOfMapped == null) {
                            String msg = "Inconsistent variant mapping. Variant \"" + variant.getName() + "\" of compartment \"" + comp.getName() + "\" is mapped to the not existing variant \"" + mappedVariantName + "\" of compartmet \"" + mappedCompartmentName + "\"";
                            throw new ValidationException(msg);
                        }
                        BuildVariant mappedVariant = (BuildVariant)variantsOfMapped.get(mappedVariantName);
                        if (mappedVariant == null) {
                            String msg = "Inconsistent variant mapping. Variant \"" + variant.getName() + "\" of compartment \"" + comp.getName() + "\" is mapped to the not existing variant \"" + mappedVariantName + "\" of compartmet \"" + mappedCompartmentName + "\"";
                            throw new ValidationException(msg);
                        }
                        try {
                            this.m_graph.connect(comp, variant, mappedCompartment, mappedVariant);
                        }
                        catch (InvalidNodeException e) {
                            String msg = "Illegal variant mapping. Variant " + variant.getName() + " of compartment " + comp.getName() + " is mapped to itself.";
                            throw new ValidationException(msg, e);
                        }
                    }
                }
            }
        }
    }

    public void check() throws VariantCollisionException {
        this.m_graph.visitNodes();
    }
}

