/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.complib.validate.graph;

import com.sap.tc.complib.BuildVariant;
import com.sap.tc.complib.Compartment;
import com.sap.tc.complib.validate.graph.Arrow;
import com.sap.tc.complib.validate.graph.VariantCollisionException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class Node {
    private Map m_variants = new HashMap();
    private Compartment m_comp;

    public Node(Compartment c) {
        this.m_comp = c;
    }

    public void addConnection(Node node, BuildVariant startVnt, BuildVariant endVnt) {
        HashSet<Arrow> arrows = (HashSet<Arrow>)this.m_variants.get(startVnt);
        if (arrows == null) {
            arrows = new HashSet<Arrow>();
            this.m_variants.put(startVnt, arrows);
        }
        arrows.add(new Arrow(endVnt, node));
    }

    public int hashCode() {
        return this.m_comp.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        Node n = (Node)obj;
        return this.m_comp.equals(n.m_comp);
    }

    public Compartment getCompartment() {
        return this.m_comp;
    }

    public String toString() {
        return this.m_comp.getName();
    }

    public String getKey(BuildVariant variant) {
        return this.m_comp.getName() + "#" + variant.getName();
    }

    public void visit(Set globalVisitedList, Map visitedNodes, BuildVariant variant) throws VariantCollisionException {
        globalVisitedList.add(this.getKey(variant));
        visitedNodes.put(this, variant);
        Set arrowsSet = (Set)this.m_variants.get(variant);
        if (arrowsSet == null) {
            return;
        }
        Iterator arrows = arrowsSet.iterator();
        while (arrows.hasNext()) {
            Arrow a = (Arrow)arrows.next();
            BuildVariant visitedVariant = (BuildVariant)visitedNodes.get(a.targetNode);
            if (visitedVariant != null) {
                if (visitedVariant == a.targetVariant) continue;
                String comp = a.targetNode.getCompartment().getName();
                String v1 = visitedVariant.getName();
                String v2 = a.targetVariant.getName();
                throw new VariantCollisionException(comp, v1, v2);
            }
            a.targetNode.visit(globalVisitedList, visitedNodes, a.targetVariant);
        }
    }

    public Set getVariantSet() {
        return this.m_variants.keySet();
    }
}

