/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.complib.validate.graph;

import com.sap.tc.complib.BuildVariant;
import com.sap.tc.complib.Compartment;
import com.sap.tc.complib.validate.graph.InvalidNodeException;
import com.sap.tc.complib.validate.graph.Node;
import com.sap.tc.complib.validate.graph.VariantCollisionException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class Graph {
    private HashMap m_nodes = new HashMap();

    public void addNode(Compartment compartment) {
        this.getNode(compartment);
    }

    private Node getNode(Compartment compartment) {
        Node node = (Node)this.m_nodes.get(compartment);
        if (node == null) {
            node = new Node(compartment);
            this.m_nodes.put(compartment, node);
        }
        return node;
    }

    public void connect(Compartment c1, BuildVariant v1, Compartment c2, BuildVariant v2) throws InvalidNodeException {
        if (c1.equals(c2)) {
            throw new InvalidNodeException("source and target must not be equal.");
        }
        Node node1 = this.getNode(c1);
        Node node2 = this.getNode(c2);
        node1.addConnection(node2, v1, v2);
    }

    void visitNodes() throws VariantCollisionException {
        HashSet globalVisitedList = new HashSet();
        Iterator it = this.m_nodes.values().iterator();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            Iterator vnts = n.getVariantSet().iterator();
            while (vnts.hasNext()) {
                BuildVariant vnt = (BuildVariant)vnts.next();
                if (globalVisitedList.contains(n.getKey(vnt))) continue;
                HashMap visitedNodes = new HashMap();
                n.visit(globalVisitedList, visitedNodes, vnt);
            }
        }
    }
}

