/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.complib.provider;

import com.sap.tc.complib.Component;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.SoftwareComponent;
import com.sap.tc.complib.provider.DCOutputProvider;
import com.sap.tc.complib.provider.PPOutputProvider;
import com.sap.tc.complib.provider.ProviderException;
import com.sap.tc.complib.provider.SCOutputProvider;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FileOutputProvider
implements DCOutputProvider,
SCOutputProvider,
PPOutputProvider {
    public static final Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$complib$provider$FileOutputProvider == null ? (class$com$sap$tc$complib$provider$FileOutputProvider = FileOutputProvider.class$("com.sap.tc.complib.provider.FileOutputProvider")) : class$com$sap$tc$complib$provider$FileOutputProvider));
    private String rootPath;
    private Component component;
    private String publicPartName;
    private static final String ENCODING = "US-ASCII";
    static /* synthetic */ Class class$com$sap$tc$complib$provider$FileOutputProvider;

    public FileOutputProvider(String rootPath, Component component) {
        this.rootPath = rootPath;
        this.component = component;
    }

    public void selectPublicPart(String publicPartName) {
        this.publicPartName = publicPartName;
    }

    public OutputStream getStreamForDC() throws ProviderException {
        if (this.component instanceof DevelopmentComponent) {
            String path = this.getPathForDC(this.component.getName(), this.component.getVendor());
            File file = new File(path + ".dcdef");
            return this.getStream(file);
        }
        throw new ProviderException("Given component is not a DC");
    }

    public OutputStream getStreamForSC() throws ProviderException {
        if (this.component instanceof SoftwareComponent) {
            String path = this.getPathForSC(this.component.getName(), this.component.getVendor());
            File file = new File(path + ".scdef");
            return this.getStream(file);
        }
        throw new ProviderException("Given component is not a SC");
    }

    public OutputStream getStreamForPublicPart() throws ProviderException {
        if (this.component instanceof DevelopmentComponent & this.publicPartName != null) {
            String path = this.getPathForDef(this.component.getName(), this.component.getVendor());
            File file = new File(path + this.publicPartName + ".pp");
            return this.getStream(file);
        }
        throw new ProviderException("Given component is not a DC");
    }

    public void releaseStream(OutputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException ex) {
                LOCATION.catching("releaseStream", (Throwable)ex);
            }
        }
    }

    public PPOutputProvider getPPOutputProvider(String publicPartName) {
        this.selectPublicPart(publicPartName);
        return this;
    }

    private String getPathForDC(String name, String vendor) {
        StringBuffer s = new StringBuffer(this.rootPath);
        if (!this.rootPath.endsWith("/")) {
            s.append('/');
        }
        s.append("DCs/").append(vendor).append('/').append(name).append('/').append("_comp/");
        return s.toString();
    }

    private String getPathForSC(String name, String vendor) {
        StringBuffer s = new StringBuffer(this.rootPath);
        if (!this.rootPath.endsWith("/")) {
            s.append('/');
        }
        s.append("SCs/").append(vendor).append('/').append(name).append('/').append("_comp/");
        return s.toString();
    }

    private String getPathForDef(String name, String vendor) {
        return this.getPathForDC(name, vendor) + "def/";
    }

    private OutputStream getStream(File file) throws ProviderException {
        FileOutputStream out;
        try {
            File dir = file.getParentFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            file.createNewFile();
            out = new FileOutputStream(file);
        }
        catch (Exception ex) {
            LOCATION.catching("getStream", (Throwable)ex);
            throw new ProviderException("Error creating output Stream for DC: " + ex.getMessage(), ex);
        }
        return out;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

