/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.complib.provider;

import com.sap.tc.complib.ComponentReference;
import com.sap.tc.complib.DCReference;
import com.sap.tc.complib.SCReference;
import com.sap.tc.complib.provider.DCInputProvider;
import com.sap.tc.complib.provider.PPInputProvider;
import com.sap.tc.complib.provider.ProviderException;
import com.sap.tc.complib.provider.SCInputProvider;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;

public final class FileInputProvider
implements DCInputProvider,
SCInputProvider,
PPInputProvider {
    public static final Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$complib$provider$FileInputProvider == null ? (class$com$sap$tc$complib$provider$FileInputProvider = FileInputProvider.class$("com.sap.tc.complib.provider.FileInputProvider")) : class$com$sap$tc$complib$provider$FileInputProvider));
    private String rootPath;
    private ComponentReference component;
    private String publicPartName;
    static /* synthetic */ Class class$com$sap$tc$complib$provider$FileInputProvider;

    public FileInputProvider(String rootPath, ComponentReference component) {
        this.rootPath = rootPath;
        this.component = component;
    }

    public void selectPublicPart(String publicPartName) {
        this.publicPartName = publicPartName;
    }

    public void releaseStream(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException ex) {
                LOCATION.catching("releaseStream", (Throwable)ex);
            }
        }
    }

    public InputStream getStreamForDC() throws ProviderException {
        if (this.component instanceof DCReference) {
            String path = this.getPathForDC(this.component.getName(), this.component.getVendor());
            File file = new File(path + ".dcdef");
            return this.getStream(file);
        }
        throw new ProviderException("Given component is not a DC");
    }

    public InputStream getStreamForSC() throws ProviderException {
        if (this.component instanceof SCReference) {
            String path = this.getPathForSC(this.component.getName(), this.component.getVendor());
            File file = new File(path + ".scdef");
            return this.getStream(file);
        }
        throw new ProviderException("Given component is not a SC");
    }

    public InputStream getStreamForPublicPart() throws ProviderException {
        if (this.component instanceof DCReference && this.publicPartName != null) {
            String path = this.getPathForDef(this.component.getName(), this.component.getVendor());
            File file = new File(path + this.publicPartName + ".pp");
            return this.getStream(file);
        }
        throw new ProviderException("Given component is not a DC");
    }

    public String[] getPublicParts() throws ProviderException {
        if (this.component instanceof DCReference) {
            String path = this.getPathForDef(this.component.getName(), this.component.getVendor());
            File defdir = new File(path);
            String[] files = defdir.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".pp");
                }
            });
            String[] res = new String[files.length];
            int i = 0;
            while (i < files.length) {
                int n = files[i].lastIndexOf(".");
                res[i] = files[i].substring(0, n);
                ++i;
            }
            return res;
        }
        throw new ProviderException("Given component is not a DC");
    }

    public PPInputProvider getPPInputProvider(String publicPartName) throws ProviderException {
        this.selectPublicPart(publicPartName);
        return this;
    }

    public String[] getTopLevelComponents() throws ProviderException {
        if (this.component instanceof SCReference) {
            String path = this.getPathForSC(this.component.getName(), this.component.getVendor()) + "TopLevelDCs/";
            File dir = new File(path);
            String[] files = dir.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".dcref");
                }
            });
            String[] res = new String[files.length];
            int i = 0;
            while (i < files.length) {
                int n = files[i].lastIndexOf(".");
                res[i] = files[i].substring(0, n);
                ++i;
            }
            return res;
        }
        throw new ProviderException("Given component is not a SC");
    }

    private String getPathForDC(String name, String vendor) {
        StringBuffer s = new StringBuffer(this.rootPath);
        if (!this.rootPath.endsWith("/")) {
            s.append('/');
        }
        s.append("DCs/").append(vendor).append('/').append(name).append('/').append("_comp/");
        return s.toString();
    }

    private String getPathForSC(String name, String vendor) {
        StringBuffer s = new StringBuffer(this.rootPath);
        if (!this.rootPath.endsWith("/")) {
            s.append('/');
        }
        s.append("SCs/").append(vendor).append('/').append(name).append('/').append("_comp/");
        return s.toString();
    }

    private String getPathForDef(String name, String vendor) {
        return this.getPathForDC(name, vendor) + "def/";
    }

    private InputStream getStream(File file) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
        }
        catch (FileNotFoundException ex) {
            LOCATION.catching("getStream", (Throwable)ex);
            return null;
        }
        return in;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

