/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.complib.namecheck;

import com.sap.tc.complib.namecheck.NameCheckException;
import java.util.HashSet;
import java.util.Set;

public class NameChecker {
    public static String COMPONENT_ROOT_FOLDER_NAME = "_comp";
    public static int COMPARTMENT_MAX_LENGTH = 70;
    public static int ALIAS_MAX_LENGTH = 50;
    public static int SC_MAX_LENGTH = 40;
    public static int DC_MAX_LENGTH = 40;
    public static int VENDOR_MAX_LENGTH = 20;
    public static int VARIANT_MAX_LENGTH = 20;
    public static int DEFCONF_MAX_LENGTH = 20;
    public static int PP_NAME_MAX_LENGTH = 40;
    public static final char CHAR_SEGMENT_SEPARATOR = '/';
    public static final char CHAR_LABEL_SEPARATOR = '.';
    public static final Set _reservedSegmentNames = new HashSet();

    public static void checkComponentName(String nameToBeChecked) throws NameCheckException {
        NameChecker.checkLength("development component", nameToBeChecked, DC_MAX_LENGTH);
        NameChecker._checkComponentName(nameToBeChecked);
    }

    public static void checkSoftwareComponentName(String nameToBeChecked) throws NameCheckException {
        NameChecker.checkLength("software component", nameToBeChecked, SC_MAX_LENGTH);
        NameChecker._checkComponentName(nameToBeChecked);
    }

    public static void _checkComponentName(String nameToBeChecked) throws NameCheckException {
        boolean STATE_SEGMENT_START = true;
        int STATE_SEGMENT = 2;
        int length = nameToBeChecked.length();
        int posCurrentSegmentStart = 0;
        if (length == 0) {
            throw new NameCheckException("Empty String", nameToBeChecked, 0, 0);
        }
        int state = 1;
        int pos = 0;
        while (pos < length) {
            char c = nameToBeChecked.charAt(pos);
            switch (state) {
                case 1: {
                    if (NameChecker.isAlphanum(c) || NameChecker.isAllowedMark(c)) {
                        state = 2;
                        posCurrentSegmentStart = pos;
                        break;
                    }
                    if (c == '/') {
                        throw new NameCheckException("A name segment must not begin with a separator", nameToBeChecked, 1, pos);
                    }
                    throw new NameCheckException("Illegal Character", nameToBeChecked, 4, pos);
                }
                case 2: {
                    if (NameChecker.isAlphanum(c) || NameChecker.isAllowedMark(c)) break;
                    if (c == '/') {
                        NameChecker.assureSubstringAllowedAsNameSegment(nameToBeChecked, posCurrentSegmentStart, pos);
                        state = 1;
                        break;
                    }
                    throw new NameCheckException("Illegal Character", nameToBeChecked, 4, pos);
                }
                default: {
                    throw new IllegalStateException("Internal Error: Illegal state: " + state);
                }
            }
            ++pos;
        }
        if (state == 1) {
            throw new NameCheckException("the name must not end with a separator", nameToBeChecked, 5, pos - 1);
        }
        NameChecker.assureSubstringAllowedAsNameSegment(nameToBeChecked, posCurrentSegmentStart, pos);
    }

    private static void assureSubstringAllowedAsNameSegment(String string, int pos1, int pos2) throws NameCheckException {
        String segment = string.substring(pos1, pos2);
        if (_reservedSegmentNames.contains(segment)) {
            throw new NameCheckException("the reserved word \"" + segment + "\" is not allowed as a name segment", string, 7, pos1);
        }
    }

    private static void assureAllowedAsNameSegment(String nameToBeChecked) throws NameCheckException {
        if (_reservedSegmentNames.contains(nameToBeChecked)) {
            throw new NameCheckException("the reserved word \"" + nameToBeChecked + "\" is not allowed as a vendor name", nameToBeChecked, 7, 0);
        }
    }

    public static void checkVendorName(String nameToBeChecked) throws NameCheckException {
        boolean STATE_LABEL_START = true;
        int STATE_LABEL = 2;
        char last_char = '\u0000';
        char lastLabelStartChar = '\u0000';
        int lastLabelStartPos = 0;
        int length = nameToBeChecked.length();
        NameChecker.checkLength("vendor", nameToBeChecked, VENDOR_MAX_LENGTH);
        if (length == 0) {
            throw new NameCheckException("Empty String", nameToBeChecked, 0, 0);
        }
        int state = 1;
        int pos = 0;
        while (pos < length) {
            char c = nameToBeChecked.charAt(pos);
            switch (state) {
                case 1: {
                    if (NameChecker.isAlphanum(c)) {
                        lastLabelStartChar = c;
                        lastLabelStartPos = pos;
                        state = 2;
                        break;
                    }
                    throw new NameCheckException("Alphanumerical character expected at start of name  section", nameToBeChecked, 1, pos);
                }
                case 2: {
                    if (c == '-' || NameChecker.isAlphanum(c)) break;
                    if (c == '.') {
                        if (last_char == '-') {
                            throw new NameCheckException("A name section must end with a letter or a digit", nameToBeChecked, 3, pos - 1);
                        }
                        state = 1;
                        break;
                    }
                    throw new NameCheckException("Illegal character", nameToBeChecked, 4, pos);
                }
                default: {
                    throw new IllegalStateException("Internal Error: Illegal state: " + state);
                }
            }
            last_char = c;
            ++pos;
        }
        if (!NameChecker.isAlphanum(last_char)) {
            throw new NameCheckException("Name must end with letter or digit", nameToBeChecked, 5, pos - 1);
        }
        if (!NameChecker.isAlpha(lastLabelStartChar)) {
            throw new NameCheckException("Top level domain must start with a letter", nameToBeChecked, 1, lastLabelStartPos);
        }
        NameChecker.assureAllowedAsNameSegment(nameToBeChecked);
    }

    public static void checkPublicPartName(String nameToBeChecked) throws NameCheckException {
        NameChecker.checkLength("public part", nameToBeChecked, PP_NAME_MAX_LENGTH);
        NameChecker.checkSimpleName(nameToBeChecked);
    }

    public static void checkCompartmentName(String nameToBeChecked) throws NameCheckException {
        NameChecker.checkLength("compartment", nameToBeChecked, COMPARTMENT_MAX_LENGTH);
        NameChecker.checkSimpleName(nameToBeChecked);
    }

    public static void checkAliasName(String nameToBeChecked) throws NameCheckException {
        NameChecker.checkLength("sc alias", nameToBeChecked, ALIAS_MAX_LENGTH);
        NameChecker.checkSimpleName(nameToBeChecked);
    }

    public static void checkBuildVariantName(String nameToBeChecked) throws NameCheckException {
        NameChecker.checkLength("build variant", nameToBeChecked, VARIANT_MAX_LENGTH);
        NameChecker.checkSimpleName(nameToBeChecked);
    }

    public static void checkDevelopmentConfigurationName(String nameToBeChecked) throws NameCheckException {
        NameChecker.checkLength("configuration", nameToBeChecked, DEFCONF_MAX_LENGTH);
        NameChecker.checkSimpleName(nameToBeChecked);
    }

    private static void checkSimpleName(String nameToBeChecked) throws NameCheckException {
        int length = nameToBeChecked.length();
        if (length == 0) {
            throw new NameCheckException("Empty String", nameToBeChecked, 0, 0);
        }
        int i = 0;
        while (i < length) {
            char c = nameToBeChecked.charAt(i);
            if (!NameChecker.isAlphanum(c) && !NameChecker.isAllowedMark(c)) {
                throw new NameCheckException("Illegal Character", nameToBeChecked, 4, i);
            }
            ++i;
        }
    }

    private static boolean isAlphanum(char c) {
        return NameChecker.isDigit(c) || NameChecker.isAlpha(c);
    }

    private static boolean isDigit(char c) {
        return '0' <= c && c <= '9';
    }

    private static boolean isAlpha(char c) {
        if ('a' <= c && c <= 'z') {
            return true;
        }
        return 'A' <= c && c <= 'Z';
    }

    private static boolean isAllowedMark(char c) {
        return c == '-' || c == '_' || c == '.' || c == '!' || c == '$';
    }

    private static void checkLength(String type, String name, int maxlength) throws NameCheckException {
        if (name.length() > maxlength) {
            String msg = "Name too long for " + type + ".  Maximum length : " + maxlength + " exceeded";
            throw new NameCheckException(msg, name, 6, maxlength);
        }
    }

    static {
        _reservedSegmentNames.add(COMPONENT_ROOT_FOLDER_NAME);
    }
}

