/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.complib.namecheck;

import com.sap.tc.complib.validate.ValidationException;

public class NameCheckException
extends ValidationException {
    private static final long serialVersionUID = -1407597383083768466L;
    public static final int ERROR_EMPTY_STRING = 0;
    public static final int ERROR_ILLEGAL_SECTION_START = 1;
    public static final int ERROR_ILLEGAL_SECTION_END = 3;
    public static final int ERROR_ILLEGAL_CHARACTER = 4;
    public static final int ERROR_ILLEGAL_END = 5;
    public static final int ERROR_NAME_TOO_LONG = 6;
    public static final int ERROR_RESERVED_SEGMENT = 7;
    private int m_error;
    private int m_position;
    private String m_string;

    public NameCheckException(String message, String checkedString, int error, int position) {
        super(message);
        this.m_error = error;
        this.m_position = position;
        this.m_string = checkedString;
    }

    public int getError() {
        return this.m_error;
    }

    public int getErrorPosition() {
        return this.m_position;
    }

    public String getCheckedString() {
        return this.m_string;
    }

    public String getMessage() {
        String msg = super.getMessage();
        if (this.m_string.length() > 0) {
            char c = this.m_string.charAt(this.m_position);
            msg = c < '\u001a' ? msg + " at position " + this.m_position + " special character with code: " + c : msg + " in \"" + this.m_string + "\" at position " + this.m_position + " character: '" + c + "'";
        }
        return msg;
    }
}

