/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.complib.impl;

import com.sap.tc.complib.Repository;
import com.sap.tc.complib.SourceState;
import com.sap.tc.complib.impl.RepositoryImpl;
import com.sap.tc.complib.validate.InvalidFileFormatException;
import com.sap.tc.complib.validate.InvalidMemberException;
import com.sap.tc.complib.validate.ValidationException;
import com.sap.tc.complib.xml.Attribute;
import com.sap.tc.complib.xml.Initializable;
import com.sap.tc.complib.xml.XMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SourceStateImpl
extends Initializable
implements SourceState {
    private int m_type = 0;
    private Repository m_repository;
    private String m_location;
    private String m_inactiveLocation;
    private boolean m_exportAllowed = false;
    private static final String TAG_SOURCE_STATE = "source-state";
    private static final String TAG_REPOSITORY = "repository";
    private static final String TAG_INACTIVE_LOCATION = "inactive-location";
    private static final String TAG_LOCATION = "location";
    private static final String ATTR_SOURCESTATE_TYPE = "type";
    private static final String ATTR_SOURCESTATE_EXPORT = "exportAllowed";
    private static final String ATTR_VALUE_TYPE_ACTIVATION = "activation";
    private static final String ATTR_VALUE_TYPE_READ = "read";
    private static final String ATTR_VALUE_TYPE_CHANGE = "change";
    private static final String ATTR_VALUE_TYPE_LOCAL = "local";
    private static final String ATTR_VALUE_EXPORT_YES = "yes";
    private static final String ATTR_VALUE_EXPORT_NO = "no";
    private static final int STATE_REPOSITORY = 3;
    private static final int STATE_CHILD_REPOSITORY = 4;
    private static final int STATE_INACTIVE_LOC = 5;
    private static final int STATE_LOCATION = 6;
    private static final int STATE_SOURCE_STATE_FINAL = 7;
    private String rootTag;
    private RepositoryImpl childRepository;

    public SourceStateImpl() {
        this._schemaVersion = "0.3";
        this._apiVersion = "0.2";
    }

    public int getType() {
        return this.m_type;
    }

    public void setType(int value) {
        this.m_type = value;
    }

    public Repository getRepository() {
        return this.m_repository;
    }

    public void setRepository(Repository value) {
        this.m_repository = value;
    }

    public String getLocation() {
        return this.m_location;
    }

    public void setLocation(String value) {
        this.m_location = value;
    }

    public String getInactiveLocation() {
        return this.m_inactiveLocation;
    }

    public void setInactiveLocation(String value) {
        this.m_inactiveLocation = value;
    }

    public boolean isExportAllowed() {
        return this.m_exportAllowed;
    }

    public void setExportAllowed(boolean value) {
        this.m_exportAllowed = value;
    }

    public boolean isLocationChangeable() {
        return this.m_type == 2;
    }

    protected void tagValue(char[] chars, int start, int length) {
        switch (this.state) {
            case 4: {
                this.childRepository.tagValue(chars, start, length);
                return;
            }
        }
        super.tagValue(chars, start, length);
    }

    protected void startTag(String tagName, Attributes attributes) throws SAXException {
        switch (this.state) {
            case 0: {
                if (tagName.equals(TAG_SOURCE_STATE)) {
                    this.state = 3;
                    this.rootTag = tagName;
                    String attrValue = attributes.getValue(ATTR_SOURCESTATE_TYPE);
                    this.checkMandatoryAttribute(attrValue, ATTR_SOURCESTATE_TYPE, this.rootTag);
                    if (ATTR_VALUE_TYPE_ACTIVATION.equalsIgnoreCase(attrValue)) {
                        this.m_type = 0;
                    } else if (ATTR_VALUE_TYPE_READ.equalsIgnoreCase(attrValue)) {
                        this.m_type = 1;
                    } else if (ATTR_VALUE_TYPE_CHANGE.equalsIgnoreCase(attrValue)) {
                        this.m_type = 2;
                    } else if (ATTR_VALUE_TYPE_LOCAL.equalsIgnoreCase(attrValue)) {
                        this.m_type = 3;
                    } else {
                        throw new SAXException("Illegal value '" + attrValue + "' of attribute'" + ATTR_SOURCESTATE_TYPE + "' in tag <" + this.rootTag + ">");
                    }
                    attrValue = attributes.getValue(ATTR_SOURCESTATE_EXPORT);
                    if (attrValue != null) {
                        if (ATTR_VALUE_EXPORT_NO.equalsIgnoreCase(attrValue)) {
                            this.m_exportAllowed = false;
                        } else if (ATTR_VALUE_EXPORT_YES.equalsIgnoreCase(attrValue)) {
                            this.m_exportAllowed = true;
                        } else {
                            throw new SAXException("Illegal value '" + attrValue + "' of attribute'" + ATTR_VALUE_EXPORT_NO + "' in tag <" + this.rootTag + ">");
                        }
                    }
                    return;
                }
                throw new SAXException("internal error: tag expected <source-state> in SourcestateImpl.startTag");
            }
            case 4: {
                this.childRepository.startTag(tagName, attributes);
                return;
            }
            case 3: {
                if (tagName.equals(TAG_REPOSITORY)) {
                    this.childRepository = new RepositoryImpl();
                    this.state = 4;
                    this.childRepository.startTag(tagName, attributes);
                    return;
                }
            }
            case 5: {
                if (tagName.equals(TAG_INACTIVE_LOCATION)) {
                    this.state = 5;
                    return;
                }
            }
            case 6: {
                if (!tagName.equals(TAG_LOCATION)) break;
                this.state = 6;
                return;
            }
        }
        throw new SAXException("internal error: illegal state (" + this.state + ") in startTag(" + tagName + ")");
    }

    protected boolean endTag(String tagName) throws SAXException {
        switch (this.state) {
            case 4: {
                if (this.childRepository.endTag(tagName)) {
                    return true;
                }
                this.m_repository = this.childRepository;
                this.childRepository = null;
                this.state = 5;
                return true;
            }
            case 5: {
                if (tagName.equals(TAG_INACTIVE_LOCATION)) {
                    this.m_inactiveLocation = this.getStringValue();
                    this.state = 6;
                    return true;
                }
            }
            case 6: {
                if (tagName.equals(TAG_LOCATION)) {
                    this.m_location = this.getStringValue();
                    this.state = 7;
                    return true;
                }
            }
            case 3: 
            case 7: {
                try {
                    this.validate();
                }
                catch (ValidationException e) {
                    throw new SAXException(e.getMessage());
                }
                return false;
            }
        }
        throw new SAXException("internal error: illegal state (" + this.state + ") in endTag(" + tagName + ")");
    }

    public void serialize(XMLWriter writer) throws ValidationException {
        if (!this._isSchemaAllowed()) {
            throw new InvalidFileFormatException("Cannot serialize source state with format version " + this._schemaVersion + " since this source state uses" + " features from API version " + this._apiVersion);
        }
        this.serialize(writer, this._schemaVersion);
    }

    public void serialize(XMLWriter writer, String schemaVersion) throws ValidationException {
        Attribute[] attribs = new Attribute[]{new Attribute(ATTR_SOURCESTATE_TYPE, null)};
        switch (this.m_type) {
            case 3: {
                attribs[0].value = ATTR_VALUE_TYPE_LOCAL;
                writer.beginTag(TAG_SOURCE_STATE, attribs);
                break;
            }
            case 2: {
                attribs[0].value = ATTR_VALUE_TYPE_CHANGE;
                writer.beginTag(TAG_SOURCE_STATE, attribs);
                this.m_repository.serialize(writer);
                writer.writeTag(TAG_LOCATION, this.m_location);
                break;
            }
            case 1: {
                attribs[0].value = ATTR_VALUE_TYPE_READ;
                writer.beginTag(TAG_SOURCE_STATE, attribs);
                this.m_repository.serialize(writer);
                writer.writeTag(TAG_LOCATION, this.m_location);
                break;
            }
            case 0: {
                attribs[0].value = ATTR_VALUE_TYPE_ACTIVATION;
                writer.beginTag(TAG_SOURCE_STATE, attribs);
                this.m_repository.serialize(writer);
                writer.writeTag(TAG_INACTIVE_LOCATION, this.m_inactiveLocation);
                writer.writeTag(TAG_LOCATION, this.m_location);
                break;
            }
        }
        writer.endTag(TAG_SOURCE_STATE);
    }

    public void validate() throws ValidationException {
        this.checkChildrenBasedOnType();
        if (this.m_repository != null) {
            this.m_repository.validate();
        }
    }

    public void checkChildrenBasedOnType() throws ValidationException {
        if (this.m_type == 3) {
            if (this.m_repository != null) {
                throw new ValidationException("Configuration is invalid. Repository \"" + this.m_repository.getURL() + "\" specified for a local only source state");
            }
            if (this.m_location != null) {
                throw new ValidationException("Configuration is invalid. Remote location \"" + this.m_location + "\" specified for a local only source state");
            }
            if (this.m_inactiveLocation != null) {
                throw new ValidationException("Configuration is invalid. Inactive location \"" + this.m_inactiveLocation + "\" specified for a local only source state");
            }
            if (this.m_exportAllowed) {
                throw new ValidationException("Configuration is invalid. Export-allowed attribute is set to true for a local only source state");
            }
            return;
        }
        this.checkPropertyNotNull(this.m_repository, "Repository", "SourceState");
        this.checkPropertyNotEmptyOrNull(this.m_location, "Location", "Source State");
        if (this.m_type == 1 || this.m_type == 2) {
            if (this.m_inactiveLocation != null && this.m_inactiveLocation.length() > 0) {
                throw new InvalidMemberException("Optional property not allowed property for SourceState of type " + this.typeAsString(), "InactiveLocation", this.m_inactiveLocation);
            }
            return;
        }
        if (this.m_type == 0) {
            this.checkPropertyNotEmptyOrNull(this.m_inactiveLocation, "InactiveLocation", " Source State with activation ");
            return;
        }
        throw new InvalidMemberException("Illegal member of SourceState object", "Type", this.typeAsString());
    }

    public String typeAsString() {
        String s = "";
        switch (this.m_type) {
            case 1: {
                s = ATTR_VALUE_TYPE_READ;
                break;
            }
            case 2: {
                s = ATTR_VALUE_TYPE_CHANGE;
                break;
            }
            case 0: {
                s = ATTR_VALUE_TYPE_ACTIVATION;
                break;
            }
            case 3: {
                s = ATTR_VALUE_TYPE_LOCAL;
                break;
            }
            default: {
                s = "";
            }
        }
        return s;
    }

    public boolean isChangeable() {
        return this.m_type != 1;
    }

    public String toString() {
        return this.typeAsString();
    }

    public boolean isLocal() {
        return this.m_type == 3;
    }
}

