/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.complib.impl;

import com.sap.tc.complib.ComponentFactory;
import com.sap.tc.complib.ComponentReference;
import com.sap.tc.complib.DCReference;
import com.sap.tc.complib.SCReference;
import com.sap.tc.complib.SoftwareComponent;
import com.sap.tc.complib.namecheck.NameCheckException;
import com.sap.tc.complib.namecheck.NameChecker;
import com.sap.tc.complib.provider.ProviderException;
import com.sap.tc.complib.provider.SCInputProvider;
import com.sap.tc.complib.provider.SCOutputProvider;
import com.sap.tc.complib.validate.InvalidFileFormatException;
import com.sap.tc.complib.validate.InvalidMemberException;
import com.sap.tc.complib.validate.MissingElementException;
import com.sap.tc.complib.validate.ValidationException;
import com.sap.tc.complib.xml.Initializable;
import com.sap.tc.complib.xml.ParserAdapter;
import com.sap.tc.complib.xml.XMLException;
import com.sap.tc.complib.xml.XMLWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SoftwareComponentImpl
extends Initializable
implements SoftwareComponent {
    private String _name;
    private String _vendor;
    private String _caption;
    private String _description;
    private List _dependencies;
    private List _grants;
    private String rootTag;
    private List list;
    private ComponentReference ref = null;
    private boolean readList = false;
    private static final int SC_NAME = 10;
    private static final int SC_VENDOR = 20;
    private static final int SC_CAPTION = 30;
    private static final int SC_DESCRIPTION = 40;
    private static final int SC_DEPENDENCIES = 60;
    private static final int SC_ACL = 70;
    private static final int SC_FINAL = 80;
    private static final int SC_DEPENDENCY = 210;
    private static final int REF_NAME = 310;
    private static final int REF_VENDOR = 320;
    private static final int REF_ALIAS = 330;
    private static final int REF_FINAL = 340;
    private static final int ACL_GRANTS = 400;
    private static final int ACL_GRANT = 410;

    public SoftwareComponentImpl() {
        this._schemaVersion = "1.0.1";
        this._apiVersion = "1.0.0";
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getVendor() {
        return this._vendor;
    }

    public void setVendor(String vendor) {
        this._vendor = vendor;
    }

    public String getCaption() {
        return this._caption;
    }

    public void setCaption(String caption) {
        this._caption = caption;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public List getDependencies() {
        return this._dependencies;
    }

    public List emptyDependencies() {
        if (this._dependencies != null) {
            this._dependencies.clear();
        } else {
            this._dependencies = new ArrayList();
        }
        return this._dependencies;
    }

    public List getGrants() {
        return this._grants;
    }

    public List emptyGrants() {
        if (this._grants != null) {
            this._grants.clear();
        } else {
            this._grants = new ArrayList();
        }
        return this._grants;
    }

    public Reader getSchema() {
        InputStream resource = this.getClass().getResourceAsStream("scdef.xsd");
        return new InputStreamReader(resource);
    }

    public void validate() throws ValidationException {
        ComponentReference child;
        Iterator iter;
        if (this._name == null) {
            throw new MissingElementException("name");
        }
        try {
            NameChecker.checkSoftwareComponentName(this._name);
        }
        catch (NameCheckException ex) {
            throw new ValidationException("invalid SC name", ex);
        }
        if (this._vendor == null) {
            throw new MissingElementException("vendor");
        }
        try {
            NameChecker.checkVendorName(this._vendor);
        }
        catch (NameCheckException ex) {
            throw new ValidationException("invalid SC vendor", ex);
        }
        if (this._dependencies != null && this._dependencies.size() > 0) {
            iter = this._dependencies.iterator();
            child = null;
            try {
                while (iter.hasNext()) {
                    child = (SCReference)iter.next();
                    ((SCReference)child).validate();
                }
            }
            catch (ClassCastException ex) {
                throw new InvalidMemberException("dependencies", child);
            }
        }
        if (this._grants != null && this._grants.size() > 0) {
            iter = this._grants.iterator();
            child = null;
            try {
                while (iter.hasNext()) {
                    child = (ComponentReference)iter.next();
                    child.validate();
                }
            }
            catch (ClassCastException ex) {
                throw new InvalidMemberException("grants", child);
            }
        }
    }

    public void serialize(SCOutputProvider provider) throws IOException, ProviderException {
        OutputStream out = provider.getStreamForSC();
        XMLWriter writer = new XMLWriter(out);
        try {
            this.serialize(writer);
        }
        catch (ValidationException ex) {
            throw new ProviderException("Serialization failed: incomplete or invalid component", ex);
        }
        writer.serialize();
        provider.releaseStream(out);
    }

    public void serialize(XMLWriter writer) throws ValidationException {
        if (!ComponentFactory.isSchemaAllowed(this._schemaVersion)) {
            throw new InvalidFileFormatException("Cannot serialize software component with schema version '" + this._schemaVersion + "'. The version number is unknown." + " Latest known schema version is " + "1.0.2");
        }
        if (!this._isSchemaAllowed()) {
            throw new InvalidFileFormatException("Cannot serialize software component with format version " + this._schemaVersion + " since this component uses" + " features from API version " + this._apiVersion);
        }
        this.serialize(writer, this._schemaVersion);
    }

    public void serialize(XMLWriter writer, String schemaVersion) throws ValidationException {
        Iterator iter;
        if (schemaVersion == null) {
            schemaVersion = this._schemaVersion;
        }
        if (!ComponentFactory.isSchemaAllowed(schemaVersion)) {
            throw new InvalidFileFormatException("Cannot serialize public part with schema version '" + schemaVersion + "'. Latest known schema version is " + "1.0.2");
        }
        if (this._name == null) {
            throw new ValidationException("SCs must have a name.");
        }
        try {
            NameChecker.checkSoftwareComponentName(this._name);
        }
        catch (NameCheckException ex) {
            throw new ValidationException("SCs must have a valid name.", ex);
        }
        if (this._vendor == null) {
            throw new ValidationException("SCs must have a vendor.");
        }
        try {
            NameChecker.checkVendorName(this._vendor);
        }
        catch (NameCheckException ex) {
            throw new ValidationException("SCs must have a valid vendor.", ex);
        }
        this.setAttribute("xmlns", "http://xml.sap.com/2002/11/SoftwareComponent");
        this.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.setAttribute("xsi:schemaLocation", "scdef.xsd");
        String versionAttr = schemaVersion == null ? this._schemaVersion : schemaVersion;
        this.setAttribute("version", versionAttr);
        this.setAttribute("xmlns:IDX", "urn:sap.com:SoftwareComponent:1.0");
        writer.beginDocument();
        writer.wrapAttributeLists(true);
        writer.writeRootTag("software-component", this.getAttributes());
        writer.wrapAttributeLists(false);
        writer.writeTag("name", this._name);
        writer.writeTag("vendor", this._vendor);
        if (this._caption != null) {
            writer.writeTag("caption", this._caption);
        }
        if (this._description != null) {
            writer.writeTag("description", this._description);
        }
        if (this._dependencies != null && this._dependencies.size() > 0) {
            try {
                writer.beginTag("dependencies");
                iter = this._dependencies.iterator();
                while (iter.hasNext()) {
                    ((SCReference)iter.next()).serialize(writer);
                }
                writer.endTag("dependencies");
            }
            catch (ClassCastException ex) {
                throw new ValidationException("List of dependencies contains an entry that is not of type SCReference");
            }
        }
        if (this._grants != null && this._grants.size() > 0) {
            try {
                writer.beginTag("access-control-list");
                iter = this._grants.iterator();
                while (iter.hasNext()) {
                    writer.beginTag("grant");
                    ((SCReference)iter.next()).serialize(writer);
                    writer.endTag("grant");
                }
                writer.endTag("access-control-list");
            }
            catch (ClassCastException ex) {
                throw new ValidationException("List of grants contains an entry that is not of type SCReference");
            }
        }
        writer.endDocument();
    }

    public void initialize(SCInputProvider provider) throws IOException, XMLException, ProviderException {
        InputStream in = null;
        try {
            try {
                in = provider.getStreamForSC();
                ParserAdapter parser = new ParserAdapter(this);
                parser.parse(in);
            }
            catch (SAXException ex) {
                throw new XMLException("Initializing software component failed", ex);
            }
            Object var5_5 = null;
            provider.releaseStream(in);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            provider.releaseStream(in);
            throw throwable;
        }
    }

    public boolean isSchemaAllowed() {
        return this._isSchemaAllowed();
    }

    public boolean isSchemaAllowed(String schemaVersion) {
        return this._isSchemaAllowed(schemaVersion);
    }

    public String getSchemaVersion() {
        return this._schemaVersion;
    }

    protected void startTag(String name, Attributes attributes) throws SAXException {
        switch (this.state) {
            case 0: {
                String versionAttr;
                if (name.equals("software-component")) {
                    this.dropTagValue();
                    versionAttr = attributes.getValue("version");
                    if (versionAttr == null) {
                        throw new SAXException("Unable to read component description: Missing 'version' attribute");
                    }
                } else {
                    throw new SAXException("root tag expected <software-component>");
                }
                this._setSchemaVersion(versionAttr);
                this._attributes = this.getAttributes(attributes);
                this._attributes.remove("version");
                this.rootTag = name;
                this.state = 10;
                return;
            }
            case 1: {
                return;
            }
            case 10: {
                if (name.equals("name")) {
                    this.state = 10;
                    return;
                }
                throw new SAXException("mandatory tag <name> missing");
            }
            case 20: {
                if (name.equals("vendor")) {
                    this.state = 20;
                    return;
                }
                throw new SAXException("mandatory tag <vendor> missing");
            }
            case 30: {
                if (name.equals("caption")) {
                    this.state = 30;
                    return;
                }
            }
            case 40: {
                if (name.equals("description")) {
                    this.state = 40;
                    return;
                }
            }
            case 60: {
                if (name.equals("dependencies")) {
                    if (this._dependencies == null) {
                        this._dependencies = new ArrayList();
                    }
                    this.list = this._dependencies;
                    this.state = 210;
                    return;
                }
            }
            case 70: {
                if (name.equals("access-control-list")) {
                    if (this._grants == null) {
                        this._grants = new ArrayList();
                    }
                    this.list = this._grants;
                    this.state = 400;
                    return;
                }
            }
            case 80: {
                break;
            }
            case 310: {
                if (name.equals("name")) {
                    this.state = 310;
                    return;
                }
                throw new SAXException("mandatory tag <name> missing in reference");
            }
            case 320: {
                if (name.equals("vendor")) {
                    this.state = 320;
                    return;
                }
                throw new SAXException("mandatory tag <vendor> missing in reference");
            }
            case 330: {
                if (name.equals("sc-alias")) {
                    this.state = 330;
                    return;
                }
            }
            case 340: {
                if (!this.readList) break;
                if (name.equals("dc-ref")) {
                    this.ref = new DCReference();
                } else if (name.equals("sc-ref")) {
                    this.ref = new SCReference();
                }
                if (this.ref == null) break;
                this.list.add(this.ref);
                this.state = 310;
                return;
            }
            case 210: {
                if (!name.equals("sc-ref")) break;
                this.ref = new SCReference();
                this.list.add(this.ref);
                this.state = 310;
                this.readList = true;
                return;
            }
            case 400: {
                if (!name.equals("grant")) break;
                this.state = 410;
                return;
            }
            case 410: {
                if (name.equals("sc-ref")) {
                    this.ref = new SCReference();
                }
                if (this.ref == null) break;
                this.list.add(this.ref);
                this.state = 310;
                return;
            }
            default: {
                throw new SAXException("internal state error: startTag(" + this.rootTag + ") state(" + this.state + ")");
            }
        }
        this.recoverTagName = name;
        this.recoverMode = this.state;
        this.state = 1;
    }

    protected boolean endTag(String name) throws SAXException {
        switch (this.state) {
            case 1: {
                this.dropTagValue();
                if (!name.equals(this.recoverTagName)) {
                    return true;
                }
                this.recoverTagName = null;
                this.state = this.recoverMode;
                return true;
            }
            case 10: {
                this._name = this.getStringValue();
                if (this._name.length() == 0) {
                    throw new SAXException("software component name must not be an empty string");
                }
                this.state = 20;
                return true;
            }
            case 20: {
                this._vendor = this.getStringValue();
                if (this._vendor.length() == 0) {
                    throw new SAXException("software component vendor must not be an empty string");
                }
                this.state = 30;
                return true;
            }
            case 30: {
                this._caption = this.getStringValue();
                this.state = 40;
                return true;
            }
            case 40: {
                this._description = this.getStringValue();
                this.state = 60;
                return true;
            }
            case 60: 
            case 210: {
                if (name.equals("dependencies")) {
                    this.state = 70;
                    this.list = null;
                    return true;
                }
            }
            case 410: {
                if (name.equals("grant")) {
                    throw new SAXException("mandatory tag <dc-ref> or <sc-ref> expected inside <grant>");
                }
            }
            case 70: 
            case 80: {
                return !name.equals(this.rootTag);
            }
            case 310: {
                if (name.equals("name")) {
                    String refname = this.getStringValue();
                    if (refname.length() == 0) {
                        throw new SAXException("name part of a component reference must not be an empty string");
                    }
                    this.ref.setName(refname);
                    this.state = 320;
                    return true;
                }
                throw new SAXException("mandatory tag <name> missing in reference");
            }
            case 320: {
                if (name.equals("vendor")) {
                    String refvendor = this.getStringValue();
                    if (refvendor.length() == 0) {
                        throw new SAXException("vendor part of a component reference must not be an empty string");
                    }
                    this.ref.setVendor(refvendor);
                    this.state = 330;
                    return true;
                }
                throw new SAXException("mandatory tag <vendor> missing in reference");
            }
            case 330: {
                if (name.equals("sc-alias")) {
                    String refalias = this.getStringValue();
                    if (refalias.length() == 0) {
                        throw new SAXException("alias part of a component reference must not be an empty string");
                    }
                    this.ref.setSCAlias(refalias);
                    this.state = 340;
                    return true;
                }
            }
            case 340: 
            case 400: {
                if (name.equals("dc-ref")) {
                    if (this.ref.getSCAlias() != null) {
                        throw new SAXException("<sc-alias> not allowed for DC references to assigned components");
                    }
                } else if (name.equals("dependencies")) {
                    this.state = 70;
                    this.list = null;
                    this.readList = false;
                } else if (name.equals("grant")) {
                    this.state = 400;
                } else if (name.equals("access-control-list")) {
                    this.list = null;
                    this.state = 80;
                }
                return true;
            }
        }
        throw new SAXException("internal state error: endTag(" + this.rootTag + ") state(" + this.state + ")");
    }
}

