/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.complib.impl;

import com.sap.tc.complib.ComponentFactory;
import com.sap.tc.complib.ComponentReference;
import com.sap.tc.complib.DCReference;
import com.sap.tc.complib.Entity;
import com.sap.tc.complib.EntityReference;
import com.sap.tc.complib.Identifiable;
import com.sap.tc.complib.Property;
import com.sap.tc.complib.PropertyElement;
import com.sap.tc.complib.PublicPart;
import com.sap.tc.complib.SCReference;
import com.sap.tc.complib.impl.EntityImpl;
import com.sap.tc.complib.impl.ImportedEntityImpl;
import com.sap.tc.complib.impl.PropertyImpl;
import com.sap.tc.complib.namecheck.NameCheckException;
import com.sap.tc.complib.namecheck.NameChecker;
import com.sap.tc.complib.provider.PPInputProvider;
import com.sap.tc.complib.provider.PPOutputProvider;
import com.sap.tc.complib.provider.ProviderException;
import com.sap.tc.complib.validate.InvalidFileFormatException;
import com.sap.tc.complib.validate.InvalidMemberException;
import com.sap.tc.complib.validate.MissingElementException;
import com.sap.tc.complib.validate.ValidationException;
import com.sap.tc.complib.xml.Initializable;
import com.sap.tc.complib.xml.ParserAdapter;
import com.sap.tc.complib.xml.XMLException;
import com.sap.tc.complib.xml.XMLWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PublicPartImpl
extends Initializable
implements PublicPart {
    private String _name;
    private PublicPart.Purpose _purpose;
    private String _caption;
    private String _description;
    private boolean _deprecated = false;
    private List _grants;
    private List _entities;
    private List _importedEntities;
    private String rootTag;
    private List list;
    private ComponentReference ref = null;
    private EntityImpl entity;
    private ImportedEntityImpl entityRef = null;
    private PropertyImpl extension;
    private PropertyElement node;
    private static final int PP_NAME = 10;
    private static final int PP_TYPE = 20;
    private static final int PP_CAPTION = 30;
    private static final int PP_DESCRIPTION = 40;
    private static final int PP_DEPRECATED = 42;
    private static final int PP_ENTITIES = 45;
    private static final int PP_ACL = 50;
    private static final int PP_EXTENSIONS = 55;
    private static final int PP_EXTENSION_CHILD = 56;
    private static final int PP_FINAL = 60;
    private static final int ACL_GRANTS = 100;
    private static final int ACL_GRANT = 110;
    private static final int PPE_ENTITIES = 200;
    private static final int PPE_ENTITY = 210;
    private static final int PPE_ENTITY_REF = 220;
    private static final int PPE_FINAL = 230;
    private static final int REF = 300;
    private static final int REF_NAME = 310;
    private static final int REF_VENDOR = 320;
    private static final int REF_ALIAS = 330;
    private static final int REF_FINAL = 340;

    public PublicPartImpl() {
        this._schemaVersion = "1.0.1";
        this._apiVersion = "1.0.0";
    }

    public PublicPartImpl(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public PublicPart.Purpose getPurpose() {
        return this._purpose;
    }

    public void setPurpose(PublicPart.Purpose purpose) {
        this._purpose = purpose;
    }

    public String getCaption() {
        return this._caption;
    }

    public void setCaption(String caption) {
        this._caption = caption;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public boolean isDeprecated() {
        return this._deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        if (deprecated) {
            this._apiVersion = "1.0.2".compareTo(this._apiVersion) > 0 ? "1.0.2" : this._apiVersion;
        }
        this._deprecated = deprecated;
    }

    public List getGrants() {
        return this._grants;
    }

    public List emptyGrants() {
        if (this._grants != null) {
            this._grants.clear();
        } else {
            this._grants = new ArrayList();
        }
        return this._grants;
    }

    public List getEntities() {
        return this._entities;
    }

    public List emptyEntities() {
        if (this._entities != null) {
            this._entities.clear();
        } else {
            this._entities = new ArrayList();
        }
        return this._entities;
    }

    public List getImportedEntities() {
        return this._importedEntities;
    }

    public List emptyImportedEntities() {
        if (this._importedEntities != null) {
            this._importedEntities.clear();
        } else {
            this._importedEntities = new ArrayList();
        }
        return this._importedEntities;
    }

    public Reader getSchema() {
        InputStream resource = this.getClass().getResourceAsStream("ppdef.xsd");
        return new InputStreamReader(resource);
    }

    public void validate() throws ValidationException {
        Identifiable child;
        Iterator iter;
        if (this._name == null) {
            throw new MissingElementException("name");
        }
        try {
            NameChecker.checkPublicPartName(this._name);
        }
        catch (NameCheckException ex) {
            throw new ValidationException("invalid public part name", ex);
        }
        if (this._purpose == null) {
            throw new MissingElementException("purpose");
        }
        if (this._grants != null && this._grants.size() > 0) {
            iter = this._grants.iterator();
            child = null;
            try {
                while (iter.hasNext()) {
                    child = (ComponentReference)iter.next();
                    child.validate();
                }
            }
            catch (ClassCastException ex) {
                throw new InvalidMemberException("grants", child);
            }
        }
        if (this._entities != null && this._entities.size() > 0) {
            iter = this._entities.iterator();
            child = null;
            try {
                while (iter.hasNext()) {
                    child = (Entity)iter.next();
                    child.validate();
                }
            }
            catch (ClassCastException ex) {
                throw new InvalidMemberException("entities", child);
            }
        }
        if (this._importedEntities != null && this._importedEntities.size() > 0) {
            iter = this._importedEntities.iterator();
            child = null;
            try {
                while (iter.hasNext()) {
                    child = (EntityReference)iter.next();
                    ((EntityReference)child).validate();
                }
            }
            catch (ClassCastException ex) {
                throw new InvalidMemberException("importedEntities", child);
            }
        }
    }

    public void serialize(PPOutputProvider provider) throws IOException, ProviderException {
        OutputStream out = provider.getStreamForPublicPart();
        XMLWriter writer = new XMLWriter(out);
        try {
            this.serialize(writer);
        }
        catch (ValidationException ex) {
            throw new ProviderException("Serialization failed", ex);
        }
        writer.serialize();
        provider.releaseStream(out);
    }

    public void serialize(PPOutputProvider provider, String formatVersion) throws IOException, ProviderException {
        OutputStream out = provider.getStreamForPublicPart();
        XMLWriter writer = new XMLWriter(out);
        try {
            this.serialize(writer, formatVersion);
        }
        catch (ValidationException ex) {
            throw new ProviderException("Serialization failed", ex);
        }
        writer.serialize();
        provider.releaseStream(out);
    }

    public void initialize(PPInputProvider provider) throws IOException, XMLException, ProviderException {
        InputStream in = null;
        try {
            block4: {
                try {
                    in = provider.getStreamForPublicPart();
                    if (in == null) break block4;
                    ParserAdapter parser = new ParserAdapter(this);
                    parser.parse(in);
                }
                catch (SAXException ex) {
                    throw new XMLException("Initializing public part failed", ex);
                }
            }
            Object var5_5 = null;
            provider.releaseStream(in);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            provider.releaseStream(in);
            throw throwable;
        }
    }

    public void serialize(XMLWriter writer) throws ValidationException {
        this.updateSchemaVersion();
        if (!ComponentFactory.isSchemaAllowed(this._schemaVersion)) {
            throw new InvalidFileFormatException("Cannot serialize public part with schema version '" + this._schemaVersion + "'. The version number is unknown." + " Latest known schema version is " + "1.0.2");
        }
        if (!this._isSchemaAllowed()) {
            throw new InvalidFileFormatException("Cannot serialize public part with schema version '" + this._schemaVersion + "' since public part uses" + " features from API version " + this._apiVersion);
        }
        this.serialize(writer, this._schemaVersion);
    }

    public void serialize(XMLWriter writer, String schemaVersion) throws ValidationException {
        Iterator iter;
        if (schemaVersion == null) {
            this.updateSchemaVersion();
            schemaVersion = this._schemaVersion;
        }
        if (!ComponentFactory.isSchemaAllowed(schemaVersion)) {
            throw new InvalidFileFormatException("Cannot serialize public part with schema version '" + schemaVersion + "'. Latest known schema version is " + "1.0.2");
        }
        if (this._name == null) {
            throw new ValidationException("Public Parts must have a name.");
        }
        try {
            NameChecker.checkPublicPartName(this._name);
        }
        catch (NameCheckException ex) {
            throw new ValidationException("Public Parts must have a valid name.", ex);
        }
        if (this._purpose == null) {
            throw new ValidationException("Public Parts must have a purpose.");
        }
        if (this._attributes == null) {
            this._attributes = new ArrayList();
        }
        this.setAttribute("xmlns", "http://xml.sap.com/2002/11/PublicPart");
        this.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.setAttribute("xsi:schemaLocation", "http://xml.sap.com/2002/11/PublicPart ppdef.xsd");
        String versionAttr = schemaVersion == null ? this._apiVersion : schemaVersion;
        this.setAttribute("version", versionAttr);
        this.setAttribute("xmlns:IDX", "urn:sap.com:PublicPart:1.0");
        writer.beginDocument();
        writer.wrapAttributeLists(true);
        writer.writeRootTag("public-part", this.getAttributes());
        writer.wrapAttributeLists(false);
        writer.writeTag("name", this._name);
        writer.writeTag("purpose", this._purpose.toString());
        if (this._caption != null) {
            writer.writeTag("caption", this._caption);
        }
        if (this._description != null) {
            writer.writeTag("description", this._description);
        }
        if (this._deprecated && this.doSerialize(schemaVersion, "1.0.2")) {
            writer.writeEmptyTag("deprecated");
        }
        if (this._entities != null && this._entities.size() > 0 || this._importedEntities != null && this._importedEntities.size() > 0) {
            try {
                writer.beginTag("entities");
                if (this._entities != null && this._entities.size() > 0) {
                    iter = this._entities.iterator();
                    while (iter.hasNext()) {
                        ((Entity)iter.next()).serialize(writer, schemaVersion);
                    }
                }
            }
            catch (ClassCastException ex) {
                throw new ValidationException("List of entities contains an entry that is not of type Entity");
            }
            try {
                if (this._importedEntities != null && this._importedEntities.size() > 0) {
                    iter = this._importedEntities.iterator();
                    while (iter.hasNext()) {
                        ((EntityReference)iter.next()).serialize(writer, schemaVersion);
                    }
                }
                writer.endTag("entities");
            }
            catch (ClassCastException ex) {
                throw new ValidationException("List of imported entities contains an entry that is not of type EntityReference");
            }
        }
        if (this._grants != null && this._grants.size() > 0) {
            try {
                writer.beginTag("access-control-list");
                iter = this._grants.iterator();
                while (iter.hasNext()) {
                    writer.beginTag("grant");
                    ((ComponentReference)iter.next()).serialize(writer);
                    writer.endTag("grant");
                }
                writer.endTag("access-control-list");
            }
            catch (ClassCastException ex) {
                throw new ValidationException("List of grants contains an entry that is not of type ComponentReference");
            }
        }
        if (this._extensions != null && this._extensions.size() > 0) {
            int i = 0;
            while (i < this._extensions.size()) {
                Property prop = (Property)this._extensions.get(i);
                String namespace = prop.getNamespace();
                String prefix = prop.getNamespacePrefix();
                if (namespace != null && prefix == null) {
                    prefix = "pns" + Integer.toString(i);
                    prop.setNamespace(prefix, namespace);
                }
                prop.serialize(writer);
                ++i;
            }
        }
        writer.endDocument();
    }

    public boolean isSchemaAllowed() {
        this.updateSchemaVersion();
        return this._isSchemaAllowed();
    }

    public boolean isSchemaAllowed(String schemaVersion) {
        this.updateSchemaVersion();
        return this._isSchemaAllowed(schemaVersion);
    }

    public String getSchemaVersion() {
        this.updateSchemaVersion();
        return this._schemaVersion;
    }

    private void updateSchemaVersion() {
        Initializable next;
        String entityAPIVersion;
        String entitySchemaVersion;
        Iterator iter;
        if (this._entities != null && this._entities.size() > 0) {
            iter = this._entities.iterator();
            entitySchemaVersion = null;
            entityAPIVersion = null;
            while (iter.hasNext()) {
                try {
                    next = (Initializable)iter.next();
                    entitySchemaVersion = next._getSchemaVersion();
                    entityAPIVersion = next._getAPIVersion();
                }
                catch (ClassCastException e) {
                    continue;
                }
                if (this._schemaVersion.compareTo(entitySchemaVersion) < 0) {
                    this._schemaVersion = entitySchemaVersion;
                }
                if (this._apiVersion.compareTo(entityAPIVersion) >= 0) continue;
                this._apiVersion = entityAPIVersion;
            }
        }
        if (this._importedEntities != null && this._importedEntities.size() > 0) {
            iter = this._importedEntities.iterator();
            entitySchemaVersion = null;
            entityAPIVersion = null;
            while (iter.hasNext()) {
                try {
                    next = (Initializable)iter.next();
                    entitySchemaVersion = next._getSchemaVersion();
                    entityAPIVersion = next._getAPIVersion();
                }
                catch (ClassCastException e) {
                    continue;
                }
                if (this._schemaVersion.compareTo(entitySchemaVersion) < 0) {
                    this._schemaVersion = entitySchemaVersion;
                }
                if (this._apiVersion.compareTo(entityAPIVersion) >= 0) continue;
                this._apiVersion = entityAPIVersion;
            }
        }
        if (!this._initialized && this._schemaVersion.compareTo(this._apiVersion) < 0) {
            this._schemaVersion = this._apiVersion;
        }
    }

    protected void tagValue(char[] chars, int start, int length) {
        switch (this.state) {
            case 210: {
                this.entity.tagValue(chars, start, length);
                return;
            }
            case 220: {
                this.entityRef.tagValue(chars, start, length);
                return;
            }
        }
        super.tagValue(chars, start, length);
    }

    protected void startTag(String name, Attributes attributes) throws SAXException {
        switch (this.state) {
            case 0: {
                String versionAttr;
                if (name.equals("public-part")) {
                    this.dropTagValue();
                    versionAttr = attributes.getValue("version");
                    if (versionAttr == null) {
                        throw new SAXException("Unable to read public part: Missing 'version' attribute");
                    }
                } else {
                    throw new SAXException("root tag expected <public-part>");
                }
                this._setSchemaVersion(versionAttr);
                this._attributes = this.getAttributes(attributes);
                this.rootTag = name;
                this.state = 10;
                return;
            }
            case 1: {
                return;
            }
            case 10: {
                if (name.equals("name")) {
                    this.state = 10;
                    return;
                }
                throw new SAXException("mandatory tag <name> expected");
            }
            case 20: {
                if (name.equals("purpose")) {
                    this.state = 20;
                    return;
                }
                throw new SAXException("mandatory tag <purpose> expected");
            }
            case 30: {
                if (name.equals("caption")) {
                    this.state = 30;
                    return;
                }
            }
            case 40: {
                if (name.equals("description")) {
                    this.state = 40;
                    return;
                }
            }
            case 42: {
                if (name.equals("deprecated")) {
                    this._deprecated = true;
                    this.state = 42;
                    return;
                }
            }
            case 45: {
                if (name.equals("entities")) {
                    this.state = 200;
                    return;
                }
            }
            case 50: {
                if (name.equals("access-control-list")) {
                    this.state = 100;
                    return;
                }
            }
            case 55: {
                this.dropTagValue();
                if (this.extension == null) {
                    this.extension = new PropertyImpl(name);
                    this.extension.setAttributes(this.getAttributes(attributes));
                    this.state = 55;
                    return;
                }
                PropertyElement elem = this.extension.addChild(name);
                elem.setAttributes(this.getAttributes(attributes));
                this.state = 56;
                this.node = this.extension.lastChild();
                return;
            }
            case 60: {
                break;
            }
            case 200: {
                if (name.equals("entity")) {
                    if (this._entities == null) {
                        this._entities = this.emptyEntities();
                    }
                    this.entity = new EntityImpl();
                    this.entity._setSchemaVersion(this._schemaVersion);
                    this.state = 210;
                    this.entity.startTag(name, attributes);
                    return;
                }
                if (!name.equals("entity-ref")) break;
                if (this._importedEntities == null) {
                    this._importedEntities = this.emptyImportedEntities();
                }
                this.entityRef = new EntityReference();
                this.entityRef._setSchemaVersion(this._schemaVersion);
                this.state = 220;
                this.entityRef.startTag(name, attributes);
                return;
            }
            case 210: {
                this.entity.startTag(name, attributes);
                return;
            }
            case 220: {
                this.entityRef.startTag(name, attributes);
                return;
            }
            case 230: {
                break;
            }
            case 100: {
                if (!name.equals("grant")) break;
                this.state = 110;
                return;
            }
            case 110: {
                if (name.equals("dc-ref")) {
                    this.ref = new DCReference();
                } else if (name.equals("sc-ref")) {
                    this.ref = new SCReference();
                }
                if (this.ref == null) break;
                if (this._grants == null) {
                    this._grants = new ArrayList();
                }
                this.list = this._grants;
                this.list.add(this.ref);
                this.state = 310;
                return;
            }
            case 56: {
                PropertyElement elem = this.node.addChild(name);
                elem.setAttributes(this.getAttributes(attributes));
                this.node = this.node.lastChild();
                return;
            }
            case 300: {
                if (!name.equals("dc-ref") && !name.equals("sc-ref")) break;
                this.state = 310;
                return;
            }
            case 310: {
                if (name.equals("name")) {
                    this.state = 310;
                    return;
                }
                throw new SAXException("mandatory tag <name> expected in reference");
            }
            case 320: {
                if (name.equals("vendor")) {
                    this.state = 320;
                    return;
                }
                throw new SAXException("mandatory tag <vendor> expected in reference");
            }
            case 330: {
                if (name.equals("sc-alias")) {
                    this.state = 330;
                    return;
                }
            }
            case 340: {
                break;
            }
            default: {
                throw new SAXException("internal state error: startTag(" + this.rootTag + ") state(" + this.state + ")");
            }
        }
        this.recoverTagName = name;
        this.recoverMode = this.state;
        this.state = 1;
    }

    protected boolean endTag(String name) throws SAXException {
        switch (this.state) {
            case 1: {
                this.dropTagValue();
                if (!name.equals(this.recoverTagName)) {
                    return true;
                }
                this.recoverTagName = null;
                this.state = this.recoverMode;
                return true;
            }
            case 10: {
                this._name = this.getStringValue();
                if (this._name.length() == 0) {
                    throw new SAXException("public part name must not be an empty string");
                }
                this.state = 20;
                return true;
            }
            case 20: {
                String purpose = this.getStringValue();
                if (purpose.length() == 0) {
                    throw new SAXException("public part purpose must not be an empty string");
                }
                try {
                    this._purpose = PublicPart.Purpose.valueOf(purpose);
                }
                catch (IllegalArgumentException ex) {
                    throw new SAXException("invalid public part purpose: " + purpose);
                }
                this.state = 30;
                return true;
            }
            case 30: {
                this._caption = this.getStringValue();
                this.state = 40;
                return true;
            }
            case 40: {
                this._description = this.getStringValue();
                this.state = 42;
                return true;
            }
            case 42: {
                this.state = 45;
                return true;
            }
            case 200: {
                if (name.equals("entities")) {
                    this.state = 50;
                    return true;
                }
            }
            case 110: {
                if (name.equals("grant")) {
                    throw new SAXException("mandatory tag <dc-ref> or <sc-ref> expected inside <grant>");
                }
            }
            case 55: {
                if (this.extension != null && name.equals(this.extension.getName())) {
                    if (this.extension.firstChild() == null && !this.isEmptyTag()) {
                        this.extension.setValue(this.getStringValue());
                    }
                    if (this._extensions == null) {
                        this._extensions = new ArrayList();
                    }
                    this._extensions.add(this.extension);
                    this.extension = null;
                    return true;
                }
            }
            case 45: 
            case 50: 
            case 60: {
                return !name.equals(this.rootTag);
            }
            case 210: {
                if (this.entity.endTag(name)) {
                    return true;
                }
                this._entities.add(this.entity);
                this.entity = null;
                this.state = 200;
                return true;
            }
            case 220: {
                if (this.entityRef.endTag(name)) {
                    return true;
                }
                this._importedEntities.add(this.entityRef);
                this.entityRef = null;
                this.state = 200;
                return true;
            }
            case 56: {
                if (this.node.firstChild() == null && !this.isEmptyTag()) {
                    this.node.setValue(this.getStringValue());
                }
                if (this.node.getParent() != null) {
                    this.node = this.node.getParent();
                } else {
                    if (this._extensions == null) {
                        this._extensions = new ArrayList();
                    }
                    this._extensions.add(this.extension);
                    this.extension = null;
                    this.state = 55;
                }
                return true;
            }
            case 310: {
                if (name.equals("name")) {
                    String refname = this.getStringValue();
                    if (refname.length() == 0) {
                        throw new SAXException("name part of a component or public part reference must not be an empty string");
                    }
                    this.ref.setName(refname);
                    this.state = 320;
                    return true;
                }
                throw new SAXException("mandatory tag <name> missing in reference");
            }
            case 320: {
                if (name.equals("vendor")) {
                    String refvendor = this.getStringValue();
                    if (refvendor.length() == 0) {
                        throw new SAXException("vendor part of a component or public part reference must not be an empty string");
                    }
                    this.ref.setVendor(refvendor);
                    this.state = 330;
                    return true;
                }
                throw new SAXException("mandatory tag <vendor> missing in reference");
            }
            case 330: {
                if (name.equals("sc-alias")) {
                    String refalias = this.getStringValue();
                    if (refalias.length() == 0) {
                        throw new SAXException("alias part of a component or public part reference must not be an empty string");
                    }
                    this.ref.setSCAlias(refalias);
                    this.state = 340;
                    return true;
                }
            }
            case 100: 
            case 340: {
                if (name.equals("grant")) {
                    this.state = 100;
                } else if (name.equals("access-control-list")) {
                    this.list = null;
                    this.state = 55;
                }
                return true;
            }
        }
        throw new SAXException("internal state error: endTag(" + this.rootTag + ") state(" + this.state + ")");
    }
}

