/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.complib.impl;

import com.sap.tc.complib.PropertyElement;
import com.sap.tc.complib.xml.Attribute;
import com.sap.tc.complib.xml.XMLWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class PropertyElementImpl
implements PropertyElement {
    private String name;
    private String prefix;
    private String namespaceURI;
    private String value;
    private PropertyElementImpl next;
    private PropertyElementImpl firstChild;
    private PropertyElementImpl lastChild;
    private PropertyElementImpl parent;
    private int count = 0;
    private List _attributes;

    public PropertyElementImpl() {
    }

    public PropertyElementImpl(PropertyElementImpl parent, String name) {
        this.parent = parent;
        int n = name.indexOf(58);
        if (n > 0) {
            this.prefix = name.substring(0, n);
            this.name = name.substring(n + 1);
        } else {
            this.name = name;
        }
    }

    public PropertyElementImpl(PropertyElementImpl parent, String name, String value) {
        this(parent, name);
        this.setValue(value);
    }

    public String getName() {
        return this.name;
    }

    public String getQName() {
        return this.prefix == null ? this.name : this.prefix + ":" + this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNamespacePrefix() {
        return this.prefix;
    }

    public String getNamespace() {
        return this.namespaceURI;
    }

    public void setNamespace(String namespaceURI) {
        this.namespaceURI = namespaceURI;
    }

    public void setNamespace(String prefix, String namespaceURI) {
        this.namespaceURI = namespaceURI;
        this.prefix = prefix;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.emptyChildren();
        this.value = value;
    }

    public int countChildren() {
        return this.count;
    }

    public PropertyElement firstChild() {
        return this.firstChild;
    }

    public PropertyElement lastChild() {
        return this.lastChild;
    }

    public PropertyElement next() {
        return this.next;
    }

    public PropertyElement getParent() {
        return this.parent;
    }

    public Iterator getChildren() {
        return new Iterator(){
            private PropertyElementImpl child;
            {
                this.child = PropertyElementImpl.this.firstChild;
            }

            public boolean hasNext() {
                return this.child != null;
            }

            public Object next() {
                if (this.child == null) {
                    throw new NoSuchElementException();
                }
                PropertyElementImpl result = this.child;
                this.child = this.child.next;
                return result;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void emptyChildren() {
        PropertyElementImpl child = this.firstChild;
        while (child != null) {
            PropertyElementImpl next = child.next;
            child.next = null;
            child = next;
            next = null;
        }
        this.firstChild = null;
        this.lastChild = null;
    }

    public PropertyElement addChild(String childName) {
        this.lastChild = this.lastChild != null ? (this.lastChild.next = new PropertyElementImpl(this, childName)) : (this.firstChild = new PropertyElementImpl(this, childName));
        ++this.count;
        return this.lastChild;
    }

    public PropertyElement addChild(String childName, String value) {
        this.lastChild = this.lastChild != null ? (this.lastChild.next = new PropertyElementImpl(this, childName)) : (this.firstChild = new PropertyElementImpl(this, childName));
        ++this.count;
        this.lastChild.setValue(value);
        return this.lastChild;
    }

    public PropertyElement getChild(String childName) {
        PropertyElementImpl child = this.firstChild;
        int n = childName.indexOf(58);
        String simpleName = n > 0 ? childName.substring(n + 1) : childName;
        while (child != null) {
            if (simpleName.equals(child.name)) break;
            child = child.next;
        }
        return child;
    }

    public String getChildValue(String childName) {
        PropertyElement child = this.getChild(childName);
        return child != null ? child.getValue() : null;
    }

    public String[] getChildValues() {
        ArrayList<String> values = new ArrayList<String>();
        PropertyElementImpl child = this.firstChild;
        if (child != null) {
            int i = 0;
            while (i < this.count) {
                if (child.getValue() != null) {
                    values.add(child.getValue());
                }
                child = child.next;
                ++i;
            }
        }
        return values.toArray(new String[values.size()]);
    }

    public void setAttributes(List attributes) {
        this._attributes = attributes;
        if (this._attributes != null) {
            String tagName = "xmlns";
            if (this.prefix != null) {
                tagName = "xmlns:" + this.prefix;
            }
            Iterator iter = this._attributes.iterator();
            while (iter.hasNext()) {
                Attribute attr = (Attribute)iter.next();
                if (!attr.name.equals(tagName)) continue;
                this.namespaceURI = attr.value;
                return;
            }
        }
    }

    public void setAttribute(String name, String value) {
        if (this._attributes == null) {
            this._attributes = new ArrayList();
        }
        Iterator iter = this._attributes.iterator();
        while (iter.hasNext()) {
            Attribute attr = (Attribute)iter.next();
            if (!attr.name.equals(name)) continue;
            attr.value = value;
            return;
        }
        this._attributes.add(new Attribute(name, value));
    }

    public Attribute[] getAttributes() {
        return this._attributes != null ? this._attributes.toArray(new Attribute[this._attributes.size()]) : null;
    }

    public void serialize(XMLWriter writer) {
        String tagName = this.name;
        if (this.prefix != null) {
            tagName = this.prefix + ":" + this.name;
            if (this.namespaceURI != null) {
                this.setAttribute("xmlns:" + this.prefix, this.namespaceURI);
            }
        } else if (this.namespaceURI != null) {
            this.setAttribute("xmlns", this.namespaceURI);
        }
        if (this.firstChild == null) {
            if (this.value != null) {
                writer.writeTag(tagName, this.value, this.getAttributes());
            } else {
                writer.writeEmptyTag(tagName, this.getAttributes());
            }
            return;
        }
        writer.beginTag(tagName, this.getAttributes());
        PropertyElementImpl child = this.firstChild;
        while (child != null) {
            child.serialize(writer);
            child = child.next;
        }
        writer.endTag(tagName);
    }
}

