/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.complib.impl;

import com.sap.tc.complib.Package;
import com.sap.tc.complib.validate.MissingElementException;
import com.sap.tc.complib.validate.ValidationException;
import com.sap.tc.complib.xml.Initializable;
import com.sap.tc.complib.xml.XMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PackageImpl
extends Initializable
implements Package {
    private String _name;
    private String _caption;
    private String _description;
    private String rootTag;
    private static final int PACKAGE_NAME = 10;
    private static final int PACKAGE_CAPTION = 20;
    private static final int PACKAGE_DESCRIPTION = 30;
    private static final int PACKAGE_FINAL = 40;

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getCaption() {
        return this._caption;
    }

    public void setCaption(String caption) {
        this._caption = caption;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void validate() throws ValidationException {
        if (this._name == null) {
            throw new MissingElementException("name");
        }
    }

    public void serialize(XMLWriter writer) throws ValidationException {
        if (this._name == null) {
            throw new ValidationException("Packages must have a name.");
        }
        writer.beginTag("package");
        writer.writeTag("name", this._name);
        if (this._caption != null) {
            writer.writeTag("caption", this._caption);
        }
        if (this._description != null) {
            writer.writeTag("description", this._description);
        }
        writer.endTag("package");
    }

    protected void tagValue(char[] chars, int start, int length) {
        super.tagValue(chars, start, length);
    }

    protected void startTag(String name, Attributes attributes) throws SAXException {
        switch (this.state) {
            case 0: {
                this.getStringValue();
                if (!name.equals("package")) {
                    throw new SAXException("root tag expected <package>");
                }
                this.state = 10;
                this.rootTag = name;
                return;
            }
            case 1: {
                return;
            }
            case 10: {
                if (name.equals("name")) {
                    this.state = 10;
                    return;
                }
                throw new SAXException("mandatory tag <name> expected");
            }
            case 20: {
                if (name.equals("caption")) {
                    this.state = 20;
                    return;
                }
            }
            case 30: {
                if (name.equals("description")) {
                    this.state = 30;
                    return;
                }
            }
            case 40: {
                break;
            }
            default: {
                throw new SAXException("internal state error: startTag(" + this.rootTag + ") state(" + this.state + ")");
            }
        }
        this.recoverTagName = name;
        this.recoverMode = this.state;
        this.state = 1;
    }

    protected boolean endTag(String name) throws SAXException {
        switch (this.state) {
            case 1: {
                this.dropTagValue();
                if (!name.equals(this.recoverTagName)) {
                    return true;
                }
                this.recoverTagName = null;
                this.state = this.recoverMode;
                return true;
            }
            case 10: {
                if (name.equals("name")) {
                    this._name = this.getStringValue();
                    if (this._name.length() == 0) {
                        throw new SAXException("package name must not be an empty string");
                    }
                    this.state = 20;
                    return true;
                }
                throw new SAXException("mandatory tag <name> expected");
            }
            case 20: {
                if (name.equals("caption")) {
                    this._caption = this.getStringValue();
                    this.state = 30;
                    return true;
                }
            }
            case 30: {
                if (name.equals("description")) {
                    this._description = this.getStringValue();
                    this.state = 40;
                    return true;
                }
            }
            case 40: {
                return !name.equals(this.rootTag);
            }
        }
        throw new SAXException("internal state error: endTag(" + this.rootTag + ") state(" + this.state + ")");
    }
}

