/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.complib.impl;

import com.sap.tc.complib.ComponentFactory;
import com.sap.tc.complib.DCReference;
import com.sap.tc.complib.ImportedEntity;
import com.sap.tc.complib.Property;
import com.sap.tc.complib.PropertyElement;
import com.sap.tc.complib.impl.PropertyImpl;
import com.sap.tc.complib.keygen.KeyGenerator;
import com.sap.tc.complib.validate.InvalidFileFormatException;
import com.sap.tc.complib.validate.MissingElementException;
import com.sap.tc.complib.validate.ValidationException;
import com.sap.tc.complib.xml.Initializable;
import com.sap.tc.complib.xml.XMLWriter;
import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ImportedEntityImpl
extends Initializable
implements ImportedEntity {
    private String _name;
    private String _packageName;
    private String _type;
    private String _subtype;
    private DCReference _component;
    private String _publicPart;
    private final String m_key = KeyGenerator.getInstance().createKey(this.getClass());
    private String rootTag;
    private PropertyImpl extension;
    private PropertyElement node;
    private static final int ENTITY_DCREF = 5;
    private static final int ENTITY_PPREF = 6;
    private static final int ENTITY_NAME = 10;
    private static final int ENTITY_PACKAGE = 15;
    private static final int ENTITY_TYPE = 40;
    private static final int ENTITY_SUBTYPE = 50;
    private static final int ENTITY_EXTENSIONS = 70;
    private static final int ENTITY_EXTENSION_CHILD = 71;
    private static final int ENTITY_FINAL = 90;
    private static final int REF_NAME = 100;
    private static final int REF_VENDOR = 110;
    private static final int REF_ALIAS = 120;
    private static final int REF_FINAL = 130;

    public ImportedEntityImpl() {
        this._schemaVersion = "1.0.1";
        this._apiVersion = "1.0.0";
    }

    public ImportedEntityImpl(String name, String publicPart, DCReference component) {
        this();
        this._name = name;
        this._component = component;
        this._publicPart = publicPart;
    }

    public DCReference getComponent() {
        return this._component;
    }

    public void setComponent(DCReference component) {
        this._component = component;
    }

    public String getPublicPart() {
        return this._publicPart;
    }

    public void setPublicPart(String publicPart) {
        this._publicPart = publicPart;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getPackageName() {
        return this._packageName;
    }

    public void setPackageName(String packageName) {
        this._packageName = packageName;
        this._apiVersion = "1.0.2".compareTo(this._apiVersion) > 0 ? "1.0.2" : this._apiVersion;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }

    public String getSubType() {
        return this._subtype;
    }

    public void setSubType(String subtype) {
        this._subtype = subtype;
        this._apiVersion = "1.0.2".compareTo(this._apiVersion) > 0 ? "1.0.2" : this._apiVersion;
    }

    public void validate() throws ValidationException {
        if (this._component == null) {
            throw new MissingElementException("component");
        }
        if (this._publicPart == null) {
            throw new MissingElementException("publicPart");
        }
    }

    public void serialize(XMLWriter writer) throws ValidationException {
        if (!ComponentFactory.isSchemaAllowed(this._schemaVersion)) {
            throw new InvalidFileFormatException("Cannot serialize entity reference with format version " + this._schemaVersion + ". Latest known schema version is " + "1.0.2");
        }
        if (!this._isSchemaAllowed()) {
            throw new InvalidFileFormatException("Cannot serialize entity reference with format version " + this._schemaVersion + " since this entity reference uses" + " features from API version " + this._apiVersion);
        }
        this.serialize(writer, this._schemaVersion);
    }

    public void serialize(XMLWriter writer, String schemaVersion) throws ValidationException {
        if (schemaVersion == null) {
            schemaVersion = this._schemaVersion;
        }
        if (!ComponentFactory.isSchemaAllowed(schemaVersion)) {
            throw new InvalidFileFormatException("Cannot serialize entity reference with format version " + schemaVersion + ". Latest known schema version is " + "1.0.2");
        }
        if (this._component == null) {
            throw new ValidationException("Entity references must specifiy a source component.");
        }
        if (this._publicPart == null) {
            throw new ValidationException("Entity references must specifiy a public part name.");
        }
        if (this._attributes != null) {
            writer.beginTag("entity-ref", this.getAttributes());
        } else {
            writer.beginTag("entity-ref");
        }
        this._component.serialize(writer);
        writer.writeTag("pp-ref", this._publicPart);
        if (this._name != null) {
            writer.writeTag("name", this._name);
        }
        if (this._packageName != null && this.doSerialize(schemaVersion, "1.0.2")) {
            writer.writeTag("package", this._packageName);
        }
        if (this._type != null) {
            writer.writeTag("entity-type", this._type);
        }
        if (this._subtype != null && this.doSerialize(schemaVersion, "1.0.2")) {
            writer.writeTag("entity-sub-type", this._subtype);
        }
        if (this._extensions != null && this._extensions.size() > 0) {
            int i = 0;
            while (i < this._extensions.size()) {
                Property prop = (Property)this._extensions.get(i);
                String namespace = prop.getNamespace();
                String prefix = prop.getNamespacePrefix();
                if (namespace != null && prefix == null) {
                    prefix = "pns" + Integer.toString(i);
                    prop.setNamespace(prefix, namespace);
                }
                prop.serialize(writer);
                ++i;
            }
        }
        writer.endTag("entity-ref");
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ImportedEntity) {
            ImportedEntityImpl ref = (ImportedEntityImpl)obj;
            boolean equals = true;
            equals &= this._component != null ? this._component.equals(ref._component) : ref._component == null;
            equals &= this._name != null ? this._name.equals(ref._name) : ref._name == null;
            equals &= this._packageName != null ? this._name.equals(ref._packageName) : ref._packageName == null;
            equals &= this._publicPart != null ? this._publicPart.equals(ref._publicPart) : ref._publicPart == null;
            equals &= this._type != null ? this._type.equals(ref._type) : ref._type == null;
            return equals &= this._subtype != null ? this._subtype.equals(ref._subtype) : ref._subtype == null;
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = this._component != null ? 37 * result + this._component.hashCode() : result;
        result = this._name != null ? 37 * result + this._name.hashCode() : result;
        result = this._packageName != null ? 37 * result + this._packageName.hashCode() : result;
        result = this._publicPart != null ? 37 * result + this._publicPart.hashCode() : result;
        result = this._type != null ? 37 * result + this._type.hashCode() : result;
        result = this._subtype != null ? 37 * result + this._subtype.hashCode() : result;
        return result;
    }

    public String getUniqueKey() {
        return this.m_key;
    }

    protected void tagValue(char[] chars, int start, int length) {
        super.tagValue(chars, start, length);
    }

    protected void startTag(String name, Attributes attributes) throws SAXException {
        switch (this.state) {
            case 0: {
                this.dropTagValue();
                if (!name.equals("entity-ref")) {
                    throw new SAXException("root tag expected <entity>");
                }
                this.state = 5;
                this._attributes = this.getAttributes(attributes);
                this.rootTag = name;
                return;
            }
            case 1: {
                return;
            }
            case 5: {
                if (name.equals("dc-ref")) {
                    this._component = new DCReference();
                    this.state = 100;
                    return;
                }
                throw new SAXException("mandatory tag <dc-ref> expected");
            }
            case 6: {
                if (name.equals("pp-ref")) {
                    this.state = 6;
                    return;
                }
                throw new SAXException("mandatory tag <pp-ref> expected");
            }
            case 10: {
                if (name.equals("name")) {
                    this.state = 10;
                    return;
                }
            }
            case 15: {
                if (name.equals("package")) {
                    this.state = 15;
                    return;
                }
            }
            case 40: {
                if (name.equals("entity-type")) {
                    this.state = 40;
                    return;
                }
            }
            case 50: {
                if (name.equals("entity-sub-type")) {
                    this.state = 50;
                    return;
                }
            }
            case 70: {
                this.dropTagValue();
                if (this.extension == null) {
                    this.extension = new PropertyImpl(name);
                    this.extension.setAttributes(this.getAttributes(attributes));
                    this.state = 70;
                    return;
                }
                PropertyElement elem = this.extension.addChild(name);
                elem.setAttributes(this.getAttributes(attributes));
                this.state = 71;
                this.node = this.extension.lastChild();
                return;
            }
            case 90: {
                break;
            }
            case 71: {
                PropertyElement elem = this.node.addChild(name);
                elem.setAttributes(this.getAttributes(attributes));
                this.node = this.node.lastChild();
                return;
            }
            case 100: {
                if (name.equals("name")) {
                    this.state = 100;
                    return;
                }
                throw new SAXException("mandatory tag <name> expected in reference");
            }
            case 110: {
                if (name.equals("vendor")) {
                    this.state = 110;
                    return;
                }
                throw new SAXException("mandatory tag <vendor> expected in reference");
            }
            case 120: {
                if (name.equals("sc-alias")) {
                    this.state = 120;
                    return;
                }
            }
            case 130: {
                break;
            }
            default: {
                throw new SAXException("internal state error: startTag(" + this.rootTag + ") state(" + this.state + ")");
            }
        }
        this.recoverTagName = name;
        this.recoverMode = this.state;
        this.state = 1;
    }

    protected boolean endTag(String name) throws SAXException {
        switch (this.state) {
            case 1: {
                this.dropTagValue();
                if (!name.equals(this.recoverTagName)) {
                    return true;
                }
                this.recoverTagName = null;
                this.state = this.recoverMode;
                return true;
            }
            case 5: {
                if (name.equals("entity-ref")) {
                    throw new SAXException("mandatory tag <dc-ref> expected");
                }
            }
            case 6: {
                if (name.equals("pp-ref")) {
                    String refname = this.getStringValue();
                    if (refname.length() == 0) {
                        throw new SAXException("name part of a public part reference must not be an empty string");
                    }
                    this._publicPart = refname;
                    this.state = 10;
                    return true;
                }
                throw new SAXException("mandatory tag <pp-ref> expected");
            }
            case 10: {
                if (name.equals("name")) {
                    this._name = this.getStringValue();
                    if (this._name.length() == 0) {
                        throw new SAXException("entity name must not be an empty string");
                    }
                    this.state = 15;
                    return true;
                }
            }
            case 15: {
                if (name.equals("package")) {
                    this._packageName = this.getStringValue();
                    if (this._packageName.length() == 0) {
                        throw new SAXException("package must not be an empty string");
                    }
                    this.state = 40;
                    return true;
                }
            }
            case 40: {
                if (name.equals("entity-type")) {
                    this._type = this.getStringValue();
                    if (this._type.length() == 0) {
                        throw new SAXException("entity type must not be an empty string");
                    }
                    this.state = 50;
                    return true;
                }
            }
            case 50: {
                if (name.equals("entity-sub-type")) {
                    this._subtype = this.getStringValue();
                    if (this._subtype.length() == 0) {
                        throw new SAXException("entity subtype must not be an empty string");
                    }
                    this.state = 70;
                    return true;
                }
            }
            case 70: {
                if (this.extension != null && name.equals(this.extension.getName())) {
                    if (this.extension.firstChild() == null && !this.isEmptyTag()) {
                        this.extension.setValue(this.getStringValue());
                    }
                    if (this._extensions == null) {
                        this._extensions = new ArrayList();
                    }
                    this._extensions.add(this.extension);
                    this.extension = null;
                    return true;
                }
            }
            case 90: {
                return !name.equals(this.rootTag);
            }
            case 71: {
                if (this.node.firstChild() == null && !this.isEmptyTag()) {
                    this.node.setValue(this.getStringValue());
                }
                if (this.node.getParent() != null) {
                    this.node = this.node.getParent();
                } else {
                    if (this._extensions == null) {
                        this._extensions = new ArrayList();
                    }
                    this._extensions.add(this.extension);
                    this.extension = null;
                    this.state = 70;
                }
                return true;
            }
            case 100: {
                if (name.equals("name")) {
                    String refname = this.getStringValue();
                    if (refname.length() == 0) {
                        throw new SAXException("name part of a component or public part reference must not be an empty string");
                    }
                    this._component.setName(refname);
                    this.state = 110;
                    return true;
                }
                throw new SAXException("mandatory tag <name> missing in reference");
            }
            case 110: {
                if (name.equals("vendor")) {
                    String refvendor = this.getStringValue();
                    if (refvendor.length() == 0) {
                        throw new SAXException("vendor part of a component or public part reference must not be an empty string");
                    }
                    this._component.setVendor(refvendor);
                    this.state = 120;
                    return true;
                }
                throw new SAXException("mandatory tag <vendor> missing in reference");
            }
            case 120: {
                if (name.equals("sc-alias")) {
                    String refalias = this.getStringValue();
                    if (refalias.length() == 0) {
                        throw new SAXException("alias part of a component or public part reference must not be an empty string");
                    }
                    this._component.setSCAlias(refalias);
                    this.state = 130;
                    return true;
                }
            }
            case 130: {
                if (name.equals("dc-ref")) {
                    this.state = 6;
                }
                return true;
            }
        }
        throw new SAXException("internal state error: endTag(" + this.rootTag + ") state(" + this.state + ")");
    }
}

