/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.complib.impl;

import com.sap.tc.complib.ComponentFactory;
import com.sap.tc.complib.Entity;
import com.sap.tc.complib.FileSet;
import com.sap.tc.complib.Property;
import com.sap.tc.complib.PropertyElement;
import com.sap.tc.complib.impl.PropertyImpl;
import com.sap.tc.complib.keygen.KeyGenerator;
import com.sap.tc.complib.validate.InvalidFileFormatException;
import com.sap.tc.complib.validate.MissingElementException;
import com.sap.tc.complib.validate.ValidationException;
import com.sap.tc.complib.xml.Initializable;
import com.sap.tc.complib.xml.XMLWriter;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class EntityImpl
extends Initializable
implements Entity {
    private String _name;
    private String _packageName;
    private String _caption;
    private String _description;
    private String _type;
    private String _subtype;
    private FileSet _fileset;
    protected final String m_key = KeyGenerator.getInstance().createKey(this.getClass());
    private String rootTag;
    private List includes;
    private List excludes;
    private PropertyImpl extension;
    private PropertyElement node;
    private static final int ENTITY_NAME = 10;
    private static final int ENTITY_PACKAGE = 15;
    private static final int ENTITY_CAPTION = 20;
    private static final int ENTITY_DESCRIPTION = 30;
    private static final int ENTITY_TYPE = 40;
    private static final int ENTITY_SUBTYPE = 50;
    private static final int ENTITY_FILESET = 60;
    private static final int ENTITY_FILESET_ENTRIES = 65;
    private static final int ENTITY_EXTENSIONS = 70;
    private static final int ENTITY_EXTENSION_CHILD = 71;
    private static final int ENTITY_FINAL = 90;

    public EntityImpl() {
        this._schemaVersion = "1.0.1";
        this._apiVersion = "1.0.0";
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getCaption() {
        return this._caption;
    }

    public void setCaption(String caption) {
        this._caption = caption;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getPackageName() {
        return this._packageName;
    }

    public void setPackageName(String packageName) {
        this._packageName = packageName;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }

    public String getSubType() {
        return this._subtype;
    }

    public void setSubType(String subtype) {
        this._subtype = subtype;
    }

    public FileSet getFileSet() {
        return this._fileset;
    }

    public void setFileSet(FileSet fileSet) {
        this._fileset = fileSet;
        this._apiVersion = "1.0.1".compareTo(this._apiVersion) > 0 ? "1.0.1" : this._apiVersion;
    }

    public void validate() throws ValidationException {
        if (this._name == null) {
            throw new MissingElementException("name");
        }
        if (this._type == null) {
            throw new MissingElementException("type");
        }
    }

    public void serialize(XMLWriter writer) throws ValidationException {
        if (!ComponentFactory.isSchemaAllowed(this._schemaVersion)) {
            throw new InvalidFileFormatException("Cannot serialize entity with format version " + this._schemaVersion + ". Latest known schema version is " + "1.0.2");
        }
        if (!this._isSchemaAllowed()) {
            throw new InvalidFileFormatException("Cannot serialize entity with format version " + this._schemaVersion + " since this entity uses" + " features from API version " + this._apiVersion);
        }
        this.serialize(writer, this._schemaVersion);
    }

    public void serialize(XMLWriter writer, String schemaVersion) throws ValidationException {
        if (schemaVersion == null) {
            schemaVersion = this._schemaVersion;
        }
        if (!ComponentFactory.isSchemaAllowed(schemaVersion)) {
            throw new InvalidFileFormatException("Cannot serialize entity with format version " + schemaVersion + ". Latest known schema version is " + "1.0.2");
        }
        if (this._name == null) {
            throw new ValidationException("Entities must have a name");
        }
        if (this._type == null) {
            throw new ValidationException("Entities must have a type");
        }
        if (this._attributes != null) {
            writer.beginTag("entity", this.getAttributes());
        } else {
            writer.beginTag("entity");
        }
        writer.writeTag("name", this._name);
        if (this._packageName != null) {
            writer.writeTag("package", this._packageName);
        }
        if (this._caption != null) {
            writer.writeTag("caption", this._caption);
        }
        if (this._description != null) {
            writer.writeTag("description", this._description);
        }
        writer.writeTag("entity-type", this._type);
        if (this._subtype != null) {
            writer.writeTag("entity-sub-type", this._subtype);
        }
        if (this._fileset != null && this.doSerialize(schemaVersion, "1.0.1")) {
            this._fileset.serialize(writer);
        }
        if (this._extensions != null && this._extensions.size() > 0) {
            int i = 0;
            while (i < this._extensions.size()) {
                Property prop = (Property)this._extensions.get(i);
                String namespace = prop.getNamespace();
                String prefix = prop.getNamespacePrefix();
                if (namespace != null && prefix == null) {
                    prefix = "pns" + Integer.toString(i);
                    prop.setNamespace(prefix, namespace);
                }
                prop.serialize(writer);
                ++i;
            }
        }
        writer.endTag("entity");
    }

    protected void tagValue(char[] chars, int start, int length) {
        super.tagValue(chars, start, length);
    }

    protected void startTag(String name, Attributes attributes) throws SAXException {
        switch (this.state) {
            case 0: {
                this.dropTagValue();
                if (!name.equals("entity")) {
                    throw new SAXException("root tag expected <entity>");
                }
                this.state = 10;
                this._attributes = this.getAttributes(attributes);
                this.rootTag = name;
                return;
            }
            case 1: {
                return;
            }
            case 10: {
                if (name.equals("name")) {
                    this.state = 10;
                    return;
                }
                throw new SAXException("mandatory tag <name> expected");
            }
            case 15: {
                if (name.equals("package")) {
                    this.state = 15;
                    return;
                }
            }
            case 20: {
                if (name.equals("caption")) {
                    this.state = 20;
                    return;
                }
            }
            case 30: {
                if (name.equals("description")) {
                    this.state = 30;
                    return;
                }
            }
            case 40: {
                if (name.equals("entity-type")) {
                    this.state = 40;
                    return;
                }
                throw new SAXException("mandatory tag <entity-type> expected");
            }
            case 50: {
                if (name.equals("entity-sub-type")) {
                    this.state = 50;
                    return;
                }
            }
            case 60: {
                if (name.equals("fileset")) {
                    this.state = 65;
                    return;
                }
            }
            case 70: {
                this.dropTagValue();
                if (this.extension == null) {
                    this.extension = new PropertyImpl(name);
                    this.extension.setAttributes(this.getAttributes(attributes));
                    this.state = 70;
                    return;
                }
                PropertyElement elem = this.extension.addChild(name);
                elem.setAttributes(this.getAttributes(attributes));
                this.node = this.extension.lastChild();
                this.state = 71;
                return;
            }
            case 90: {
                break;
            }
            case 71: {
                PropertyElement elem = this.node.addChild(name);
                elem.setAttributes(this.getAttributes(attributes));
                this.node = this.node.lastChild();
                return;
            }
            case 65: {
                if (name.equals("include")) {
                    if (this._fileset == null) {
                        this._fileset = new FileSet();
                    }
                    if (this._fileset.getIncludes() == null) {
                        this.includes = this._fileset.emptyIncludes();
                    }
                    this.includes.add(attributes.getValue("name"));
                    return;
                }
                if (!name.equals("exclude")) break;
                if (this._fileset == null) {
                    this._fileset = new FileSet();
                }
                if (this._fileset.getExcludes() == null) {
                    this.excludes = this._fileset.emptyExcludes();
                }
                this.excludes.add(attributes.getValue("name"));
                return;
            }
            default: {
                throw new SAXException("internal state error: startTag(" + this.rootTag + ") state(" + this.state + ")");
            }
        }
        this.recoverTagName = name;
        this.recoverMode = this.state;
        this.state = 1;
    }

    protected boolean endTag(String name) throws SAXException {
        switch (this.state) {
            case 1: {
                this.dropTagValue();
                if (!name.equals(this.recoverTagName)) {
                    return true;
                }
                this.recoverTagName = null;
                this.state = this.recoverMode;
                return true;
            }
            case 10: {
                if (name.equals("name")) {
                    this._name = this.getStringValue();
                    if (this._name.length() == 0) {
                        throw new SAXException("entity name must not be an empty string");
                    }
                    this.state = 15;
                    return true;
                }
                throw new SAXException("mandatory tag <name> expected");
            }
            case 15: {
                this._packageName = this.getStringValue();
                this.state = 20;
                return true;
            }
            case 20: {
                this._caption = this.getStringValue();
                this.state = 30;
                return true;
            }
            case 30: {
                this._description = this.getStringValue();
                this.state = 40;
                return true;
            }
            case 40: {
                this._type = this.getStringValue();
                if (this._type.length() == 0) {
                    throw new SAXException("entity type must not be an empty string");
                }
                this.state = 50;
                return true;
            }
            case 50: {
                if (name.equals("entity-sub-type")) {
                    this._subtype = this.getStringValue();
                    this.state = 60;
                    return true;
                }
            }
            case 60: 
            case 65: {
                if (name.equals("fileset")) {
                    this.state = 70;
                    return true;
                }
            }
            case 70: {
                if (this.extension != null && name.equals(this.extension.getName())) {
                    if (this.extension.firstChild() == null && !this.isEmptyTag()) {
                        this.extension.setValue(this.getStringValue());
                    }
                    if (this._extensions == null) {
                        this._extensions = new ArrayList();
                    }
                    this._extensions.add(this.extension);
                    this.extension = null;
                    return true;
                }
            }
            case 90: {
                return !name.equals(this.rootTag);
            }
            case 71: {
                if (this.node.firstChild() == null && !this.isEmptyTag()) {
                    this.node.setValue(this.getStringValue());
                }
                if (this.node.getParent() != null) {
                    this.node = this.node.getParent();
                } else {
                    if (this._extensions == null) {
                        this._extensions = new ArrayList();
                    }
                    this._extensions.add(this.extension);
                    this.extension = null;
                    this.state = 70;
                }
                return true;
            }
        }
        throw new SAXException("internal state error: endTag(" + this.rootTag + ") state(" + this.state + ")");
    }

    public String getUniqueKey() {
        return this.m_key;
    }
}

