/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.complib.impl;

import com.sap.tc.complib.BuildVariant;
import com.sap.tc.complib.Compartment;
import com.sap.tc.complib.ConfigurationException;
import com.sap.tc.complib.ConfigurationFactory;
import com.sap.tc.complib.DevelopmentConfiguration;
import com.sap.tc.complib.Property;
import com.sap.tc.complib.PropertyElement;
import com.sap.tc.complib.SourceState;
import com.sap.tc.complib.impl.CompartmentImpl;
import com.sap.tc.complib.impl.PropertyImpl;
import com.sap.tc.complib.namecheck.NameChecker;
import com.sap.tc.complib.provider.ConfigurationInputProvider;
import com.sap.tc.complib.provider.ConfigurationOutputProvider;
import com.sap.tc.complib.provider.ProviderException;
import com.sap.tc.complib.validate.InvalidFileFormatException;
import com.sap.tc.complib.validate.NoBuildServerDefinedException;
import com.sap.tc.complib.validate.ValidationException;
import com.sap.tc.complib.validate.graph.VariantUsageChecker;
import com.sap.tc.complib.xml.Initializable;
import com.sap.tc.complib.xml.ParserAdapter;
import com.sap.tc.complib.xml.XMLException;
import com.sap.tc.complib.xml.XMLWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DevelopmentConfigurationImpl
extends Initializable
implements DevelopmentConfiguration {
    public static final String TAG_CONFIG = "configuration";
    public static final String TAG_CONFIG_DESCRIPTION = "config-description";
    public static final String TAG_BUILD_SERVER = "build-server";
    public static final String TAG_PROPERTIES = "properties";
    public static final String TAG_CONFIG_COMPARTMENTS = "sc-compartments";
    public static final String TAG_CONFIG_COMPARTMENT = "sc-compartment";
    public static final String ATTR_CONF_NAME = "name";
    public static final String ATTR_CONF_CAPTION = "caption";
    public static final String ATTR_CONFIG_VERSION = "config-version";
    public static final String ATTR_CONFIG_LOCATION = "sl-location";
    public static final String ATTR_DOCTYPE_VERSION = "document-type-version";
    public static final String ATTR_INDEX_DOCTYPE = "xmlns:IDX";
    public static final String ATTR_CMS = "cms-url";
    public static final String ATTR_NAMESERVER = "name-server-url";
    public static final String ATTR_IS_LOCAL = "is-local";
    private static final int STATE_CONFIG_DESCRIPTION = 3;
    private static final int STATE_BUILD_SERVER = 4;
    private static final int STATE_COMPARTMENT_LIST = 5;
    private static final int STATE_COMPARTMENT = 6;
    private static final int STATE_COMPARTMENT_CHILD = 7;
    private static final int STATE_CONFIG_FINAL = 8;
    private static final int STATE_PROPERTIES = 9;
    private static final int STATE_PROPERTY = 10;
    private static final int STATE_PROP_CHILD = 11;
    private String m_name;
    private String m_caption;
    private String m_buildServer = null;
    private String m_description;
    private String m_configVersion;
    private String m_location = null;
    private TreeMap m_compartments;
    private String m_NameServer = null;
    private String m_CMS = null;
    private boolean m_isLocal = false;
    private List m_properties = null;
    private CompartmentImpl compartmentChild;
    private PropertyImpl property = null;
    private PropertyElement child = null;
    private String rootTag;

    public DevelopmentConfigurationImpl() {
        this._schemaVersion = "0.3";
        this._apiVersion = "0.2";
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String value) {
        this.m_name = value;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String value) {
        this.m_description = value;
    }

    public String getCaption() {
        return this.m_caption;
    }

    public void setCaption(String value) {
        this.m_caption = value;
    }

    public void setBuildServer(String value) {
        this.m_buildServer = value;
    }

    public String getBuildServer() {
        return this.m_buildServer == null || this.m_buildServer.length() == 0 ? null : this.m_buildServer;
    }

    public String getLocation() {
        return this.m_location == null ? "" : this.m_location;
    }

    public void setLocation(String location) {
        this.m_location = location;
    }

    public List emptyProperties() {
        if (this.m_properties != null) {
            Iterator iter = this.m_properties.iterator();
            while (iter.hasNext()) {
                ((Property)iter.next()).emptyChildren();
            }
            this.m_properties.clear();
        } else {
            this.m_properties = new ArrayList();
        }
        this._apiVersion = "0.3".compareTo(this._apiVersion) > 0 ? "0.3" : this._apiVersion;
        return this.m_properties;
    }

    public Property addProperty(String name, String namespaceURI) {
        if (this.m_properties == null) {
            this.emptyProperties();
        }
        PropertyImpl prop = new PropertyImpl(name);
        prop.setNamespace(null, namespaceURI);
        this.m_properties.add(prop);
        this._apiVersion = "0.3".compareTo(this._apiVersion) > 0 ? "0.3" : this._apiVersion;
        return prop;
    }

    public Property addProperty(String name, String namespaceURI, String value) {
        if (this.m_properties == null) {
            this.emptyProperties();
        }
        PropertyImpl prop = new PropertyImpl(name, namespaceURI);
        prop.setValue(value);
        this.m_properties.add(prop);
        this._apiVersion = "0.3".compareTo(this._apiVersion) > 0 ? "0.3" : this._apiVersion;
        return prop;
    }

    public Property getProperty(String name) {
        Property property = null;
        if (this.m_properties != null) {
            Iterator iter = this.m_properties.iterator();
            while (iter.hasNext()) {
                Property next = (Property)iter.next();
                if (!name.equals(next.getName())) continue;
                property = next;
                break;
            }
        }
        return property;
    }

    public Property getProperty(String name, String namespaceURI) {
        Property property = null;
        if (this.m_properties != null) {
            Iterator iter = this.m_properties.iterator();
            while (iter.hasNext()) {
                Property next = (Property)iter.next();
                if (!name.equals(next.getName()) || !namespaceURI.equals(next.getNamespace())) continue;
                property = next;
                break;
            }
        }
        return property;
    }

    public List getProperties() {
        return this.m_properties;
    }

    public Map getCompartments() {
        return this.m_compartments;
    }

    public Map emptyCompartments() {
        if (this.m_compartments == null) {
            this.m_compartments = new TreeMap();
        } else {
            this.m_compartments.clear();
        }
        return this.m_compartments;
    }

    public void addCompartment(Compartment compartment) {
        if (this.m_compartments == null) {
            this.m_compartments = new TreeMap();
        }
        this.m_compartments.put(compartment.getName(), compartment);
    }

    public Compartment getDefaultCompartmentForSC(String scVendor, String scName) {
        Iterator it = this.m_compartments.values().iterator();
        Compartment defaultComp = null;
        while (it.hasNext()) {
            Compartment comp = (Compartment)it.next();
            if (!comp.getScName().equals(scName) || !comp.getScVendor().equals(scVendor) || !comp.IsDefaultCompartment()) continue;
            defaultComp = comp;
            break;
        }
        return defaultComp;
    }

    public Compartment getCompartmentByAlias(String referencingCompartmentName, String aliasName) throws ConfigurationException {
        Compartment targetCompartment = null;
        String targetCompartmentName = null;
        Compartment sourceCompartment = (Compartment)this.m_compartments.get(referencingCompartmentName);
        if (sourceCompartment == null) {
            throw new ConfigurationException("compartment " + referencingCompartmentName + " not found in configuration");
        }
        Map aliasMap = sourceCompartment.getScAliases();
        if (aliasMap != null) {
            targetCompartmentName = (String)aliasMap.get(aliasName);
        }
        if (targetCompartmentName == null) {
            throw new ConfigurationException("alias " + aliasName + " not defined for referencing compartment " + referencingCompartmentName);
        }
        targetCompartment = (Compartment)this.m_compartments.get(targetCompartmentName);
        if (targetCompartment == null) {
            throw new ConfigurationException("alias " + aliasName + " of referencing compartment " + referencingCompartmentName + " points to not existing compartment " + targetCompartmentName);
        }
        return targetCompartment;
    }

    public void initialize(ConfigurationInputProvider provider) throws IOException, XMLException, ProviderException, ValidationException {
        InputStream in = null;
        try {
            try {
                in = provider.getStreamForConfiguration();
                ParserAdapter parser = new ParserAdapter(this);
                parser.parse(in);
                this.completeInitialization();
                this.validate();
            }
            catch (SAXException ex) {
                throw new XMLException("Initializing development configuration failed", ex);
            }
            Object var5_5 = null;
            if (in != null) {
                provider.releaseStream(in);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (in != null) {
                provider.releaseStream(in);
            }
            throw throwable;
        }
    }

    public void serialize(ConfigurationOutputProvider provider) throws IOException, ProviderException {
        OutputStream out = provider.getStreamForConfiguration();
        XMLWriter writer = new XMLWriter(out);
        try {
            this.serialize(writer);
        }
        catch (ValidationException e) {
            throw new ProviderException("Serialization failed", e);
        }
        writer.serialize();
        provider.releaseStream(out);
    }

    public void serialize(ConfigurationOutputProvider provider, String schemaVersion) throws IOException, ProviderException {
        OutputStream out = provider.getStreamForConfiguration();
        XMLWriter writer = new XMLWriter(out);
        try {
            this.serialize(writer, schemaVersion);
        }
        catch (ValidationException e) {
            throw new ProviderException("Serialization failed", e);
        }
        writer.serialize();
        provider.releaseStream(out);
    }

    public void serialize(XMLWriter writer) throws ValidationException {
        this.updateSchemaVersion();
        if (!ConfigurationFactory.isSchemaAllowed(this._schemaVersion)) {
            throw new InvalidFileFormatException("Cannot serialize development configuration with schema version '" + this._schemaVersion + "'. The version number is unknown." + " Latest known schema version is " + "1.0");
        }
        if (!this._isSchemaAllowed()) {
            throw new InvalidFileFormatException("Cannot serialize development configuration with schema version '" + this._schemaVersion + "' since this configuration uses" + " features from API version " + this._apiVersion);
        }
        this.serialize(writer, this._schemaVersion);
    }

    public void serialize(XMLWriter writer, String schemaVersion) throws ValidationException {
        if (schemaVersion == null) {
            this.updateSchemaVersion();
            schemaVersion = this._schemaVersion;
        }
        if (!ConfigurationFactory.isSchemaAllowed(schemaVersion)) {
            throw new InvalidFileFormatException("Cannot serialize development configuration with schema version '" + schemaVersion + "'. Latest known schema version is " + "1.0");
        }
        if (this._attributes == null) {
            this._attributes = new ArrayList();
        }
        if (this.doSerialize(schemaVersion, "1.0")) {
            this.setAttribute("xmlns", "http://xml.sap.com/2002/11/DevelopmentConfiguration");
            this.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.setAttribute("xsi:schemaLocation", "http://xml.sap.com/2002/11/DevelopmentConfiguration confdef.xsd");
        } else {
            this.removeAttribute("xmlns");
            this.removeAttribute("xmlns:xsi");
            this.removeAttribute("xsi:schemaLocation");
        }
        this.setAttribute(ATTR_CONF_NAME, this.m_name);
        String versionAttr = schemaVersion == null ? this._schemaVersion : schemaVersion;
        this.setAttribute(ATTR_DOCTYPE_VERSION, versionAttr);
        this.handleOptionalAttribute(ATTR_CONF_CAPTION, this.m_caption);
        this.handleOptionalAttribute(ATTR_CONFIG_VERSION, this.m_configVersion);
        this.handleOptionalAttribute(ATTR_CONFIG_LOCATION, this.m_location);
        this.handleOptionalAttribute(ATTR_CMS, this.m_CMS);
        this.handleOptionalAttribute(ATTR_NAMESERVER, this.m_NameServer);
        if (this.doSerialize(schemaVersion, "0.3")) {
            this.setAttribute(ATTR_IS_LOCAL, this.m_isLocal ? "yes" : "no");
        } else {
            this.removeAttribute(ATTR_IS_LOCAL);
        }
        if (this.doSerialize(schemaVersion, "1.0")) {
            this.setAttribute(ATTR_INDEX_DOCTYPE, "urn:sap.com:DevelopmentConfiguration:1.0");
        } else {
            this.removeAttribute(ATTR_INDEX_DOCTYPE);
        }
        writer.beginDocument();
        writer.wrapAttributeLists(true);
        writer.writeRootTag(TAG_CONFIG, this.getAttributes());
        writer.wrapAttributeLists(false);
        if (this.m_description != null) {
            writer.writeTag(TAG_CONFIG_DESCRIPTION, this.m_description);
        }
        if (this.m_buildServer != null) {
            writer.writeTag(TAG_BUILD_SERVER, this.m_buildServer);
        }
        if (this.m_properties != null && this.m_properties.size() > 0 && this.doSerialize(schemaVersion, "0.3")) {
            writer.beginTag(TAG_PROPERTIES);
            int i = 0;
            while (i < this.m_properties.size()) {
                Property prop = (Property)this.m_properties.get(i);
                String namespace = prop.getNamespace();
                String prefix = prop.getNamespacePrefix();
                if (namespace != null && prefix == null) {
                    prefix = "pns" + Integer.toString(i);
                    prop.setNamespace(prefix, namespace);
                }
                prop.serialize(writer);
                ++i;
            }
            writer.endTag(TAG_PROPERTIES);
        }
        writer.beginTag(TAG_CONFIG_COMPARTMENTS);
        if (this.m_compartments != null) {
            Iterator it = this.m_compartments.values().iterator();
            while (it.hasNext()) {
                Compartment comp = (Compartment)it.next();
                comp.serialize(writer, schemaVersion);
            }
        }
        writer.endTag(TAG_CONFIG_COMPARTMENTS);
        writer.endDocument();
    }

    private void handleOptionalAttribute(String name, String value) {
        if (value != null) {
            this.setAttribute(name, value);
        } else {
            this.removeAttribute(name);
        }
    }

    public boolean isSchemaAllowed() {
        this.updateSchemaVersion();
        return this._isSchemaAllowed();
    }

    public boolean isSchemaAllowed(String schemaVersion) {
        this.updateSchemaVersion();
        return this._isSchemaAllowed(schemaVersion);
    }

    public String getSchemaVersion() {
        this.updateSchemaVersion();
        return this._schemaVersion;
    }

    private void updateSchemaVersion() {
        if (!this._initialized && this._schemaVersion.compareTo(this._apiVersion) < 0) {
            this._schemaVersion = this._apiVersion;
        }
    }

    public void validate() throws ValidationException {
        this.checkPropertyNotEmptyOrNull(this.m_name, ATTR_CONF_NAME, "configuration \"" + this + "\"");
        NameChecker.checkDevelopmentConfigurationName(this.m_name);
        this.checkPropertyNotEmptyOrNull(this.m_configVersion, "configVersion", "configuration \"" + this.m_name + "\"");
        this.checkPropertyNotEmptyOrNull(this.m_caption, ATTR_CONF_CAPTION, "configuration \"" + this.m_name + "\"");
        this.checkPropertyNotEmptyOrNull(this.m_compartments, "compartments", "configuration \"" + this.m_caption + "\"");
        if (this.isLocal()) {
            if (this.m_buildServer != null) {
                String message = "Configuration validation failed. If  \"is-local\" is set, a build server must not be specified.";
                throw new ValidationException(message);
            }
            if (this.m_CMS != null) {
                String message = "Configuration validation failed. If  \"is-local\" is set, a CMS server must not be specified.";
                throw new ValidationException(message);
            }
            if (this.m_NameServer != null) {
                String message = "Configuration validation failed. If  \"is-local\" is set, a name server must not be specified.";
                throw new ValidationException(message);
            }
        }
        Iterator it = this.m_compartments.values().iterator();
        while (it.hasNext()) {
            Compartment comp = (Compartment)it.next();
            comp.validate();
        }
        this.validateGlobalConstraints();
    }

    public String getConfigVersion() {
        return this.m_configVersion;
    }

    public String getDocumentTypeVersion() {
        return this._apiVersion;
    }

    public void setConfigVersion(String value) {
        this.m_configVersion = value;
    }

    public String getCMS() {
        return this.m_CMS;
    }

    public String getNameServer() {
        return this.m_NameServer;
    }

    public void setCMS(String cmsURL) {
        this.m_CMS = cmsURL;
    }

    public void setNameServer(String nameServerURL) {
        this.m_NameServer = nameServerURL;
    }

    private void validateGlobalConstraints() throws ValidationException {
        Hashtable<String, Compartment> defaultCompartments = new Hashtable<String, Compartment>();
        int localSourceCompCounter = 0;
        Iterator iterComp = this.m_compartments.values().iterator();
        while (iterComp.hasNext()) {
            Map variantsMap;
            Map aliasMap;
            SourceState sourceState;
            Compartment comp = (Compartment)iterComp.next();
            if (this.isLocal()) {
                if (!comp.isLocal()) {
                    throw new ValidationException("Non local compartment: \"" + comp.getName() + "\" not allowed in local-only configuration \"" + this.getName() + "\"");
                }
                if (comp.hasSourceState()) {
                    if (localSourceCompCounter > 0) {
                        throw new ValidationException("Found at lesat 2 compartments for source code. A local-only configuration may only have one such compartment");
                    }
                    ++localSourceCompCounter;
                }
            }
            if (comp.IsDefaultCompartment()) {
                String scname = comp.getScName();
                String scvendor = comp.getScVendor();
                String key = scvendor + ":" + scname;
                if (defaultCompartments.containsKey(key)) {
                    String defName = ((Compartment)defaultCompartments.get(key)).getName();
                    String curName = comp.getName();
                    throw new ValidationException("compartments '" + curName + "' and '" + defName + "' cannot both be default compartments for SC-name '" + scname + "' and SC-vendor '" + scvendor + "'");
                }
                defaultCompartments.put(key, comp);
            }
            if ((sourceState = comp.getSourceState()) != null && sourceState.getType() == 0 && (this.getBuildServer() == null || this.getBuildServer().length() == 0)) {
                String msg = "Compartment " + comp.getName() + " has source state of type ACTIVATION but no build server is defined.";
                throw new NoBuildServerDefinedException(msg);
            }
            String localArchivefolder = comp.getLocalArchiveFolder();
            if (localArchivefolder != null && this.getBuildServer() != null) {
                throw new ValidationException("Specification of build sever (" + this.m_buildServer + ") and local archive folder not allowed. compartment: \"" + comp.getName() + "\", local archive folder: \"" + localArchivefolder + "\"");
            }
            Set usedCompartments = comp.getUsedCompartments();
            if (usedCompartments != null) {
                Iterator iterUsedCompartments = usedCompartments.iterator();
                while (iterUsedCompartments.hasNext()) {
                    String usedCompartment = (String)iterUsedCompartments.next();
                    if (usedCompartment.equals(comp.getName())) {
                        throw new ValidationException("Illegal used compartment: compartment \"" + comp.getName() + "\" cannot use itself");
                    }
                    if (this.m_compartments.containsKey(usedCompartment)) continue;
                    throw new ValidationException("Illegal used compartment of compartment \"" + comp.getName() + "\" . Used compartment  \"" + usedCompartment + "\" does not exist.");
                }
            }
            if ((aliasMap = comp.getScAliases()) != null) {
                Iterator iterAliases = aliasMap.keySet().iterator();
                while (iterAliases.hasNext()) {
                    String aliasName = (String)iterAliases.next();
                    String mappedComp = (String)aliasMap.get(aliasName);
                    this.checkPropertyNotEmptyOrNull(mappedComp, " mapped compartment ", "SC alias mapping for alias name " + aliasName + " in compartment " + comp.getName());
                    if (this.m_compartments.containsKey(mappedComp)) continue;
                    throw new ValidationException("mapped compartment '" + mappedComp + "' for alias name '" + aliasName + "' in compartment '" + comp.getName() + "' does not exist");
                }
            }
            if ((variantsMap = comp.getBuildVariants()) == null) continue;
            Iterator iterVariants = variantsMap.keySet().iterator();
            while (iterVariants.hasNext()) {
                String usedCompartment;
                String variantName = (String)iterVariants.next();
                BuildVariant v = (BuildVariant)variantsMap.get(variantName);
                Map variantMapping = v.getVariantMapping();
                if (usedCompartments != null) {
                    Iterator iterUsedCompartments = usedCompartments.iterator();
                    while (iterUsedCompartments.hasNext()) {
                        usedCompartment = (String)iterUsedCompartments.next();
                        if (variantMapping != null && variantMapping.containsKey(usedCompartment)) continue;
                        throw new ValidationException("Build variant mapping missing: variant \"" + variantName + "\" of compartment \"" + comp.getName() + "\" has no variant mapping for usedCompartment \"" + usedCompartment + "\"");
                    }
                }
                if (variantMapping == null) continue;
                Iterator iterMapping = variantMapping.keySet().iterator();
                while (iterMapping.hasNext()) {
                    usedCompartment = (String)iterMapping.next();
                    String mappedVariant = (String)variantMapping.get(usedCompartment);
                    this.checkPropertyNotEmptyOrNull(usedCompartment, "used-compartment-name", " variant mapping of BuildVariant " + v.getName() + " in compartment '" + comp.getName() + "'");
                    this.checkPropertyNotEmptyOrNull(mappedVariant, "used-variant-name", " variant mapping of BuildVariant " + v.getName() + "for used compatment " + usedCompartment + " in compartment '" + comp.getName() + "'");
                    Compartment usedCompObj = (Compartment)this.m_compartments.get(usedCompartment);
                    if (usedCompObj != null) {
                        Map usedCompVariants = usedCompObj.getBuildVariants();
                        if (usedCompVariants != null && usedCompVariants.containsKey(mappedVariant)) continue;
                        throw new ValidationException("used variant '" + mappedVariant + "' does not exist in used compartment '" + usedCompartment + "'.(Build variant mapping of build variant  '" + v.getName() + "' in compartment '" + comp.getName() + "')");
                    }
                    throw new ValidationException("used compartment '" + usedCompartment + "' does not exist. (Build variant mapping of build variant  '" + v.getName() + "' in compartment '" + comp.getName() + "')");
                }
            }
            VariantUsageChecker checker = new VariantUsageChecker(this);
            checker.check();
        }
    }

    protected void tagValue(char[] chars, int start, int length) {
        switch (this.state) {
            case 7: {
                this.compartmentChild.tagValue(chars, start, length);
                return;
            }
        }
        super.tagValue(chars, start, length);
    }

    protected void startTag(String tagName, Attributes attributes) throws SAXException {
        switch (this.state) {
            case 0: {
                if (!tagName.equals(TAG_CONFIG)) {
                    throw new SAXException("root tag expected <configuration>");
                }
                this.dropTagValue();
                this._attributes = this.getAttributes(attributes);
                String stringValue = null;
                this.m_name = attributes.getValue(ATTR_CONF_NAME);
                this.m_caption = attributes.getValue(ATTR_CONF_CAPTION);
                stringValue = attributes.getValue(ATTR_IS_LOCAL);
                this.m_isLocal = "yes".equalsIgnoreCase(stringValue) || "true".equalsIgnoreCase(stringValue);
                stringValue = attributes.getValue(ATTR_DOCTYPE_VERSION);
                this._setSchemaVersion(stringValue);
                this.m_configVersion = attributes.getValue(ATTR_CONFIG_VERSION);
                this.m_location = attributes.getValue(ATTR_CONFIG_LOCATION);
                this.m_CMS = attributes.getValue(ATTR_CMS);
                this.m_NameServer = attributes.getValue(ATTR_NAMESERVER);
                this.checkMandatoryAttribute(this.m_name, ATTR_CONF_NAME, this.rootTag);
                this.checkMandatoryAttribute(this.m_caption, ATTR_CONF_CAPTION, this.rootTag);
                this.checkMandatoryAttribute(this._schemaVersion, ATTR_DOCTYPE_VERSION, this.rootTag);
                this.checkMandatoryAttribute(this.m_configVersion, ATTR_CONFIG_VERSION, this.rootTag);
                this.rootTag = tagName;
                this.state = 3;
                return;
            }
            case 3: {
                if (tagName.equals(TAG_CONFIG_DESCRIPTION)) {
                    this.state = 3;
                    return;
                }
            }
            case 4: {
                if (tagName.equals(TAG_BUILD_SERVER)) {
                    this.state = 4;
                    return;
                }
            }
            case 9: {
                if (tagName.equals(TAG_PROPERTIES)) {
                    this.state = 10;
                    return;
                }
            }
            case 5: {
                if (tagName.equals(TAG_CONFIG_COMPARTMENTS)) {
                    this.state = 6;
                    return;
                }
                throw new SAXException(this.getMissingTagMessage(TAG_CONFIG_COMPARTMENTS, this.rootTag));
            }
            case 6: {
                if (tagName.equals(TAG_CONFIG_COMPARTMENT)) {
                    this.compartmentChild = new CompartmentImpl();
                    this.compartmentChild._setSchemaVersion(this._schemaVersion);
                    this.state = 7;
                    this.compartmentChild.startTag(tagName, attributes);
                    return;
                }
                throw new SAXException("unexepected tag: <" + tagName + "> encountered instead of expected tag <" + TAG_CONFIG_COMPARTMENT + ">");
            }
            case 7: {
                if (this.compartmentChild == null) {
                    throw new SAXException("internal error: 'compartmentChild' is null in state STATE_COMPARTMENT_CHILD (" + this.state + ") in startTag(" + tagName + ") ");
                }
                this.compartmentChild.startTag(tagName, attributes);
                return;
            }
            case 10: {
                if (this.property == null) {
                    this.property = new PropertyImpl(tagName);
                    this.property.setAttributes(this.getAttributes(attributes));
                    return;
                }
                PropertyElement elem = this.property.addChild(tagName);
                elem.setAttributes(this.getAttributes(attributes));
                this.state = 11;
                this.child = this.property.lastChild();
                return;
            }
            case 11: {
                this.child.addChild(tagName);
                this.child = this.child.lastChild();
                return;
            }
            case 8: {
                break;
            }
            case 1: {
                return;
            }
            default: {
                throw new SAXException("internal error: illegal state (" + this.state + ") in startTag(" + tagName + ")  (rootTag=" + TAG_CONFIG + ")");
            }
        }
        this.recoverTagName = tagName;
        this.recoverMode = this.state;
        this.state = 1;
    }

    protected boolean endTag(String tagName) throws SAXException {
        switch (this.state) {
            case 1: {
                this.dropTagValue();
                if (!tagName.equals(this.recoverTagName)) break;
                this.state = this.recoverMode;
                this.recoverTagName = null;
                break;
            }
            case 3: {
                if (tagName.equals(TAG_CONFIG_DESCRIPTION)) {
                    this.m_description = this.getStringValue();
                    this.state = 4;
                    return true;
                }
            }
            case 4: {
                if (tagName.equals(TAG_BUILD_SERVER)) {
                    this.m_buildServer = this.getStringValue();
                    this.state = 9;
                    return true;
                }
                if (!tagName.equals(this.rootTag)) break;
                throw new SAXException(this.getMissingTagMessage(TAG_CONFIG_COMPARTMENTS, this.rootTag));
            }
            case 8: {
                return !tagName.equals(this.rootTag);
            }
            case 10: {
                if (tagName.equals(TAG_PROPERTIES)) {
                    this.state = 5;
                } else if (tagName.equals(this.property.getQName())) {
                    if (this.property.firstChild() == null) {
                        this.property.setValue(this.getStringValue());
                    }
                    if (this.m_properties == null) {
                        this.emptyProperties();
                    }
                    this.m_properties.add(this.property);
                    this.property = null;
                }
                return true;
            }
            case 11: {
                if (this.child.firstChild() == null) {
                    this.child.setValue(this.getStringValue());
                }
                if (this.child.getParent() != null) {
                    this.child = this.child.getParent();
                } else {
                    if (this.m_properties == null) {
                        this.emptyProperties();
                    }
                    this.m_properties.add(this.property);
                    this.property = null;
                    this.state = 10;
                }
                return true;
            }
            case 7: {
                if (this.compartmentChild.endTag(tagName)) {
                    return true;
                }
                this.addCompartment(this.compartmentChild);
                this.compartmentChild = null;
                this.state = 6;
                return true;
            }
            case 6: {
                if (!tagName.equals(TAG_CONFIG_COMPARTMENTS)) break;
                this.state = 8;
                return true;
            }
            case 5: {
                if (tagName.equals(this.rootTag)) {
                    throw new SAXException(this.getMissingTagMessage(TAG_CONFIG_COMPARTMENTS, this.rootTag));
                }
            }
            default: {
                throw new SAXException("internal state error: endTag(" + tagName + "), state=" + this.state + ")");
            }
        }
        return true;
    }

    private void completeInitialization() {
        if (this._schemaVersion.equals("0.1")) {
            Iterator it = this.m_compartments.values().iterator();
            while (it.hasNext()) {
                CompartmentImpl comp = (CompartmentImpl)it.next();
                if (!comp.isModificationAllowed()) continue;
                comp.initializeUsedCompartmentsFromVariantMappings();
            }
        }
    }

    public String getOriginalDocumentTypeVersion() {
        return this._schemaVersion;
    }

    public boolean isLocal() {
        return this.m_isLocal;
    }

    public void setLocal(boolean isLocal) {
        this._apiVersion = "0.3".compareTo(this._apiVersion) > 0 ? "0.3" : this._apiVersion;
        this.m_isLocal = isLocal;
    }
}

