/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.complib.impl;

import com.sap.tc.complib.ComponentFactory;
import com.sap.tc.complib.ComponentReference;
import com.sap.tc.complib.ComponentType;
import com.sap.tc.complib.DCReference;
import com.sap.tc.complib.Dependency;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.PPReference;
import com.sap.tc.complib.Property;
import com.sap.tc.complib.PropertyElement;
import com.sap.tc.complib.PublicPart;
import com.sap.tc.complib.SCReference;
import com.sap.tc.complib.impl.DependencyImpl;
import com.sap.tc.complib.impl.PropertyImpl;
import com.sap.tc.complib.namecheck.NameCheckException;
import com.sap.tc.complib.namecheck.NameChecker;
import com.sap.tc.complib.provider.DCInputProvider;
import com.sap.tc.complib.provider.DCOutputProvider;
import com.sap.tc.complib.provider.PPInputProvider;
import com.sap.tc.complib.provider.PPOutputProvider;
import com.sap.tc.complib.provider.ProviderException;
import com.sap.tc.complib.validate.InvalidFileFormatException;
import com.sap.tc.complib.validate.InvalidMemberException;
import com.sap.tc.complib.validate.MissingElementException;
import com.sap.tc.complib.validate.ValidationException;
import com.sap.tc.complib.xml.Initializable;
import com.sap.tc.complib.xml.ParserAdapter;
import com.sap.tc.complib.xml.XMLException;
import com.sap.tc.complib.xml.XMLWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DevelopmentComponentImpl
extends Initializable
implements DevelopmentComponent {
    private String _name;
    private String _vendor;
    private String _caption;
    private String _description;
    private ComponentType _componentType;
    private PPReference _buildPlugin;
    private boolean _external = false;
    private boolean _internal = false;
    private boolean _deprecated = false;
    private DCReference _parent;
    private List _children;
    private List _grants;
    private List _dependencies;
    private List _sourceFolders;
    private List _packageFolders;
    private List _properties;
    private Map _publicParts;
    private ComponentType compType = null;
    private PPReference ppref = null;
    private ComponentReference ref = null;
    private List list;
    private boolean readList = false;
    private String rootTag;
    private DependencyImpl dep;
    private PropertyImpl property;
    private PropertyElement child;
    private PropertyImpl extension;
    private PropertyElement node;
    private static final String DEVELOPMENT_COMPONENT = "development-component";
    private static final String VERSION = "version";
    private static final String NAME = "name";
    private static final String VENDOR = "vendor";
    private static final String CAPTION = "caption";
    private static final String DESCRIPTION = "description";
    private static final String COMPONENT_TYPE = "component-type";
    private static final String PROPERTIES = "properties";
    private static final String BUILD_PLUGIN = "build-plugin";
    private static final String EXTERNAL = "external";
    private static final String INTERNAL = "internal";
    private static final String DEPRECATED = "deprecated";
    private static final String PARENT_DC = "parent-dc";
    private static final String INNER_COMPONENTS = "inner-components";
    private static final String DEPENDENCIES = "dependencies";
    private static final String FOLDERS = "folders";
    private static final String ACCESS_CONTROL_LIST = "access-control-list";
    private static final String TYPE = "type";
    private static final String SUBTYPE = "sub-type";
    private static final String DCREF = "dc-ref";
    private static final String SCREF = "sc-ref";
    private static final String PPREF = "pp-ref";
    private static final String SC_ALIAS = "sc-alias";
    private static final String DEPENDENCY = "dependency";
    private static final String SOURCE_FOLDER = "source-folder";
    private static final String PACKAGE_FOLDER = "package-folder";
    private static final String GRANT = "grant";
    private static final int DC_NAME = 10;
    private static final int DC_VENDOR = 20;
    private static final int DC_CAPTION = 30;
    private static final int DC_DESCRIPTION = 40;
    private static final int DC_COMP_TYPE = 50;
    private static final int DC_TEMPLATE = 60;
    private static final int DC_PROPERTIES = 65;
    private static final int DC_BUILD_TYPE = 70;
    private static final int DC_EXTERNAL = 80;
    private static final int DC_INTERNAL = 90;
    private static final int DC_DEPRECATED = 95;
    private static final int DC_PARENT = 100;
    private static final int DC_INNER_COMP = 110;
    private static final int DC_DEPENDENCIES = 112;
    private static final int DC_ACL = 120;
    private static final int DC_FOLDERS = 123;
    private static final int DC_EXTENSIONS = 125;
    private static final int DC_EXTENSION_CHILD = 126;
    private static final int DC_FINAL = 130;
    private static final int TEMPLATE_VENDOR = 200;
    private static final int TEMPLATE_TYPE = 210;
    private static final int TEMPLATE_SUBTYPE = 220;
    private static final int TEMPLATE_FINAL = 230;
    private static final int PROP_PROPERTY = 240;
    private static final int PROP_CHILD = 245;
    private static final int REF = 300;
    private static final int REF_NAME = 310;
    private static final int REF_VENDOR = 320;
    private static final int REF_ALIAS = 330;
    private static final int REF_FINAL = 340;
    private static final int INNER_COMP_ENTRY = 400;
    private static final int ACL_GRANTS = 500;
    private static final int ACL_GRANT = 510;
    private static final int DIR_FOLDERS = 550;
    private static final int DIR_SOURCE_FOLDER = 555;
    private static final int DIR_PACKAGE_FOLDER = 560;
    private static final int BUILD_DCREF = 600;
    private static final int BUILD_PPREF = 610;
    private static final int DEPS_DEPENDENCIES = 800;
    private static final int DEPS_DEPENDENCY = 810;
    private static final int DEPS_FINAL = 820;

    public DevelopmentComponentImpl() {
        this._schemaVersion = "1.0.1";
        this._apiVersion = "1.0.0";
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getVendor() {
        return this._vendor;
    }

    public void setVendor(String vendor) {
        this._vendor = vendor;
    }

    public String getCaption() {
        return this._caption;
    }

    public void setCaption(String caption) {
        this._caption = caption;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public boolean isDeprecated() {
        return this._deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        if (deprecated) {
            this._apiVersion = "1.0.2".compareTo(this._apiVersion) > 0 ? "1.0.2" : this._apiVersion;
        }
        this._deprecated = deprecated;
    }

    public ComponentType getComponentType() {
        return this._componentType;
    }

    public void setComponentType(ComponentType componentType) {
        this._componentType = componentType;
    }

    public List getProperties() {
        return this._properties;
    }

    public List emptyProperties() {
        if (this._properties != null) {
            Iterator iter = this._properties.iterator();
            while (iter.hasNext()) {
                ((Property)iter.next()).emptyChildren();
            }
            this._properties.clear();
        } else {
            this._properties = new ArrayList();
        }
        this._apiVersion = "1.0.1".compareTo(this._apiVersion) > 0 ? "1.0.1" : this._apiVersion;
        return this._properties;
    }

    public Property getProperty(String name) {
        Property property = null;
        if (this._properties != null) {
            Iterator iter = this._properties.iterator();
            while (iter.hasNext()) {
                Property next = (Property)iter.next();
                if (!name.equals(next.getName())) continue;
                property = next;
                break;
            }
        }
        return property;
    }

    public Property getProperty(String name, String namespaceURI) {
        Property property = null;
        if (this._properties != null) {
            Iterator iter = this._properties.iterator();
            while (iter.hasNext()) {
                Property next = (Property)iter.next();
                if (!name.equals(next.getName()) || !namespaceURI.equals(next.getNamespace())) continue;
                property = next;
                break;
            }
        }
        return property;
    }

    public Property addProperty(String name, String namespaceURI) {
        if (this._properties == null) {
            this.emptyProperties();
        }
        PropertyImpl prop = new PropertyImpl(name, namespaceURI);
        this._properties.add(prop);
        this._apiVersion = "1.0.1".compareTo(this._apiVersion) > 0 ? "1.0.1" : this._apiVersion;
        return prop;
    }

    public Property addProperty(String name, String namespaceURI, String value) {
        if (this._properties == null) {
            this.emptyProperties();
        }
        PropertyImpl prop = new PropertyImpl(name, namespaceURI);
        prop.setValue(value);
        this._properties.add(prop);
        this._apiVersion = "1.0.1".compareTo(this._apiVersion) > 0 ? "1.0.1" : this._apiVersion;
        return prop;
    }

    public PPReference getBuildPlugin() {
        return this._buildPlugin;
    }

    public void setBuildPlugin(PPReference buildPlugin) {
        this._buildPlugin = buildPlugin;
    }

    public boolean isExternal() {
        return this._external;
    }

    public void setExternal(boolean external) {
        this._external = external;
    }

    public boolean isInternal() {
        return this._internal;
    }

    public void setInternal(boolean internal) {
        this._internal = internal;
    }

    public DCReference getEnclosingComponent() {
        return this._parent;
    }

    public void setEnclosingComponent(DCReference enclosingComponent) {
        this._parent = enclosingComponent;
    }

    public List getEnclosedComponents() {
        return this._children;
    }

    public List emptyEnclosedComponents() {
        if (this._children != null) {
            this._children.clear();
        } else {
            this._children = new ArrayList();
        }
        return this._children;
    }

    public List getGrants() {
        return this._grants;
    }

    public List emptyGrants() {
        if (this._grants != null) {
            this._grants.clear();
        } else {
            this._grants = new ArrayList();
        }
        return this._grants;
    }

    public Map getPublicParts() {
        return this._publicParts;
    }

    public Map emptyPublicParts() {
        if (this._publicParts != null) {
            this._publicParts.clear();
        } else {
            this._publicParts = new HashMap();
        }
        return this._publicParts;
    }

    public List getDependencies() {
        return this._dependencies;
    }

    public List emptyDependencies() {
        if (this._dependencies != null) {
            this._dependencies.clear();
        } else {
            this._dependencies = new ArrayList();
        }
        return this._dependencies;
    }

    public List getSourceFolders() {
        return this._sourceFolders;
    }

    public List emptySourceFolders() {
        if (this._sourceFolders != null) {
            this._sourceFolders.clear();
        } else {
            this._sourceFolders = new ArrayList();
        }
        this._apiVersion = "1.0.1".compareTo(this._apiVersion) > 0 ? "1.0.1" : this._apiVersion;
        return this._sourceFolders;
    }

    public List getPackageFolders() {
        return this._packageFolders;
    }

    public List emptyPackageFolders() {
        if (this._packageFolders != null) {
            this._packageFolders.clear();
        } else {
            this._packageFolders = new ArrayList();
        }
        this._apiVersion = "1.0.1".compareTo(this._apiVersion) > 0 ? "1.0.1" : this._apiVersion;
        return this._packageFolders;
    }

    public Reader getSchema() {
        InputStream resource = this.getClass().getResourceAsStream("dcdef.xsd");
        return new InputStreamReader(resource);
    }

    public void validate() throws ValidationException {
        Object child;
        Iterator<Object> iter;
        if (this._name == null) {
            throw new MissingElementException(NAME);
        }
        try {
            NameChecker.checkComponentName(this._name);
        }
        catch (NameCheckException ex) {
            throw new ValidationException("Invalid DC name", ex);
        }
        if (this._vendor == null) {
            throw new MissingElementException(VENDOR);
        }
        try {
            NameChecker.checkVendorName(this._vendor);
        }
        catch (NameCheckException ex) {
            throw new ValidationException("Invalid DC vendor", ex);
        }
        if (this._componentType == null) {
            throw new MissingElementException(COMPONENT_TYPE);
        }
        this._componentType.validate();
        if (this._buildPlugin != null) {
            this._buildPlugin.validate();
        }
        if (this._parent != null) {
            this._parent.validate();
        }
        if (this._children != null && this._children.size() > 0) {
            iter = this._children.iterator();
            child = null;
            try {
                while (iter.hasNext()) {
                    child = (DCReference)iter.next();
                    ((DCReference)child).validate();
                }
            }
            catch (ClassCastException ex) {
                throw new InvalidMemberException("dcref", child);
            }
        }
        if (this._publicParts != null && this._publicParts.size() > 0) {
            iter = this._publicParts.values().iterator();
            child = null;
            try {
                while (iter.hasNext()) {
                    child = (PublicPart)iter.next();
                    child.validate();
                }
            }
            catch (ClassCastException ex) {
                throw new InvalidMemberException("public-part", child);
            }
        }
        if (this._grants != null && this._grants.size() > 0) {
            iter = this._grants.iterator();
            child = null;
            try {
                while (iter.hasNext()) {
                    child = (ComponentReference)iter.next();
                    child.validate();
                }
            }
            catch (ClassCastException ex) {
                throw new InvalidMemberException(GRANT, child);
            }
        }
        if (this._dependencies != null && this._dependencies.size() > 0) {
            iter = this._dependencies.iterator();
            child = null;
            try {
                while (iter.hasNext()) {
                    child = (Dependency)iter.next();
                    child.validate();
                }
            }
            catch (ClassCastException ex) {
                throw new InvalidMemberException(DEPENDENCY, child);
            }
        }
        if (this._sourceFolders != null && this._sourceFolders.size() > 0) {
            iter = this._sourceFolders.iterator();
            child = null;
            try {
                while (iter.hasNext()) {
                    child = (String)iter.next();
                }
            }
            catch (ClassCastException ex) {
                throw new InvalidMemberException(SOURCE_FOLDER, child);
            }
        }
        if (this._packageFolders != null && this._packageFolders.size() > 0) {
            iter = this._packageFolders.iterator();
            child = null;
            try {
                while (iter.hasNext()) {
                    child = (String)iter.next();
                }
            }
            catch (ClassCastException ex) {
                throw new InvalidMemberException(PACKAGE_FOLDER, child);
            }
        }
    }

    public void serialize(DCOutputProvider provider) throws IOException, ProviderException {
        OutputStream out = provider.getStreamForDC();
        XMLWriter writer = new XMLWriter(out);
        try {
            this.serialize(writer);
        }
        catch (ValidationException ex) {
            throw new ProviderException("Serialization failed", ex);
        }
        writer.serialize();
        provider.releaseStream(out);
    }

    public void serialize(DCOutputProvider provider, String schemaVersion) throws IOException, ProviderException {
        OutputStream out = provider.getStreamForDC();
        XMLWriter writer = new XMLWriter(out);
        try {
            this.serialize(writer, schemaVersion);
        }
        catch (ValidationException ex) {
            throw new ProviderException("Serialization failed", ex);
        }
        writer.serialize();
        provider.releaseStream(out);
    }

    public void serializePublicPart(String publicPartName, DCOutputProvider provider) throws IOException, ProviderException {
        if (this._publicParts != null) {
            PPOutputProvider ppProvider = provider.getPPOutputProvider(publicPartName);
            PublicPart pp = (PublicPart)this._publicParts.get(publicPartName);
            if (pp != null) {
                pp.serialize(ppProvider);
            }
        }
    }

    public void serializePublicPart(String publicPartName, DCOutputProvider provider, String schemaVersion) throws IOException, ProviderException {
        if (this._publicParts != null) {
            PPOutputProvider ppProvider = provider.getPPOutputProvider(publicPartName);
            PublicPart pp = (PublicPart)this._publicParts.get(publicPartName);
            if (pp != null) {
                pp.serialize(ppProvider, schemaVersion);
            }
        }
    }

    public void serializePublicParts(DCOutputProvider provider) throws IOException, ProviderException {
        if (this._publicParts != null) {
            Iterator iter = this._publicParts.keySet().iterator();
            while (iter.hasNext()) {
                String ppName = (String)iter.next();
                PPOutputProvider ppProvider = provider.getPPOutputProvider(ppName);
                PublicPart pp = (PublicPart)this._publicParts.get(ppName);
                pp.serialize(ppProvider);
            }
        }
    }

    public void serializePublicParts(DCOutputProvider provider, String schemaVersion) throws IOException, ProviderException {
        if (this._publicParts != null) {
            Iterator iter = this._publicParts.keySet().iterator();
            while (iter.hasNext()) {
                String ppName = (String)iter.next();
                PPOutputProvider ppProvider = provider.getPPOutputProvider(ppName);
                PublicPart pp = (PublicPart)this._publicParts.get(ppName);
                pp.serialize(ppProvider, schemaVersion);
            }
        }
    }

    public void serialize(XMLWriter writer) throws ValidationException {
        this.updateSchemaVersion();
        if (!ComponentFactory.isSchemaAllowed(this._schemaVersion)) {
            throw new InvalidFileFormatException("Cannot serialize development component with schema version '" + this._schemaVersion + "'. Latest known schema version is " + "1.0.2");
        }
        if (!this._isSchemaAllowed()) {
            throw new InvalidFileFormatException("Cannot serialize development component with schema version '" + this._schemaVersion + "' since this component uses" + " features from API version " + this._apiVersion);
        }
        this.serialize(writer, this._schemaVersion);
    }

    public void serialize(XMLWriter writer, String schemaVersion) throws ValidationException {
        String prefix;
        String namespace;
        Property prop;
        if (schemaVersion == null) {
            this.updateSchemaVersion();
            schemaVersion = this._schemaVersion;
        }
        if (!ComponentFactory.isSchemaAllowed(schemaVersion)) {
            throw new InvalidFileFormatException("Cannot serialize development component with schema version '" + schemaVersion + "'. The version number is unknown." + " Latest known schema version is " + "1.0.2");
        }
        if (this._name == null) {
            throw new ValidationException("DCs must have a name.");
        }
        try {
            NameChecker.checkComponentName(this._name);
        }
        catch (NameCheckException ex) {
            throw new ValidationException("DCs must have a valid name.", ex);
        }
        if (this._vendor == null) {
            throw new ValidationException("DCs must have a vendor.");
        }
        try {
            NameChecker.checkVendorName(this._vendor);
        }
        catch (NameCheckException ex) {
            throw new ValidationException("DCs must have a valid vendor.", ex);
        }
        if (this._componentType == null) {
            throw new ValidationException("DCs must have a component type.");
        }
        if (this._attributes == null) {
            this._attributes = new ArrayList();
        }
        this.setAttribute("xmlns", "http://xml.sap.com/2002/11/DevelopmentComponent");
        this.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.setAttribute("xsi:schemaLocation", "http://xml.sap.com/2002/11/DevelopmentComponent dcdef.xsd");
        String versionAttr = schemaVersion == null ? this._schemaVersion : schemaVersion;
        this.setAttribute(VERSION, versionAttr);
        this.setAttribute("xmlns:IDX", "urn:sap.com:DevelopmentComponent:1.0");
        writer.beginDocument();
        writer.wrapAttributeLists(true);
        writer.writeRootTag(DEVELOPMENT_COMPONENT, this.getAttributes());
        writer.wrapAttributeLists(false);
        writer.writeTag(NAME, this._name);
        writer.writeTag(VENDOR, this._vendor);
        if (this._caption != null) {
            writer.writeTag(CAPTION, this._caption);
        }
        if (this._description != null) {
            writer.writeTag(DESCRIPTION, this._description);
        }
        if (this._deprecated && this.doSerialize(schemaVersion, "1.0.2")) {
            writer.writeEmptyTag(DEPRECATED);
        }
        writer.beginTag(COMPONENT_TYPE);
        this._componentType.serialize(writer);
        writer.endTag(COMPONENT_TYPE);
        if (this._properties != null && this._properties.size() > 0 && this.doSerialize(schemaVersion, "1.0.1")) {
            try {
                writer.beginTag(PROPERTIES);
                int i = 0;
                while (i < this._properties.size()) {
                    prop = (Property)this._properties.get(i);
                    namespace = prop.getNamespace();
                    prefix = prop.getNamespacePrefix();
                    if (namespace != null && prefix == null) {
                        prefix = "pns" + Integer.toString(i);
                        prop.setNamespace(prefix, namespace);
                    }
                    prop.serialize(writer);
                    ++i;
                }
                writer.endTag(PROPERTIES);
            }
            catch (ClassCastException ex) {
                throw new ValidationException("List of properties contains an entry that is not of type Property");
            }
        }
        if (this._buildPlugin != null) {
            writer.beginTag(BUILD_PLUGIN);
            this._buildPlugin.serialize(writer);
            writer.endTag(BUILD_PLUGIN);
        }
        if (this._external) {
            writer.writeEmptyTag(EXTERNAL);
        }
        if (this._internal) {
            writer.writeEmptyTag(INTERNAL);
        }
        if (this._parent != null) {
            writer.beginTag(PARENT_DC);
            this._parent.serialize(writer);
            writer.endTag(PARENT_DC);
        }
        if (this._children != null && this._children.size() > 0) {
            try {
                writer.beginTag(INNER_COMPONENTS);
                Iterator iter = this._children.iterator();
                while (iter.hasNext()) {
                    ((DCReference)iter.next()).serialize(writer);
                }
                writer.endTag(INNER_COMPONENTS);
            }
            catch (ClassCastException ex) {
                throw new ValidationException("List of children contains an entry that is not of type DCReference");
            }
        }
        if (this._dependencies != null && this._dependencies.size() > 0) {
            try {
                writer.beginTag(DEPENDENCIES);
                Iterator iter = this._dependencies.iterator();
                while (iter.hasNext()) {
                    ((Dependency)iter.next()).serialize(writer, schemaVersion);
                }
                writer.endTag(DEPENDENCIES);
            }
            catch (ClassCastException ex) {
                throw new ValidationException("List of depedencies contains an entry that is not of type Dependency");
            }
        }
        if ((this._sourceFolders != null && this._sourceFolders.size() > 0 || this._packageFolders != null && this._packageFolders.size() > 0) && this.doSerialize(schemaVersion, "1.0.1")) {
            try {
                writer.beginTag(FOLDERS);
                if (this._sourceFolders != null && this._sourceFolders.size() > 0) {
                    Iterator iter = this._sourceFolders.iterator();
                    while (iter.hasNext()) {
                        writer.writeTag(SOURCE_FOLDER, (String)iter.next());
                    }
                }
                if (this._packageFolders != null && this._packageFolders.size() > 0) {
                    Iterator iter = this._packageFolders.iterator();
                    while (iter.hasNext()) {
                        writer.writeTag(PACKAGE_FOLDER, (String)iter.next());
                    }
                }
                writer.endTag(FOLDERS);
            }
            catch (ClassCastException ex) {
                throw new ValidationException("List of folders contains an entry that is not of type String");
            }
        }
        if (this._grants != null && this._grants.size() > 0) {
            try {
                writer.beginTag(ACCESS_CONTROL_LIST);
                Iterator iter = this._grants.iterator();
                while (iter.hasNext()) {
                    writer.beginTag(GRANT);
                    ((ComponentReference)iter.next()).serialize(writer);
                    writer.endTag(GRANT);
                }
                writer.endTag(ACCESS_CONTROL_LIST);
            }
            catch (ClassCastException ex) {
                throw new ValidationException("List of grants contains an entry that is not of type ComponentReference");
            }
        }
        if (this._extensions != null && this._extensions.size() > 0) {
            int i = 0;
            while (i < this._extensions.size()) {
                prop = (Property)this._extensions.get(i);
                namespace = prop.getNamespace();
                prefix = prop.getNamespacePrefix();
                if (namespace != null && prefix == null) {
                    prefix = "pns" + Integer.toString(i);
                    prop.setNamespace(prefix, namespace);
                }
                prop.serialize(writer);
                ++i;
            }
        }
        writer.endDocument();
    }

    public void initialize(DCInputProvider provider) throws IOException, XMLException, ProviderException {
        this.initialize(provider, false);
    }

    public void initialize(DCInputProvider provider, boolean withPPs) throws IOException, XMLException, ProviderException {
        InputStream in = null;
        try {
            block4: {
                try {
                    in = provider.getStreamForDC();
                    ParserAdapter parser = new ParserAdapter(this);
                    parser.parse(in);
                    if (!withPPs) break block4;
                    this.initializePublicParts(provider);
                }
                catch (SAXException ex) {
                    throw new XMLException("Initializing development component failed", ex);
                }
            }
            Object var6_6 = null;
            provider.releaseStream(in);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            provider.releaseStream(in);
            throw throwable;
        }
    }

    public void initializePublicPart(String publicPartName, DCInputProvider provider) throws IOException, XMLException, ProviderException {
        PPInputProvider ppProvider = provider.getPPInputProvider(publicPartName);
        PublicPart pp = ComponentFactory.createPublicPart();
        pp.initialize(ppProvider);
        if (this._publicParts == null) {
            this.emptyPublicParts();
        }
        this._publicParts.put(pp.getName(), pp);
    }

    public void initializePublicParts(DCInputProvider provider) throws IOException, XMLException, ProviderException {
        String[] publicPartNames = provider.getPublicParts();
        int i = 0;
        while (i < publicPartNames.length) {
            PPInputProvider ppProvider = provider.getPPInputProvider(publicPartNames[i]);
            PublicPart pp = ComponentFactory.createPublicPart();
            try {
                pp.initialize(ppProvider);
            }
            catch (XMLException ex) {
                throw new XMLException("Initializing public part " + publicPartNames[i] + "failed", ex.getCause());
            }
            if (this._publicParts == null) {
                this.emptyPublicParts();
            }
            this._publicParts.put(pp.getName(), pp);
            ++i;
        }
    }

    public boolean isSchemaAllowed() {
        this.updateSchemaVersion();
        return this._isSchemaAllowed();
    }

    public boolean isSchemaAllowed(String schemaVersion) {
        this.updateSchemaVersion();
        return this._isSchemaAllowed(schemaVersion);
    }

    public String getSchemaVersion() {
        this.updateSchemaVersion();
        return this._schemaVersion;
    }

    private void updateSchemaVersion() {
        if (this._dependencies != null && this._dependencies.size() > 0) {
            Iterator iter = this._dependencies.iterator();
            String entitySchemaVersion = null;
            String entityAPIVersion = null;
            while (iter.hasNext()) {
                try {
                    Initializable next = (Initializable)iter.next();
                    entitySchemaVersion = next._getSchemaVersion();
                    entityAPIVersion = next._getAPIVersion();
                }
                catch (ClassCastException e) {
                    continue;
                }
                if (this._schemaVersion.compareTo(entitySchemaVersion) < 0) {
                    this._schemaVersion = entitySchemaVersion;
                }
                if (this._apiVersion.compareTo(entityAPIVersion) >= 0) continue;
                this._apiVersion = entityAPIVersion;
            }
        }
        if (!this._initialized && this._schemaVersion.compareTo(this._apiVersion) < 0) {
            this._schemaVersion = this._apiVersion;
        }
    }

    protected void tagValue(char[] chars, int start, int length) {
        switch (this.state) {
            case 810: {
                this.dep.tagValue(chars, start, length);
                return;
            }
        }
        super.tagValue(chars, start, length);
    }

    protected void startTag(String name, Attributes attributes) throws SAXException {
        switch (this.state) {
            case 0: {
                String versionAttr;
                if (name.equals(DEVELOPMENT_COMPONENT)) {
                    this.dropTagValue();
                    versionAttr = attributes.getValue(VERSION);
                    if (versionAttr == null) {
                        throw new SAXException("Unable to read component description: Missing 'version' attribute");
                    }
                } else {
                    throw new SAXException("root tag expected <development-component>");
                }
                this._setSchemaVersion(versionAttr);
                this._attributes = this.getAttributes(attributes);
                this.rootTag = name;
                this.state = 10;
                return;
            }
            case 1: {
                return;
            }
            case 10: {
                if (name.equals(NAME)) {
                    this.state = 10;
                    return;
                }
                throw new SAXException("mandatory tag <name> expected");
            }
            case 20: {
                if (name.equals(VENDOR)) {
                    this.state = 20;
                    return;
                }
                throw new SAXException("mandatory tag <vendor> expected");
            }
            case 30: {
                if (name.equals(CAPTION)) {
                    this.state = 30;
                    return;
                }
            }
            case 40: {
                if (name.equals(DESCRIPTION)) {
                    this.state = 40;
                    return;
                }
            }
            case 95: {
                if (name.equals(DEPRECATED)) {
                    this._deprecated = true;
                    this.state = 95;
                    return;
                }
            }
            case 50: {
                if (name.equals(COMPONENT_TYPE)) {
                    this.compType = new ComponentType();
                    this.state = 60;
                    return;
                }
                throw new SAXException("mandatory tag <component-type> expected");
            }
            case 65: {
                if (name.equals(PROPERTIES)) {
                    this.state = 240;
                    return;
                }
            }
            case 70: {
                if (name.equals(BUILD_PLUGIN)) {
                    this.ppref = new PPReference();
                    this.state = 600;
                    return;
                }
            }
            case 80: {
                if (name.equals(EXTERNAL)) {
                    this._external = true;
                    this.state = 80;
                    return;
                }
            }
            case 90: {
                if (name.equals(INTERNAL)) {
                    this._internal = true;
                    this.state = 90;
                    return;
                }
            }
            case 100: {
                if (name.equals(PARENT_DC)) {
                    this._parent = new DCReference();
                    this.ref = this._parent;
                    this.state = 300;
                    return;
                }
            }
            case 110: {
                if (name.equals(INNER_COMPONENTS)) {
                    if (this._children == null) {
                        this._children = new ArrayList();
                    }
                    this.list = this._children;
                    this.state = 400;
                    return;
                }
            }
            case 112: {
                if (name.equals(DEPENDENCIES)) {
                    this.state = 800;
                    return;
                }
            }
            case 123: {
                if (name.equals(FOLDERS)) {
                    this.state = 550;
                    return;
                }
            }
            case 120: {
                if (name.equals(ACCESS_CONTROL_LIST)) {
                    this.state = 500;
                    return;
                }
            }
            case 125: {
                this.dropTagValue();
                if (this.extension == null) {
                    this.extension = new PropertyImpl(name);
                    this.extension.setAttributes(this.getAttributes(attributes));
                    this.state = 125;
                    return;
                }
                PropertyElement elem = this.extension.addChild(name);
                elem.setAttributes(this.getAttributes(attributes));
                this.state = 126;
                this.node = this.extension.lastChild();
                return;
            }
            case 130: {
                break;
            }
            case 60: {
                if (name.equals(VENDOR)) {
                    this.state = 200;
                    return;
                }
                throw new SAXException("mandatory tag <vendor> expected in template");
            }
            case 210: {
                if (name.equals(TYPE)) {
                    this.state = 210;
                    return;
                }
                throw new SAXException("mandatory tag <type> expected in template");
            }
            case 220: {
                if (name.equals(SUBTYPE)) {
                    this.state = 220;
                }
                return;
            }
            case 230: {
                break;
            }
            case 600: {
                if (!name.equals(DCREF)) break;
                this.ppref.setComponent(new DCReference());
                this.ref = this.ppref.getComponent();
                this.state = 310;
                return;
            }
            case 300: {
                if (name.equals(DCREF) || name.equals(SCREF)) {
                    this.state = 310;
                    return;
                }
                throw new SAXException("mandatory tag <dc-ref> or <sc-ref> expected.");
            }
            case 310: {
                if (name.equals(NAME)) {
                    this.state = 310;
                    return;
                }
                throw new SAXException("mandatory tag <name> expected in reference");
            }
            case 320: {
                if (name.equals(VENDOR)) {
                    this.state = 320;
                    return;
                }
                throw new SAXException("mandatory tag <vendor> expected in reference");
            }
            case 330: {
                if (name.equals(SC_ALIAS)) {
                    this.state = 330;
                    return;
                }
            }
            case 340: {
                if (name.equals(PPREF)) {
                    this.state = 610;
                    return;
                }
                if (!this.readList) break;
                if (name.equals(DCREF)) {
                    this.ref = new DCReference();
                } else if (name.equals(SCREF)) {
                    this.ref = new SCReference();
                }
                if (this.ref == null) break;
                this.list.add(this.ref);
                this.state = 310;
                return;
            }
            case 400: {
                if (!name.equals(DCREF)) break;
                this.ref = new DCReference();
                this.list.add(this.ref);
                this.state = 310;
                this.readList = true;
                return;
            }
            case 240: {
                if (this.property == null) {
                    this.property = new PropertyImpl(name);
                    this.property.setAttributes(this.getAttributes(attributes));
                    return;
                }
                PropertyElement elem = this.property.addChild(name);
                elem.setAttributes(this.getAttributes(attributes));
                this.state = 245;
                this.child = this.property.lastChild();
                return;
            }
            case 245: {
                PropertyElement elem = this.child.addChild(name);
                elem.setAttributes(this.getAttributes(attributes));
                this.child = this.child.lastChild();
                return;
            }
            case 800: {
                if (!name.equals(DEPENDENCY)) break;
                if (this._dependencies == null) {
                    this._dependencies = this.emptyDependencies();
                }
                this.dep = new DependencyImpl();
                this.dep._setSchemaVersion(this._schemaVersion);
                this.state = 810;
                this.dep.startTag(name, attributes);
                return;
            }
            case 810: {
                this.dep.startTag(name, attributes);
                return;
            }
            case 820: {
                break;
            }
            case 550: {
                if (name.equals(SOURCE_FOLDER)) {
                    if (this._sourceFolders == null) {
                        this._sourceFolders = new ArrayList();
                    }
                    this.state = 555;
                    return;
                }
                if (!name.equals(PACKAGE_FOLDER)) break;
                if (this._packageFolders == null) {
                    this._packageFolders = new ArrayList();
                }
                this.state = 560;
                return;
            }
            case 500: {
                if (!name.equals(GRANT)) break;
                this.state = 510;
                return;
            }
            case 510: {
                if (name.equals(DCREF)) {
                    this.ref = new DCReference();
                } else if (name.equals(SCREF)) {
                    this.ref = new SCReference();
                }
                if (this.ref == null) break;
                if (this._grants == null) {
                    this._grants = new ArrayList();
                }
                this.list = this._grants;
                this.list.add(this.ref);
                this.state = 310;
                return;
            }
            case 126: {
                PropertyElement elem = this.node.addChild(name);
                elem.setAttributes(this.getAttributes(attributes));
                this.node = this.node.lastChild();
                return;
            }
            default: {
                throw new SAXException("internal state error: startTag(" + this.rootTag + ") state(" + this.state + ")");
            }
        }
        this.recoverTagName = name;
        this.recoverMode = this.state;
        this.state = 1;
    }

    protected boolean endTag(String name) throws SAXException {
        switch (this.state) {
            case 130: {
                return !name.equals(this.rootTag);
            }
            case 1: {
                this.dropTagValue();
                if (!name.equals(this.recoverTagName)) {
                    return true;
                }
                this.recoverTagName = null;
                this.state = this.recoverMode;
                return true;
            }
            case 10: {
                this._name = this.getStringValue();
                if (this._name.length() == 0) {
                    throw new SAXException("DC name must not be an empty string");
                }
                this.state = 20;
                return true;
            }
            case 20: {
                this._vendor = this.getStringValue();
                if (this._vendor.length() == 0) {
                    throw new SAXException("DC vendor must not be an empty string");
                }
                this.state = 30;
                return true;
            }
            case 30: {
                this._caption = this.getStringValue();
                this.state = 40;
                return true;
            }
            case 40: {
                this._description = this.getStringValue();
                this.state = 95;
                return true;
            }
            case 95: {
                this.state = 50;
                return true;
            }
            case 80: {
                if (name.equals(EXTERNAL)) {
                    this.state = 90;
                    return true;
                }
            }
            case 90: {
                if (name.equals(INTERNAL)) {
                    this.state = 100;
                    return true;
                }
            }
            case 110: 
            case 400: {
                if (name.equals(INNER_COMPONENTS)) {
                    this.state = 112;
                    this.list = null;
                    this.readList = false;
                    return true;
                }
            }
            case 60: {
                if (name.equals(COMPONENT_TYPE)) {
                    throw new SAXException("mandatory tag <vendor> expected inside <component-type>");
                }
            }
            case 300: {
                if (name.equals(PARENT_DC)) {
                    throw new SAXException("mandatory tag <dc-ref> expected inside <parent-dc>");
                }
            }
            case 600: {
                if (name.equals(BUILD_PLUGIN)) {
                    throw new SAXException("mandatory tag <dc-ref> expected inside <build-plugin>");
                }
            }
            case 800: {
                if (name.equals(DEPENDENCIES)) {
                    this.state = 123;
                    return true;
                }
            }
            case 510: {
                if (name.equals(GRANT)) {
                    throw new SAXException("mandatory tag <dc-ref> or <sc-ref> expected inside <grant>");
                }
            }
            case 125: {
                if (this.extension != null && name.equals(this.extension.getName())) {
                    if (this.extension.firstChild() == null && !this.isEmptyTag()) {
                        this.extension.setValue(this.getStringValue());
                    }
                    if (this._extensions == null) {
                        this._extensions = new ArrayList();
                    }
                    this._extensions.add(this.extension);
                    this.extension = null;
                    return true;
                }
            }
            case 65: 
            case 70: 
            case 100: 
            case 112: 
            case 120: 
            case 123: {
                return !name.equals(this.rootTag);
            }
            case 200: {
                String typevendor = this.getStringValue();
                if (typevendor.length() == 0) {
                    throw new SAXException("vendor of component type must not be an empty string");
                }
                this.compType.setVendor(typevendor);
                this.state = 210;
                return true;
            }
            case 210: {
                if (name.equals(TYPE)) {
                    String comptype = this.getStringValue();
                    if (comptype.length() == 0) {
                        throw new SAXException("component type must not be an empty string");
                    }
                    this.compType.setType(comptype);
                    this.state = 220;
                    return true;
                }
                throw new SAXException("mandatory tag <type> expected inside <component-type>");
            }
            case 220: {
                if (name.equals(SUBTYPE)) {
                    this.compType.setSubType(this.getStringValue());
                    this.state = 230;
                    return true;
                }
            }
            case 230: {
                if (name.equals(COMPONENT_TYPE)) {
                    this._componentType = this.compType;
                    this.state = 65;
                }
                return true;
            }
            case 240: {
                if (name.equals(PROPERTIES)) {
                    this.state = 70;
                } else if (name.equals(this.property.getQName())) {
                    if (this.property.firstChild() == null) {
                        this.property.setValue(this.getStringValue());
                    }
                    if (this._properties == null) {
                        this.emptyProperties();
                    }
                    this._properties.add(this.property);
                    this.property = null;
                }
                return true;
            }
            case 245: {
                if (this.child.firstChild() == null) {
                    this.child.setValue(this.getStringValue());
                }
                if (this.child.getParent() != null) {
                    this.child = this.child.getParent();
                } else {
                    if (this._properties == null) {
                        this.emptyProperties();
                    }
                    this._properties.add(this.property);
                    this.property = null;
                    this.state = 240;
                }
                return true;
            }
            case 810: {
                if (this.dep.endTag(name)) {
                    return true;
                }
                this._dependencies.add(this.dep);
                this.dep = null;
                this.state = 800;
                return true;
            }
            case 555: {
                this._sourceFolders.add(this.getStringValue());
                this.state = 550;
                return true;
            }
            case 560: {
                this._packageFolders.add(this.getStringValue());
                this.state = 550;
                return true;
            }
            case 550: {
                this.state = 120;
                return true;
            }
            case 610: {
                if (name.equals(PPREF)) {
                    String buildppref = this.getStringValue();
                    if (buildppref.length() == 0) {
                        throw new SAXException("public part of the build plugin must not be an empty string");
                    }
                    this.ppref.setName(buildppref);
                } else if (name.equals(BUILD_PLUGIN)) {
                    this._buildPlugin = this.ppref;
                    this.state = 80;
                }
                return true;
            }
            case 310: {
                if (name.equals(NAME)) {
                    String refname = this.getStringValue();
                    if (refname.length() == 0) {
                        throw new SAXException("name part of a component or public part reference must not be an empty string");
                    }
                    this.ref.setName(refname);
                    this.state = 320;
                    return true;
                }
                throw new SAXException("mandatory tag <name> missing in reference");
            }
            case 320: {
                if (name.equals(VENDOR)) {
                    String refvendor = this.getStringValue();
                    if (refvendor.length() == 0) {
                        throw new SAXException("vendor part of a component or public part reference must not be an empty string");
                    }
                    this.ref.setVendor(refvendor);
                    this.state = 330;
                    return true;
                }
                throw new SAXException("mandatory tag <vendor> missing in reference");
            }
            case 330: {
                if (name.equals(SC_ALIAS)) {
                    String refalias = this.getStringValue();
                    if (refalias.length() == 0) {
                        throw new SAXException("alias part of a component or public part reference must not be an empty string");
                    }
                    this.ref.setSCAlias(refalias);
                    this.state = 340;
                    return true;
                }
            }
            case 340: 
            case 500: {
                if (name.equals(PARENT_DC)) {
                    this.state = 110;
                } else {
                    if (name.equals(BUILD_PLUGIN)) {
                        throw new SAXException("mandatory tag <pp-ref> missing in <build-plugin>");
                    }
                    if (name.equals(INNER_COMPONENTS)) {
                        this.state = 112;
                        this.list = null;
                        this.readList = false;
                    } else if (name.equals(GRANT)) {
                        this.state = 500;
                    } else if (name.equals(ACCESS_CONTROL_LIST)) {
                        this.list = null;
                        this.state = 125;
                    }
                }
                return true;
            }
            case 126: {
                if (this.node.firstChild() == null && !this.isEmptyTag()) {
                    this.node.setValue(this.getStringValue());
                }
                if (this.node.getParent() != null) {
                    this.node = this.node.getParent();
                } else {
                    if (this._extensions == null) {
                        this._extensions = new ArrayList();
                    }
                    this._extensions.add(this.extension);
                    this.extension = null;
                    this.state = 125;
                }
                return true;
            }
        }
        throw new SAXException("internal state error: endTag(" + this.rootTag + ") state(" + this.state + ")");
    }

    public boolean isParentDependencyPrerequisiteForChildren() {
        return false;
    }
}

