/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.complib.impl;

import com.sap.tc.complib.ComponentFactory;
import com.sap.tc.complib.DCReference;
import com.sap.tc.complib.Dependency;
import com.sap.tc.complib.PPReference;
import com.sap.tc.complib.Property;
import com.sap.tc.complib.PropertyElement;
import com.sap.tc.complib.impl.PropertyImpl;
import com.sap.tc.complib.keygen.KeyGenerator;
import com.sap.tc.complib.validate.InvalidFileFormatException;
import com.sap.tc.complib.validate.MissingElementException;
import com.sap.tc.complib.validate.ValidationException;
import com.sap.tc.complib.xml.Attribute;
import com.sap.tc.complib.xml.Initializable;
import com.sap.tc.complib.xml.XMLWriter;
import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DependencyImpl
extends Initializable
implements Dependency {
    private DCReference _component;
    private String _publicPart;
    private boolean _childDependencyAllowed = false;
    private boolean _atDesignTime;
    private boolean _atBuildTime;
    private boolean _atRuntime;
    private boolean _atDeployTime;
    private String _designtimeQualifier;
    private String _buildtimeQualifier;
    private String _deploytimeQualifier;
    private String _runtimeQualifier;
    private static final String AT_RUNTIME = "at-runtime";
    private static final String AT_DESIGN_TIME = "at-design-time";
    private static final String AT_BUILD_TIME = "at-build-time";
    private static final String AT_DEPLOY_TIME = "at-deploy-time";
    private static final String FOR_CHILDREN = "for-children";
    private static final String PP_REF = "pp-ref";
    private static final String DEPENDENCY = "dependency";
    private static final String QUALIFIER = "qualifier";
    private static final String ALLOW_INNER = "allow-inner";
    private static final String DC_REF = "dc-ref";
    private static final String NAME = "name";
    private static final String VENDOR = "vendor";
    private static final String SC_ALIAS = "sc-alias";
    private static final int _hashStart = 17;
    private static final int _hashPrime = 37;
    private final String m_key = KeyGenerator.getInstance().createKey(this.getClass());
    private String rootTag;
    private DCReference ref = null;
    private PropertyImpl extension;
    private PropertyElement node;
    private static final int DEP_DCREF = 10;
    private static final int DEP_PPREF = 20;
    private static final int DEP_ALLOW_INNER = 30;
    private static final int DEP_AT_DESIGN_TIME = 40;
    private static final int DEP_AT_BUILD_TIME = 50;
    private static final int DEP_AT_DEPLOY_TIME = 60;
    private static final int DEP_AT_RUNTIME = 70;
    private static final int DEP_EXTENSIONS = 80;
    private static final int DEP_EXTENSION_CHILD = 85;
    private static final int DEP_FINAL = 90;
    private static final int REF_NAME = 310;
    private static final int REF_VENDOR = 320;
    private static final int REF_ALIAS = 330;
    private static final int REF_FINAL = 340;

    public DependencyImpl() {
        this._schemaVersion = "1.0.2";
        this._apiVersion = "1.0.1";
    }

    public DCReference getComponent() {
        return this._component;
    }

    public void setComponent(DCReference component) {
        this._component = component;
    }

    public PPReference getPublicPartDependency() {
        return this._component != null && this._publicPart != null ? new PPReference(this) : null;
    }

    public void setPublicPartDependency(PPReference ref) {
        this._component = ref.getComponent();
        this._publicPart = ref.getName();
    }

    public String getPublicPart() {
        return this._publicPart;
    }

    public void setPublicPart(String publicPart) {
        this._publicPart = publicPart;
    }

    public boolean isForChildrenOnly() {
        return this._childDependencyAllowed;
    }

    public void setForChildrenOnly(boolean forChildrenOnly) {
        this._childDependencyAllowed = forChildrenOnly;
    }

    public boolean isAtDesignTime() {
        return this._atDesignTime;
    }

    public void setAtDesignTime(boolean atDesignTime) {
        this._atDesignTime = atDesignTime;
    }

    public void setAtDesignTime(boolean atDesignTime, String qualifier) {
        this._atDesignTime = atDesignTime;
        this._apiVersion = "1.0.2".compareTo(this._apiVersion) > 0 ? "1.0.2" : this._apiVersion;
    }

    public String getDesignTimeQualifier() {
        return this._designtimeQualifier;
    }

    public void setDesignTimeQualifier(String qualifier) {
        this._designtimeQualifier = qualifier;
        this._apiVersion = "1.0.2".compareTo(this._apiVersion) > 0 ? "1.0.2" : this._apiVersion;
    }

    public boolean isAtBuildTime() {
        return this._atBuildTime;
    }

    public void setAtBuildTime(boolean atBuildTime) {
        this._atBuildTime = atBuildTime;
    }

    public void setAtBuildTime(boolean atBuildTime, String qualifier) {
        this._atBuildTime = atBuildTime;
        this._apiVersion = "1.0.2".compareTo(this._apiVersion) > 0 ? "1.0.2" : this._apiVersion;
    }

    public String getBuildTimeQualifier() {
        return this._buildtimeQualifier;
    }

    public void setBuildTimeQualifier(String qualifier) {
        this._buildtimeQualifier = qualifier;
        this._apiVersion = "1.0.2".compareTo(this._apiVersion) > 0 ? "1.0.2" : this._apiVersion;
    }

    public boolean isAtDeployTime() {
        return this._atDeployTime;
    }

    public void setAtDeployTime(boolean atDeployTime) {
        this._atDeployTime = atDeployTime;
    }

    public void setAtDeployTime(boolean atDeployTime, String qualifier) {
        this._atDeployTime = atDeployTime;
        this._apiVersion = "1.0.2".compareTo(this._apiVersion) > 0 ? "1.0.2" : this._apiVersion;
    }

    public String getDeployTimeQualifier() {
        return this._deploytimeQualifier;
    }

    public void setDeployTimeQualifier(String qualifier) {
        this._deploytimeQualifier = qualifier;
        this._apiVersion = "1.0.2".compareTo(this._apiVersion) > 0 ? "1.0.2" : this._apiVersion;
    }

    public boolean isAtRunTime() {
        return this._atRuntime;
    }

    public void setAtRunTime(boolean atRuntime) {
        this._atRuntime = atRuntime;
    }

    public void setAtRunTime(boolean atRuntime, String qualifier) {
        this._atRuntime = atRuntime;
        this._runtimeQualifier = qualifier;
    }

    public String getRuntimeQuialifier() {
        return this._runtimeQualifier;
    }

    public void setRuntimeQualifier(String qualifier) {
        this._runtimeQualifier = qualifier;
    }

    public void validate() throws ValidationException {
        if (this._component == null) {
            throw new MissingElementException("component");
        }
        this._component.validate();
    }

    public void serialize(XMLWriter writer) throws ValidationException {
        if (!ComponentFactory.isSchemaAllowed(this._schemaVersion)) {
            throw new InvalidFileFormatException("Cannot serialize dependency with format version " + this._schemaVersion + ". Latest known schema version is " + "1.0.2");
        }
        if (!this._isSchemaAllowed()) {
            throw new InvalidFileFormatException("Cannot serialize dependency with format version " + this._schemaVersion + " since this dependency uses" + " features from API version " + this._apiVersion);
        }
        this.serialize(writer, this._schemaVersion);
    }

    public void serialize(XMLWriter writer, String schemaVersion) throws ValidationException {
        if (schemaVersion == null) {
            schemaVersion = this._schemaVersion;
        }
        if (!ComponentFactory.isSchemaAllowed(schemaVersion)) {
            throw new InvalidFileFormatException("Cannot serialize dependency with format version " + schemaVersion + ". Latest known schema version is " + "1.0.2");
        }
        if (this._component == null) {
            throw new ValidationException("Dependency must define a target component");
        }
        if (this._attributes != null) {
            writer.beginTag(DEPENDENCY, this.getAttributes());
        } else {
            writer.beginTag(DEPENDENCY);
        }
        this._component.serialize(writer);
        if (this._publicPart != null) {
            writer.writeTag(PP_REF, this._publicPart);
        }
        if (this._childDependencyAllowed) {
            writer.writeEmptyTag(FOR_CHILDREN);
        }
        if (this._atDesignTime) {
            if (this._designtimeQualifier != null && this.doSerialize(schemaVersion, "1.0.2")) {
                writer.writeEmptyTag(AT_DESIGN_TIME, new Attribute[]{new Attribute(QUALIFIER, this._designtimeQualifier)});
            } else {
                writer.writeEmptyTag(AT_DESIGN_TIME);
            }
        }
        if (this._atBuildTime) {
            if (this._buildtimeQualifier != null && this.doSerialize(schemaVersion, "1.0.2")) {
                writer.writeEmptyTag(AT_BUILD_TIME, new Attribute[]{new Attribute(QUALIFIER, this._buildtimeQualifier)});
            } else {
                writer.writeEmptyTag(AT_BUILD_TIME);
            }
        }
        if (this._atDeployTime) {
            if (this._deploytimeQualifier != null && this.doSerialize(schemaVersion, "1.0.2")) {
                writer.writeEmptyTag(AT_DEPLOY_TIME, new Attribute[]{new Attribute(QUALIFIER, this._deploytimeQualifier)});
            } else {
                writer.writeEmptyTag(AT_DEPLOY_TIME);
            }
        }
        if (this._atRuntime) {
            if (this._runtimeQualifier != null) {
                writer.writeEmptyTag(AT_RUNTIME, new Attribute[]{new Attribute(QUALIFIER, this._runtimeQualifier)});
            } else {
                writer.writeEmptyTag(AT_RUNTIME);
            }
        }
        if (this._extensions != null && this._extensions.size() > 0) {
            int i = 0;
            while (i < this._extensions.size()) {
                Property prop = (Property)this._extensions.get(i);
                String namespace = prop.getNamespace();
                String prefix = prop.getNamespacePrefix();
                if (namespace != null && prefix == null) {
                    prefix = "pns" + Integer.toString(i);
                    prop.setNamespace(prefix, namespace);
                }
                prop.serialize(writer);
                ++i;
            }
        }
        writer.endTag(DEPENDENCY);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DependencyImpl)) {
            return false;
        }
        Dependency dep = (Dependency)obj;
        return this._equals(dep);
    }

    public boolean equals(Dependency dep) {
        if (dep == this) {
            return true;
        }
        if (dep == null) {
            return false;
        }
        return this._equals(dep);
    }

    private boolean _equals(Dependency dep) {
        return this._atDesignTime == dep.isAtDesignTime() && this._atBuildTime == dep.isAtBuildTime() && this._atDeployTime == dep.isAtDeployTime() && this._atRuntime == dep.isAtRunTime() && this._childDependencyAllowed == dep.isForChildrenOnly() && (this._designtimeQualifier != null ? this._designtimeQualifier.equals(dep.getDesignTimeQualifier()) : dep.getDesignTimeQualifier() == null) && (this._buildtimeQualifier != null ? this._buildtimeQualifier.equals(dep.getBuildTimeQualifier()) : dep.getBuildTimeQualifier() == null) && (this._deploytimeQualifier != null ? this._deploytimeQualifier.equals(dep.getDeployTimeQualifier()) : dep.getDeployTimeQualifier() == null) && (this._runtimeQualifier != null ? this._runtimeQualifier.equals(dep.getRuntimeQuialifier()) : dep.getRuntimeQuialifier() == null) && (this._component != null ? this._component.equals(dep.getComponent()) : dep.getComponent() == null) && (this._publicPart != null ? this._publicPart.equals(dep.getPublicPart()) : dep.getPublicPart() == null);
    }

    public int hashCode() {
        int hash = 17;
        if (this._designtimeQualifier != null) {
            hash = 37 * hash + this._designtimeQualifier.hashCode();
        }
        if (this._buildtimeQualifier != null) {
            hash = 37 * hash + this._buildtimeQualifier.hashCode();
        }
        if (this._deploytimeQualifier != null) {
            hash = 37 * hash + this._deploytimeQualifier.hashCode();
        }
        if (this._runtimeQualifier != null) {
            hash = 37 * hash + this._runtimeQualifier.hashCode();
        }
        if (this._publicPart != null) {
            hash = 37 * hash + this._publicPart.hashCode();
        }
        if (this._component != null) {
            hash = 37 * hash + this._component.hashCode();
        }
        hash = 37 * hash + (this._atDesignTime ? 0 : 1);
        hash = 37 * hash + (this._atBuildTime ? 0 : 1);
        hash = 37 * hash + (this._atDeployTime ? 0 : 1);
        hash = 37 * hash + (this._atRuntime ? 0 : 1);
        return hash;
    }

    public String getUniqueKey() {
        return this.m_key;
    }

    protected void tagValue(char[] chars, int start, int length) {
        super.tagValue(chars, start, length);
    }

    protected void startTag(String name, Attributes attributes) throws SAXException {
        switch (this.state) {
            case 0: {
                this.dropTagValue();
                if (!name.equals(DEPENDENCY)) {
                    throw new SAXException("root tag expected <dependency>");
                }
                this._component = this.ref = new DCReference();
                this._attributes = this.getAttributes(attributes);
                this.state = 10;
                this.rootTag = name;
                return;
            }
            case 1: {
                return;
            }
            case 10: {
                if (name.equals(DC_REF)) {
                    this.state = 310;
                    return;
                }
                throw new SAXException("mandatory tag <dc-ref> expected.");
            }
            case 20: {
                if (name.equals(PP_REF)) {
                    this.state = 20;
                    return;
                }
            }
            case 30: {
                if (name.equals(FOR_CHILDREN) || name.equals(ALLOW_INNER)) {
                    this._childDependencyAllowed = true;
                    this.state = 30;
                    return;
                }
            }
            case 40: {
                if (name.equals(AT_DESIGN_TIME)) {
                    this._atDesignTime = true;
                    this._designtimeQualifier = attributes.getValue(QUALIFIER);
                    this.state = 40;
                    return;
                }
            }
            case 50: {
                if (name.equals(AT_BUILD_TIME)) {
                    this._atBuildTime = true;
                    this._buildtimeQualifier = attributes.getValue(QUALIFIER);
                    this.state = 50;
                    return;
                }
            }
            case 60: {
                if (name.equals(AT_DEPLOY_TIME)) {
                    this._atDeployTime = true;
                    this._deploytimeQualifier = attributes.getValue(QUALIFIER);
                    this.state = 60;
                    return;
                }
            }
            case 70: {
                if (name.equals(AT_RUNTIME)) {
                    this._atRuntime = true;
                    this._runtimeQualifier = attributes.getValue(QUALIFIER);
                    this.state = 70;
                    return;
                }
            }
            case 80: {
                this.dropTagValue();
                if (this.extension == null) {
                    this.extension = new PropertyImpl(name);
                    this.extension.setAttributes(this.getAttributes(attributes));
                    this.state = 80;
                    return;
                }
                PropertyElement elem = this.extension.addChild(name);
                elem.setAttributes(this.getAttributes(attributes));
                this.state = 85;
                this.node = this.extension.lastChild();
                return;
            }
            case 90: {
                break;
            }
            case 85: {
                PropertyElement elem = this.node.addChild(name);
                elem.setAttributes(this.getAttributes(attributes));
                this.node = this.node.lastChild();
                return;
            }
            case 310: {
                if (name.equals(NAME)) {
                    this.state = 310;
                    return;
                }
                throw new SAXException("mandatory tag <name> expected in reference");
            }
            case 320: {
                if (name.equals(VENDOR)) {
                    this.state = 320;
                    return;
                }
                throw new SAXException("mandatory tag <vendor> expected in reference");
            }
            case 330: {
                if (name.equals(SC_ALIAS)) {
                    this.state = 330;
                    return;
                }
            }
            case 340: {
                break;
            }
            default: {
                throw new SAXException("internal state error: endTag(" + this.rootTag + ") state(" + this.state + ")");
            }
        }
    }

    protected boolean endTag(String name) throws SAXException {
        switch (this.state) {
            case 1: {
                this.dropTagValue();
                if (!name.equals(this.recoverTagName)) {
                    return true;
                }
                this.recoverTagName = null;
                this.state = this.recoverMode;
                return true;
            }
            case 20: {
                if (name.equals(PP_REF)) {
                    this._publicPart = this.getStringValue();
                    if (this._publicPart.length() == 0) {
                        throw new SAXException("public part reference must not be an empty string");
                    }
                    this.state = 30;
                    return true;
                }
            }
            case 30: {
                if (name.equals(FOR_CHILDREN) || name.equals(ALLOW_INNER)) {
                    this.state = 40;
                    return true;
                }
            }
            case 40: {
                if (name.equals(AT_DESIGN_TIME)) {
                    this.state = 50;
                    return true;
                }
            }
            case 50: {
                if (name.equals(AT_BUILD_TIME)) {
                    this.state = 60;
                    return true;
                }
            }
            case 60: {
                if (name.equals(AT_DEPLOY_TIME)) {
                    this.state = 70;
                    return true;
                }
            }
            case 70: {
                if (name.equals(AT_RUNTIME)) {
                    this.state = 80;
                    return true;
                }
            }
            case 80: {
                if (this.extension != null && name.equals(this.extension.getName())) {
                    if (this.extension.firstChild() == null && !this.isEmptyTag()) {
                        this.extension.setValue(this.getStringValue());
                    }
                    if (this._extensions == null) {
                        this._extensions = new ArrayList();
                    }
                    this._extensions.add(this.extension);
                    this.extension = null;
                    return true;
                }
            }
            case 90: {
                return !name.equals(this.rootTag);
            }
            case 85: {
                if (this.node.firstChild() == null && !this.isEmptyTag()) {
                    this.node.setValue(this.getStringValue());
                }
                if (this.node.getParent() != null) {
                    this.node = this.node.getParent();
                } else {
                    if (this._extensions == null) {
                        this._extensions = new ArrayList();
                    }
                    this._extensions.add(this.extension);
                    this.extension = null;
                    this.state = 80;
                }
                return true;
            }
            case 310: {
                if (name.equals(NAME)) {
                    String refname = this.getStringValue();
                    if (refname.length() == 0) {
                        throw new SAXException("name part of a component or public part reference must not be an empty string");
                    }
                    this.ref.setName(refname);
                    this.state = 320;
                    return true;
                }
                throw new SAXException("mandatory tag <name> missing in reference");
            }
            case 320: {
                if (name.equals(VENDOR)) {
                    String refvendor = this.getStringValue();
                    if (refvendor.length() == 0) {
                        throw new SAXException("vendor part of a component or public part reference must not be an empty string");
                    }
                    this.ref.setVendor(refvendor);
                    this.state = 330;
                    return true;
                }
                throw new SAXException("mandatory tag <vendor> missing in reference");
            }
            case 330: {
                if (name.equals(SC_ALIAS)) {
                    String refalias = this.getStringValue();
                    if (refalias.length() == 0) {
                        throw new SAXException("alias part of a component or public part reference must not be an empty string");
                    }
                    this.ref.setSCAlias(refalias);
                    this.state = 340;
                    return true;
                }
            }
            case 340: {
                this.state = 20;
                return true;
            }
        }
        throw new SAXException("internal state error: endTag(" + this.rootTag + ") state(" + this.state + ")");
    }

    public String toString() {
        return this.getComponent().toString() + " public part: " + this.getPublicPart() + " build-time: " + this.isAtBuildTime() + " deploy-time: " + this.isAtDeployTime() + " run-time: " + this.isAtRunTime() + " design-time: " + this.isAtDesignTime();
    }
}

