/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.complib.impl;

import com.sap.tc.complib.BuildVariant;
import com.sap.tc.complib.Compartment;
import com.sap.tc.complib.Property;
import com.sap.tc.complib.PropertyElement;
import com.sap.tc.complib.SourceState;
import com.sap.tc.complib.impl.BuildVariantImpl;
import com.sap.tc.complib.impl.PropertyImpl;
import com.sap.tc.complib.impl.SourceStateImpl;
import com.sap.tc.complib.namecheck.NameChecker;
import com.sap.tc.complib.validate.CompartmentEmptyException;
import com.sap.tc.complib.validate.CompartmentLocalAndRemoteException;
import com.sap.tc.complib.validate.InvalidFileFormatException;
import com.sap.tc.complib.validate.ValidationException;
import com.sap.tc.complib.xml.Attribute;
import com.sap.tc.complib.xml.Initializable;
import com.sap.tc.complib.xml.XMLWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CompartmentImpl
extends Initializable
implements Compartment {
    private String m_id;
    private String m_name;
    private SourceState m_sourceState;
    private TreeMap m_scAliases;
    private TreeMap m_buildVariants;
    private String m_scName;
    private String m_scVendor;
    private String m_caption = "";
    private String m_description = "";
    private boolean m_hasArchiveState = false;
    private boolean m_defaultCompartment = true;
    private String m_localArchiveFolder = null;
    private Set m_usedCompartments = null;
    private List m_properties = null;
    public static final String TAG_COMPARTMENT = "sc-compartment";
    public static final String ATTR_COMP_NAME = "name";
    public static final String ATTR_COMP_CAPTION = "caption";
    public static final String ATTR_COMP_ARCHIVE = "archive-state";
    public static final String ATTR_COMP_DEFAULT = "default-compartment";
    public static final String ATTR_COMP_SCVENDOR = "sc-vendor";
    public static final String ATTR_COMP_SCNAME = "sc-name";
    public static final String TAG_COMP_DESCRIP = "compartment-description";
    public static final String TAG_STATE_INFO = "sc-state-info";
    public static final String TAG_SC_ALIASES = "sc-aliases";
    public static final String TAG_BUILD_VARIANTS = "build-variants";
    public static final String TAG_BUILD_VARIANT = "build-variant";
    public static final String TAG_SC_ALIAS = "sc-alias";
    public static final String TAG_DEPENDENCIES = "dependencies";
    public static final String TAG_USED_COMPARTMENT = "used-compartment";
    public static final String TAG_PROPERTIES = "properties";
    public static final String ATTR_ALIAS_NAME = "name";
    public static final String ATTR_ALIAS_COMPARTMENT_REF = "compartment-ref";
    public static final String ATTR_LOCAL_ARCHIVES = "local-archive-folder";
    public static final String TAG_SOURCE_STATE = "source-state";
    private static final int STATE_COMP_DESCRIP = 4;
    private static final int STATE_STATE_INFO = 5;
    private static final int STATE_SC_ALIASES = 6;
    private static final int STATE_SC_ALIAS = 7;
    private static final int STATE_BUILD_VARIANTS = 8;
    private static final int STATE_BUILD_VARIANT = 9;
    private static final int STATE_SOURCE_STATE = 10;
    private static final int STATE_CHILD_SOURCE_STATE = 11;
    private static final int STATE_CHILD_BUILD_VARIANT = 12;
    private static final int STATE_COMP_FINAL = 13;
    private static final int STATE_DEPENDENCIES = 14;
    private static final int STATE_USED_COMPARTMENT = 15;
    private static final int STATE_PROPERTIES = 16;
    private static final int STATE_PROPERTY = 17;
    private static final int STATE_PROP_CHILD = 18;
    private BuildVariantImpl buildVariantChild = null;
    private SourceStateImpl sourceStateChild = null;
    private String rootTag;
    private String currentScAliasName = null;
    private String currentScAliasCompartment = null;
    private PropertyImpl property = null;
    private PropertyElement child = null;

    public CompartmentImpl() {
        this._schemaVersion = "0.3";
        this._apiVersion = "0.2";
    }

    public String getId() {
        return this.m_id;
    }

    public void setId(String value) {
        this.m_id = value;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String value) {
        this.m_description = value;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String value) {
        this.m_name = value;
    }

    public String getCaption() {
        return this.m_caption;
    }

    public void setCaption(String value) {
        this.m_caption = value;
    }

    public boolean getHasArchiveState() {
        return this.m_hasArchiveState;
    }

    public void setHasArchiveState(boolean value) {
        this.m_hasArchiveState = value;
    }

    public boolean IsDefaultCompartment() {
        return this.m_defaultCompartment;
    }

    public void setDefaultCompartment(boolean value) {
        this.m_defaultCompartment = value;
    }

    public List emptyProperties() {
        if (this.m_properties != null) {
            Iterator iter = this.m_properties.iterator();
            while (iter.hasNext()) {
                ((Property)iter.next()).emptyChildren();
            }
            this.m_properties.clear();
        } else {
            this.m_properties = new ArrayList();
        }
        return this.m_properties;
    }

    public Property addProperty(String name, String namespaceURI) {
        if (this.m_properties == null) {
            this.emptyProperties();
        }
        PropertyImpl prop = new PropertyImpl(name);
        prop.setNamespace(null, namespaceURI);
        this.m_properties.add(prop);
        return prop;
    }

    public Property addProperty(String name, String namespaceURI, String value) {
        if (this.m_properties == null) {
            this.emptyProperties();
        }
        PropertyImpl prop = new PropertyImpl(name, namespaceURI);
        prop.setValue(value);
        this.m_properties.add(prop);
        return prop;
    }

    public Property getProperty(String name) {
        Property property = null;
        if (this.m_properties != null) {
            Iterator iter = this.m_properties.iterator();
            while (iter.hasNext()) {
                Property next = (Property)iter.next();
                if (!name.equals(next.getName())) continue;
                property = next;
                break;
            }
        }
        return property;
    }

    public Property getProperty(String name, String namespaceURI) {
        Property property = null;
        if (this.m_properties != null) {
            Iterator iter = this.m_properties.iterator();
            while (iter.hasNext()) {
                Property next = (Property)iter.next();
                if (!name.equals(next.getName()) || !namespaceURI.equals(next.getNamespace())) continue;
                property = next;
                break;
            }
        }
        return property;
    }

    public List getProperties() {
        return this.m_properties;
    }

    public SourceState getSourceState() {
        return this.m_sourceState;
    }

    public void setSourceState(SourceState value) {
        this.m_sourceState = value;
    }

    public String getScVendor() {
        return this.m_scVendor;
    }

    public void setScVendor(String value) {
        this.m_scVendor = value;
    }

    public Map getScAliases() {
        return this.m_scAliases;
    }

    public Map emptyScAliases() {
        if (this.m_scAliases == null) {
            this.m_scAliases = new TreeMap();
        } else {
            this.m_scAliases.clear();
        }
        return this.m_scAliases;
    }

    public void addScAlias(String aliasName, String compartment) {
        if (this.m_scAliases == null) {
            this.m_scAliases = new TreeMap();
        }
        this.m_scAliases.put(aliasName, compartment);
    }

    public String getScName() {
        return this.m_scName;
    }

    public void setScName(String value) {
        this.m_scName = value;
    }

    public Map getBuildVariants() {
        return this.m_buildVariants;
    }

    public Map emptyBuildVariants() {
        if (this.m_buildVariants == null) {
            this.m_buildVariants = new TreeMap();
        } else {
            this.m_buildVariants.clear();
        }
        return this.m_buildVariants;
    }

    public void addBuildVariant(BuildVariant variant) {
        if (this.m_buildVariants == null) {
            this.m_buildVariants = new TreeMap();
        }
        this.m_buildVariants.put(variant.getName(), variant);
    }

    protected void tagValue(char[] chars, int start, int length) {
        switch (this.state) {
            case 11: {
                this.sourceStateChild.tagValue(chars, start, length);
                return;
            }
            case 12: {
                this.buildVariantChild.tagValue(chars, start, length);
                return;
            }
        }
        super.tagValue(chars, start, length);
    }

    protected void startTag(String tagName, Attributes attributes) throws SAXException {
        switch (this.state) {
            case 0: {
                if (tagName.equals(TAG_COMPARTMENT)) {
                    this.state = 4;
                    this.rootTag = tagName;
                    this.m_name = attributes.getValue("name");
                    this.checkMandatoryAttribute(this.m_name, "name", this.rootTag);
                    this.m_scName = attributes.getValue(ATTR_COMP_SCNAME);
                    this.checkMandatoryAttribute(this.m_scName, ATTR_COMP_SCNAME, this.rootTag);
                    this.m_scVendor = attributes.getValue(ATTR_COMP_SCVENDOR);
                    this.checkMandatoryAttribute(this.m_scVendor, ATTR_COMP_SCVENDOR, this.rootTag);
                    this.m_localArchiveFolder = attributes.getValue(ATTR_LOCAL_ARCHIVES);
                    this.m_caption = attributes.getValue(ATTR_COMP_CAPTION);
                    String attrValue = attributes.getValue(ATTR_COMP_DEFAULT);
                    if (attrValue != null) {
                        this.m_defaultCompartment = this.getBooleanValue(attrValue, ATTR_COMP_DEFAULT, this.rootTag);
                    }
                    if ((attrValue = attributes.getValue(ATTR_COMP_ARCHIVE)) != null) {
                        this.m_hasArchiveState = this.getBooleanValue(attrValue, ATTR_COMP_ARCHIVE, this.rootTag);
                    }
                } else {
                    throw new SAXException("internal error in startTag(" + tagName + "). tag expected: <" + TAG_COMPARTMENT + ">");
                }
                return;
            }
            case 4: {
                if (tagName.equals(TAG_COMP_DESCRIP)) {
                    this.state = 4;
                    return;
                }
            }
            case 16: {
                if (tagName.equals(TAG_PROPERTIES)) {
                    this.state = 17;
                    return;
                }
            }
            case 5: {
                if (tagName.equals(TAG_STATE_INFO)) {
                    this.state = 5;
                    return;
                }
            }
            case 10: {
                if (tagName.equals(TAG_SOURCE_STATE)) {
                    this.sourceStateChild = new SourceStateImpl();
                    this.sourceStateChild._setSchemaVersion(this._schemaVersion);
                    this.state = 11;
                    this.sourceStateChild.startTag(tagName, attributes);
                    return;
                }
            }
            case 14: {
                if (tagName.equals(TAG_DEPENDENCIES)) {
                    this.state = 15;
                    return;
                }
            }
            case 6: {
                if (tagName.equals(TAG_SC_ALIASES)) {
                    this.state = 7;
                    return;
                }
            }
            case 8: {
                if (tagName.equals(TAG_BUILD_VARIANTS)) {
                    this.state = 9;
                    return;
                }
                throw new SAXException(this.getMissingTagMessage(TAG_BUILD_VARIANTS, this.rootTag));
            }
            case 9: {
                if (tagName.equals(TAG_BUILD_VARIANT)) {
                    this.buildVariantChild = new BuildVariantImpl();
                    this.buildVariantChild._setSchemaVersion(this._schemaVersion);
                    this.state = 12;
                    this.buildVariantChild.startTag(tagName, attributes);
                    return;
                }
                throw new SAXException("unexpected tag <" + tagName + "> in build variant list ");
            }
            case 15: {
                if (tagName.equals(TAG_USED_COMPARTMENT)) {
                    this.state = 15;
                    return;
                }
                throw new SAXException("unexpected tag <" + tagName + "> in compartment dependencies list ");
            }
            case 7: {
                if (tagName.equals(TAG_SC_ALIAS)) {
                    this.currentScAliasName = attributes.getValue("name");
                    this.checkMandatoryAttributeNotEmpty(this.currentScAliasName, "name", "sc-alias in compartment " + this.m_name);
                    this.currentScAliasCompartment = attributes.getValue(ATTR_ALIAS_COMPARTMENT_REF);
                    this.checkMandatoryAttributeNotEmpty(this.currentScAliasCompartment, ATTR_ALIAS_COMPARTMENT_REF, "sc-alias in compartment " + this.m_name);
                    return;
                }
                throw new SAXException("unexpected tag <" + tagName + "> in sc-aliases list ");
            }
            case 11: {
                this.sourceStateChild.startTag(tagName, attributes);
                return;
            }
            case 12: {
                this.buildVariantChild.startTag(tagName, attributes);
                return;
            }
            case 13: {
                break;
            }
            case 17: {
                if (this.property == null) {
                    this.property = new PropertyImpl(tagName);
                    this.property.setAttributes(this.getAttributes(attributes));
                    return;
                }
                PropertyElement elem = this.property.addChild(tagName);
                elem.setAttributes(this.getAttributes(attributes));
                this.state = 18;
                this.child = this.property.lastChild();
                return;
            }
            case 18: {
                this.child.addChild(tagName);
                this.child = this.child.lastChild();
                return;
            }
            default: {
                throw new SAXException("internal error: illegal state (" + this.state + ") in startTag(" + tagName + ")");
            }
        }
        this.recoverTagName = tagName;
        this.recoverMode = this.state;
        this.state = 1;
    }

    protected boolean endTag(String tagName) throws SAXException {
        switch (this.state) {
            case 1: {
                this.dropTagValue();
                if (!tagName.equals(this.recoverTagName)) {
                    return true;
                }
                this.recoverTagName = null;
                this.state = this.recoverMode;
                return true;
            }
            case 15: {
                if (tagName.equals(TAG_USED_COMPARTMENT)) {
                    String compName = this.getStringValue();
                    if (this.m_usedCompartments == null) {
                        this.m_usedCompartments = new HashSet();
                    }
                    this.m_usedCompartments.add(compName);
                    this.state = 15;
                    return true;
                }
            }
            case 14: {
                if (tagName.equals(TAG_DEPENDENCIES)) {
                    this.state = 6;
                    return true;
                }
                throw new SAXException("internal error: unexpeceted closing tag </" + tagName + ">  in state " + this.state + " (rootTag=" + TAG_COMPARTMENT + ")");
            }
            case 11: {
                if (this.sourceStateChild.endTag(tagName)) {
                    return true;
                }
                this.state = 14;
                this.m_sourceState = this.sourceStateChild;
                this.sourceStateChild = null;
                return true;
            }
            case 12: {
                if (this.buildVariantChild.endTag(tagName)) {
                    return true;
                }
                this.state = 9;
                this.addBuildVariant(this.buildVariantChild);
                this.buildVariantChild = null;
                return true;
            }
            case 4: {
                if (tagName.equals(TAG_COMP_DESCRIP)) {
                    this.m_description = this.getStringValue();
                    this.state = 16;
                    return true;
                }
            }
            case 5: {
                if (tagName.equals(TAG_STATE_INFO)) {
                    this.state = 10;
                    return true;
                }
            }
            case 7: {
                if (tagName.equals(TAG_SC_ALIAS)) {
                    this.addScAlias(this.currentScAliasName, this.currentScAliasCompartment);
                    return true;
                }
                if (tagName.equals(TAG_SC_ALIASES)) {
                    this.state = 8;
                    return true;
                }
            }
            case 6: 
            case 8: 
            case 10: {
                if (tagName.equals(this.rootTag)) {
                    throw new SAXException(this.getMissingTagMessage(TAG_BUILD_VARIANTS, this.rootTag));
                }
            }
            case 9: {
                if (tagName.equals(TAG_BUILD_VARIANTS)) {
                    this.state = 13;
                    return true;
                }
            }
            case 17: {
                if (tagName.equals(TAG_PROPERTIES)) {
                    this.state = 5;
                } else if (tagName.equals(this.property.getQName())) {
                    if (this.property.firstChild() == null) {
                        this.property.setValue(this.getStringValue());
                    }
                    if (this.m_properties == null) {
                        this.emptyProperties();
                    }
                    this.m_properties.add(this.property);
                    this.property = null;
                }
                return true;
            }
            case 18: {
                if (this.child.firstChild() == null) {
                    this.child.setValue(this.getStringValue());
                }
                if (this.child.getParent() != null) {
                    this.child = this.child.getParent();
                } else {
                    if (this.m_properties == null) {
                        this.emptyProperties();
                    }
                    this.m_properties.add(this.property);
                    this.property = null;
                    this.state = 17;
                }
                return true;
            }
            case 13: {
                if (!tagName.equals(this.rootTag)) break;
                return false;
            }
        }
        throw new SAXException("internal error: illegal state (" + this.state + ") in endTag(" + tagName + ")  (rootTag=" + TAG_COMPARTMENT + ")");
    }

    public void serialize(XMLWriter writer) throws ValidationException {
        if (!this._isSchemaAllowed()) {
            throw new InvalidFileFormatException("Cannot serialize compartment with format version " + this._schemaVersion + " since this compartment uses" + " features from API version " + this._apiVersion);
        }
        this.serialize(writer, this._schemaVersion);
    }

    public void serialize(XMLWriter writer, String schemaVersion) throws ValidationException {
        int attributeTotalCount = 6;
        if (this.m_localArchiveFolder != null) {
            ++attributeTotalCount;
        }
        Attribute[] attribs = new Attribute[attributeTotalCount];
        int attributeCount = 0;
        attribs[attributeCount++] = new Attribute("name", this.m_name);
        attribs[attributeCount++] = new Attribute(ATTR_COMP_CAPTION, this.m_caption);
        attribs[attributeCount++] = new Attribute(ATTR_COMP_ARCHIVE, this.m_hasArchiveState ? "yes" : "no");
        attribs[attributeCount++] = new Attribute(ATTR_COMP_DEFAULT, this.m_defaultCompartment ? "yes" : "no");
        attribs[attributeCount++] = new Attribute(ATTR_COMP_SCVENDOR, this.m_scVendor);
        attribs[attributeCount++] = new Attribute(ATTR_COMP_SCNAME, this.m_scName);
        if (this.m_localArchiveFolder != null) {
            attribs[attributeCount++] = new Attribute(ATTR_LOCAL_ARCHIVES, this.m_localArchiveFolder);
        }
        writer.beginTag(TAG_COMPARTMENT, attribs);
        if (this.m_description != null) {
            writer.writeTag(TAG_COMP_DESCRIP, this.m_description);
        }
        if (this.m_properties != null && this.m_properties.size() > 0 && this.doSerialize(schemaVersion, "0.3")) {
            writer.beginTag(TAG_PROPERTIES);
            int i = 0;
            while (i < this.m_properties.size()) {
                Property prop = (Property)this.m_properties.get(i);
                String namespace = prop.getNamespace();
                String prefix = prop.getNamespacePrefix();
                if (namespace != null && prefix == null) {
                    prefix = "pns" + Integer.toString(i);
                    prop.setNamespace(prefix, namespace);
                }
                prop.serialize(writer);
                ++i;
            }
            writer.endTag(TAG_PROPERTIES);
        }
        if (this.m_sourceState != null) {
            this.m_sourceState.serialize(writer);
        }
        if (this.m_usedCompartments != null && this.m_usedCompartments.size() > 0) {
            writer.beginTag(TAG_DEPENDENCIES);
            Iterator it = this.m_usedCompartments.iterator();
            while (it.hasNext()) {
                String usedCompartmentName = (String)it.next();
                writer.writeTag(TAG_USED_COMPARTMENT, usedCompartmentName);
            }
            writer.endTag(TAG_DEPENDENCIES);
        }
        if (this.m_scAliases != null && this.m_scAliases.size() != 0) {
            writer.beginTag(TAG_SC_ALIASES);
            Set aliasNames = this.m_scAliases.keySet();
            Attribute[] aliasAttribs = new Attribute[]{new Attribute("name", ""), new Attribute(ATTR_ALIAS_COMPARTMENT_REF, "")};
            Iterator aliasIterator = aliasNames.iterator();
            while (aliasIterator.hasNext()) {
                String aliasName = (String)aliasIterator.next();
                String targetCompartment = (String)this.m_scAliases.get(aliasName);
                aliasAttribs[0].value = aliasName;
                aliasAttribs[1].value = targetCompartment;
                writer.writeEmptyTag(TAG_SC_ALIAS, aliasAttribs);
            }
            writer.endTag(TAG_SC_ALIASES);
        }
        writer.beginTag(TAG_BUILD_VARIANTS);
        if (this.m_buildVariants != null) {
            Iterator variantIterator = this.m_buildVariants.values().iterator();
            while (variantIterator.hasNext()) {
                BuildVariant variant = (BuildVariant)variantIterator.next();
                boolean isBuildable = this.m_sourceState != null;
                variant.serialize(writer, schemaVersion, isBuildable);
            }
        }
        writer.endTag(TAG_BUILD_VARIANTS);
        writer.endTag(TAG_COMPARTMENT);
    }

    public void validate() throws ValidationException {
        this.checkPropertyNotEmptyOrNull(this.m_name, "name", "Compartment" + this);
        NameChecker.checkCompartmentName(this.m_name);
        this.checkPropertyNotEmptyOrNull(this.m_scVendor, "scVendor", "Compartment" + this.m_name);
        NameChecker.checkVendorName(this.m_scVendor);
        this.checkPropertyNotEmptyOrNull(this.m_scName, "scName", "Compartment" + this.m_name);
        NameChecker.checkSoftwareComponentName(this.m_scName);
        this.checkPropertyNotEmptyOrNull(this.m_buildVariants, "buildVariants", "Compartment" + this.m_name);
        if (this.m_sourceState == null) {
            if (!this.m_hasArchiveState && this.m_localArchiveFolder == null) {
                throw new CompartmentEmptyException(this.m_name);
            }
        } else {
            if (!this.m_defaultCompartment) {
                throw new ValidationException("A non-default compartment must not have a source state. ( compartment: \"" + this.m_name + "\")");
            }
            if (this.m_localArchiveFolder != null) {
                throw new CompartmentLocalAndRemoteException(this.m_name);
            }
            this.m_sourceState.validate();
        }
        Iterator it = this.m_buildVariants.values().iterator();
        boolean atLeastOneIsRequired = false;
        while (it.hasNext()) {
            BuildVariant v = (BuildVariant)it.next();
            v.validate();
            atLeastOneIsRequired |= v.getIsRequired();
        }
        if (!atLeastOneIsRequired && this.isActivationAllowed()) {
            throw new ValidationException("There must be at lesat one compartmnet required for activation. ( compartment: \"" + this.m_name + "\")");
        }
    }

    public boolean hasInactiveSourceState() {
        return this.m_sourceState != null && this.m_sourceState.getType() == 0;
    }

    public boolean hasSourceState() {
        return this.m_sourceState != null;
    }

    public boolean isModificationAllowed() {
        if (this.m_sourceState == null) {
            return false;
        }
        return this.m_sourceState.isChangeable();
    }

    public String getSCAlias(String targetCompartment) {
        String alias = null;
        if (this.m_scAliases != null && !this.m_scAliases.isEmpty()) {
            Iterator iterMapEntries = this.m_scAliases.entrySet().iterator();
            while (iterMapEntries.hasNext()) {
                Map.Entry entry = iterMapEntries.next();
                if (!targetCompartment.equals((String)entry.getValue())) continue;
                alias = (String)entry.getKey();
                break;
            }
        }
        return alias;
    }

    public Set getUsedCompartments() {
        return this.m_usedCompartments;
    }

    public boolean hasLocalArchivesOnly() {
        return this.m_localArchiveFolder != null;
    }

    public String getLocalArchiveFolder() {
        return this.m_localArchiveFolder;
    }

    public void setLocalArchiveFolder(String localArchiveFolder) {
        this.m_localArchiveFolder = localArchiveFolder;
    }

    public void setUsedCompartments(Set usedCompartments) {
        this.m_usedCompartments = usedCompartments;
    }

    void initializeUsedCompartmentsFromVariantMappings() {
        if (this.m_usedCompartments == null) {
            BuildVariant v;
            Map vmap;
            Iterator it;
            Set list = null;
            if (this.hasSourceState() && this.m_buildVariants != null && (it = this.m_buildVariants.values().iterator()).hasNext() && (vmap = (v = (BuildVariant)it.next()).getVariantMapping()) != null) {
                list = vmap.keySet();
            }
            this.m_usedCompartments = list;
        }
    }

    public boolean isLocal() {
        return this.hasLocalArchivesOnly() || this.hasLocalSourceStateOnly();
    }

    public void addUsedCompartment(String usedCompartmentName) {
        if (this.m_usedCompartments == null) {
            this.m_usedCompartments = new TreeSet();
        }
        this.m_usedCompartments.add(usedCompartmentName);
    }

    public Set emptyUsedCompartments() {
        if (this.m_usedCompartments == null) {
            this.m_usedCompartments = new TreeSet();
        } else {
            this.m_usedCompartments.clear();
        }
        return this.m_usedCompartments;
    }

    public void removeUsedCompartment(String usedCompartmentName) {
        if (this.m_usedCompartments == null) {
            return;
        }
        this.m_usedCompartments.remove(usedCompartmentName);
    }

    public boolean hasLocalSourceStateOnly() {
        return this.hasSourceState() && this.m_sourceState.isLocal();
    }

    public boolean isActivationAllowed() {
        return this.m_sourceState != null && this.m_sourceState.getType() == 0;
    }
}

