/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.complib.impl;

import com.sap.tc.complib.BuildVariant;
import com.sap.tc.complib.namecheck.NameChecker;
import com.sap.tc.complib.validate.InvalidFileFormatException;
import com.sap.tc.complib.validate.ValidationException;
import com.sap.tc.complib.xml.Attribute;
import com.sap.tc.complib.xml.Initializable;
import com.sap.tc.complib.xml.XMLWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BuildVariantImpl
extends Initializable
implements BuildVariant {
    private String name;
    private boolean isRequired = false;
    private TreeMap buildOptions;
    private TreeMap variantMapping;
    private static final String TAG_BUILD_VARIANT = "build-variant";
    private static final String TAG_BUILD_OPTIONS = "build-options";
    private static final String TAG_VARIANT_MAPPINGS = "variant-mappings";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_VARIANT_REQUIRED = "required-for-activation";
    private static final String TAG_VARIANT_MAPPING = "variant-mapping";
    private static final String ATTR_VARIANT_MAPPING_COMPARTMENT = "used-compartment";
    private static final String ATTR_VARIANT_MAPPING_VARIANT = "used-variant-name";
    private static final String TAG_BUILD_OPTION = "build-option";
    private static final String ATTR_BUILD_OPTION_NAME = "name";
    private static final String TAG_BUILD_OPTION_VALUE = "option-value";
    private static final int STATE_BUILD_VARIANT_FINAL = 3;
    private static final int STATE_BUILD_OPTIONS = 4;
    private static final int STATE_BUILD_OPTION = 5;
    private static final int STATE_BUILD_OPTION_VALUE = 6;
    private static final int STATE_MAPPINGS = 7;
    private static final int STATE_MAPPING = 8;
    private String rootTag;
    private String currentOptionName;
    private List currentOptionValues;
    private String currentMappingVariant;
    private String currentMappingCompartment;

    public BuildVariantImpl() {
        this._schemaVersion = "0.3";
        this._apiVersion = "0.2";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public boolean getIsRequired() {
        return this.isRequired;
    }

    public void setIsRequired(boolean value) {
        this.isRequired = value;
    }

    public List getBuildOptionNames() {
        LinkedList nameList = null;
        if (this.buildOptions != null) {
            nameList = new LinkedList(this.buildOptions.keySet());
        }
        return nameList;
    }

    public Map emptyBuildOptions() {
        if (this.buildOptions == null) {
            this.buildOptions = new TreeMap();
        } else {
            this.buildOptions.clear();
        }
        return this.buildOptions;
    }

    public void putBuildOption(String optionName, List values) {
        if (this.buildOptions == null) {
            this.buildOptions = new TreeMap();
        }
        this.buildOptions.put(optionName, new LinkedList(values));
    }

    public void putBuildOption(String optionName, String value) {
        LinkedList<String> list = new LinkedList<String>();
        list.add(value);
        this.putBuildOption(optionName, list);
    }

    public Map getVariantMapping() {
        return this.variantMapping;
    }

    public Map emptyVariantMapping() {
        if (this.variantMapping == null) {
            this.variantMapping = new TreeMap();
        } else {
            this.variantMapping.clear();
        }
        return this.variantMapping;
    }

    public List getBuildOptionValues(String optionName) {
        LinkedList values = null;
        if (this.buildOptions != null && this.buildOptions.containsKey(optionName) && (values = (LinkedList)this.buildOptions.get(optionName)) == null) {
            values = new LinkedList();
            this.buildOptions.put(optionName, values);
        }
        if (values == null) {
            throw new IllegalArgumentException("Build option " + optionName + "does not exist in build variant " + this.name);
        }
        return values;
    }

    public void removeBuildOption(String optionName) {
        if (this.buildOptions != null) {
            this.buildOptions.remove(optionName);
        }
    }

    protected void tagValue(char[] chars, int start, int length) {
        super.tagValue(chars, start, length);
    }

    protected void startTag(String tagName, Attributes attributes) throws SAXException {
        switch (this.state) {
            case 0: {
                if (tagName.equals(TAG_BUILD_VARIANT)) {
                    this.state = 4;
                    this.rootTag = tagName;
                    this.name = attributes.getValue("name");
                    this.checkMandatoryAttribute(this.name, "name", this.rootTag);
                    String attrValue = attributes.getValue(ATTR_VARIANT_REQUIRED);
                    if (attrValue != null) {
                        this.isRequired = this.getBooleanValue(attrValue, ATTR_VARIANT_REQUIRED, this.rootTag);
                    }
                } else {
                    throw new SAXException("internal error in startTag(" + tagName + ") tag expected <" + TAG_BUILD_VARIANT + ">");
                }
                return;
            }
            case 5: {
                if (!tagName.equals(TAG_BUILD_OPTION)) break;
                this.currentOptionName = attributes.getValue("name");
                this.checkMandatoryAttribute(this.currentOptionName, "name", TAG_BUILD_OPTION);
                this.state = 6;
                this.currentOptionValues = new LinkedList();
                return;
            }
            case 6: {
                if (!tagName.equals(TAG_BUILD_OPTION_VALUE)) break;
                this.state = 6;
                return;
            }
            case 8: {
                if (!tagName.equals(TAG_VARIANT_MAPPING)) break;
                this.currentMappingVariant = attributes.getValue(ATTR_VARIANT_MAPPING_VARIANT);
                this.checkMandatoryAttribute(this.currentMappingVariant, ATTR_VARIANT_MAPPING_VARIANT, TAG_VARIANT_MAPPING);
                this.currentMappingCompartment = attributes.getValue(ATTR_VARIANT_MAPPING_COMPARTMENT);
                this.checkMandatoryAttribute(this.currentMappingCompartment, ATTR_VARIANT_MAPPING_COMPARTMENT, TAG_VARIANT_MAPPING);
                this.state = 8;
                return;
            }
            case 4: {
                if (tagName.equals(TAG_BUILD_OPTIONS)) {
                    this.state = 5;
                    this.buildOptions = new TreeMap();
                    return;
                }
            }
            case 7: {
                if (!tagName.equals(TAG_VARIANT_MAPPINGS)) break;
                this.state = 8;
                this.emptyVariantMapping();
                return;
            }
            case 3: {
                break;
            }
            default: {
                throw new SAXException("internal error: illegal state (" + this.state + ") in startTag(" + tagName + ")");
            }
        }
        this.recoverTagName = tagName;
        this.recoverMode = this.state;
        this.state = 1;
    }

    protected boolean endTag(String tagName) throws SAXException {
        switch (this.state) {
            case 1: {
                this.dropTagValue();
                if (!tagName.equals(this.recoverTagName)) {
                    return true;
                }
                this.recoverTagName = null;
                this.state = this.recoverMode;
                return true;
            }
            case 6: {
                if (tagName.equals(TAG_BUILD_OPTION_VALUE)) {
                    String optionValue = this.getStringValue();
                    this.currentOptionValues.add(optionValue);
                    this.state = 6;
                    return true;
                }
            }
            case 5: {
                if (tagName.equals(TAG_BUILD_OPTION)) {
                    this.state = 5;
                    this.buildOptions.put(this.currentOptionName, this.currentOptionValues);
                    this.currentOptionValues = null;
                    this.currentOptionName = null;
                    return true;
                }
            }
            case 4: {
                if (tagName.equals(TAG_BUILD_OPTIONS)) {
                    this.state = 7;
                    return true;
                }
            }
            case 8: {
                if (tagName.equals(TAG_VARIANT_MAPPING)) {
                    this.variantMapping.put(this.currentMappingCompartment, this.currentMappingVariant);
                    this.currentMappingCompartment = null;
                    this.currentMappingVariant = null;
                    this.state = 8;
                    return true;
                }
            }
            case 7: {
                if (tagName.equals(TAG_VARIANT_MAPPINGS)) {
                    this.state = 3;
                    return true;
                }
            }
            case 3: {
                if (tagName.equals(this.rootTag)) {
                    return false;
                }
                throw new SAXException("unexpected endTag(" + tagName + ") found when waiting for </" + this.rootTag + ">");
            }
        }
        throw new SAXException("internal error: illegal state (" + this.state + ") in endTag(" + tagName + ")");
    }

    public void serialize(XMLWriter writer, boolean IsBuildable) throws ValidationException {
        if (!this._isSchemaAllowed()) {
            throw new InvalidFileFormatException("Cannot serialize build variant with format version " + this._schemaVersion + " since build variant uses" + " features from API version " + this._apiVersion);
        }
        this.serialize(writer, this._schemaVersion, IsBuildable);
    }

    public void serialize(XMLWriter writer, String schemaVersion, boolean IsBuildable) throws ValidationException {
        Attribute[] attribs = IsBuildable ? new Attribute[]{new Attribute("name", this.name), new Attribute(ATTR_VARIANT_REQUIRED, this.isRequired ? "yes" : "no")} : new Attribute[]{new Attribute("name", this.name)};
        writer.beginTag(TAG_BUILD_VARIANT, attribs);
        if (this.buildOptions != null) {
            writer.beginTag(TAG_BUILD_OPTIONS);
            Set optionNames = this.buildOptions.keySet();
            Iterator optionIterator = optionNames.iterator();
            Attribute[] optionAttribs = new Attribute[]{new Attribute("name", null)};
            while (optionIterator.hasNext()) {
                String buildOptionName;
                optionAttribs[0].value = buildOptionName = (String)optionIterator.next();
                writer.beginTag(TAG_BUILD_OPTION, optionAttribs);
                List optionValues = (List)this.buildOptions.get(buildOptionName);
                if (optionValues != null) {
                    Iterator valueIterator = optionValues.iterator();
                    while (valueIterator.hasNext()) {
                        String valueString = (String)valueIterator.next();
                        writer.writeTag(TAG_BUILD_OPTION_VALUE, valueString);
                    }
                }
                writer.endTag(TAG_BUILD_OPTION);
            }
            writer.endTag(TAG_BUILD_OPTIONS);
        }
        if (this.variantMapping != null && this.variantMapping.size() > 0) {
            writer.beginTag(TAG_VARIANT_MAPPINGS);
            Set targetCompartmentNames = this.variantMapping.keySet();
            Iterator targetCompartmentNameIterator = targetCompartmentNames.iterator();
            Attribute[] mappingAttribs = new Attribute[]{new Attribute(ATTR_VARIANT_MAPPING_COMPARTMENT, null), new Attribute(ATTR_VARIANT_MAPPING_VARIANT, null)};
            while (targetCompartmentNameIterator.hasNext()) {
                String targetCompartmentName = (String)targetCompartmentNameIterator.next();
                String targetVariantName = (String)this.variantMapping.get(targetCompartmentName);
                mappingAttribs[0].value = targetCompartmentName;
                mappingAttribs[1].value = targetVariantName;
                writer.writeEmptyTag(TAG_VARIANT_MAPPING, mappingAttribs);
            }
            writer.endTag(TAG_VARIANT_MAPPINGS);
        }
        writer.endTag(TAG_BUILD_VARIANT);
    }

    public void validate() throws ValidationException {
        this.checkPropertyNotEmptyOrNull(this.name, "name", "BuildVariant");
        NameChecker.checkBuildVariantName(this.name);
        if (this.buildOptions != null) {
            Iterator iterOptions = this.buildOptions.keySet().iterator();
            while (iterOptions.hasNext()) {
                String option = (String)iterOptions.next();
                this.checkPropertyNotEmptyOrNull(option, "name", "is missing or empty in a build option of BuildVariant " + this.name + ")");
            }
        }
    }
}

