/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.complib.cmpconf;

import com.sap.tc.complib.PropertyElement;
import com.sap.tc.complib.cmpconf.AbstractEntityDelta;
import com.sap.tc.complib.cmpconf.ChangeType;
import com.sap.tc.complib.cmpconf.IPropertyDelta;
import com.sap.tc.complib.cmpconf.InternalConfigComparisonException;
import com.sap.tc.logging.Location;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class PropertyDelta
extends AbstractEntityDelta
implements IPropertyDelta {
    static final Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$complib$cmpconf$PropertyDelta == null ? (class$com$sap$tc$complib$cmpconf$PropertyDelta = PropertyDelta.class$("com.sap.tc.complib.cmpconf.PropertyDelta")) : class$com$sap$tc$complib$cmpconf$PropertyDelta));
    private static final String ELEMENT_TYPE_PROPERTY = "generic property";
    private final PropertyElement m_oldProperty;
    private final PropertyElement m_newProperty;
    static /* synthetic */ Class class$com$sap$tc$complib$cmpconf$PropertyDelta;

    public PropertyDelta(ChangeType changeType, AbstractEntityDelta parent, PropertyElement oldProperty, PropertyElement newProperty) throws InternalConfigComparisonException {
        super(changeType, parent);
        this.m_newProperty = newProperty;
        this.m_oldProperty = oldProperty;
        if (oldProperty == null && newProperty == null) {
            LOCATION.debugT("constructor", "Internal error. Illegal arguments for contructing configuration element delta. Old and new value must not null at the same time. for element " + this);
            throw new InternalConfigComparisonException("Internal error. Illegal arguments for contructing configuration element delta. Old and new value must not null at the same time.", this);
        }
        if (!(oldProperty == null || newProperty == null || oldProperty.getName().equals(newProperty.getName()) && oldProperty.getNamespace().equals(newProperty.getNamespace()))) {
            String msg = "Internal error. Illegal arguments for contructing configuration element delta. Old and new value are for different entities. : " + oldProperty.getQName() + " | " + newProperty.getQName();
            LOCATION.debugT("constructor", msg + " " + this);
            throw new InternalConfigComparisonException(msg, this);
        }
        PropertyElement prop = oldProperty == null ? newProperty : oldProperty;
        String ns = prop.getNamespace();
        if (ns != null && ns.length() > 0) {
            this.setName(prop.getName() + "(" + ns + ")");
        } else {
            this.setName(prop.getName());
        }
    }

    public PropertyElement getOldProperty() {
        return this.m_oldProperty;
    }

    public PropertyElement getNewProperty() {
        return this.m_newProperty;
    }

    public String getTypeName() {
        return ELEMENT_TYPE_PROPERTY;
    }

    List getOldProperties() {
        LinkedList childrenList = new LinkedList();
        if (this.getOldProperty() != null) {
            Iterator iter = this.getOldProperty().getChildren();
            while (iter.hasNext()) {
                childrenList.add(iter.next());
            }
        }
        return childrenList;
    }

    List getNewProperties() {
        LinkedList childrenList = new LinkedList();
        if (this.getNewProperty() != null) {
            Iterator iter = this.getNewProperty().getChildren();
            while (iter.hasNext()) {
                childrenList.add(iter.next());
            }
        }
        return childrenList;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

