/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.complib.cmpconf;

import com.sap.tc.complib.PropertyElement;
import com.sap.tc.complib.cmpconf.AbstractEntityDelta;
import com.sap.tc.complib.cmpconf.AttributeID;
import com.sap.tc.complib.cmpconf.ChangeType;
import com.sap.tc.complib.cmpconf.ConfigurationComparisonException;
import com.sap.tc.complib.cmpconf.EntityComparatorBase;
import com.sap.tc.complib.cmpconf.PropertyDelta;
import com.sap.tc.complib.xml.Attribute;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class PropertyComparator
extends EntityComparatorBase {
    private static final String ATTRIBUTE_NAME_PREFIX = "namespace prefix";
    private static final String ATTRIBUTE_NAME_VALUE = "value";

    PropertyComparator() {
    }

    protected boolean findPropertyDelta(AbstractEntityDelta parentDelta, PropertyElement oldProperty, PropertyElement newProperty) throws ConfigurationComparisonException {
        PropertyDelta delta = new PropertyDelta(ChangeType.MODIFIED, parentDelta, oldProperty, newProperty);
        boolean isSomethingChanged = false;
        Attribute[] oldAttrs = oldProperty.getAttributes();
        Attribute[] newAttrs = newProperty.getAttributes();
        if (oldAttrs == null) {
            oldAttrs = new Attribute[]{};
        }
        if (newAttrs == null) {
            newAttrs = new Attribute[]{};
        }
        HashMap<String, PairOldNew> attrMap = new HashMap<String, PairOldNew>();
        int i = 0;
        while (i < newAttrs.length) {
            Attribute attribute = newAttrs[i];
            PairOldNew pair = (PairOldNew)attrMap.get(attribute.name);
            if (pair == null) {
                pair = new PairOldNew();
                attrMap.put(attribute.name, pair);
            }
            pair.newValue = attribute.value;
            ++i;
        }
        int i2 = 0;
        while (i2 < oldAttrs.length) {
            Attribute attribute = oldAttrs[i2];
            PairOldNew pair = (PairOldNew)attrMap.get(attribute.name);
            if (pair == null) {
                pair = new PairOldNew();
                attrMap.put(attribute.name, pair);
            }
            pair.oldValue = attribute.value;
            ++i2;
        }
        Iterator iter = attrMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String attrName = (String)entry.getKey();
            PairOldNew values = (PairOldNew)entry.getValue();
            isSomethingChanged |= this.findAttributeDelta(attrName, AttributeID.PROPERTY_GENERIC_ATTRIBUTE, values.oldValue, values.newValue, (AbstractEntityDelta)delta);
        }
        isSomethingChanged |= this.findAttributeDelta(ATTRIBUTE_NAME_PREFIX, AttributeID.PROPERTY_NAMSEPACE_PREFIX, oldProperty.getNamespacePrefix(), newProperty.getNamespacePrefix(), (AbstractEntityDelta)delta);
        isSomethingChanged |= this.findAttributeDelta(ATTRIBUTE_NAME_VALUE, AttributeID.PROPERTY_VALUE, oldProperty.getValue(), newProperty.getValue(), (AbstractEntityDelta)delta);
        if (isSomethingChanged |= this.findPropertyDeltas(delta)) {
            parentDelta.addPropertyDelta(delta);
        }
        return isSomethingChanged;
    }

    static class PairOldNew {
        String oldValue = null;
        String newValue = null;

        PairOldNew() {
        }
    }
}

