/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.complib.cmpconf;

import com.sap.tc.complib.PropertyElement;
import com.sap.tc.complib.cmpconf.AbstractAttributeDelta;
import com.sap.tc.complib.cmpconf.AbstractEntityDelta;
import com.sap.tc.complib.cmpconf.AttributeID;
import com.sap.tc.complib.cmpconf.BooleanAttributeDelta;
import com.sap.tc.complib.cmpconf.ChangeType;
import com.sap.tc.complib.cmpconf.ConfigurationComparisonException;
import com.sap.tc.complib.cmpconf.IntegerAttributeDelta;
import com.sap.tc.complib.cmpconf.InternalConfigComparisonException;
import com.sap.tc.complib.cmpconf.PropertyComparator;
import com.sap.tc.complib.cmpconf.PropertyDelta;
import com.sap.tc.complib.cmpconf.StringAttributeDelta;
import com.sap.tc.logging.Location;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

class EntityComparatorBase {
    protected static final int SET_DIFFERENCE_1 = 0;
    protected static final int SET_DIFFERENCE_2 = 1;
    protected static final int SET_INTERSECT = 2;
    static final Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$complib$cmpconf$EntityComparatorBase == null ? (class$com$sap$tc$complib$cmpconf$EntityComparatorBase = EntityComparatorBase.class$("com.sap.tc.complib.cmpconf.EntityComparatorBase")) : class$com$sap$tc$complib$cmpconf$EntityComparatorBase));
    private static final int BOOLEAN = 0;
    private static final int STRING = 1;
    private static final int INTEGER = 2;
    private PropertyComparator m_propertyComparator;
    static /* synthetic */ Class class$com$sap$tc$complib$cmpconf$EntityComparatorBase;

    EntityComparatorBase() {
    }

    ChangeType determineChangeType(Object oldObj, Object newObj) {
        Object type = oldObj == null ? (newObj != null ? ChangeType.ADDED : null) : (newObj == null ? ChangeType.DELETED : (oldObj.equals(newObj) ? null : ChangeType.MODIFIED));
        return type;
    }

    protected boolean findAttributeDelta(String attributeName, AttributeID attributeID, String oldValue, String newValue, AbstractEntityDelta entityDelta) throws InternalConfigComparisonException {
        return this.findAttributeDelta(attributeName, attributeID, 1, oldValue, newValue, entityDelta);
    }

    protected boolean findAttributeDelta(AttributeID attributeID, String oldValue, String newValue, AbstractEntityDelta entityDelta) throws InternalConfigComparisonException {
        return this.findAttributeDelta(attributeID.toString(), attributeID, 1, oldValue, newValue, entityDelta);
    }

    protected boolean findAttributeDelta(AttributeID attributeID, Boolean oldValue, Boolean newValue, AbstractEntityDelta entityDelta) throws InternalConfigComparisonException {
        return this.findAttributeDelta(attributeID.toString(), attributeID, 0, oldValue, newValue, entityDelta);
    }

    protected boolean findAttributeDelta(String attributeName, AttributeID attributeID, Boolean oldValue, Boolean newValue, AbstractEntityDelta entityDelta) throws InternalConfigComparisonException {
        return this.findAttributeDelta(attributeName, attributeID, 0, oldValue, newValue, entityDelta);
    }

    protected boolean findAttributeDelta(AttributeID attributeID, Integer oldValue, Integer newValue, AbstractEntityDelta entityDelta) throws InternalConfigComparisonException {
        return this.findAttributeDelta(attributeID.toString(), attributeID, 2, oldValue, newValue, entityDelta);
    }

    private boolean findAttributeDelta(String attributeName, AttributeID attributeID, int valueType, Object oldValue, Object newValue, AbstractEntityDelta entityDelta) throws InternalConfigComparisonException {
        String methodString = "findAttributeDelta";
        boolean changed = false;
        ChangeType kindOfChange = this.determineChangeType(oldValue, newValue);
        if (kindOfChange != null) {
            AbstractAttributeDelta attrDelta;
            if (valueType == 1) {
                attrDelta = new StringAttributeDelta(kindOfChange, entityDelta, attributeID, attributeName, (String)oldValue, (String)newValue);
            } else if (valueType == 0) {
                attrDelta = new BooleanAttributeDelta(kindOfChange, entityDelta, attributeID, attributeName, (Boolean)oldValue, (Boolean)newValue);
            } else if (valueType == 2) {
                attrDelta = new IntegerAttributeDelta(kindOfChange, entityDelta, attributeID, attributeName, (Integer)oldValue, (Integer)newValue);
            } else {
                String msg = "Internal Error: Unknown attribute value type.";
                LOCATION.infoT(methodString, msg);
                throw new IllegalStateException(msg);
            }
            entityDelta.addAttributeDelta(attrDelta);
            changed = true;
        }
        return changed;
    }

    protected Set[] getChangeSets(Set set1, Set set2) {
        HashSet set1minusSet2;
        HashSet set2minusSet1;
        HashSet intersection;
        if (set1 == null) {
            if (set2 == null) {
                intersection = new HashSet();
                set2minusSet1 = new HashSet();
                set1minusSet2 = new HashSet();
            } else {
                intersection = new HashSet();
                set2minusSet1 = new HashSet(set2);
                set1minusSet2 = new HashSet();
            }
        } else if (set2 == null) {
            intersection = new HashSet();
            set2minusSet1 = new HashSet();
            set1minusSet2 = new HashSet(set1);
        } else {
            intersection = new HashSet(set2);
            intersection.retainAll(set1);
            set2minusSet1 = new HashSet(set2);
            set2minusSet1.removeAll(set1);
            set1minusSet2 = new HashSet(set1);
            set1minusSet2.removeAll(set2);
        }
        Set[] result = new Set[3];
        result[1] = set2minusSet1;
        result[0] = set1minusSet2;
        result[2] = intersection;
        return result;
    }

    protected boolean areEqualAsSets(Collection col1, Collection col2) {
        if (col1 == col2) {
            return true;
        }
        if (col1 == null) {
            return false;
        }
        if (col2 == null) {
            return false;
        }
        if (col1.size() != col2.size()) {
            return false;
        }
        HashSet oldSet = new HashSet(col1);
        HashSet newSet = new HashSet(col2);
        oldSet.retainAll(newSet);
        return oldSet.size() == newSet.size();
    }

    protected boolean findPropertyDeltas(AbstractEntityDelta delta) throws ConfigurationComparisonException {
        Iterator iter;
        LinkedList addedProperties;
        List beforeProperties = delta.getOldProperties();
        List afterProperties = delta.getNewProperties();
        LinkedList linkedList = addedProperties = afterProperties == null ? new LinkedList() : new LinkedList(afterProperties);
        if (beforeProperties == null || beforeProperties.size() == 0) {
            if (afterProperties == null || afterProperties.size() == 0) {
                return false;
            }
            iter = afterProperties.iterator();
            while (iter.hasNext()) {
                delta.addPropertyDelta(new PropertyDelta(ChangeType.ADDED, delta, null, (PropertyElement)iter.next()));
            }
        } else if (afterProperties == null || afterProperties.size() == 0) {
            iter = beforeProperties.iterator();
            while (iter.hasNext()) {
                delta.addPropertyDelta(new PropertyDelta(ChangeType.DELETED, delta, (PropertyElement)iter.next(), null));
            }
        }
        delta.resetPropertyDeltas();
        iter = beforeProperties.iterator();
        while (iter.hasNext()) {
            PropertyElement propertyBeforeChange = (PropertyElement)iter.next();
            boolean found = false;
            Iterator afterIterator = afterProperties.iterator();
            while (afterIterator.hasNext()) {
                PropertyElement propertyAfterChange = (PropertyElement)afterIterator.next();
                if (!propertyAfterChange.getName().equals(propertyBeforeChange.getName()) || (propertyBeforeChange.getNamespace() != null || propertyAfterChange.getNamespace() != null) && (propertyBeforeChange.getNamespace() == null || !propertyBeforeChange.getNamespace().equals(propertyAfterChange.getNamespace()))) continue;
                found = true;
                addedProperties.remove(propertyAfterChange);
                this.getPropertyComparator().findPropertyDelta(delta, propertyBeforeChange, propertyAfterChange);
                break;
            }
            if (found) continue;
            delta.addPropertyDelta(new PropertyDelta(ChangeType.DELETED, delta, propertyBeforeChange, null));
        }
        Iterator iter2 = addedProperties.iterator();
        while (iter2.hasNext()) {
            PropertyElement prop = (PropertyElement)iter2.next();
            delta.addPropertyDelta(new PropertyDelta(ChangeType.ADDED, delta, null, prop));
        }
        return delta.countPropertyDeltas() > 0;
    }

    PropertyComparator getPropertyComparator() {
        if (this.m_propertyComparator == null) {
            this.m_propertyComparator = new PropertyComparator();
        }
        return this.m_propertyComparator;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

