/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.complib.cmpconf;

import com.sap.tc.complib.DevelopmentConfiguration;
import com.sap.tc.complib.cmpconf.AbstractEntityDelta;
import com.sap.tc.complib.cmpconf.ChangeType;
import com.sap.tc.complib.cmpconf.ICompartmentDelta;
import com.sap.tc.complib.cmpconf.IConfigurationDelta;
import com.sap.tc.complib.cmpconf.InternalConfigComparisonException;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

class ConfigurationDelta
extends AbstractEntityDelta
implements IConfigurationDelta {
    static final Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$complib$cmpconf$ConfigurationDelta == null ? (class$com$sap$tc$complib$cmpconf$ConfigurationDelta = ConfigurationDelta.class$("com.sap.tc.complib.cmpconf.ConfigurationDelta")) : class$com$sap$tc$complib$cmpconf$ConfigurationDelta));
    private static final String ELEMENT_TYPE_CONFIGURATION = "development configuration";
    private final DevelopmentConfiguration m_oldConfig;
    private final DevelopmentConfiguration m_newConfig;
    private Collection m_compartmentDeltas = new ArrayList();
    static /* synthetic */ Class class$com$sap$tc$complib$cmpconf$ConfigurationDelta;

    public ConfigurationDelta(ChangeType changeType, DevelopmentConfiguration oldConfig, DevelopmentConfiguration newConfig) throws InternalConfigComparisonException {
        super(changeType, null);
        this.setName(newConfig.getName());
        this.m_oldConfig = oldConfig;
        this.m_newConfig = newConfig;
        if (changeType != ChangeType.MODIFIED) {
            LOCATION.debugT("constructor", "Internal error. Illegal arguments for contructing configuration element delta. Change type makes no sense for this element. for element " + this);
            throw new InternalConfigComparisonException("Internal error. Illegal arguments for contructing configuration element delta. Change type makes no sense for this element.", this);
        }
    }

    public DevelopmentConfiguration getOldConfiguration() {
        return this.m_oldConfig;
    }

    public DevelopmentConfiguration getNewConfiguration() {
        return this.m_newConfig;
    }

    public ICompartmentDelta[] getCompartmentDeltas() {
        return this.m_compartmentDeltas.toArray(new ICompartmentDelta[this.m_compartmentDeltas.size()]);
    }

    public void resetCompartmentDeltas() {
        this.m_compartmentDeltas = new ArrayList();
    }

    public void addCompartmentDelta(ICompartmentDelta delta) {
        this.m_compartmentDeltas.add(delta);
    }

    public String getTypeName() {
        return ELEMENT_TYPE_CONFIGURATION;
    }

    List getOldProperties() {
        return this.getOldConfiguration() == null ? new LinkedList() : this.getOldConfiguration().getProperties();
    }

    List getNewProperties() {
        return this.getNewConfiguration() == null ? new LinkedList() : this.getNewConfiguration().getProperties();
    }

    protected Collection _getChildren() {
        Collection children = super._getChildren();
        children.addAll(this.m_compartmentDeltas);
        return children;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

