/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.complib.cmpconf;

import com.sap.tc.complib.Compartment;
import com.sap.tc.complib.DevelopmentConfiguration;
import com.sap.tc.complib.cmpconf.AbstractEntityDelta;
import com.sap.tc.complib.cmpconf.AttributeID;
import com.sap.tc.complib.cmpconf.ChangeType;
import com.sap.tc.complib.cmpconf.CompartmentComparator;
import com.sap.tc.complib.cmpconf.CompartmentDelta;
import com.sap.tc.complib.cmpconf.ConfigComparisonResult;
import com.sap.tc.complib.cmpconf.ConfigurationComparisonException;
import com.sap.tc.complib.cmpconf.ConfigurationComparisonIllegalArgumentException;
import com.sap.tc.complib.cmpconf.ConfigurationDelta;
import com.sap.tc.complib.cmpconf.EntityComparatorBase;
import com.sap.tc.complib.cmpconf.IConfigComparisonResult;
import com.sap.tc.complib.cmpconf.IConfigurationComparator;
import com.sap.tc.complib.cmpconf.InternalConfigComparisonException;
import com.sap.tc.complib.cmpconf.ResultCode;
import com.sap.tc.logging.Location;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class ConfigurationComparator
extends EntityComparatorBase
implements IConfigurationComparator {
    static final Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$complib$cmpconf$ConfigurationComparator == null ? (class$com$sap$tc$complib$cmpconf$ConfigurationComparator = ConfigurationComparator.class$("com.sap.tc.complib.cmpconf.ConfigurationComparator")) : class$com$sap$tc$complib$cmpconf$ConfigurationComparator));
    private CompartmentComparator m_compartmentComparator = null;
    static /* synthetic */ Class class$com$sap$tc$complib$cmpconf$ConfigurationComparator;

    public IConfigComparisonResult compare(DevelopmentConfiguration oldConfiguration, DevelopmentConfiguration newConfiguration) throws ConfigurationComparisonException {
        String methodString = "findChanges";
        if (oldConfiguration == null) {
            String msg = "Illegal Argument for comparison: old configuration is null";
            LOCATION.debugT(methodString, msg);
            throw new ConfigurationComparisonIllegalArgumentException(msg);
        }
        if (newConfiguration == null) {
            String msg = "Illegal Argument for comparison: new configuration is null";
            LOCATION.debugT(methodString, msg);
            throw new ConfigurationComparisonIllegalArgumentException(msg);
        }
        ConfigurationDelta configDelta = new ConfigurationDelta(ChangeType.MODIFIED, oldConfiguration, newConfiguration);
        boolean isComethingChanged = false;
        isComethingChanged = isComethingChanged | this.findAttributeDeltas(configDelta) | this.findPropertyDeltas(configDelta) | this.findCompartmentDeltas(configDelta);
        String maxDocumentSchemaVersion = oldConfiguration.getSchemaVersion().compareTo(newConfiguration.getSchemaVersion()) > 0 ? oldConfiguration.getSchemaVersion() : newConfiguration.getSchemaVersion();
        ResultCode code = maxDocumentSchemaVersion.compareTo("1.0") > 0 ? ResultCode.PROBLEM_LIBRARY_SCHEMA : ResultCode.COMPARISON_OK;
        ConfigComparisonResult result = new ConfigComparisonResult(isComethingChanged ? configDelta : null, code, maxDocumentSchemaVersion);
        return result;
    }

    private boolean findCompartmentDeltas(ConfigurationDelta configDelta) throws ConfigurationComparisonException {
        Map afterCompartments = configDelta.getNewConfiguration().getCompartments();
        Map beforeCompartments = configDelta.getOldConfiguration().getCompartments();
        if (afterCompartments == null && beforeCompartments == null) {
            return false;
        }
        if (beforeCompartments == null) {
            return this.addAll(configDelta, afterCompartments.values(), ChangeType.ADDED);
        }
        if (afterCompartments == null) {
            return this.addAll(configDelta, beforeCompartments.values(), ChangeType.DELETED);
        }
        if (afterCompartments == null && beforeCompartments == null) {
            return false;
        }
        boolean changed = false;
        HashSet addedCompartments = new HashSet(afterCompartments.keySet());
        Set beforeNames = beforeCompartments.keySet();
        Set afterNames = afterCompartments.keySet();
        Iterator iter = beforeNames.iterator();
        while (iter.hasNext()) {
            String oldName = (String)iter.next();
            if (afterNames.contains(oldName)) {
                addedCompartments.remove(oldName);
                changed |= this.getCompartmentComparator().findDeltas(configDelta, oldName);
                continue;
            }
            configDelta.addCompartmentDelta(new CompartmentDelta(ChangeType.DELETED, configDelta, (Compartment)beforeCompartments.get(oldName), null));
            changed = true;
        }
        if (!addedCompartments.isEmpty()) {
            changed = true;
            Iterator addedCompartmnetIterator = addedCompartments.iterator();
            while (addedCompartmnetIterator.hasNext()) {
                String name = (String)addedCompartmnetIterator.next();
                configDelta.addCompartmentDelta(new CompartmentDelta(ChangeType.ADDED, configDelta, null, (Compartment)afterCompartments.get(name)));
            }
        }
        return changed;
    }

    private boolean addAll(ConfigurationDelta configDelta, Collection compartments, ChangeType kindOfChange) throws InternalConfigComparisonException {
        String methodString = "addAll";
        if (compartments == null || compartments.isEmpty()) {
            return false;
        }
        Iterator iter = compartments.iterator();
        while (iter.hasNext()) {
            CompartmentDelta delta;
            Compartment comp = (Compartment)iter.next();
            if (kindOfChange == ChangeType.DELETED) {
                delta = new CompartmentDelta(ChangeType.DELETED, configDelta, comp, null);
            } else if (kindOfChange == ChangeType.ADDED) {
                delta = new CompartmentDelta(ChangeType.ADDED, configDelta, null, comp);
            } else {
                String m = "Internal error.. Unexpected change type: " + kindOfChange;
                LOCATION.infoT(methodString, m);
                throw new InternalConfigComparisonException(m, configDelta);
            }
            configDelta.addCompartmentDelta(delta);
        }
        return true;
    }

    private boolean findAttributeDeltas(ConfigurationDelta configDelta) throws ConfigurationComparisonException {
        DevelopmentConfiguration oldConf = configDelta.getOldConfiguration();
        DevelopmentConfiguration newConf = configDelta.getNewConfiguration();
        boolean changed = false;
        changed |= this.findAttributeDelta("name", AttributeID.CONFIG_NAME, oldConf.getCaption(), newConf.getCaption(), (AbstractEntityDelta)configDelta);
        changed |= this.findAttributeDelta("caption", AttributeID.CONFIG_CAPTION, oldConf.getCaption(), newConf.getCaption(), (AbstractEntityDelta)configDelta);
        changed |= this.findAttributeDelta("config-version", AttributeID.CONFIG_VERSION, oldConf.getConfigVersion(), newConf.getConfigVersion(), (AbstractEntityDelta)configDelta);
        changed |= this.findAttributeDelta("document-type-version", AttributeID.CONFIG_DOCUMENT_TYPE_VERSION, oldConf.getSchemaVersion(), newConf.getSchemaVersion(), (AbstractEntityDelta)configDelta);
        changed |= this.findAttributeDelta("is-local", AttributeID.CONFIG_IS_LOCAL, new Boolean(oldConf.isLocal()), new Boolean(newConf.isLocal()), (AbstractEntityDelta)configDelta);
        changed |= this.findAttributeDelta("config-description", AttributeID.CONFIG_DESCRIPTION, oldConf.getDescription(), newConf.getDescription(), (AbstractEntityDelta)configDelta);
        changed |= this.findAttributeDelta("sl-location", AttributeID.CONFIG_SL_LOCATION, oldConf.getLocation(), newConf.getLocation(), (AbstractEntityDelta)configDelta);
        changed |= this.findAttributeDelta("name-server-url", AttributeID.CONFIG_NAME_SERVER_URL, oldConf.getNameServer(), newConf.getNameServer(), (AbstractEntityDelta)configDelta);
        changed |= this.findAttributeDelta("cms-url", AttributeID.CONFIG_CMS_URL, oldConf.getCMS(), newConf.getCMS(), (AbstractEntityDelta)configDelta);
        return changed |= this.findAttributeDelta("build-server", AttributeID.CONFIG_BUILD_SERVER, oldConf.getBuildServer(), newConf.getBuildServer(), (AbstractEntityDelta)configDelta);
    }

    private CompartmentComparator getCompartmentComparator() {
        if (this.m_compartmentComparator == null) {
            this.m_compartmentComparator = new CompartmentComparator();
        }
        return this.m_compartmentComparator;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

