/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.complib.cmpconf;

import com.sap.tc.complib.cmpconf.ConfigComparisonTexts;
import com.sap.tc.complib.cmpconf.IConfigComparisonResult;
import com.sap.tc.complib.cmpconf.IConfigElementDelta;
import com.sap.tc.complib.cmpconf.IConfigurationDelta;
import com.sap.tc.complib.cmpconf.IEntityDelta;
import java.io.PrintWriter;

public class ConfigDeltaWriter {
    private static final String INDENT_CHARACTER = " ";

    public void print(IConfigComparisonResult comparisonResult, PrintWriter out) {
        out.println(ConfigComparisonTexts.getString("ConfigDeltaWriter.HEADER_COMPARISON_RESULTS"));
        out.println(ConfigComparisonTexts.getString("ConfigDeltaWriter.HEADER_STATUS") + comparisonResult.getResultCode());
        IConfigurationDelta confDelta = comparisonResult.getConfigurationDelta();
        if (confDelta == null) {
            out.println(ConfigComparisonTexts.getString("ConfigDeltaWriter.REPORT_NO_CHANGES"));
            return;
        }
        this.printElement(confDelta, 0, out);
    }

    public void printElement(IConfigElementDelta delta, int level, PrintWriter out) {
        String prefix = this.getPrefix(level);
        out.println(prefix + delta);
        if (delta instanceof IEntityDelta) {
            IConfigElementDelta[] children = ((IEntityDelta)delta).getChildren();
            int i = 0;
            while (i < children.length) {
                this.printElement(children[i], level + 2, out);
                ++i;
            }
        }
    }

    private String getPrefix(int level) {
        String s = "";
        int i = 0;
        while (i < level) {
            s = s + INDENT_CHARACTER;
            ++i;
        }
        return s;
    }
}

