/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.complib.cmpconf;

import com.sap.tc.complib.Compartment;
import com.sap.tc.complib.cmpconf.AbstractEntityDelta;
import com.sap.tc.complib.cmpconf.ChangeType;
import com.sap.tc.complib.cmpconf.ConfigurationDelta;
import com.sap.tc.complib.cmpconf.IAliasDefinitionDelta;
import com.sap.tc.complib.cmpconf.IBuildVariantDelta;
import com.sap.tc.complib.cmpconf.ICompartmentDelta;
import com.sap.tc.complib.cmpconf.ICompartmentUsageDelta;
import com.sap.tc.complib.cmpconf.ISourceStateDelta;
import com.sap.tc.complib.cmpconf.InternalConfigComparisonException;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

class CompartmentDelta
extends AbstractEntityDelta
implements ICompartmentDelta {
    private static final String ELEMENT_TYPE_COMPARTMENT = "compartment";
    static final Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$complib$cmpconf$CompartmentDelta == null ? (class$com$sap$tc$complib$cmpconf$CompartmentDelta = CompartmentDelta.class$("com.sap.tc.complib.cmpconf.CompartmentDelta")) : class$com$sap$tc$complib$cmpconf$CompartmentDelta));
    private final Compartment m_oldCompartment;
    private final Compartment m_newCompartment;
    private ISourceStateDelta m_sourceStateDelta = null;
    private Collection m_usageDeltas;
    private Collection m_buildVariantDeltas;
    private Collection m_aliasMappingDeltas;
    static /* synthetic */ Class class$com$sap$tc$complib$cmpconf$CompartmentDelta;

    public CompartmentDelta(ChangeType changeType, ConfigurationDelta parent, Compartment oldCompartment, Compartment newCompartment) throws InternalConfigComparisonException {
        super(changeType, parent);
        if (oldCompartment == null && newCompartment == null) {
            LOCATION.debugT("constructor", "Internal error. Illegal arguments for contructing configuration element delta. Old and new value must not null at the same time. for element " + this);
            throw new InternalConfigComparisonException("Internal error. Illegal arguments for contructing configuration element delta. Old and new value must not null at the same time.", this);
        }
        if (oldCompartment != null && newCompartment != null && !oldCompartment.getName().equals(newCompartment.getName())) {
            String msg = "Internal error. Illegal arguments for contructing configuration element delta. Old and new value are for different entities. : " + oldCompartment.getName() + " | " + newCompartment.getName();
            throw new InternalConfigComparisonException(msg, this);
        }
        this.setName(oldCompartment == null ? newCompartment.getName() : oldCompartment.getName());
        this.m_oldCompartment = oldCompartment;
        this.m_newCompartment = newCompartment;
        this.resetAliasMapDeltas();
        this.resetUsageDelta();
        this.resetBuildVariantDelta();
    }

    public Compartment getOldCompartment() {
        return this.m_oldCompartment;
    }

    public Compartment getNewCompartment() {
        return this.m_newCompartment;
    }

    public ISourceStateDelta getSourceStateDelta() {
        return this.m_sourceStateDelta;
    }

    public void setSourceStateDelta(ISourceStateDelta sourceStateDelta) {
        this.m_sourceStateDelta = sourceStateDelta;
    }

    public ICompartmentUsageDelta[] getUsageDeltas() {
        return this.m_usageDeltas.toArray(new ICompartmentUsageDelta[this.m_usageDeltas.size()]);
    }

    private void resetUsageDelta() {
        this.m_usageDeltas = new ArrayList();
    }

    public void addUsageDelta(ICompartmentUsageDelta delta) {
        this.m_usageDeltas.add(delta);
    }

    public IBuildVariantDelta[] getBuildVariantDeltas() {
        return this.m_buildVariantDeltas.toArray(new IBuildVariantDelta[this.m_buildVariantDeltas.size()]);
    }

    private void resetBuildVariantDelta() {
        this.m_buildVariantDeltas = new ArrayList();
    }

    public void addBuildVariantDelta(IBuildVariantDelta delta) {
        this.m_buildVariantDeltas.add(delta);
    }

    public IAliasDefinitionDelta[] getAliasMapDeltas() {
        return this.m_aliasMappingDeltas.toArray(new IAliasDefinitionDelta[this.m_aliasMappingDeltas.size()]);
    }

    public void addAliasMapDelta(IAliasDefinitionDelta delta) {
        this.m_aliasMappingDeltas.add(delta);
    }

    public void resetAliasMapDeltas() {
        this.m_aliasMappingDeltas = new ArrayList();
    }

    public String getTypeName() {
        return ELEMENT_TYPE_COMPARTMENT;
    }

    int countUsageDeltas() {
        return this.m_usageDeltas.size();
    }

    int countBuildVariantDeltas() {
        return this.m_buildVariantDeltas.size();
    }

    int countAliasDeltas() {
        return this.m_aliasMappingDeltas.size();
    }

    List getOldProperties() {
        return this.getOldCompartment() == null ? new LinkedList() : this.getOldCompartment().getProperties();
    }

    List getNewProperties() {
        return this.getNewCompartment() == null ? new LinkedList() : this.getNewCompartment().getProperties();
    }

    protected Collection _getChildren() {
        Collection children = super._getChildren();
        children.addAll(this.m_aliasMappingDeltas);
        children.addAll(this.m_buildVariantDeltas);
        children.addAll(this.m_usageDeltas);
        if (this.m_sourceStateDelta != null) {
            children.add(this.m_sourceStateDelta);
        }
        return children;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

