/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.complib.cmpconf;

import com.sap.tc.complib.BuildVariant;
import com.sap.tc.complib.Compartment;
import com.sap.tc.complib.SourceState;
import com.sap.tc.complib.cmpconf.AbstractEntityDelta;
import com.sap.tc.complib.cmpconf.AliasDefinitionDelta;
import com.sap.tc.complib.cmpconf.AttributeID;
import com.sap.tc.complib.cmpconf.BuildVariantComparator;
import com.sap.tc.complib.cmpconf.BuildVariantDelta;
import com.sap.tc.complib.cmpconf.ChangeType;
import com.sap.tc.complib.cmpconf.CompartmentDelta;
import com.sap.tc.complib.cmpconf.CompartmentUsageDelta;
import com.sap.tc.complib.cmpconf.ConfigurationComparisonException;
import com.sap.tc.complib.cmpconf.ConfigurationDelta;
import com.sap.tc.complib.cmpconf.EntityComparatorBase;
import com.sap.tc.complib.cmpconf.InternalConfigComparisonException;
import com.sap.tc.complib.cmpconf.SourceStateDelta;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class CompartmentComparator
extends EntityComparatorBase {
    private BuildVariantComparator m_bvComparator;

    CompartmentComparator() {
    }

    boolean findDeltas(ConfigurationDelta configDelta, String compartmentName) throws ConfigurationComparisonException {
        Compartment oldCompartment = (Compartment)configDelta.getOldConfiguration().getCompartments().get(compartmentName);
        Compartment newCompartment = (Compartment)configDelta.getNewConfiguration().getCompartments().get(compartmentName);
        CompartmentDelta compartmentDelta = new CompartmentDelta(ChangeType.MODIFIED, configDelta, oldCompartment, newCompartment);
        boolean isComethingChanged = false;
        if (isComethingChanged = isComethingChanged | this.findAttributeDeltas(compartmentDelta) | this.findPropertyDeltas(compartmentDelta) | this.findBuildVariantDeltas(compartmentDelta) | this.findUsageDeltas(compartmentDelta) | this.findSourceStateDeltas(compartmentDelta) | this.findAliasMappingDeltas(compartmentDelta)) {
            configDelta.addCompartmentDelta(compartmentDelta);
        }
        return isComethingChanged;
    }

    private boolean findSourceStateDeltas(CompartmentDelta compartmentDelta) throws ConfigurationComparisonException {
        SourceState oldSourceState = compartmentDelta.getOldCompartment().getSourceState();
        SourceState newSourceState = compartmentDelta.getNewCompartment().getSourceState();
        if (oldSourceState == null) {
            if (newSourceState != null) {
                SourceStateDelta sourceStateDelta = new SourceStateDelta(ChangeType.ADDED, compartmentDelta, oldSourceState, newSourceState);
                compartmentDelta.setSourceStateDelta(sourceStateDelta);
            }
        } else if (newSourceState == null) {
            SourceStateDelta sourceStateDelta = new SourceStateDelta(ChangeType.DELETED, compartmentDelta, oldSourceState, newSourceState);
            compartmentDelta.setSourceStateDelta(sourceStateDelta);
        } else {
            SourceStateDelta sourceStateDelta = new SourceStateDelta(ChangeType.MODIFIED, compartmentDelta, oldSourceState, newSourceState);
            boolean changed = false;
            changed |= this.findAttributeDelta(AttributeID.SOURCE_STATE_REPOS_URL, oldSourceState.getRepository().getURL(), newSourceState.getRepository().getURL(), (AbstractEntityDelta)sourceStateDelta);
            changed |= this.findAttributeDelta(AttributeID.SOURCE_STATE_REPOS_TYPE, oldSourceState.getRepository().getType(), newSourceState.getRepository().getType(), (AbstractEntityDelta)sourceStateDelta);
            changed |= this.findAttributeDelta(AttributeID.SOURCE_STATE_REPOS_TYPE, oldSourceState.getRepository().getType(), newSourceState.getRepository().getType(), (AbstractEntityDelta)sourceStateDelta);
            changed |= this.findAttributeDelta(AttributeID.SOURCE_STATE_ACTIVE_LOCATION, oldSourceState.getLocation(), newSourceState.getLocation(), (AbstractEntityDelta)sourceStateDelta);
            changed |= this.findAttributeDelta(AttributeID.SOURCE_STATE_INACTIVE_LOCATION, oldSourceState.getInactiveLocation(), newSourceState.getInactiveLocation(), (AbstractEntityDelta)sourceStateDelta);
            changed |= this.findAttributeDelta(AttributeID.SOURCE_STATE_EXPORT_ALLOWED, new Boolean(oldSourceState.isExportAllowed()), new Boolean(newSourceState.isExportAllowed()), (AbstractEntityDelta)sourceStateDelta);
            if (changed |= this.findAttributeDelta(AttributeID.SOURCE_STATE_TYPE, new Integer(oldSourceState.getType()), new Integer(newSourceState.getType()), (AbstractEntityDelta)sourceStateDelta)) {
                compartmentDelta.setSourceStateDelta(sourceStateDelta);
            }
        }
        return compartmentDelta.getSourceStateDelta() != null;
    }

    private boolean findAliasMappingDeltas(CompartmentDelta compartmentDelta) throws ConfigurationComparisonException {
        Map oldAliases = compartmentDelta.getOldCompartment().getScAliases();
        Map newAliases = compartmentDelta.getNewCompartment().getScAliases();
        Set originalSet = oldAliases == null ? null : oldAliases.keySet();
        Set finalSet = newAliases == null ? null : newAliases.keySet();
        Set[] changeSets = this.getChangeSets(originalSet, finalSet);
        Set deleted = changeSets[0];
        Set changeCandidates = changeSets[2];
        Set added = changeSets[1];
        if (deleted.size() != 0) {
            this.addAliases(deleted, compartmentDelta, oldAliases, ChangeType.DELETED);
        }
        if (added.size() != 0) {
            this.addAliases(added, compartmentDelta, newAliases, ChangeType.ADDED);
        }
        Iterator iter = changeCandidates.iterator();
        while (iter.hasNext()) {
            String newValue;
            String aliasName = (String)iter.next();
            String oldValue = (String)oldAliases.get(aliasName);
            if (oldValue.equals(newValue = (String)newAliases.get(aliasName))) continue;
            compartmentDelta.addAliasMapDelta(new AliasDefinitionDelta(ChangeType.MODIFIED, compartmentDelta, aliasName, oldValue, newValue));
        }
        return compartmentDelta.countAliasDeltas() > 0;
    }

    private void addAliases(Collection keysToAdd, CompartmentDelta compartmentDelta, Map aliasMap, ChangeType changeType) throws ConfigurationComparisonException {
        String thisMethod = "addAliases";
        Iterator iter = keysToAdd.iterator();
        while (iter.hasNext()) {
            String aliasName = (String)iter.next();
            String aliasedCompartment = (String)aliasMap.get(aliasName);
            if (aliasedCompartment == null) {
                EntityComparatorBase.LOCATION.infoT(thisMethod, "Internal error..Illegal argument for adding alias map deltas. Could not find key {0} in alias mapping of compartment {1}.", new Object[]{aliasName, compartmentDelta.getName()});
                throw new InternalConfigComparisonException("Internal error..Illegal argument for adding alias map deltas. Could not find key in alias map. ", compartmentDelta);
            }
            if (changeType == ChangeType.ADDED) {
                compartmentDelta.addAliasMapDelta(new AliasDefinitionDelta(ChangeType.ADDED, compartmentDelta, aliasName, null, aliasedCompartment));
                continue;
            }
            if (changeType == ChangeType.DELETED) {
                compartmentDelta.addAliasMapDelta(new AliasDefinitionDelta(ChangeType.DELETED, compartmentDelta, aliasName, aliasedCompartment, null));
                continue;
            }
            EntityComparatorBase.LOCATION.infoT(thisMethod, "Internal error..Illegal argument for adding alias map deltas. Illegal Change type {0}.", new Object[]{changeType});
            throw new InternalConfigComparisonException("Internal error..Illegal argument for adding alias map deltas. Illegal change type " + changeType, compartmentDelta);
        }
    }

    private boolean findUsageDeltas(CompartmentDelta compartmentDelta) throws InternalConfigComparisonException {
        CompartmentUsageDelta delta;
        String usedCompartmentName;
        HashSet usagesBefore = compartmentDelta.getOldCompartment().getUsedCompartments();
        HashSet usagesAfter = compartmentDelta.getNewCompartment().getUsedCompartments();
        HashSet deletedUsages = null;
        HashSet addedUsages = null;
        if (usagesBefore == null) {
            if (usagesAfter != null) {
                addedUsages = usagesAfter;
            }
        } else if (usagesAfter == null) {
            deletedUsages = usagesBefore;
        } else {
            deletedUsages = new HashSet(usagesBefore);
            deletedUsages.removeAll(usagesAfter);
            addedUsages = new HashSet(usagesAfter);
            addedUsages.removeAll(usagesBefore);
        }
        if (addedUsages != null) {
            Iterator iterAdded = addedUsages.iterator();
            while (iterAdded.hasNext()) {
                usedCompartmentName = (String)iterAdded.next();
                delta = new CompartmentUsageDelta(ChangeType.ADDED, compartmentDelta, usedCompartmentName);
                compartmentDelta.addUsageDelta(delta);
            }
        }
        if (deletedUsages != null) {
            Iterator iterDeleted = deletedUsages.iterator();
            while (iterDeleted.hasNext()) {
                usedCompartmentName = (String)iterDeleted.next();
                delta = new CompartmentUsageDelta(ChangeType.DELETED, compartmentDelta, usedCompartmentName);
                compartmentDelta.addUsageDelta(delta);
            }
        }
        return compartmentDelta.countUsageDeltas() > 0;
    }

    private boolean findBuildVariantDeltas(CompartmentDelta compartmentDelta) throws ConfigurationComparisonException {
        Map oldBuildVariants = compartmentDelta.getOldCompartment().getBuildVariants();
        Map newBuildVariants = compartmentDelta.getNewCompartment().getBuildVariants();
        if (oldBuildVariants == null && newBuildVariants == null) {
            return false;
        }
        Set originalSet = oldBuildVariants == null ? null : oldBuildVariants.keySet();
        Set finalSet = newBuildVariants == null ? null : newBuildVariants.keySet();
        Set[] changeSets = this.getChangeSets(originalSet, finalSet);
        Set deleted = changeSets[0];
        Set changeCandidates = changeSets[2];
        Set added = changeSets[1];
        Iterator iter = deleted.iterator();
        while (iter.hasNext()) {
            String variantName = (String)iter.next();
            BuildVariantDelta delta = new BuildVariantDelta(ChangeType.DELETED, compartmentDelta, (BuildVariant)oldBuildVariants.get(variantName), null);
            compartmentDelta.addBuildVariantDelta(delta);
        }
        Iterator iter2 = added.iterator();
        while (iter2.hasNext()) {
            String variantName = (String)iter2.next();
            BuildVariantDelta delta = new BuildVariantDelta(ChangeType.ADDED, compartmentDelta, null, (BuildVariant)newBuildVariants.get(variantName));
            compartmentDelta.addBuildVariantDelta(delta);
        }
        Iterator iter3 = changeCandidates.iterator();
        while (iter3.hasNext()) {
            String variantName = (String)iter3.next();
            this.getBuildVariantComparator().compareBuildVariants(compartmentDelta, variantName);
        }
        return compartmentDelta.countBuildVariantDeltas() > 0;
    }

    private boolean findAttributeDeltas(CompartmentDelta compartmentDelta) throws ConfigurationComparisonException {
        Compartment oldComp = compartmentDelta.getOldCompartment();
        Compartment newComp = compartmentDelta.getNewCompartment();
        boolean changed = false;
        changed |= this.findAttributeDelta("caption", AttributeID.COMPARTMENT_CAPTION, oldComp.getCaption(), newComp.getCaption(), (AbstractEntityDelta)compartmentDelta);
        changed |= this.findAttributeDelta("sc-name", AttributeID.COMPARTMENT_SC_NAME, oldComp.getScName(), newComp.getScName(), (AbstractEntityDelta)compartmentDelta);
        changed |= this.findAttributeDelta("sc-vendor", AttributeID.COMPARTMENT_SC_VENDOR, oldComp.getScVendor(), newComp.getScVendor(), (AbstractEntityDelta)compartmentDelta);
        changed |= this.findAttributeDelta("local-archive-folder", AttributeID.COMPARTMENT_LOCAL_ARCHIVE_FOLDER, oldComp.getLocalArchiveFolder(), newComp.getLocalArchiveFolder(), (AbstractEntityDelta)compartmentDelta);
        changed |= this.findAttributeDelta("compartment-description", AttributeID.COMPARTMENT_DESCRIPTION, oldComp.getDescription(), newComp.getDescription(), (AbstractEntityDelta)compartmentDelta);
        changed |= this.findAttributeDelta("default-compartment", AttributeID.COMPARTMENT_DEFAULT_COMPARTMENT, new Boolean(oldComp.IsDefaultCompartment()), new Boolean(newComp.IsDefaultCompartment()), (AbstractEntityDelta)compartmentDelta);
        return changed |= this.findAttributeDelta("archive-state", AttributeID.COMPARTMENT_ARCHIVE_STATE, new Boolean(oldComp.getHasArchiveState()), new Boolean(newComp.getHasArchiveState()), (AbstractEntityDelta)compartmentDelta);
    }

    private BuildVariantComparator getBuildVariantComparator() {
        if (this.m_bvComparator == null) {
            this.m_bvComparator = new BuildVariantComparator();
        }
        return this.m_bvComparator;
    }
}

