/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.complib.cmpconf;

import com.sap.tc.complib.BuildVariant;
import com.sap.tc.complib.Compartment;
import com.sap.tc.complib.cmpconf.AbstractEntityDelta;
import com.sap.tc.complib.cmpconf.AttributeID;
import com.sap.tc.complib.cmpconf.BuildOptionDelta;
import com.sap.tc.complib.cmpconf.BuildVariantDelta;
import com.sap.tc.complib.cmpconf.ChangeType;
import com.sap.tc.complib.cmpconf.CompartmentDelta;
import com.sap.tc.complib.cmpconf.ConfigurationComparisonException;
import com.sap.tc.complib.cmpconf.EntityComparatorBase;
import com.sap.tc.complib.cmpconf.InternalConfigComparisonException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

class BuildVariantComparator
extends EntityComparatorBase {
    BuildVariantComparator() {
    }

    public boolean compareBuildVariants(CompartmentDelta compartmentDelta, String variantName) throws ConfigurationComparisonException {
        if (compartmentDelta.getChangeType() != ChangeType.MODIFIED) {
            throw new InternalConfigComparisonException("Internal error. Illegal argument.cannot compare build variants. Wrong change type: " + compartmentDelta.getChangeType(), compartmentDelta);
        }
        Compartment oldCompartment = compartmentDelta.getOldCompartment();
        Compartment newCompartment = compartmentDelta.getNewCompartment();
        if (oldCompartment == null) {
            throw new InternalConfigComparisonException("Internal error. Illegal argument.cannot compare build variants. Old compartment is null.", compartmentDelta);
        }
        if (newCompartment == null) {
            throw new InternalConfigComparisonException("Internal error. Illegal argument.cannot compare build variants. New compartment is null.", compartmentDelta);
        }
        if (oldCompartment.getBuildVariants() == null) {
            throw new InternalConfigComparisonException("Internal error. Illegal argument.cannot compare build variants. Old compartment has no build variants.", compartmentDelta);
        }
        if (newCompartment.getBuildVariants() == null) {
            throw new InternalConfigComparisonException("Internal error. Illegal argument.cannot compare build variants. New compartment has no build variants.", compartmentDelta);
        }
        BuildVariant oldBV = (BuildVariant)oldCompartment.getBuildVariants().get(variantName);
        BuildVariant newBV = (BuildVariant)newCompartment.getBuildVariants().get(variantName);
        if (oldBV == null) {
            throw new InternalConfigComparisonException("Internal error. Illegal argument.cannot compare build variants. Old compartment has no build variant named " + variantName, compartmentDelta);
        }
        if (newBV == null) {
            throw new InternalConfigComparisonException("Internal error. Illegal argument.cannot compare build variants. New compartment has no build variant named " + variantName, compartmentDelta);
        }
        BuildVariantDelta delta = new BuildVariantDelta(ChangeType.MODIFIED, compartmentDelta, oldBV, newBV);
        boolean isSomethingChanged = this.findAttributeDelta(AttributeID.BUILD_VARIANT_REQUIRED, new Boolean(oldBV.getIsRequired()), new Boolean(newBV.getIsRequired()), (AbstractEntityDelta)delta);
        if (isSomethingChanged |= this.findBuildOptionChanges(delta)) {
            compartmentDelta.addBuildVariantDelta(delta);
        }
        return isSomethingChanged;
    }

    private boolean findBuildOptionChanges(BuildVariantDelta bvDelta) throws ConfigurationComparisonException {
        List oldNames = bvDelta.getOldBuildVariant().getBuildOptionNames();
        List newNames = bvDelta.getNewBuildVariant().getBuildOptionNames();
        HashSet originalSet = oldNames == null ? new HashSet() : new HashSet(oldNames);
        HashSet finalSet = newNames == null ? new HashSet() : new HashSet(newNames);
        Set[] changeSets = this.getChangeSets(originalSet, finalSet);
        Set deleted = changeSets[0];
        Set changeCandidates = changeSets[2];
        Set added = changeSets[1];
        Iterator iter = added.iterator();
        while (iter.hasNext()) {
            String optionName = (String)iter.next();
            bvDelta.addBuildOptionDelta(new BuildOptionDelta(ChangeType.ADDED, bvDelta, optionName, null, bvDelta.getNewBuildVariant().getBuildOptionValues(optionName)));
        }
        Iterator iter2 = deleted.iterator();
        while (iter2.hasNext()) {
            String optionName = (String)iter2.next();
            bvDelta.addBuildOptionDelta(new BuildOptionDelta(ChangeType.DELETED, bvDelta, optionName, bvDelta.getOldBuildVariant().getBuildOptionValues(optionName), null));
        }
        Iterator iter3 = changeCandidates.iterator();
        while (iter3.hasNext()) {
            List newValues;
            String optionName = (String)iter3.next();
            List oldValues = bvDelta.getOldBuildVariant().getBuildOptionValues(optionName);
            if (this.areEqualAsSets(oldValues, newValues = bvDelta.getNewBuildVariant().getBuildOptionValues(optionName))) continue;
            bvDelta.addBuildOptionDelta(new BuildOptionDelta(ChangeType.MODIFIED, bvDelta, optionName, oldValues, newValues));
        }
        return bvDelta.countBuildOptionDeltas() > 0;
    }
}

