/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.complib.cmpconf;

import com.sap.tc.complib.cmpconf.AbstractConfigElementDelta;
import com.sap.tc.complib.cmpconf.ChangeType;
import com.sap.tc.complib.cmpconf.IAttributeDelta;
import com.sap.tc.complib.cmpconf.IConfigElementDelta;
import com.sap.tc.complib.cmpconf.IEntityDelta;
import com.sap.tc.complib.cmpconf.IPropertyDelta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

abstract class AbstractEntityDelta
extends AbstractConfigElementDelta
implements IEntityDelta {
    private Collection m_attributeDeltas = new ArrayList();
    private Collection m_propertyDeltas = new ArrayList();
    private String m_name;

    public AbstractEntityDelta(ChangeType changeType, AbstractEntityDelta parent) {
        super(changeType, parent);
    }

    public IPropertyDelta[] getPropertyDeltas() {
        return this.m_propertyDeltas.toArray(new IPropertyDelta[this.m_propertyDeltas.size()]);
    }

    public IAttributeDelta[] getAttributeDeltas() {
        return this.m_attributeDeltas.toArray(new IAttributeDelta[this.m_attributeDeltas.size()]);
    }

    void resetAttributeDeltas() {
        this.m_attributeDeltas = new ArrayList();
    }

    void resetPropertyDeltas() {
        this.m_attributeDeltas = new ArrayList();
    }

    void addPropertyDelta(IPropertyDelta delta) {
        this.m_propertyDeltas.add(delta);
    }

    void addAttributeDelta(IAttributeDelta delta) {
        this.m_attributeDeltas.add(delta);
    }

    public String getName() {
        return this.m_name;
    }

    protected void setName(String name) {
        this.m_name = name;
    }

    List getOldProperties() {
        return new LinkedList();
    }

    List getNewProperties() {
        return new LinkedList();
    }

    int countPropertyDeltas() {
        return this.m_propertyDeltas.size();
    }

    int countAttributeDeltas() {
        return this.m_attributeDeltas.size();
    }

    public IConfigElementDelta[] getChildren() {
        Collection children = this._getChildren();
        return children.toArray(new IConfigElementDelta[children.size()]);
    }

    protected Collection _getChildren() {
        LinkedList children = new LinkedList();
        children.addAll(this.m_attributeDeltas);
        children.addAll(this.m_propertyDeltas);
        return children;
    }
}

