/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.complib;

import com.sap.tc.complib.ComponentReference;
import com.sap.tc.complib.keygen.KeyGenerator;
import com.sap.tc.complib.validate.MissingElementException;
import com.sap.tc.complib.validate.ValidationException;
import com.sap.tc.complib.xml.XMLWriter;

public final class SCReference
implements ComponentReference {
    private String _name;
    private String _vendor;
    private String _alias;
    private final String _key = KeyGenerator.getInstance().createKey(this.getClass());

    public SCReference() {
    }

    public SCReference(String name, String vendor) {
        this._name = name;
        this._vendor = vendor;
    }

    public SCReference(String name, String vendor, String alias) {
        this._name = name;
        this._vendor = vendor;
        this._alias = alias;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getVendor() {
        return this._vendor;
    }

    public void setVendor(String vendor) {
        this._vendor = vendor;
    }

    public String getSCAlias() {
        return this._alias;
    }

    public void setSCAlias(String alias) {
        this._alias = alias;
    }

    public void validate() throws ValidationException {
        if (this._name == null) {
            throw new MissingElementException("name");
        }
        if (this._vendor == null) {
            throw new MissingElementException("vendor");
        }
    }

    public void serialize(XMLWriter writer) throws ValidationException {
        if (this._name == null) {
            throw new MissingElementException("SC references must specify a SC name");
        }
        if (this._vendor == null) {
            throw new MissingElementException("SC references must specify a SC vendor");
        }
        writer.beginTag("sc-ref");
        writer.writeTag("name", this._name);
        writer.writeTag("vendor", this._vendor);
        if (this._alias != null) {
            writer.writeTag("sc-alias", this._alias);
        }
        writer.endTag("sc-ref");
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof SCReference) {
            SCReference ref = (SCReference)obj;
            boolean equals = true;
            equals &= this._name != null ? this._name.equals(ref._name) : ref._name == null;
            equals &= this._vendor != null ? this._vendor.equals(ref._vendor) : ref._vendor == null;
            return equals &= this._alias != null ? this._alias.equals(ref._alias) : ref._alias == null;
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = this._name != null ? 37 * result + this._name.hashCode() : result;
        result = this._vendor != null ? 37 * result + this._vendor.hashCode() : result;
        result = this._alias != null ? 37 * result + this._alias.hashCode() : result;
        return result;
    }

    public String getUniqueKey() {
        return this._key;
    }
}

