/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.complib;

import com.sap.tc.complib.DCReference;
import com.sap.tc.complib.Dependency;
import com.sap.tc.complib.validate.MissingElementException;
import com.sap.tc.complib.validate.ValidationException;
import com.sap.tc.complib.xml.XMLWriter;

public final class PPReference {
    private DCReference _component;
    private String _name;

    public PPReference() {
    }

    public PPReference(String name, DCReference component) {
        this._name = name;
        this._component = component;
    }

    public PPReference(Dependency dependency) {
        this._name = dependency.getPublicPart();
        this._component = dependency.getComponent();
    }

    public DCReference getComponent() {
        return this._component;
    }

    public void setComponent(DCReference component) {
        this._component = component;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void validate() throws ValidationException {
        if (this._name == null) {
            throw new MissingElementException("name");
        }
        if (this._component == null) {
            throw new MissingElementException("component");
        }
    }

    public void serialize(XMLWriter writer) throws ValidationException {
        if (this._name == null) {
            throw new ValidationException("Public part references must specifiy a public part name.");
        }
        if (this._component == null) {
            throw new ValidationException("Public part references must specifiy a target component.");
        }
        this._component.serialize(writer);
        writer.writeTag("pp-ref", this._name);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof PPReference) {
            PPReference ref = (PPReference)obj;
            boolean equals = true;
            equals &= this._component != null ? this._component.equals(ref._component) : ref._component == null;
            return equals &= this._name != null ? this._name.equals(ref._name) : ref._name == null;
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = this._component != null ? 37 * result + this._component.hashCode() : result;
        result = this._name != null ? 37 * result + this._name.hashCode() : result;
        return result;
    }

    public String toString() {
        if (this._component == null) {
            return super.toString();
        }
        String s = this._component.toString();
        if (this._name != null) {
            s = s + "#" + this._name;
        }
        return s;
    }
}

