/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.complib;

import com.sap.tc.complib.validate.InvalidMemberException;
import com.sap.tc.complib.validate.ValidationException;
import com.sap.tc.complib.xml.Attribute;
import com.sap.tc.complib.xml.XMLWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class FileSet {
    private List _includes;
    private List _excludes;

    public List getIncludes() {
        return this._includes;
    }

    public List emptyIncludes() {
        if (this._includes != null) {
            this._includes.clear();
        } else {
            this._includes = new ArrayList();
        }
        return this._includes;
    }

    public List getExcludes() {
        return this._excludes;
    }

    public List emptyExcludes() {
        if (this._excludes != null) {
            this._excludes.clear();
        } else {
            this._excludes = new ArrayList();
        }
        return this._excludes;
    }

    public void setIncludes(String includes) {
        this.emptyIncludes();
        StringTokenizer t = new StringTokenizer(includes, ",");
        while (t.hasMoreTokens()) {
            this._includes.add(t.nextToken().trim());
        }
    }

    public void setExcludes(String excludes) {
        this.emptyExcludes();
        StringTokenizer t = new StringTokenizer(excludes, ",");
        while (t.hasMoreTokens()) {
            this._excludes.add(t.nextToken().trim());
        }
    }

    public void validate() throws ValidationException {
        String child;
        Iterator iter;
        if (this._includes != null && this._includes.size() > 0) {
            iter = this._includes.iterator();
            child = null;
            try {
                while (iter.hasNext()) {
                    child = (String)iter.next();
                }
            }
            catch (ClassCastException ex) {
                throw new InvalidMemberException("includes", child);
            }
        }
        if (this._excludes != null && this._excludes.size() > 0) {
            iter = this._excludes.iterator();
            child = null;
            try {
                while (iter.hasNext()) {
                    child = (String)iter.next();
                }
            }
            catch (ClassCastException ex) {
                throw new InvalidMemberException("excludes", child);
            }
        }
    }

    public void serialize(XMLWriter writer) throws ValidationException {
        String s;
        int i;
        writer.beginTag("fileset");
        if (this._includes != null) {
            i = 0;
            while (i < this._includes.size()) {
                s = (String)this._includes.get(i);
                if (s != null && s.length() > 0) {
                    writer.writeEmptyTag("include", new Attribute[]{new Attribute("name", s)});
                }
                ++i;
            }
        }
        if (this._excludes != null) {
            i = 0;
            while (i < this._excludes.size()) {
                s = (String)this._excludes.get(i);
                if (s != null && s.length() > 0) {
                    writer.writeEmptyTag("exclude", new Attribute[]{new Attribute("name", s)});
                }
                ++i;
            }
        }
        writer.endTag("fileset");
    }
}

