/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.complib;

import com.sap.tc.complib.BuildVariant;
import com.sap.tc.complib.Compartment;
import com.sap.tc.complib.DevelopmentConfiguration;
import com.sap.tc.complib.Repository;
import com.sap.tc.complib.SourceState;
import com.sap.tc.complib.impl.BuildVariantImpl;
import com.sap.tc.complib.impl.CompartmentImpl;
import com.sap.tc.complib.impl.DevelopmentConfigurationImpl;
import com.sap.tc.complib.impl.RepositoryImpl;
import com.sap.tc.complib.impl.SourceStateImpl;
import com.sap.tc.complib.provider.ConfigurationInputProvider;
import com.sap.tc.complib.provider.ProviderException;
import com.sap.tc.complib.validate.ValidationException;
import com.sap.tc.complib.xml.XMLException;
import java.io.IOException;
import java.util.Arrays;

public class ConfigurationFactory {
    public static final String SCHEMA_VERSION_0_2 = "0.2";
    public static final String SCHEMA_VERSION_0_3 = "0.3";
    public static final String SCHEMA_VERSION_1_0 = "1.0";
    public static final String SCHEMA_VERSION = "1.0";

    public static String[] getSchemaVersions() {
        return new String[]{SCHEMA_VERSION_0_2, SCHEMA_VERSION_0_3, "1.0"};
    }

    public static boolean isSchemaAllowed(String schemaVersion) {
        return schemaVersion != null && Arrays.binarySearch(ConfigurationFactory.getSchemaVersions(), schemaVersion) >= 0;
    }

    public static DevelopmentConfiguration createDevelopmentConfiguration() {
        DevelopmentConfigurationImpl conf = new DevelopmentConfigurationImpl();
        return conf;
    }

    public static DevelopmentConfiguration createDevelopmentConfiguration(String name, String caption, String description, String buildserver, String configVersion) {
        DevelopmentConfigurationImpl conf = new DevelopmentConfigurationImpl();
        conf.setName(name);
        conf.setCaption(caption);
        conf.setBuildServer(buildserver);
        conf.setDescription(description);
        conf.emptyCompartments();
        conf.setConfigVersion(configVersion);
        return conf;
    }

    public static Compartment createCompartment() {
        CompartmentImpl compartment = new CompartmentImpl();
        return compartment;
    }

    public static Compartment createCompartment(String name, String scName, String scVendor) {
        return ConfigurationFactory.createCompartment(name, scName, scVendor, true, null);
    }

    public static Compartment createCompartment(String name, String scName, String scVendor, boolean hasArchiveState, SourceState sourceState) {
        CompartmentImpl compartment = new CompartmentImpl();
        compartment.setName(name);
        compartment.setScName(scName);
        compartment.setScVendor(scVendor);
        compartment.setHasArchiveState(hasArchiveState);
        compartment.setSourceState(sourceState);
        return compartment;
    }

    public static SourceState createSourceStateForRead(Repository repository, String workspace) {
        SourceStateImpl s = new SourceStateImpl();
        s.setRepository(repository);
        s.setType(1);
        s.setLocation(workspace);
        return s;
    }

    public static SourceState createSourceStateForChange(Repository repository, String workspace) {
        SourceStateImpl s = new SourceStateImpl();
        s.setRepository(repository);
        s.setType(2);
        s.setLocation(workspace);
        return s;
    }

    public static SourceState createSourceStateWithActivation(Repository repository, String inactiveWorkspace, String activeWorkspace) {
        SourceStateImpl s = new SourceStateImpl();
        s.setRepository(repository);
        s.setType(0);
        s.setInactiveLocation(activeWorkspace);
        s.setLocation(inactiveWorkspace);
        return s;
    }

    public static SourceState createSourceState() {
        SourceStateImpl s = new SourceStateImpl();
        return s;
    }

    public static Repository createRepository() {
        RepositoryImpl r = new RepositoryImpl();
        return r;
    }

    public static Repository createRepository(String type, String url) {
        RepositoryImpl r = new RepositoryImpl(type, url);
        return r;
    }

    public static BuildVariant createBuildVariant() {
        BuildVariantImpl v = new BuildVariantImpl();
        return v;
    }

    public static BuildVariant createBuildVariant(String name) {
        BuildVariantImpl v = new BuildVariantImpl();
        v.setName(name);
        return v;
    }

    public static BuildVariant createBuildVariant(String name, boolean isRequired) {
        BuildVariantImpl v = new BuildVariantImpl();
        v.setName(name);
        v.setIsRequired(isRequired);
        return v;
    }

    public static DevelopmentConfiguration initializeDevelopmentConfiguration(ConfigurationInputProvider provider) throws IOException, XMLException, ProviderException, ValidationException {
        DevelopmentConfiguration conf = ConfigurationFactory.createDevelopmentConfiguration();
        conf.initialize(provider);
        return conf;
    }
}

