/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.complib;

import com.sap.tc.complib.validate.MissingElementException;
import com.sap.tc.complib.validate.ValidationException;
import com.sap.tc.complib.xml.XMLWriter;

public final class ComponentType {
    private String _vendor;
    private String _type;
    private String _subtype;

    public ComponentType() {
    }

    public ComponentType(String vendor, String type) {
        this._vendor = vendor;
        this._type = type;
    }

    public String getVendor() {
        return this._vendor;
    }

    public void setVendor(String vendor) {
        this._vendor = vendor;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }

    public String getSubType() {
        return this._subtype;
    }

    public void setSubType(String subtype) {
        this._subtype = subtype;
    }

    public void validate() throws ValidationException {
        if (this._vendor == null) {
            throw new MissingElementException("vendor");
        }
        if (this._type == null) {
            throw new MissingElementException("type");
        }
    }

    public void serialize(XMLWriter writer) throws ValidationException {
        if (this._vendor == null) {
            throw new ValidationException("Component type must define a vendor.");
        }
        if (this._type == null) {
            throw new ValidationException("Component type must define a type identifier.");
        }
        writer.writeTag("vendor", this._vendor);
        writer.writeTag("type", this._type);
        if (this._subtype != null) {
            writer.writeTag("sub-type", this._subtype);
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ComponentType) {
            ComponentType tp = (ComponentType)obj;
            boolean equals = true;
            equals &= this._type != null ? this._type.equals(tp._type) : tp._type == null;
            equals &= this._vendor != null ? this._vendor.equals(tp._vendor) : tp._vendor == null;
            return equals &= this._subtype != null ? this._subtype.equals(tp._subtype) : tp._subtype == null;
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = this._type != null ? 37 * result + this._type.hashCode() : result;
        result = this._vendor != null ? 37 * result + this._vendor.hashCode() : result;
        result = this._subtype != null ? 37 * result + this._subtype.hashCode() : result;
        return result;
    }
}

