/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.complib;

import com.sap.tc.complib.ComponentType;
import com.sap.tc.complib.DCReference;
import com.sap.tc.complib.Dependency;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.Entity;
import com.sap.tc.complib.ImportedEntity;
import com.sap.tc.complib.PPReference;
import com.sap.tc.complib.Property;
import com.sap.tc.complib.PublicPart;
import com.sap.tc.complib.SoftwareComponent;
import com.sap.tc.complib.impl.DependencyImpl;
import com.sap.tc.complib.impl.DevelopmentComponentImpl;
import com.sap.tc.complib.impl.EntityImpl;
import com.sap.tc.complib.impl.ImportedEntityImpl;
import com.sap.tc.complib.impl.PropertyImpl;
import com.sap.tc.complib.impl.PublicPartImpl;
import com.sap.tc.complib.impl.SoftwareComponentImpl;
import com.sap.tc.complib.provider.DCInputProvider;
import com.sap.tc.complib.provider.DCOutputProvider;
import com.sap.tc.complib.provider.PPInputProvider;
import com.sap.tc.complib.provider.PPOutputProvider;
import com.sap.tc.complib.provider.ProviderException;
import com.sap.tc.complib.provider.SCInputProvider;
import com.sap.tc.complib.provider.SCOutputProvider;
import com.sap.tc.complib.xml.XMLException;
import java.io.IOException;
import java.util.Arrays;

public class ComponentFactory {
    public static final String SCHEMA_VERSION_1_0_0 = "1.0.0";
    public static final String SCHEMA_VERSION_1_0_1 = "1.0.1";
    public static final String SCHEMA_VERSION_1_0_2 = "1.0.2";
    public static final String SCHEMA_VERSION = "1.0.2";

    public static String[] getSchemaVersions() {
        return new String[]{SCHEMA_VERSION_1_0_0, SCHEMA_VERSION_1_0_1, "1.0.2"};
    }

    public static boolean isSchemaAllowed(String schemaVersion) {
        return schemaVersion != null && Arrays.binarySearch(ComponentFactory.getSchemaVersions(), schemaVersion) >= 0;
    }

    public static DevelopmentComponent createDevelopmentComponent() {
        return new DevelopmentComponentImpl();
    }

    public static DevelopmentComponent createDevelopmentComponent(String name, String vendor, ComponentType componentType) {
        DevelopmentComponent dc = ComponentFactory.createDevelopmentComponent();
        dc.setName(name);
        dc.setVendor(vendor);
        dc.setComponentType(componentType);
        return dc;
    }

    public static Property createProperty() {
        return new PropertyImpl();
    }

    public static Property createProperty(String propertyName, DevelopmentComponent parent) {
        Property property = ComponentFactory.createProperty();
        property.setName(propertyName);
        if (parent.getProperties() == null) {
            parent.emptyProperties();
        }
        parent.getProperties().add(property);
        return property;
    }

    public static Property createProperty(String propertyName, String namespacePrefix, String namespaceURI, DevelopmentComponent parent) {
        Property property = ComponentFactory.createProperty();
        property.setName(propertyName);
        property.setNamespace(namespacePrefix, namespaceURI);
        if (parent.getProperties() == null) {
            parent.emptyProperties();
        }
        parent.getProperties().add(property);
        return property;
    }

    public static PublicPart createPublicPart() {
        return new PublicPartImpl();
    }

    public static PublicPart createPublicPart(String publicPartName, DevelopmentComponent parent) {
        PublicPart publicPart = ComponentFactory.createPublicPart();
        publicPart.setName(publicPartName);
        if (parent.getPublicParts() == null) {
            parent.emptyPublicParts();
        }
        parent.getPublicParts().put(publicPartName, publicPart);
        return publicPart;
    }

    public static Entity createEntity() {
        return new EntityImpl();
    }

    public static Entity createEntity(String entityName, String entityType, PublicPart publicPart) {
        Entity entity = ComponentFactory.createEntity();
        entity.setName(entityName);
        entity.setType(entityType);
        if (publicPart.getEntities() == null) {
            publicPart.emptyEntities();
        }
        publicPart.getEntities().add(entity);
        return entity;
    }

    public static ImportedEntity createImportedEntity() {
        return new ImportedEntityImpl();
    }

    public static ImportedEntity createImportedEntity(String entityName, String entityType, PublicPart publicPart) {
        ImportedEntity entity = ComponentFactory.createImportedEntity();
        entity.setName(entityName);
        entity.setType(entityType);
        if (publicPart.getImportedEntities() == null) {
            publicPart.emptyImportedEntities();
        }
        publicPart.getImportedEntities().add(entity);
        return entity;
    }

    public static Dependency createDependency() {
        return new DependencyImpl();
    }

    public static Dependency createDependency(DCReference ref, DevelopmentComponent parent) {
        Dependency dependency = ComponentFactory.createDependency();
        dependency.setComponent(ref);
        if (parent.getDependencies() == null) {
            parent.emptyDependencies();
        }
        parent.getDependencies().add(dependency);
        return dependency;
    }

    public static Dependency createDependency(PPReference ref, DevelopmentComponent parent) {
        Dependency dependency = ComponentFactory.createDependency(ref.getComponent(), parent);
        dependency.setPublicPart(ref.getName());
        return dependency;
    }

    public static SoftwareComponent createSoftwareComponent() {
        return new SoftwareComponentImpl();
    }

    public static SoftwareComponent createSoftwareComponent(String name, String vendor) {
        SoftwareComponent sc = ComponentFactory.createSoftwareComponent();
        sc.setName(name);
        sc.setVendor(vendor);
        return sc;
    }

    public static void serialize(DevelopmentComponent component, DCOutputProvider provider) throws IOException, ProviderException {
        component.serialize(provider);
    }

    public static void serialize(PublicPart publicPart, PPOutputProvider provider) throws IOException, ProviderException {
        publicPart.serialize(provider);
    }

    public static void serialize(SoftwareComponent component, SCOutputProvider provider) throws IOException, ProviderException {
        component.serialize(provider);
    }

    public static DevelopmentComponent initialize(DCInputProvider provider) throws IOException, XMLException, ProviderException {
        DevelopmentComponent DC = ComponentFactory.createDevelopmentComponent();
        DC.initialize(provider);
        return DC;
    }

    public static DevelopmentComponent initialize(DCInputProvider provider, boolean withPPs) throws IOException, XMLException, ProviderException {
        DevelopmentComponent DC = ComponentFactory.createDevelopmentComponent();
        DC.initialize(provider, withPPs);
        return DC;
    }

    public static PublicPart initialize(PPInputProvider provider) throws IOException, XMLException, ProviderException {
        PublicPart pp = ComponentFactory.createPublicPart();
        pp.initialize(provider);
        return pp;
    }

    public static SoftwareComponent initialize(SCInputProvider provider) throws IOException, XMLException, ProviderException {
        SoftwareComponent SC = ComponentFactory.createSoftwareComponent();
        SC.initialize(provider);
        return SC;
    }
}

