/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.frame.core.locking;

import com.sap.engine.frame.core.locking.TimeStatisticsEntry;
import com.sap.engine.frame.core.locking.Util;

public class TimeStatisticsHelper {
    private static final Util UTIL = new Util();
    private static final String HEADER_DESCRIPTION = "description";
    private static final String HEADER_AVERAGE = "average";
    private static final String HEADER_MIN = "min";
    private static final String HEADER_MAX = "max";
    private static final String HEADER_COUNTS = "count";

    public String formatTimeStatisticsEntry(TimeStatisticsEntry[] entries, boolean detail) {
        StringBuffer result = new StringBuffer(1024);
        int maxDescriptionLength = HEADER_DESCRIPTION.length();
        long maxAverageDelta = 0L;
        long maxMinDelta = 0L;
        long maxMaxDelta = 0L;
        long maxCounts = 0L;
        int i = 0;
        while (i < entries.length) {
            maxDescriptionLength = Math.max(maxDescriptionLength, entries[i].getDescription().length());
            maxAverageDelta = Math.max(maxAverageDelta, entries[i].getAverageDelta());
            maxMinDelta = Math.max(maxMinDelta, entries[i].getMinDelta());
            maxMaxDelta = Math.max(maxMaxDelta, entries[i].getMaxDelta());
            maxCounts = Math.max(maxCounts, entries[i].getCounts());
            ++i;
        }
        int maxAverageDeltaLength = Math.max(HEADER_AVERAGE.length(), Long.toString(maxAverageDelta).length());
        int maxMinDeltaLength = Math.max(HEADER_MIN.length(), Long.toString(maxMinDelta).length());
        int maxMaxDeltaLength = Math.max(HEADER_MAX.length(), Long.toString(maxMaxDelta).length());
        int maxCountsLength = Math.max(HEADER_COUNTS.length(), Long.toString(maxCounts).length());
        String header = detail ? UTIL.adjustStringLengthRight(HEADER_DESCRIPTION, maxDescriptionLength, ' ') + " | " + UTIL.adjustStringLengthLeft(HEADER_AVERAGE, maxAverageDeltaLength, ' ') + " | " + UTIL.adjustStringLengthLeft(HEADER_MIN, maxMinDeltaLength, ' ') + " | " + UTIL.adjustStringLengthLeft(HEADER_MAX, maxMaxDeltaLength, ' ') + " | " + UTIL.adjustStringLengthLeft(HEADER_COUNTS, maxCountsLength, ' ') : UTIL.adjustStringLengthRight(HEADER_DESCRIPTION, maxDescriptionLength, ' ') + " | " + UTIL.adjustStringLengthLeft(HEADER_AVERAGE, maxAverageDeltaLength, ' ');
        result.append(header).append('\n');
        result.append(UTIL.adjustStringLengthRight("", header.length(), '-')).append('\n');
        int i2 = 0;
        while (i2 < entries.length) {
            TimeStatisticsEntry next = entries[i2];
            String description = UTIL.adjustStringLengthRight(next.getDescription(), maxDescriptionLength, ' ');
            String averageDelta = UTIL.adjustStringLengthLeft(Long.toString(next.getAverageDelta()), maxAverageDeltaLength, ' ');
            String minDelta = UTIL.adjustStringLengthLeft(Long.toString(next.getMinDelta()), maxMinDeltaLength, ' ');
            String maxDelta = UTIL.adjustStringLengthLeft(Long.toString(next.getMaxDelta()), maxMaxDeltaLength, ' ');
            String counts = UTIL.adjustStringLengthLeft(Long.toString(next.getCounts()), maxCountsLength, ' ');
            if (detail) {
                result.append(description + " | " + averageDelta + " | " + minDelta + " | " + maxDelta + " | " + counts).append('\n');
            } else {
                result.append(description + " | " + averageDelta).append('\n');
            }
            ++i2;
        }
        return result.toString();
    }
}

