/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.frame.core.load.gui;

import java.io.File;
import java.io.Serializable;

public class ItemInfo
implements Serializable {
    private String fullName;
    private String shortName;
    private byte type;

    private ItemInfo() {
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public byte getType() {
        return this.type;
    }

    public boolean isComponent() {
        return this.type == 1 || this.type == 2 || this.type == 3 || this.type == 5 || this.type == 4;
    }

    public boolean isResource() {
        return this.type == 10 || this.type == 11;
    }

    public static ItemInfo[] parseComponents(String[] names) {
        if (names == null) {
            return null;
        }
        ItemInfo[] result = new ItemInfo[names.length];
        int i = 0;
        while (i < names.length) {
            result[i] = ItemInfo.parseComponent(names[i]);
            ++i;
        }
        return result;
    }

    public static ItemInfo parseComponent(String fullName) {
        if (fullName == null) {
            return null;
        }
        ItemInfo result = new ItemInfo();
        result.fullName = fullName;
        if (fullName.startsWith("service:")) {
            result.type = (byte)3;
            result.shortName = fullName.substring("service:".length());
        } else if (fullName.startsWith("library:")) {
            result.type = (byte)2;
            result.shortName = fullName.substring("library:".length());
        } else if (fullName.startsWith("interface:")) {
            result.type = 1;
            result.shortName = fullName.substring("interface:".length());
        } else if (fullName.startsWith("common:")) {
            result.type = (byte)5;
            result.shortName = fullName.substring("common:".length());
        } else {
            result.type = (byte)4;
            result.shortName = fullName;
        }
        return result;
    }

    public static ItemInfo[] parseResources(String[] names) {
        if (names == null) {
            return null;
        }
        ItemInfo[] result = new ItemInfo[names.length];
        int i = 0;
        while (i < names.length) {
            result[i] = ItemInfo.parseResource(names[i]);
            ++i;
        }
        return result;
    }

    public static ItemInfo parseResource(String fullName) {
        if (fullName == null) {
            return null;
        }
        File file = new File(fullName);
        ItemInfo result = new ItemInfo();
        result.shortName = file.getName();
        result.fullName = fullName;
        String lowerCaseName = result.shortName.toLowerCase();
        result.type = lowerCaseName.endsWith(".jar") || lowerCaseName.endsWith(".zip") ? (byte)10 : (byte)11;
        return result;
    }

    public static String getComponentPrefix(byte type) {
        switch (type) {
            case 1: {
                return "interface:";
            }
            case 2: {
                return "library:";
            }
            case 3: {
                return "service:";
            }
            case 5: {
                return "common:";
            }
        }
        return "";
    }
}

