/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.notification;

import com.sapportals.portal.prt.service.notification.FileData;
import com.sapportals.portal.prt.service.notification.NotificationStringBufferPool;
import com.sapportals.portal.prt.service.notification.StreamData;
import com.sapportals.portal.prt.service.notification.TopicData;
import com.sapportals.portal.prt.service.notification.TopicType;
import com.sapportals.portal.prt.util.RecyclableStringBuffer;
import com.sapportals.portal.prt.util.SmartBuffer;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class TopicDataContainer {
    private static final String HASH_PROPERTY = "hash";
    private static final char SPECIAL_CHARACTER = '#';
    private static final String VALUE_8859_1 = "8859_1";
    private static final char SAPCE_CHARACTER = ' ';
    private static final String CONTENT_TYPE_PROPERTY = "Content-Type: ";
    private static final String SIMPLE_EOF_CHARACTER = "\"\r\n";
    private static final String NAME_PROPERTY = "name=\"";
    private static final String CONTENT_DISPOSITION_PROPERTY = "content-disposition: ";
    private static final String DOUBLE_EOF_CHARACTER = "\r\n\r\n";
    private static final String FILENAME_TYPE_STRING = "\"; filename=\"";
    private static final String END_BRACKET_CHARACTER = "}";
    private static final String EQUAL_CHARACTER = "=";
    private static final String EQUALS_CHARACTER_AND_BRACKET = "={";
    private String mm_topicName;
    private HashMap mm_topicDataList = new HashMap();
    public static final TopicType STRING = new TopicType("string");
    public static final TopicType INT = new TopicType("int");
    public static final TopicType STREAM = new TopicType("stream");
    public static final TopicType FILE = new TopicType("file");
    public static final String BOUNDARY = "BOUNDARY";
    public static final String TOPIC_NAME = "TOPICNAME";
    public static final String BOUNDARY_LINE = "--BOUNDARY\r\n";
    private final byte[] END_LINE_BYTES = "\r\n".getBytes();
    private final String CONTENT_DIPOSITION_INLINE = "inline;";
    private final String CONTENT_DIPOSITION_FORM = "form-data;";
    private final String CONTENT_TYPE_ZIP = "application/zip";
    private final String CONTENT_TYPE_TEXT = "text/plain";
    private final String CONTENT_TYPE_OCTET = "application/octet-stream";
    private final byte[] HASH_DELIMITER = ", ".getBytes();
    private final byte[] END_BOUNDARY_BYTES = "--BOUNDARY--".getBytes();

    public TopicDataContainer(String topicName) {
        this.mm_topicName = topicName;
    }

    public void addTopicData(String key, String data) {
        this.mm_topicDataList.put(key, new TopicData(STRING, data));
    }

    public void addTopicData(String key, TopicData data) {
        this.mm_topicDataList.put(key, data);
    }

    public void removeTopicData(String key) {
        this.mm_topicDataList.remove(key);
    }

    public void updateTopicName(String topicName) {
        this.mm_topicName = topicName;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream byteOutPut = new ByteArrayOutputStream();
        byte[] dataContainer = null;
        try {
            this.convertContainer(byteOutPut);
            dataContainer = byteOutPut.toByteArray();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dataContainer;
    }

    public String getTopicName() {
        return this.mm_topicName;
    }

    public Enumeration getTopicDataKeys() {
        Vector v = new Vector();
        Iterator iter = this.mm_topicDataList.keySet().iterator();
        while (iter.hasNext()) {
            v.add(iter.next());
        }
        return v.elements();
    }

    public Enumeration getTopicDataValues() {
        Vector v = new Vector();
        Iterator iter = this.mm_topicDataList.values().iterator();
        while (iter.hasNext()) {
            v.add(iter.next());
        }
        return v.elements();
    }

    public TopicData getTopicDataValue(String key) {
        return (TopicData)this.mm_topicDataList.get(key);
    }

    private void addPart(String name, String type, String contentdisposition, byte[] values, OutputStream outstream) throws IOException {
        this.writePartLine(name, type, contentdisposition, outstream);
        outstream.write(values);
        outstream.write(this.END_LINE_BYTES);
        outstream.flush();
    }

    private void writePartLine(String name, String type, String contentdisposition, OutputStream outstream) throws IOException {
        RecyclableStringBuffer rbuffer = NotificationStringBufferPool.getInstance().get(8192);
        SmartBuffer buffer = rbuffer.getBuffer();
        buffer.append(BOUNDARY_LINE);
        buffer.append(CONTENT_DISPOSITION_PROPERTY);
        buffer.append(contentdisposition);
        buffer.append(' ');
        buffer.append(NAME_PROPERTY);
        buffer.append(name);
        buffer.append(SIMPLE_EOF_CHARACTER);
        buffer.append(CONTENT_TYPE_PROPERTY);
        buffer.append(type);
        buffer.append(DOUBLE_EOF_CHARACTER);
        outstream.write(buffer.toString().getBytes());
        NotificationStringBufferPool.getInstance().release(rbuffer);
    }

    /*
     * WARNING - void declaration
     */
    private void addPart(String name, String type, String contentdisposition, InputStream stream, OutputStream outstream) throws IOException {
        int read;
        this.writePartLine(name, type, contentdisposition, outstream);
        byte[] buf = new byte[8192];
        while ((read = stream.read(buf)) != -1) {
            void var6_7;
            outstream.write(buf, 0, (int)var6_7);
        }
        outstream.write(this.END_LINE_BYTES);
        outstream.flush();
    }

    public void convertContainer(ByteArrayOutputStream outPut2) throws IOException {
        ByteArrayOutputStream topicdatastream_ = new ByteArrayOutputStream(8192);
        BufferedOutputStream topicdataContainerstreamBuffered = new BufferedOutputStream(outPut2);
        BufferedOutputStream topicdatastreamBuffered = new BufferedOutputStream(topicdatastream_);
        BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter((OutputStream)topicdatastreamBuffered, VALUE_8859_1));
        awriter.write(35);
        awriter.write(new Date().toString());
        awriter.newLine();
        Enumeration k = this.getTopicDataKeys();
        Enumeration v = this.getTopicDataValues();
        RecyclableStringBuffer rbuffer = NotificationStringBufferPool.getInstance().get(8192);
        SmartBuffer buffer = rbuffer.getBuffer();
        while (k.hasMoreElements()) {
            String key = k.nextElement().toString();
            TopicData data = (TopicData)v.nextElement();
            String type = data.getTopicType().toString();
            if (((Object)((Object)data.getTopicType())).equals((Object)STREAM)) {
                StreamData stream = (StreamData)data;
                this.addPart(key, "application/zip", "inline;", stream.getInputStream(), (OutputStream)topicdataContainerstreamBuffered);
                continue;
            }
            if (((Object)((Object)data.getTopicType())).equals((Object)FILE)) {
                FileData file = (FileData)data;
                buffer.reset();
                buffer.append(key);
                buffer.append(FILENAME_TYPE_STRING);
                buffer.append(file.getFilePath());
                this.addPart(buffer.toString(), "application/zip", "inline;", file.getInputStream(), (OutputStream)topicdataContainerstreamBuffered);
                continue;
            }
            buffer.reset();
            buffer.append(key);
            buffer.append(EQUALS_CHARACTER_AND_BRACKET);
            buffer.append(type);
            buffer.append(EQUAL_CHARACTER);
            buffer.append(data.getTopicValue());
            buffer.append(END_BRACKET_CHARACTER);
            awriter.write(buffer.toString());
            awriter.newLine();
        }
        NotificationStringBufferPool.getInstance().release(rbuffer);
        topicdataContainerstreamBuffered.flush();
        topicdatastreamBuffered.flush();
        this.addPart(TOPIC_NAME, "text/plain", "form-data;", this.getTopicName().getBytes(), (OutputStream)topicdataContainerstreamBuffered);
        awriter.flush();
        topicdatastreamBuffered.flush();
        this.addPart(HASH_PROPERTY, "application/octet-stream", "form-data;", topicdatastream_.toByteArray(), (OutputStream)topicdataContainerstreamBuffered);
        topicdataContainerstreamBuffered.write(this.END_BOUNDARY_BYTES);
        topicdataContainerstreamBuffered.flush();
        awriter.close();
        topicdatastream_.close();
        topicdatastreamBuffered.close();
        awriter = null;
        topicdatastreamBuffered = null;
        Object var2_2 = null;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(256);
        result.append("TopicName : " + this.getTopicName() + "\n");
        Enumeration k = this.getTopicDataKeys();
        Enumeration v = this.getTopicDataValues();
        while (k.hasMoreElements()) {
            String key = k.nextElement().toString();
            TopicData topicData = (TopicData)v.nextElement();
            TopicType type = topicData.getTopicType();
            if (((Object)((Object)type)).equals((Object)FILE)) {
                FileData f = (FileData)topicData;
                result.append(key + " : " + f.getFilePath() + " (" + type.toString() + ")\n");
                continue;
            }
            if (((Object)((Object)type)).equals((Object)STREAM)) {
                result.append(key + " (" + type.toString() + ")\n");
                continue;
            }
            result.append(key + " : " + topicData.getTopicValue() + " (" + type.toString() + ")\n");
        }
        return result.toString();
    }
}

