/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.projectbrowser.views;

import com.sap.dictionary.projectbrowser.ProjectBrowserPlugin;
import com.sap.dictionary.projectbrowser.actions.PBCopyAction;
import com.sap.dictionary.projectbrowser.actions.PBDeleteAction;
import com.sap.dictionary.projectbrowser.actions.PBDeleteDbTableAction;
import com.sap.dictionary.projectbrowser.actions.PBDeleteDbViewAction;
import com.sap.dictionary.projectbrowser.actions.PBDeleteSimpletypeAction;
import com.sap.dictionary.projectbrowser.actions.PBDeleteStructureAction;
import com.sap.dictionary.projectbrowser.actions.PBPasteAction;
import com.sap.dictionary.projectbrowser.filters.DictionaryFilter;
import com.sap.dictionary.projectbrowser.services.ServicesProjectBrowser;
import com.sap.dictionary.projectbrowser.tree.DictionarySorter;
import com.sap.dictionary.projectbrowser.tree.PBDoubleClickListener;
import com.sap.dictionary.projectbrowser.tree.ProjectBrowserTreeLabels;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.dictionary.tools.ui.image.DictionaryImage;
import com.sap.ide.login.LoginListener;
import com.sap.ide.login.UserValidator;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.editor.IDevelopmentObjectEditor;
import com.sap.ide.metamodel.core.generation.IGenerationTransactionManager;
import com.sap.ide.metamodel.core.plugin.DtrHelper;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.core.selectionconverter.ProjectSelectionConverter;
import com.sap.ide.metamodel.core.services.MetamodelImage;
import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.metamodel.dictionary.datatype.DtDataType;
import com.sap.ide.metamodel.dictionary.datatype.DtDbIndex;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.dictionary.datatype.DtDbView;
import com.sap.ide.metamodel.dictionary.datatype.DtGeneralStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.general.CommitResult;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.MetamodelObject;
import com.sap.ide.metamodel.general.RollbackResult;
import com.sap.ide.metamodel.general.clipboard.MetamodelClipboard;
import com.tssap.dii.component.DCToolbox;
import com.tssap.dii.dtri.actions.file.FileAddAction;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.DAVTeamProvider;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityListener;
import com.tssap.dtr.client.lib.vfs.VfsActivityState;
import com.tssap.selena.impl.model.elements.EntityImpl;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.ModelUtilPlugin;
import com.tssap.selena.model.extension.filter.FilterFactory;
import com.tssap.selena.model.extension.filter.IFilter;
import com.tssap.selena.model.extension.filter.IMutableFilterSet;
import com.tssap.selena.model.extension.ui.treeviewer.GenericDataModelFilteredTreeViewer;
import com.tssap.util.action.path.ContextDependentPathProvider;
import com.tssap.util.action.path.IPathProvider;
import com.tssap.util.ui.LabelProviderContainer;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.menu.IMenuFactory;
import com.tssap.util.ui.menu.MenuFactory;
import com.tssap.util.ui.menu.context.DynamicContextMenu;
import com.tssap.util.ui.menu.context.IContextMenu;
import com.tssap.util.ui.viewer.sorter.IViewerSorterContainer;
import com.tssap.util.ui.viewer.sorter.ViewerSorterContainer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.ui.actions.OpenProjectAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.part.ViewPart;

public class ProjectBrowserView
extends ViewPart
implements IPartListener {
    private GenericDataModelFilteredTreeViewer mTreeViewer;
    private IMutableFilterSet mMutableFilterSet;
    protected static String DDFILTER = "Dictionary objects";
    protected static String FILTER_DC = "Development Component";
    protected static String FILTER_CONFIGURATION_FILE = "ConfigurationFile";
    private Action copyAction;
    private Action pasteAction;
    public static Properties properties = new Properties();
    public static String propOptimisticChildCheck = "Optimistic children check";
    public static String propHideDeletedTables = "Hide deleted tables";
    public static String propHideDcStuff = "Hide dc labels";
    public static String propLinkToEditor = "Link with Editor";
    public static String PROP_PROJECT_NAME = "PropertyProjectName";
    public static String PROP_DOMAIN = "PropertyDomain";
    public static String PROP_SUBDOMAIN = "PropertySubdomain";
    public static String PROP_LOCATION = "PropertyLocation";
    public static String PROP_NAME = "PropertyName";
    private static ILabelProvider dcSpecialLabelProvider = DCToolbox.getDCMetaDataLabelProvider();
    private static ProjectBrowserTreeLabels pbTreeLabels = new ProjectBrowserTreeLabels();
    private LabelProviderContainer labelManager;
    private IToolBarManager mToolBarManager;
    private Element mSelectedElement = null;
    private Entity mEditorEntity = null;
    private boolean mShouldLinkWithEditor = false;
    private IViewerSorterContainer viewerSorterContainer;
    long lastTime = System.currentTimeMillis();
    IAction mCloseAction;
    IAction mOpenAction;

    public ProjectBrowserView() {
        this.initFilterManager();
        this.readProperties();
        MetamodelManager.registerGenerationTransactionManager((IGenerationTransactionManager)new IGenerationTransactionManager(){

            public void commitNotification(String projectName, CommitResult commitContext) {
                MainDevelopmentObject[] newMdos = commitContext.getCreatedMDOs();
                Vector<Element> vElements = new Vector<Element>();
                int i = 0;
                while (i < newMdos.length) {
                    UniqueName dbTableUname;
                    Element element;
                    UniqueName uname;
                    Model lModel;
                    DAVTeamProvider teamProvider;
                    IProject project;
                    if ((newMdos[i] instanceof DtDbTable || newMdos[i] instanceof DtDbIndex) && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(newMdos[i].getMetamodel().getName())) != null && (teamProvider = BluebirdPlugin.getDAVTeamProvider((IResource)project)) != null && (DtrHelper.isUserLoggedOn((IProject)project) || DtrHelper.logon((IProject)project)) && (lModel = ModelAccess.getModel((UniqueName)(uname = ModelAccess.createModelUniqueName((String)newMdos[i].getMetamodel().getName())))) != null && (element = lModel.findElement(dbTableUname = DataSourceManager.createUniqueName((DevelopmentObject)newMdos[i], (String)"DbTable", (String)"Local Dictionary"))) != null) {
                        vElements.add(element);
                    }
                    ++i;
                }
                if (vElements.size() > 0) {
                    Element[] elements = vElements.toArray(new Element[0]);
                    FileAddAction addAction = new FileAddAction();
                    addAction.run(elements);
                }
            }

            public void rollbackNotification(String projectName, RollbackResult rollbackContext) {
            }
        });
    }

    private void readProperties() {
        try {
            File f = new File(ProjectBrowserPlugin.getDefault().getStateLocation() + "/prop.txt");
            if (f.exists()) {
                FileInputStream in = new FileInputStream(f);
                properties.load(in);
                in.close();
            }
        }
        catch (Exception e) {
            ProjectBrowserPlugin.tracer.error("load properties:", (Throwable)e);
        }
    }

    private void saveProperties() {
        try {
            FileOutputStream out = new FileOutputStream(ProjectBrowserPlugin.getDefault().getStateLocation() + "/prop.txt");
            properties.store(out, "project_explorer");
            out.close();
        }
        catch (Exception e) {
            ProjectBrowserPlugin.tracer.error("save properties:", (Throwable)e);
        }
    }

    protected void initFilterManager() {
        this.mMutableFilterSet = FilterFactory.createOrFilterSet();
        DictionaryFilter ddProjectFilter = new DictionaryFilter();
        ddProjectFilter.setName(DDFILTER);
        this.mMutableFilterSet.addFilter((IFilter)ddProjectFilter);
        IFilter filter = DCToolbox.getDCMetaDataFilter();
        this.mMutableFilterSet.addFilter(filter);
    }

    public void createPartControl(Composite parent) {
        final GenericDataModelFilteredTreeViewer viewer = new GenericDataModelFilteredTreeViewer(parent, ModelUtilPlugin.computeModels(), (IFilter)this.mMutableFilterSet){

            protected void setViewer(StructuredViewer viewer) {
                viewer = new TreeViewer(this, ((TreeViewer)viewer).getTree()){
                    HashMap lastTime;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                        this.lastTime = new HashMap<K, V>();
                    }

                    protected void doUpdateItem(Item item, Object element) {
                        ILabelProvider labelProvider;
                        long time = System.currentTimeMillis();
                        if (element != null && this.lastTime.get(element) != null && time - (Long)this.lastTime.get(element) < 500L && (labelProvider = (ILabelProvider)this.getLabelProvider()).getText(element).equals(item.getText())) {
                            return;
                        }
                        super.doUpdateItem(item, element);
                        if (element != null) {
                            this.lastTime.put(element, new Long(System.currentTimeMillis()));
                        }
                    }
                };
                super.setViewer(viewer);
            }
        };
        this.labelManager = new LabelProviderContainer();
        if (((Hashtable)properties).containsKey(propHideDcStuff)) {
            Boolean ret = new Boolean((String)((Hashtable)properties).get(propHideDcStuff));
            if (!ret.booleanValue()) {
                this.labelManager.addLabelProvider(dcSpecialLabelProvider);
            }
        } else {
            this.labelManager.addLabelProvider(dcSpecialLabelProvider);
        }
        this.labelManager.addLabelProvider((ILabelProvider)pbTreeLabels);
        viewer.getTreeViewer().setLabelProvider((IBaseLabelProvider)this.labelManager);
        viewer.setOptimisticChildrenCheck(false);
        viewer.setDissolveReferences(false);
        viewer.setSkipReferenceCollections(true);
        viewer.setSkipReferences(true);
        viewer.getTreeViewer().addDoubleClickListener((IDoubleClickListener)new PBDoubleClickListener());
        this.setDragDrop(viewer);
        viewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u007f') {
                    IStructuredSelection sel = viewer.getCurrentViewerContext().getStructuredSelection();
                    Object[] els = sel.toArray();
                    int i = 0;
                    while (i < els.length) {
                        Entity entity;
                        if (els[i] instanceof Entity && ServicesProjectBrowser.elementBelongsToValidProject((Element)(entity = (Entity)els[i]))) {
                            String metaclass = entity.getPropertyValue("$metaclass");
                            Element[] elements = new Element[]{entity};
                            if (metaclass.equals("DDSimpleType")) {
                                PBDeleteSimpletypeAction deleteStAction = new PBDeleteSimpletypeAction();
                                deleteStAction.run(elements);
                            } else if (metaclass.equals("Model")) {
                                PBDeleteAction deleteAction = new PBDeleteAction();
                                deleteAction.run(elements);
                            } else if (metaclass.equals("DDDbTable")) {
                                PBDeleteDbTableAction deleteDbTableAction = new PBDeleteDbTableAction();
                                deleteDbTableAction.run(elements);
                            } else if (metaclass.equals("DDStructure")) {
                                PBDeleteStructureAction deleteStructureAction = new PBDeleteStructureAction();
                                deleteStructureAction.run(elements);
                            } else if (metaclass.equals("DDDbView")) {
                                PBDeleteDbViewAction deleteDbViewAction = new PBDeleteDbViewAction();
                                deleteDbViewAction.run(elements);
                            }
                        }
                        ++i;
                    }
                }
            }
        });
        viewer.getTreeViewer().setSorter((ViewerSorter)this.getViewerSorterContainer());
        this.setTreeViewer(viewer);
        MenuFactory menuFactory = new MenuFactory();
        menuFactory.getPathProviderManager().addPathProvider((IPathProvider)new ContextDependentPathProvider(false));
        DynamicContextMenu contextMenu = new DynamicContextMenu((IMenuFactory)menuFactory);
        this.getTreeViewer().setContextMenu((IContextMenu)contextMenu);
        this.getSite().setSelectionProvider((ISelectionProvider)new ProjectSelectionConverter(this.mTreeViewer.getTreeViewer()));
        this.setViewMenu(viewer);
        this.setTitleImage(SapIdeUtilImages.getSapImage((ISapImage)DictionaryImage.ICON_DICTIONARY));
        this.setSystemMenuEntries(viewer);
        this.addActivityListener();
        this.addPartListener();
        this.getTreeViewer().getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)new TreeSelectionListener());
        String projectName = null;
        String domain = null;
        String subdomain = null;
        String location = null;
        String name = null;
        if (((Hashtable)properties).containsKey(PROP_PROJECT_NAME)) {
            projectName = properties.getProperty(PROP_PROJECT_NAME);
        }
        if (((Hashtable)properties).containsKey(PROP_DOMAIN)) {
            domain = properties.getProperty(PROP_DOMAIN);
        }
        if (((Hashtable)properties).containsKey(PROP_SUBDOMAIN)) {
            subdomain = properties.getProperty(PROP_SUBDOMAIN);
        }
        if (((Hashtable)properties).containsKey(PROP_LOCATION)) {
            location = properties.getProperty(PROP_LOCATION);
        }
        if (((Hashtable)properties).containsKey(PROP_NAME)) {
            name = properties.getProperty(PROP_NAME);
        }
        UniqueName uniqueName = null;
        if (projectName != null && domain != null && subdomain != null && location != null && name != null) {
            uniqueName = ModelAccess.createUniqueName((String)domain, (String)subdomain, (String)location, (String)name, null);
            UniqueName modelUIN = ModelAccess.createModelUniqueName((String)projectName);
            Model model = ModelAccess.getModel((UniqueName)modelUIN);
            if (uniqueName != null && model != null) {
                this.mEditorEntity = model.findEntity(uniqueName);
                this.revealTree();
            }
        }
    }

    private IViewerSorterContainer getViewerSorterContainer() {
        if (this.viewerSorterContainer == null) {
            this.viewerSorterContainer = new ViewerSorterContainer();
            this.viewerSorterContainer.addViewerSorter((ViewerSorter)new DictionarySorter());
        }
        return this.viewerSorterContainer;
    }

    private void addPartListener() {
        WorkbenchWindow w = (WorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IPartService partService = w.getPartService();
        partService.addPartListener((IPartListener)this);
    }

    private void addActivityListener() {
        UserValidator.addLoginListener((boolean)false, (LoginListener)new LoginListener(){

            public void loginPerformed(UserValidator.Data loginData) {
                if (loginData.isOnline()) {
                    IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                    int i = 0;
                    while (i < projects.length) {
                        DAVTeamProvider teamProvider = BluebirdPlugin.getDAVTeamProvider((IResource)projects[i]);
                        if (teamProvider != null) {
                            IVersionedFileSystemManager manager = teamProvider.getVFSManager();
                            if (manager != null) {
                                manager.addActivityListener(new IVfsActivityListener(this){
                                    private final /* synthetic */ 5 this$1;
                                    {
                                        this.this$1 = this$1;
                                    }

                                    public void beforeCheckin(IVfsActivity arg0) {
                                    }

                                    public void created(IVfsActivity arg0) {
                                        ProjectBrowserView.access$200(5.access$100(this.this$1));
                                    }

                                    public void deleted(IVfsActivity arg0, VfsActivityState arg1) {
                                        ProjectBrowserView.access$200(5.access$100(this.this$1));
                                    }

                                    public void itemsAddedOrRemoved(IVfsActivity arg0) {
                                        ProjectBrowserView.access$200(5.access$100(this.this$1));
                                    }

                                    public void stateChanged(IVfsActivity arg0, VfsActivityState arg1) {
                                        ProjectBrowserView.access$200(5.access$100(this.this$1));
                                    }

                                    public void nameOrDescriptionChanged(IVfsActivity arg0) {
                                    }
                                });
                            } else {
                                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"Couldn't get Vfs Manager");
                            }
                        }
                        ++i;
                    }
                }
            }

            static /* synthetic */ ProjectBrowserView access$100(5 x0) {
                return x0.ProjectBrowserView.this;
            }
        });
    }

    private void refreshTree() {
        long time = System.currentTimeMillis();
        if (time - this.lastTime < 5000L) {
            this.lastTime = time;
            return;
        }
        if (!this.getTreeViewer().getTreeViewer().getTree().isDisposed()) {
            this.getTreeViewer().refresh();
            this.lastTime = System.currentTimeMillis();
        }
    }

    private void setDragDrop(GenericDataModelFilteredTreeViewer viewer) {
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        int operations = 3;
        DragSource source = new DragSource((Control)viewer.getTree(), operations);
        source.setTransfer(types);
        source.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                ISelection sel;
                ISelection selection = ProjectBrowserView.this.mTreeViewer.getTreeViewer().getSelection();
                if (selection instanceof IStructuredSelection && (sel = ProjectBrowserView.this.mTreeViewer.getTreeViewer().getSelection()) instanceof StructuredSelection) {
                    Iterator it = ((StructuredSelection)sel).iterator();
                    while (it.hasNext()) {
                        DtDataType dt;
                        Object obj = it.next();
                        if (!(obj instanceof Entity)) continue;
                        Entity entity = (Entity)obj;
                        String subdomain = entity.getUniqueName().getSubDomain();
                        if (!(subdomain.equals("DbTable") || subdomain.equals("SimpleType") || subdomain.equals("Structure") || subdomain.equals("DbView"))) {
                            event.doit = false;
                            return;
                        }
                        String projectName = entity.getModel().getUniqueName().getName();
                        DevelopmentObject devObj = DataSourceManager.getDataSourceManager((String)projectName).getDevelopmentObject(entity.getUniqueName());
                        if (!(devObj instanceof DtDataType) || !(dt = (DtDataType)devObj).hasLogicalDictionary()) continue;
                        event.doit = false;
                        return;
                    }
                }
                event.doit = true;
            }

            public void dragSetData(DragSourceEvent event) {
                ISelection sel;
                ISelection selection = ProjectBrowserView.this.mTreeViewer.getTreeViewer().getSelection();
                if (selection instanceof IStructuredSelection && (sel = ProjectBrowserView.this.mTreeViewer.getTreeViewer().getSelection()) instanceof StructuredSelection) {
                    Element[] elements = new Element[((StructuredSelection)sel).size()];
                    Iterator it = ((StructuredSelection)sel).iterator();
                    int i = 0;
                    while (it.hasNext()) {
                        elements[i] = (Element)it.next();
                        ++i;
                    }
                    if (ServicesProjectBrowser.elementsBelongToValidProject(elements)) {
                        new PBCopyAction().run(elements);
                    }
                }
                event.data = "Hallo";
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        DropTarget target = new DropTarget((Control)viewer.getTree(), operations);
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragOver(DropTargetEvent event) {
                super.dragOver(event);
                event.detail = event.item.getData() instanceof Model ? 1 : 0;
            }

            public void drop(DropTargetEvent event) {
                Object obj = event.item.getData();
                new PBPasteAction().run((Element)obj);
                event.detail = 0;
            }
        });
    }

    private void setViewMenu(GenericDataModelFilteredTreeViewer view) {
        String value;
        final GenericDataModelFilteredTreeViewer viewer = view;
        Action hideAction = new Action("Hide deleted tables"){

            public void run() {
                if (this.isChecked()) {
                    DictionaryFilter.mHideDeletedTables = true;
                    ((Hashtable)properties).put(propHideDeletedTables, new String("true"));
                } else {
                    DictionaryFilter.mHideDeletedTables = false;
                    ((Hashtable)properties).put(propHideDeletedTables, new String("false"));
                }
                ProjectBrowserView.this.getTreeViewer().refresh();
            }
        };
        if (((Hashtable)properties).containsKey(propHideDeletedTables)) {
            Boolean ret = new Boolean((String)((Hashtable)properties).get(propHideDeletedTables));
            DictionaryFilter.mHideDeletedTables = ret;
            hideAction.setChecked(ret.booleanValue());
        } else {
            hideAction.setChecked(false);
        }
        Action optimisticChildrenAction = new Action("Optimistic children check"){

            public void run() {
                super.run();
                if (this.isChecked()) {
                    ((Hashtable)properties).put(propOptimisticChildCheck, new String("true"));
                    viewer.setOptimisticChildrenCheck(true);
                } else {
                    ((Hashtable)properties).put(propOptimisticChildCheck, new String("false"));
                    viewer.setOptimisticChildrenCheck(false);
                }
            }
        };
        if (((Hashtable)properties).containsKey(propOptimisticChildCheck)) {
            Boolean ret = new Boolean((String)((Hashtable)properties).get(propOptimisticChildCheck));
            optimisticChildrenAction.setChecked(ret.booleanValue());
            viewer.setOptimisticChildrenCheck(ret.booleanValue());
        } else {
            optimisticChildrenAction.setChecked(false);
            viewer.setOptimisticChildrenCheck(false);
        }
        Action hideDcStuff = new Action("Hide icons"){

            public void run() {
                super.run();
                if (this.isChecked()) {
                    ((Hashtable)properties).put(propHideDcStuff, new String("true"));
                    ProjectBrowserView.this.labelManager.removeLabelProvider(dcSpecialLabelProvider);
                } else {
                    ((Hashtable)properties).put(propHideDcStuff, new String("false"));
                    ProjectBrowserView.this.labelManager = new LabelProviderContainer();
                    ProjectBrowserView.this.labelManager.addLabelProvider(dcSpecialLabelProvider);
                    ProjectBrowserView.this.labelManager.addLabelProvider((ILabelProvider)pbTreeLabels);
                    viewer.getTreeViewer().setLabelProvider((IBaseLabelProvider)ProjectBrowserView.this.labelManager);
                }
                ProjectBrowserView.this.getTreeViewer().refresh();
            }
        };
        if (((Hashtable)properties).containsKey(propHideDcStuff)) {
            Boolean ret = new Boolean((String)((Hashtable)properties).get(propHideDcStuff));
            hideDcStuff.setChecked(ret.booleanValue());
        } else {
            hideDcStuff.setChecked(false);
        }
        IMenuManager mgr = this.getViewSite().getActionBars().getMenuManager();
        mgr.add((IAction)hideAction);
        MenuManager subMenu = new MenuManager("Tree performance");
        subMenu.add((IAction)optimisticChildrenAction);
        subMenu.add((IAction)hideDcStuff);
        mgr.add((IContributionItem)subMenu);
        Action refreshAction = new Action(){

            public void run() {
                super.run();
                Display.getDefault().asyncExec(new Runnable(this){
                    private final /* synthetic */ 12 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        if (!12.access$700(this.this$1).getTreeViewer().getTreeViewer().getTree().isDisposed()) {
                            12.access$700(this.this$1).getTreeViewer().refresh();
                        }
                    }
                });
            }

            static /* synthetic */ ProjectBrowserView access$700(12 x0) {
                return x0.ProjectBrowserView.this;
            }
        };
        refreshAction.setImageDescriptor(SapIdeUtilImages.getSapImageDescriptor((ISapImage)MetamodelImage.ICON_REFRESH_ECLIPSE));
        refreshAction.setToolTipText("Refresh");
        CollapseAllAction collapseAllAction = new CollapseAllAction();
        ToggleLinkWithEditorAction toggleLinkWithEditorAction = new ToggleLinkWithEditorAction();
        if (((Hashtable)properties).containsKey(propLinkToEditor) && (value = (String)((Hashtable)properties).get(propLinkToEditor)).equals("true")) {
            toggleLinkWithEditorAction.setChecked(true);
            this.mShouldLinkWithEditor = true;
        }
        this.mToolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        this.mToolBarManager.add((IAction)refreshAction);
        this.mToolBarManager.add((IContributionItem)new Separator());
        this.mToolBarManager.add((IAction)collapseAllAction);
        this.mToolBarManager.add((IAction)toggleLinkWithEditorAction);
    }

    private void setSystemMenuEntries(GenericDataModelFilteredTreeViewer view) {
        final GenericDataModelFilteredTreeViewer viewer = view;
        this.mCloseAction = new Action(){

            public void run() {
                TreeItem[] items = viewer.getTree().getSelection();
                int i = 0;
                while (i < items.length) {
                    Model model;
                    String projectName;
                    Object obj = items[i].getData();
                    if (obj instanceof Model && (projectName = (model = (Model)obj).getUniqueName().getName()) != null && projectName.length() > 0) {
                        IProject eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                        try {
                            if (ServicesEclipse.closeProjectEditors((IProject)eclipseProject)) {
                                eclipseProject.close((IProgressMonitor)new NullProgressMonitor());
                            }
                        }
                        catch (CoreException e) {
                            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error", (String)("Could not close Project. Reason: " + e.getMessage() + "."));
                            ProjectBrowserPlugin.tracer.error("close project editors", (Throwable)e);
                        }
                    }
                    ++i;
                }
                this.setEnabled(this.isEnabled());
                ProjectBrowserView.this.mOpenAction.setEnabled(ProjectBrowserView.this.mOpenAction.isEnabled());
            }

            public boolean isEnabled() {
                return this.hasOpenProjects();
            }

            private boolean hasOpenProjects() {
                IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int i = 0;
                while (i < projects.length) {
                    if (projects[i].isOpen()) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
        };
        this.getViewSite().getActionBars().setGlobalActionHandler("closeProject", this.mCloseAction);
        this.mOpenAction = new Action(){

            public void run() {
                ProjectBrowserView.this.mTreeViewer.getTreeViewer().setSelection(null);
                OpenProjectAction action = new OpenProjectAction((IWorkbenchSite)ProjectBrowserView.this.getSite());
                action.run();
                this.setEnabled(this.isEnabled());
                ProjectBrowserView.this.mCloseAction.setEnabled(ProjectBrowserView.this.mCloseAction.isEnabled());
            }

            public boolean isEnabled() {
                return this.hasCloseProjects();
            }

            private boolean hasCloseProjects() {
                IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int i = 0;
                while (i < projects.length) {
                    if (!projects[i].isOpen()) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
        };
        this.getViewSite().getActionBars().setGlobalActionHandler("openProject", this.mOpenAction);
        this.copyAction = new Action(){

            public void run() {
                ISelection sel = viewer.getTreeViewer().getSelection();
                if (sel instanceof StructuredSelection) {
                    Element[] elements = new Element[((StructuredSelection)sel).size()];
                    Iterator it = ((StructuredSelection)sel).iterator();
                    int i = 0;
                    while (it.hasNext()) {
                        elements[i] = (Element)it.next();
                        ++i;
                    }
                    if (ServicesProjectBrowser.elementsBelongToValidProject(elements)) {
                        new PBCopyAction().run(elements);
                    }
                    ProjectBrowserView.this.pasteAction.setEnabled(true);
                }
            }
        };
        this.getViewSite().getActionBars().setGlobalActionHandler("copy", (IAction)this.copyAction);
        this.pasteAction = new Action(){

            public void run() {
                Element element;
                ISelection sel = viewer.getTreeViewer().getSelection();
                if (sel instanceof StructuredSelection && ServicesProjectBrowser.elementBelongsToValidProject(element = (Element)((StructuredSelection)sel).getFirstElement())) {
                    new PBPasteAction().run(element);
                }
            }
        };
        this.pasteAction.setEnabled(false);
        this.getViewSite().getActionBars().setGlobalActionHandler("paste", (IAction)this.pasteAction);
        viewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ISelection sel = viewer.getTreeViewer().getSelection();
                if (sel instanceof StructuredSelection) {
                    if (((StructuredSelection)sel).size() == 1) {
                        Element element = (Element)((StructuredSelection)sel).getFirstElement();
                        String projectName = element.getModel().getUniqueName().getName();
                        if (projectName != null && projectName.length() > 0) {
                            IProject eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                            if (eclipseProject != null) {
                                Metamodel metamodel = MetamodelManager.getMetamodel((String)projectName);
                                MetamodelClipboard clipboard = Metamodel.getClipboard();
                                if (clipboard.isPasteAllowed((MetamodelObject)DataSourceManager.getDataSourceManager((String)projectName).getDictionaryRoot())) {
                                    ProjectBrowserView.this.pasteAction.setEnabled(true);
                                } else {
                                    ProjectBrowserView.this.pasteAction.setEnabled(false);
                                }
                            } else {
                                ProjectBrowserView.this.pasteAction.setEnabled(false);
                            }
                        } else {
                            ProjectBrowserView.this.pasteAction.setEnabled(false);
                        }
                    } else {
                        ProjectBrowserView.this.pasteAction.setEnabled(false);
                    }
                    Iterator it = ((StructuredSelection)sel).iterator();
                    while (it.hasNext()) {
                        Element el = (Element)it.next();
                        if (!(el instanceof EntityImpl)) continue;
                        if (((EntityImpl)el).getUniqueName().getSubDomain().equals("DbTable") || ((EntityImpl)el).getUniqueName().getSubDomain().equals("SimpleType") || ((EntityImpl)el).getUniqueName().getSubDomain().equals("Structure") || ((EntityImpl)el).getUniqueName().getSubDomain().equals("DbView")) {
                            String projectName = el.getModel().getUniqueName().getName();
                            DevelopmentObject developmentObject = DataSourceManager.getDataSourceManager((String)projectName).getDevelopmentObject(el.getUniqueName());
                            if (!(developmentObject instanceof DtDataType)) continue;
                            DtDataType dt = (DtDataType)developmentObject;
                            if (dt.hasLogicalDictionary()) {
                                if (dt.getLogicalDictionary().equals("Local Dictionary")) {
                                    ProjectBrowserView.this.copyAction.setEnabled(true);
                                    continue;
                                }
                                ProjectBrowserView.this.copyAction.setEnabled(false);
                                continue;
                            }
                            ProjectBrowserView.this.copyAction.setEnabled(true);
                            continue;
                        }
                        ProjectBrowserView.this.copyAction.setEnabled(false);
                        return;
                    }
                } else {
                    ProjectBrowserView.this.copyAction.setEnabled(false);
                }
            }
        });
        this.getViewSite().getActionBars().updateActionBars();
    }

    public void partActivated(IWorkbenchPart part) {
        if (this.mShouldLinkWithEditor) {
            if (part == null) {
                return;
            }
            if (!(part instanceof IEditorPart)) {
                return;
            }
            DevelopmentObject developmentObject = ProjectBrowserView.getDevelopmentObjectFromEditor(part);
            if (developmentObject != null) {
                this.mEditorEntity = ProjectBrowserView.getEntityFromDevelopmentObject(developmentObject);
                this.revealTree();
            }
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
        if (part == null) {
            return;
        }
        if (!(part instanceof IEditorPart)) {
            return;
        }
        DevelopmentObject developmentObject = ProjectBrowserView.getDevelopmentObjectFromEditor(part);
        if (this.mEditorEntity == null) {
            this.mEditorEntity = ProjectBrowserView.getEntityFromDevelopmentObject(developmentObject);
        }
    }

    private void revealTree() {
        if (this.mEditorEntity != null && this.mShouldLinkWithEditor) {
            this.getTreeViewer().getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)this.mEditorEntity), true);
        }
    }

    public static DevelopmentObject getDevelopmentObjectFromEditor(IWorkbenchPart part) {
        if (part == null) {
            return null;
        }
        if (!(part instanceof IDevelopmentObjectEditor)) {
            return null;
        }
        return ((IDevelopmentObjectEditor)part).getDevelopmentObject();
    }

    public static Entity getEntityFromDevelopmentObject(DevelopmentObject developmentObject) {
        if (developmentObject == null) {
            return null;
        }
        String projectName = developmentObject.getMetamodel().getName();
        UniqueName modelUIN = ModelAccess.createModelUniqueName((String)projectName);
        Model model = ModelAccess.getModel((UniqueName)modelUIN);
        if (developmentObject instanceof DtSimpleType) {
            DtSimpleType st = (DtSimpleType)developmentObject;
            String logDicName = null;
            logDicName = st.hasLogicalDictionary() ? st.getLogicalDictionary().getName() : "Local Dictionary";
            UniqueName entityUIN = DataSourceManager.createUniqueName((DevelopmentObject)st, (String)"SimpleType", (String)logDicName);
            return model.findEntity(entityUIN);
        }
        if (developmentObject instanceof DtDbTable) {
            DtDbTable dbtable = (DtDbTable)developmentObject;
            String logDicName = null;
            logDicName = dbtable.hasLogicalDictionary() ? dbtable.getLogicalDictionary().getName() : "Local Dictionary";
            UniqueName entityUIN = DataSourceManager.createUniqueName((DevelopmentObject)dbtable, (String)"DbTable", (String)logDicName);
            return model.findEntity(entityUIN);
        }
        if (developmentObject instanceof DtGeneralStructure) {
            DtGeneralStructure dtStructure = (DtGeneralStructure)developmentObject;
            String logDicName = null;
            logDicName = dtStructure.hasLogicalDictionary() ? dtStructure.getLogicalDictionary().getName() : "Local Dictionary";
            UniqueName entityUIN = DataSourceManager.createUniqueName((DevelopmentObject)dtStructure, (String)"Structure", (String)logDicName);
            return model.findEntity(entityUIN);
        }
        if (developmentObject instanceof DtDbView) {
            DtDbView dtDbView = (DtDbView)developmentObject;
            String logDicName = null;
            logDicName = dtDbView.hasLogicalDictionary() ? dtDbView.getLogicalDictionary().getName() : "Local Dictionary";
            UniqueName entityUIN = DataSourceManager.createUniqueName((DevelopmentObject)dtDbView, (String)"DbView", (String)logDicName);
            return model.findEntity(entityUIN);
        }
        return null;
    }

    public void setFocus() {
        if (this.getTreeViewer() != null) {
            this.getTreeViewer().getTree().setFocus();
        }
    }

    protected GenericDataModelFilteredTreeViewer getTreeViewer() {
        return this.mTreeViewer;
    }

    protected void setTreeViewer(GenericDataModelFilteredTreeViewer treeViewer) {
        this.mTreeViewer = treeViewer;
    }

    public void dispose() {
        if (this.mSelectedElement != null) {
            String projectName = this.mSelectedElement.getModel().getUniqueName().getName();
            UniqueName uin = this.mSelectedElement.getUniqueName();
            ((Hashtable)properties).put(PROP_PROJECT_NAME, projectName);
            ((Hashtable)properties).put(PROP_DOMAIN, uin.getDomain());
            ((Hashtable)properties).put(PROP_SUBDOMAIN, uin.getSubDomain());
            ((Hashtable)properties).put(PROP_LOCATION, uin.getLocation());
            ((Hashtable)properties).put(PROP_NAME, uin.getName());
        }
        this.saveProperties();
    }

    static /* synthetic */ void access$200(ProjectBrowserView x0) {
        x0.refreshTree();
    }

    private class TreeSelectionListener
    implements ISelectionChangedListener {
        private TreeSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            StructuredSelection structuredSelection;
            Object object;
            ISelection selection;
            IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
            if (part instanceof ProjectBrowserView && (selection = event.getSelection()) instanceof StructuredSelection && (object = (structuredSelection = (StructuredSelection)selection).getFirstElement()) instanceof Element) {
                ProjectBrowserView.this.mSelectedElement = (Element)object;
            }
        }
    }

    private class ToggleLinkWithEditorAction
    extends Action {
        private ToggleLinkWithEditorAction() {
        }

        public void run() {
            if (this.isChecked()) {
                ProjectBrowserView.this.mShouldLinkWithEditor = true;
                ProjectBrowserView.this.revealTree();
            } else {
                ProjectBrowserView.this.mShouldLinkWithEditor = false;
            }
            ((Hashtable)properties).put(propLinkToEditor, new Boolean(ProjectBrowserView.this.mShouldLinkWithEditor).toString());
            ProjectBrowserView.this.mToolBarManager.update(true);
        }

        public int getStyle() {
            return 2;
        }

        public String getToolTipText() {
            return "Link with Editor";
        }

        public ImageDescriptor getImageDescriptor() {
            return SapIdeUtilImages.getSapImageDescriptor((ISapImage)DictionaryImage.ICON_LINK_WITH_EDITOR);
        }
    }

    private class CollapseAllAction
    extends Action {
        private CollapseAllAction() {
        }

        public void run() {
            ProjectBrowserView.this.getTreeViewer().getTreeViewer().collapseAll();
        }

        public String getToolTipText() {
            return "Collapse All";
        }

        public ImageDescriptor getImageDescriptor() {
            return SapIdeUtilImages.getSapImageDescriptor((ISapImage)DictionaryImage.ICON_COLLAPSE_ALL);
        }
    }
}

