/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.projectbrowser.views;

import com.sap.dictionary.projectbrowser.ProjectBrowserPlugin;
import com.sap.dictionary.projectbrowser.actions.PBCopyAction;
import com.sap.dictionary.projectbrowser.actions.PBDeleteAction;
import com.sap.dictionary.projectbrowser.actions.PBDeleteDbTableAction;
import com.sap.dictionary.projectbrowser.actions.PBDeleteSimpletypeAction;
import com.sap.dictionary.projectbrowser.actions.PBEditDbIndexAction;
import com.sap.dictionary.projectbrowser.actions.PBEditDbTableAction;
import com.sap.dictionary.projectbrowser.actions.PBEditSimpletypeAction;
import com.sap.dictionary.projectbrowser.actions.PBPasteAction;
import com.sap.dictionary.projectbrowser.filters.DictionaryFilter;
import com.sap.dictionary.projectbrowser.tree.ProjectBrowserTreeLabels;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.IMetamodelSaveParticipant;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.core.services.MetamodelImage;
import com.sap.ide.metamodel.general.MetamodelObject;
import com.sap.ide.metamodel.general.clipboard.MetamodelClipboard;
import com.tssap.dii.component.DCToolbox;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ModelAccessEvent;
import com.tssap.selena.model.elements.ModelAccessListener;
import com.tssap.selena.model.elements.ModelChangeEvent;
import com.tssap.selena.model.elements.ModelChangeListener;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.enum.EntityEnumeration;
import com.tssap.selena.model.extension.filter.IFilter;
import com.tssap.util.action.path.ContextDependentPathProvider;
import com.tssap.util.action.path.IPathProvider;
import com.tssap.util.ui.IContext;
import com.tssap.util.ui.IContextProvider;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.menu.IMenuFactory;
import com.tssap.util.ui.menu.MenuFactory;
import com.tssap.util.ui.menu.context.ContextMenu;
import com.tssap.util.ui.menu.context.DynamicContextMenu;
import com.tssap.util.ui.menu.context.IContextMenu;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.ui.actions.OpenProjectAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeAdapter;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class MyProjectBrowserView
extends ViewPart {
    ProjectBrowserTreeLabels pbTreeLabels = new ProjectBrowserTreeLabels();
    ILabelProvider dcMetaDataLabelProvider = DCToolbox.getDCMetaDataLabelProvider();
    DictionaryFilter ddicFilter = new DictionaryFilter();
    IFilter logFilter = DCToolbox.getDCMetaDataFilter();
    MyModelUpdater modelUpdater;
    Tree tree;
    TreeItem item;
    TreeItem item2;
    Vector modelVector;
    private Action copyAction;
    private Action pasteAction;
    public static Properties properties = new Properties();
    public static String propHideDeletedTables = "Hide deleted tables";

    public MyProjectBrowserView() {
        this.readProperties();
    }

    private void readProperties() {
        try {
            File f = new File(ProjectBrowserPlugin.getDefault().getStateLocation() + "/prop.txt");
            if (f.exists()) {
                FileInputStream in = new FileInputStream(f);
                properties.load(in);
                in.close();
            }
        }
        catch (Exception e) {
            ProjectBrowserPlugin.tracer.error("load properties:", (Throwable)e);
        }
    }

    private void saveProperties() {
        try {
            FileOutputStream out = new FileOutputStream(ProjectBrowserPlugin.getDefault().getStateLocation() + "/prop.txt");
            properties.store(out, "project_explorer");
            out.close();
        }
        catch (Exception e) {
            ProjectBrowserPlugin.tracer.error("save properties:", (Throwable)e);
        }
    }

    private synchronized TreeItem createRootTreeItem(Tree t, Entity da, ILabelProvider prov) {
        this.tree = t;
        final ILabelProvider provider = prov;
        final Entity data = da;
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                String text = provider.getText((Object)data);
                TreeItem[] treeItems = MyProjectBrowserView.this.tree.getItems();
                int index = 0;
                int i = 0;
                while (i < treeItems.length) {
                    index = i;
                    String treeText = treeItems[i].getText();
                    if (treeText.toLowerCase().compareTo(text.toLowerCase()) > 0) break;
                    ++index;
                    ++i;
                }
                MyProjectBrowserView.this.item = new TreeItem(MyProjectBrowserView.this.tree, 0, index);
                MyProjectBrowserView.this.item.setText(text);
                MyProjectBrowserView.this.item.setImage(provider.getImage((Object)data));
                MyProjectBrowserView.this.item.setData((Object)data);
                TreeItem dummy = new TreeItem(MyProjectBrowserView.this.item, 0);
                dummy.setText("123");
            }
        });
        return this.item;
    }

    private synchronized TreeItem createTreeItem(TreeItem t, Entity da, ILabelProvider prov) {
        this.item = t;
        final Entity data = da;
        final ILabelProvider provider = prov;
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                String text = provider.getText((Object)data);
                TreeItem[] treeItems = MyProjectBrowserView.this.item.getItems();
                int index = 0;
                int i = 0;
                while (i < treeItems.length) {
                    index = i;
                    String treeText = treeItems[i].getText();
                    if (treeText.toLowerCase().compareTo(text.toLowerCase()) > 0) break;
                    ++index;
                    ++i;
                }
                MyProjectBrowserView.this.item2 = new TreeItem(MyProjectBrowserView.this.item, 0, index);
                MyProjectBrowserView.this.item2.setText(text);
                MyProjectBrowserView.this.item2.setImage(provider.getImage((Object)data));
                MyProjectBrowserView.this.item2.setData((Object)data);
            }
        });
        return this.item2;
    }

    public void createPartControl(Composite parent) {
        this.tree = new Tree(parent, 2);
        this.tree.addTreeListener((TreeListener)new TreeAdapter(){

            public void treeExpanded(TreeEvent e) {
                TreeItem[] dummy;
                super.treeExpanded(e);
                TreeItem item = (TreeItem)e.item;
                if (item.getItemCount() == 1 && (dummy = item.getItems())[0].getText().equals("123")) {
                    dummy[0].dispose();
                    MyProjectBrowserView.this.getChildren((Entity)item.getData(), item);
                    item.setExpanded(true);
                }
            }
        });
        this.modelVector = new Vector();
        Enumeration enumeration = ModelAccess.models();
        while (enumeration.hasMoreElements()) {
            Object element = enumeration.nextElement();
            if (!(element instanceof Model) || !this.ddicFilter.isAvailable((PropertyMap)((Model)element))) continue;
            ((Model)element).childEntities();
            this.modelVector.add(element);
            Display.getDefault().readAndDispatch();
        }
        new Thread(new Runnable(){

            public void run() {
                int i = 0;
                while (i < MyProjectBrowserView.this.modelVector.size()) {
                    Model model = (Model)MyProjectBrowserView.this.modelVector.get(i);
                    MyProjectBrowserView.this.createRootTreeItem(MyProjectBrowserView.this.tree, (Entity)model, (ILabelProvider)MyProjectBrowserView.this.pbTreeLabels);
                    ++i;
                }
            }
        }).start();
        Model[] models = new Model[]{};
        models = this.modelVector.toArray(models);
        this.modelUpdater = new MyModelUpdater(models);
        this.tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TreeItem[] items = MyProjectBrowserView.this.tree.getSelection();
                int i = 0;
                while (i < items.length) {
                    Entity entity = (Entity)items[i].getData();
                    String metaclass = entity.getPropertyValue("$metaclass");
                    Element[] elements = new Element[]{entity};
                    if (metaclass.equals("DDSimpleType")) {
                        PBEditSimpletypeAction editSimpletypeAction = new PBEditSimpletypeAction();
                        editSimpletypeAction.run(elements[0]);
                    }
                    if (metaclass.equals("DDDbTable")) {
                        PBEditDbTableAction editDbTableAction = new PBEditDbTableAction();
                        editDbTableAction.run(elements[0]);
                    }
                    if (metaclass.equals("DDDbIndex")) {
                        PBEditDbIndexAction editDbIndexAction = new PBEditDbIndexAction();
                        editDbIndexAction.run(elements[0]);
                    }
                    ++i;
                }
            }
        });
        this.setDragDrop();
        this.tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u007f') {
                    TreeItem[] items = MyProjectBrowserView.this.tree.getSelection();
                    int i = 0;
                    while (i < items.length) {
                        Entity entity = (Entity)items[i].getData();
                        String metaclass = entity.getPropertyValue("$metaclass");
                        Element[] elements = new Element[]{entity};
                        if (metaclass.equals("DDSimpleType")) {
                            PBDeleteSimpletypeAction deleteStAction = new PBDeleteSimpletypeAction();
                            deleteStAction.run(elements);
                        } else if (metaclass.equals("Model")) {
                            PBDeleteAction deleteAction = new PBDeleteAction();
                            deleteAction.run(elements);
                        } else if (metaclass.equals("DDDbTable")) {
                            PBDeleteDbTableAction deleteDbTableAction = new PBDeleteDbTableAction();
                            deleteDbTableAction.run(elements);
                        }
                        ++i;
                    }
                }
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)new MySelectionConverter(this.tree));
        this.setSystemMenuEntries();
        this.setViewMenu();
        MenuFactory menuFactory = new MenuFactory();
        menuFactory.getPathProviderManager().addPathProvider((IPathProvider)new ContextDependentPathProvider(false));
        DynamicContextMenu contextMenu = new DynamicContextMenu((IMenuFactory)menuFactory);
        ContextMenu.setContextMenuToControl((Control)this.tree, (IContextMenu)contextMenu, (IContextProvider)new MySelectionContext());
    }

    private void getChildren(Entity p, TreeItem i) {
        Entity parent = p;
        TreeItem item = i;
        EntityEnumeration enum2 = parent.childEntities();
        while (enum2.hasMoreElements()) {
            Entity child = enum2.next();
            if (child == null) continue;
            if (this.ddicFilter.isAvailable((PropertyMap)child)) {
                this.item2 = this.createTreeItem(item, child, (ILabelProvider)this.pbTreeLabels);
                this.getChildren(child, this.item2);
                continue;
            }
            if (!this.logFilter.isAvailable((PropertyMap)child)) continue;
            this.item2 = this.createTreeItem(item, child, this.dcMetaDataLabelProvider);
            this.getChildren(child, this.item2);
        }
    }

    private void removeRoot(Entity entity) {
        TreeItem[] items = this.tree.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getData() == entity) {
                this.tree.setRedraw(false);
                items[i].dispose();
                this.tree.setRedraw(true);
                return;
            }
            ++i;
        }
    }

    private TreeItem findTreeChildren(TreeItem item, Entity child) {
        TreeItem[] items = item.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getData() == child) {
                return items[i];
            }
            TreeItem lItem = this.findTreeChildren(items[i], child);
            if (lItem != null) {
                return lItem;
            }
            ++i;
        }
        return null;
    }

    private void refreshProjectItems(TreeItem changedItem, Entity entity) {
        EntityEnumeration enum2 = entity.childEntities();
        TreeItem parent = null;
        Vector<Entity> children = new Vector<Entity>();
        Vector<TreeItem> itemList = new Vector<TreeItem>(Arrays.asList(changedItem.getItems()));
        while (enum2.hasMoreElements()) {
            Entity child = enum2.next();
            if (child == null) continue;
            children.add(child);
        }
        int i = 0;
        while (i < children.size()) {
            int j;
            Entity child = (Entity)children.get(i);
            if (this.ddicFilter.isAvailable((PropertyMap)child)) {
                parent = this.findTreeChildren(changedItem, child);
                if (parent == null) {
                    parent = this.item2 = this.createTreeItem(changedItem, child, (ILabelProvider)this.pbTreeLabels);
                } else {
                    parent.setImage(this.pbTreeLabels.getImage(child));
                    parent.setText(this.pbTreeLabels.getText(child));
                    j = 0;
                    while (j < itemList.size()) {
                        if (itemList.get(j) == parent) {
                            itemList.remove(j);
                            break;
                        }
                        ++j;
                    }
                }
                this.refreshProjectItems(parent, child);
            } else if (this.logFilter.isAvailable((PropertyMap)child)) {
                parent = this.findTreeChildren(changedItem, child);
                if (parent == null) {
                    parent = this.item2 = this.createTreeItem(changedItem, child, this.dcMetaDataLabelProvider);
                } else {
                    parent.setImage(this.dcMetaDataLabelProvider.getImage((Object)child));
                    parent.setText(this.dcMetaDataLabelProvider.getText((Object)child));
                    j = 0;
                    while (j < itemList.size()) {
                        if (itemList.get(j) == parent) {
                            itemList.remove(j);
                            break;
                        }
                        ++j;
                    }
                }
                this.refreshProjectItems(parent, child);
            }
            ++i;
        }
        int j = 0;
        while (j < itemList.size()) {
            itemList.get(j).dispose();
            ++j;
        }
    }

    private void refreshProject(Model model) {
        TreeItem changedItem = null;
        TreeItem[] items = this.tree.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getData() == model) {
                changedItem = items[i];
                break;
            }
            ++i;
        }
        if (changedItem != null) {
            this.refreshProjectItems(changedItem, (Entity)model);
        } else if (this.ddicFilter.isAvailable((PropertyMap)model)) {
            this.createRootTreeItem(this.tree, (Entity)model, (ILabelProvider)this.pbTreeLabels);
            this.getChildren((Entity)model, this.item);
        }
    }

    private void refreshAll() {
        TreeItem[] items = this.tree.getItems();
        Enumeration enumeration = ModelAccess.models();
        block0: while (enumeration.hasMoreElements()) {
            Object element = enumeration.nextElement();
            if (!(element instanceof Model) || !this.ddicFilter.isAvailable((PropertyMap)((Model)element))) continue;
            int i = 0;
            while (i < items.length) {
                if (items[i].getData() == element) {
                    this.refreshProjectItems(items[i], (Entity)element);
                    continue block0;
                }
                ++i;
            }
        }
    }

    public void setFocus() {
        this.tree.setFocus();
    }

    public void dispose() {
        this.modelUpdater.unregister();
        this.saveProperties();
    }

    private void setDragDrop() {
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        int operations = 3;
        DragSource source = new DragSource((Control)this.tree, operations);
        source.setTransfer(types);
        source.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                TreeItem[] items = MyProjectBrowserView.this.tree.getSelection();
                int i = 0;
                while (i < items.length) {
                    Entity entity;
                    String subdomain;
                    Object obj = items[i].getData();
                    if (obj instanceof Entity && !(subdomain = (entity = (Entity)obj).getUniqueName().getSubDomain()).equals("DbTable") && !subdomain.equals("SimpleType")) {
                        event.doit = false;
                        return;
                    }
                    ++i;
                }
                event.doit = true;
            }

            public void dragSetData(DragSourceEvent event) {
                TreeItem[] items = MyProjectBrowserView.this.tree.getSelection();
                Element[] elements = new Element[items.length];
                int i = 0;
                while (i < items.length) {
                    elements[i] = (Element)items[i].getData();
                    ++i;
                }
                new PBCopyAction().run(elements);
                event.data = "Hallo";
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        DropTarget target = new DropTarget((Control)this.tree, operations);
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragOver(DropTargetEvent event) {
                super.dragOver(event);
                event.detail = event.item.getData() instanceof Model ? 1 : 0;
            }

            public void drop(DropTargetEvent event) {
                Object obj = event.item.getData();
                new PBPasteAction().run((Element)obj);
                event.detail = 0;
            }
        });
    }

    private void setSystemMenuEntries() {
        this.getViewSite().getActionBars().setGlobalActionHandler("closeProject", (IAction)new Action(){

            public void run() {
                TreeItem[] items = MyProjectBrowserView.this.tree.getSelection();
                int i = 0;
                while (i < items.length) {
                    Element element = (Element)items[i].getData();
                    String projectName = element.getModel().getUniqueName().getName();
                    if (projectName != null && projectName.length() > 0) {
                        IProject eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                        try {
                            MyProjectBrowserView.this.closeProjectEditors(eclipseProject);
                            eclipseProject.close((IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (CoreException e) {
                            ProjectBrowserPlugin.tracer.error("close project editors", (Throwable)e);
                            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error", (String)("Could not close Project. Reason: " + e.getMessage() + "."));
                        }
                    }
                    ++i;
                }
            }
        });
        this.getViewSite().getActionBars().setGlobalActionHandler("openProject", (IAction)new Action(){

            public void run() {
                OpenProjectAction action = new OpenProjectAction((IWorkbenchSite)MyProjectBrowserView.this.getSite());
                action.run();
            }
        });
        this.copyAction = new Action(){

            public void run() {
                TreeItem[] items = MyProjectBrowserView.this.tree.getSelection();
                Element[] elements = new Element[items.length];
                int i = 0;
                while (i < items.length) {
                    elements[i] = (Element)items[i].getData();
                    ++i;
                }
                new PBCopyAction().run(elements);
                MyProjectBrowserView.this.pasteAction.setEnabled(true);
            }
        };
        this.getViewSite().getActionBars().setGlobalActionHandler("copy", (IAction)this.copyAction);
        this.pasteAction = new Action(){

            public void run() {
                TreeItem[] items = MyProjectBrowserView.this.tree.getSelection();
                if (items.length > 0) {
                    Element element = (Element)items[0].getData();
                    new PBPasteAction().run(element);
                }
            }
        };
        this.pasteAction.setEnabled(false);
        this.getViewSite().getActionBars().setGlobalActionHandler("paste", (IAction)this.pasteAction);
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                TreeItem[] items = MyProjectBrowserView.this.tree.getSelection();
                if (items.length == 1) {
                    Element element = (Element)items[0].getData();
                    String projectName = element.getModel().getUniqueName().getName();
                    if (projectName != null && projectName.length() > 0) {
                        IProject eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                        if (eclipseProject != null) {
                            Metamodel metamodel = MetamodelManager.getMetamodel((String)projectName);
                            MetamodelClipboard clipboard = Metamodel.getClipboard();
                            if (clipboard.isPasteAllowed((MetamodelObject)DataSourceManager.getDataSourceManager((String)projectName).getDictionaryRoot())) {
                                MyProjectBrowserView.this.pasteAction.setEnabled(true);
                            } else {
                                MyProjectBrowserView.this.pasteAction.setEnabled(false);
                            }
                        } else {
                            MyProjectBrowserView.this.pasteAction.setEnabled(false);
                        }
                    } else {
                        MyProjectBrowserView.this.pasteAction.setEnabled(false);
                    }
                } else {
                    MyProjectBrowserView.this.pasteAction.setEnabled(false);
                }
            }
        });
    }

    private void setViewMenu() {
        Action hideAction = new Action("Hide deleted tables"){

            public void run() {
                if (this.isChecked()) {
                    DictionaryFilter.mHideDeletedTables = true;
                    ((Hashtable)properties).put(propHideDeletedTables, new String("true"));
                } else {
                    DictionaryFilter.mHideDeletedTables = false;
                    ((Hashtable)properties).put(propHideDeletedTables, new String("false"));
                }
                MyProjectBrowserView.this.refreshAll();
            }
        };
        if (((Hashtable)properties).containsKey(propHideDeletedTables)) {
            Boolean ret = new Boolean((String)((Hashtable)properties).get(propHideDeletedTables));
            DictionaryFilter.mHideDeletedTables = ret;
            hideAction.setChecked(ret.booleanValue());
        } else {
            hideAction.setChecked(false);
        }
        IMenuManager mgr = this.getViewSite().getActionBars().getMenuManager();
        mgr.add((IAction)hideAction);
        Action refreshAction = new Action(){

            public void run() {
                super.run();
                Display.getDefault().asyncExec(new Runnable(this){
                    private final /* synthetic */ 15 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        if (!15.access$600(this.this$1).tree.isDisposed()) {
                            MyProjectBrowserView.access$500(15.access$600(this.this$1));
                        }
                    }
                });
            }

            static /* synthetic */ MyProjectBrowserView access$600(15 x0) {
                return x0.MyProjectBrowserView.this;
            }
        };
        refreshAction.setImageDescriptor(SapIdeUtilImages.getSapImageDescriptor((ISapImage)MetamodelImage.ICON_REFRESH_ECLIPSE));
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)refreshAction);
    }

    private void closeProjectEditors(IProject project) {
        ArrayList dirtyEditors = new ArrayList(0);
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        Metamodel pMm = MetamodelManager.getMetamodel((String)project.getName());
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int j = 0;
            while (j < pages.length) {
                IWorkbenchPage page = pages[j];
                IEditorReference[] editors = page.getEditorReferences();
                int k = 0;
                while (k < editors.length) {
                    IFile inputFile;
                    IEditorInput input;
                    IMetamodelSaveParticipant participant;
                    IEditorPart editor = editors[k].getEditor(true);
                    if (editor instanceof IMetamodelSaveParticipant && (participant = (IMetamodelSaveParticipant)editor).getMetamodel() == pMm) {
                        participant.preSave();
                        page.closeEditor(editor, true);
                    }
                    if ((input = editor.getEditorInput()) instanceof IFileEditorInput && project == (inputFile = ((IFileEditorInput)input).getFile()).getProject()) {
                        page.closeEditor(editor, true);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private class MySelectionConverter
    implements ISelectionProvider,
    SelectionListener,
    ISelectionChangedListener {
        private HashSet myListeners = new HashSet();
        private Tree mTree;

        public MySelectionConverter(Tree viewer) {
            this.mTree = viewer;
            this.mTree.addSelectionListener((SelectionListener)this);
        }

        public ISelection getSelection() {
            TreeItem[] items = this.mTree.getSelection();
            int i = 0;
            while (i < items.length) {
                Entity entity = (Entity)items[i].getData();
                String projectName = entity.getModel().getUniqueName().getName();
                if (projectName != null && projectName.length() > 0) {
                    IProject eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                    return new StructuredSelection((Object)eclipseProject);
                }
                ++i;
            }
            return new StructuredSelection();
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.myListeners.add(listener);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.myListeners.remove(listener);
        }

        public void setSelection(ISelection selection) {
        }

        public void widgetSelected(SelectionEvent e) {
            this.selectionChanged(null);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            SelectionChangedEvent propertyEvent = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
            Iterator it = this.myListeners.iterator();
            while (it.hasNext()) {
                ((ISelectionChangedListener)it.next()).selectionChanged(propertyEvent);
            }
        }
    }

    private class MyModelUpdater
    implements ModelAccessListener,
    ModelChangeListener {
        private boolean updateModels = true;
        private boolean updateModelContent = true;
        private ArrayList myKnownModels = new ArrayList();

        public MyModelUpdater(Model[] models) {
            this.myKnownModels.addAll(Arrays.asList(models));
            int i = 0;
            while (i < models.length) {
                Model model = models[i];
                model.addModelDeltaListener((ModelChangeListener)this);
                ++i;
            }
            ModelAccess.addModelAccessListener((ModelAccessListener)this);
        }

        public void unregister() {
            Model[] models = this.myKnownModels.toArray(new Model[this.myKnownModels.size()]);
            int i = 0;
            while (i < models.length) {
                Model model = models[i];
                model.removeModelDeltaListener((ModelChangeListener)this);
                ++i;
            }
            ModelAccess.removeModelAccessListener((ModelAccessListener)this);
        }

        public void modelCreated(ModelAccessEvent event) {
            Model model = event.getModel();
            if (this.isUpdateModels() && MyProjectBrowserView.this.ddicFilter.isAvailable((PropertyMap)model)) {
                MyProjectBrowserView.this.createRootTreeItem(MyProjectBrowserView.this.tree, (Entity)model, (ILabelProvider)MyProjectBrowserView.this.pbTreeLabels);
                MyProjectBrowserView.this.getChildren((Entity)model, MyProjectBrowserView.this.item);
            }
            model.addModelDeltaListener((ModelChangeListener)this);
            this.myKnownModels.add(model);
        }

        public void modelRemoved(ModelAccessEvent event) {
            Model model = event.getModel();
            if (this.isUpdateModels()) {
                MyProjectBrowserView.this.removeRoot((Entity)model);
            }
            model.removeModelDeltaListener((ModelChangeListener)this);
            ((AbstractCollection)this.myKnownModels).remove(model);
        }

        public void modelChanged(ModelChangeEvent changeEvent) {
            if (this.isUpdateModelContent()) {
                Model model = changeEvent.getModel();
                MyProjectBrowserView.this.refreshProject(model);
            }
        }

        public boolean isUpdateModelContent() {
            return this.updateModelContent;
        }

        public boolean isUpdateModels() {
            return this.updateModels;
        }

        public void setUpdateModelContent(boolean updateModelContent) {
            this.updateModelContent = updateModelContent;
        }

        public void setUpdateModels(boolean updateModels) {
            this.updateModels = updateModels;
        }
    }

    private class MySelectionContext
    implements IContext,
    IContextProvider {
        private MySelectionContext() {
        }

        public Object[] getContextObjects() {
            TreeItem[] items = MyProjectBrowserView.this.tree.getSelection();
            Object[] data = new Object[items.length];
            int i = 0;
            while (i < items.length) {
                data[i] = items[i].getData();
                ++i;
            }
            return data;
        }

        public IContext getContext() {
            return this;
        }
    }
}

