/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.projectbrowser.tree;

import com.sap.dictionary.projectbrowser.ProjectBrowserPlugin;
import com.sap.dictionary.projectbrowser.views.ProjectBrowserView;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.dictionary.tools.ui.image.DecoratedImageDescriptor;
import com.sap.dictionary.tools.ui.image.DictionaryImage;
import com.sap.ide.generationfwk.eclipse.marker.GenerationMarker;
import com.sap.ide.metamodel.core.plugin.DtrHelper;
import com.sap.ide.metamodel.dictionary.datatype.DtDbIndex;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.dictionary.datatype.DtDbView;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.DAVTeamProvider;
import com.tssap.dtr.client.eclipse.ui.DAVDecorator;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.ui.treeviewer.DataModelTreeLabelProvider;
import com.tssap.selena.model.extension.util.SelenaElementUtil;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class ProjectBrowserTreeLabels
extends DataModelTreeLabelProvider {
    private static Image ddicsImage = SapIdeUtilImages.getSapImage((ISapImage)DictionaryImage.ICON_DICTIONARIES);
    private static Image ddicImage = SapIdeUtilImages.getSapImage((ISapImage)DictionaryImage.ICON_DICTIONARY);
    private static Image logDdicImage = SapIdeUtilImages.getSapImage((ISapImage)DictionaryImage.ICON_LOGICAL_DICTIONARY);
    private static Image stImage = SapIdeUtilImages.getSapImage((ISapImage)DictionaryImage.ICON_SIMPLE_TYPES);
    private static Image dataTypesImage = SapIdeUtilImages.getSapImage((ISapImage)DictionaryImage.ICON_DATA_TYPES);
    private static Image dbTablesImage = SapIdeUtilImages.getSapImage((ISapImage)DictionaryImage.ICON_DATABASE_TABLES);
    private static Image simpleTypeImage = SapIdeUtilImages.getSapImage((ISapImage)DictionaryImage.ICON_SIMPLETYPE);
    private static Image dbTableImage = SapIdeUtilImages.getSapImage((ISapImage)DictionaryImage.ICON_OUTLINE_UITABLE);
    private static Image projectImage = SapIdeUtilImages.getWorkbenchImage((String)"IMG_OBJ_PROJECT");
    private static Image errorImage = JavaPlugin.getImageDescriptorRegistry().get(JavaPluginImages.DESC_OVR_ERROR);
    private static Image warningImage = JavaPlugin.getImageDescriptorRegistry().get(JavaPluginImages.DESC_OVR_WARNING);
    private static Image indexUniqueImage = SapIdeUtilImages.getSapImage((ISapImage)DictionaryImage.ICON_OUTLINE_INDEXUNIQUE);
    private static Image indexNotUniqueImage = SapIdeUtilImages.getSapImage((ISapImage)DictionaryImage.ICON_OUTLINE_INDEXNOTUNIQUE);
    private static Image dbViews = SapIdeUtilImages.getSapImage((ISapImage)DictionaryImage.ICON_DB_VIEWS);
    private static Image dbView = SapIdeUtilImages.getSapImage((ISapImage)DictionaryImage.ICON_DB_VIEW);
    private static Image structures = SapIdeUtilImages.getSapImage((ISapImage)DictionaryImage.ICON_STRUCTURES);
    private static Image structure = SapIdeUtilImages.getSapImage((ISapImage)DictionaryImage.ICON_STRUCTURE);

    public Image getImage(Object element) {
        if (((Hashtable)ProjectBrowserView.properties).containsKey(ProjectBrowserView.propHideDcStuff) && ((String)((Hashtable)ProjectBrowserView.properties).get(ProjectBrowserView.propHideDcStuff)).equals("true")) {
            return null;
        }
        Image image = super.getImage(element);
        if (element instanceof Entity) {
            IFile file;
            Entity entity = (Entity)element;
            String metaclass = entity.getPropertyValue("$metaclass");
            if (metaclass == null) {
                return null;
            }
            Model tsModel = entity.getModel();
            if (tsModel == null) {
                return null;
            }
            if (!SelenaElementUtil.isProjectModelUniqueName((UniqueName)tsModel.getUniqueName())) {
                return null;
            }
            if (metaclass.equals("DDDictionaries")) {
                image = ddicsImage;
            } else if (metaclass.equals("DDDictionary")) {
                image = entity.getUniqueName().getLocation().equals("Local Dictionary") ? ddicImage : logDdicImage;
            } else if (metaclass.equals("DDSimpleTypes")) {
                image = stImage;
            } else if (metaclass.equals("DDDataTypes")) {
                image = dataTypesImage;
            } else if (metaclass.equals("DDDbTables")) {
                image = dbTablesImage;
            } else if (metaclass.equals("DDSimpleType")) {
                image = simpleTypeImage;
            } else if (metaclass.equals("DDDbTable")) {
                image = dbTableImage;
            } else if (metaclass.equals("DDDbViews")) {
                image = dbViews;
            } else if (metaclass.equals("DDDbView")) {
                image = dbView;
            } else if (metaclass.equals("DDStructures")) {
                image = structures;
            } else if (metaclass.equals("DDStructure")) {
                image = structure;
            } else {
                IResource resource;
                UniqueName uniqueName = entity.getUniqueName();
                Object dataSource = entity.getObjectPropertyValue("FileAndFolderDataSource");
                if (dataSource == null) {
                    if (SelenaElementUtil.isProjectModelUniqueName((UniqueName)uniqueName)) {
                        image = projectImage;
                        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(uniqueName.getName());
                        try {
                            if (GenerationMarker.hasMarkers((String)"com.sap.dictionary.tools.generation", (IProject)proj)) {
                                Image data = errorImage;
                                Vector<Image> images = new Vector<Image>();
                                images.add(data);
                                Vector<Integer> imageKeys = new Vector<Integer>();
                                imageKeys.add(new Integer(4));
                                DecoratedImageDescriptor imageDesc = new DecoratedImageDescriptor(image, images, imageKeys);
                                image = imageDesc.getImage();
                            }
                        }
                        catch (Exception e) {
                            ProjectBrowserPlugin.tracer.error("create error images", (Throwable)e);
                        }
                    }
                } else if (dataSource instanceof IResource && (resource = (IResource)dataSource) instanceof IProject) {
                    image = projectImage;
                }
            }
            String projectName = entity.getModel().getUniqueName().getName();
            IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            if (metaclass.equals("DDDbTable") || metaclass.equals("DDSimpleType") || metaclass.equals("DDStructure") || metaclass.equals("DDDbView")) {
                MainDevelopmentObject mdo = (MainDevelopmentObject)DataSourceManager.getDataSourceManager((String)projectName).getDevelopmentObject(entity.getUniqueName());
                if (mdo != null) {
                    IVfsFolderItem vfsFolderItem;
                    DAVTeamProvider teamProvider;
                    file = myWorkspaceRoot.getFileForLocation((IPath)new Path(mdo.getAbsolutePath()));
                    boolean error = false;
                    if (file != null && file.exists()) {
                        try {
                            int severity = 0;
                            IMarker[] problems = file.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                            int i = 0;
                            while (i < problems.length) {
                                int sev;
                                Object priority = problems[i].getAttribute("severity");
                                if (priority instanceof Integer && (sev = ((Integer)priority).intValue()) > severity) {
                                    severity = sev;
                                }
                                ++i;
                            }
                            if (severity > 0) {
                                Vector<Image> images = new Vector<Image>();
                                Vector<Integer> imageKeys = new Vector<Integer>();
                                if (severity == 2) {
                                    imageKeys.add(new Integer(4));
                                    images.add(errorImage);
                                }
                                if (severity == 1) {
                                    imageKeys.add(new Integer(2));
                                    images.add(warningImage);
                                }
                                DecoratedImageDescriptor imageDesc = new DecoratedImageDescriptor(image, images, imageKeys);
                                image = imageDesc.getImage();
                                error = true;
                            }
                        }
                        catch (Exception e) {
                            ProjectBrowserPlugin.tracer.error("create error images", (Throwable)e);
                        }
                    }
                    if (!error && DtrHelper.isUserLoggedOn() && this.isDtrLabelDecoratorEnabled() && (teamProvider = BluebirdPlugin.getDAVTeamProvider((IResource)ResourcesPlugin.getWorkspace().getRoot().getProject(projectName))) != null && (vfsFolderItem = teamProvider.getFolderItem((IResource)file)) != null) {
                        boolean stretch = false;
                        image = DAVDecorator.decorateFolderItem((Image)image, (IVfsFolderItem)vfsFolderItem, (boolean)stretch);
                    }
                }
            } else if (metaclass.equals("DDDbIndex")) {
                IVfsFolderItem vfsFolderItem;
                DAVTeamProvider teamProvider;
                DtDbIndex dbIndex = (DtDbIndex)DataSourceManager.getDataSourceManager((String)projectName).getDevelopmentObject(entity.getUniqueName());
                image = dbIndex.getUnique() ? indexUniqueImage : indexNotUniqueImage;
                file = myWorkspaceRoot.getFileForLocation((IPath)new Path(dbIndex.getAbsolutePath()));
                if (file != null && file.exists() && DtrHelper.isUserLoggedOn() && this.isDtrLabelDecoratorEnabled() && (teamProvider = BluebirdPlugin.getDAVTeamProvider((IResource)ResourcesPlugin.getWorkspace().getRoot().getProject(projectName))) != null && (vfsFolderItem = teamProvider.getFolderItem((IResource)file)) != null) {
                    boolean stretch = false;
                    image = DAVDecorator.decorateFolderItem((Image)image, (IVfsFolderItem)vfsFolderItem, (boolean)stretch);
                }
            }
        }
        return image;
    }

    public String getText(Object element) {
        if (element instanceof Entity) {
            Entity entity = (Entity)element;
            String nameProperty = entity.getPropertyValue("$name");
            if (entity.getUniqueName().getSubDomain() == "DbTable" || entity.getUniqueName().getSubDomain() == "DbView") {
                String projectName = entity.getModel().getUniqueName().getName();
                DevelopmentObject dtDbTable = DataSourceManager.getDataSourceManager((String)projectName).getDevelopmentObject(entity.getUniqueName());
                String predAct = null;
                if (dtDbTable instanceof DtDbTable) {
                    predAct = ((DtDbTable)dtDbTable).getPredefinedAction();
                }
                if (dtDbTable instanceof DtDbView) {
                    predAct = ((DtDbView)dtDbTable).getPredefinedAction();
                }
                if (predAct != null && predAct.equals("DROP")) {
                    return nameProperty + " (deleted)";
                }
            }
            if (nameProperty != null) {
                return nameProperty;
            }
            String name = entity.getUniqueName().getName();
            if (name != null) {
                return name;
            }
        }
        return null;
    }

    private boolean isDtrLabelDecoratorEnabled() {
        return PlatformUI.getWorkbench().getDecoratorManager().getEnabled("com.tssap.dtr.client.eclipse.ui.decorator");
    }
}

