/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.projectbrowser.tree;

import com.tssap.selena.model.elements.Element;
import java.text.Collator;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class DictionarySorter
extends ViewerSorter {
    protected static final int CATEGORY_DICTIONARIES = 4;
    protected static final int CATEGORY_DICTIONARY = 5;

    public DictionarySorter() {
    }

    public DictionarySorter(Collator collator) {
        super(collator);
    }

    public int compare(Viewer viewer, Object obj1, Object obj2) {
        int ret = 0;
        if (obj1 instanceof Element && obj2 instanceof Element) {
            Element element1 = (Element)obj1;
            Element element2 = (Element)obj2;
            String subdomain1 = element1.getUniqueName().getSubDomain();
            String subdomain2 = element2.getUniqueName().getSubDomain();
            if (subdomain1.equals("Dictionary") && subdomain2.equals("Dictionary")) {
                if (element1.getUniqueName().getLocation().equals("Local Dictionary")) {
                    return -1;
                }
                if (element2.getUniqueName().getLocation().equals("Local Dictionary")) {
                    return 1;
                }
            }
            if (subdomain1.equals("DataTypes")) {
                return -1;
            }
            if (subdomain2.equals("DataTypes")) {
                return 1;
            }
        }
        if (ret == 0) {
            ret = super.compare(viewer, obj1, obj2);
        }
        return ret;
    }

    public int category(Object object) {
        if (object instanceof Element) {
            Element element = (Element)object;
            String subdomain = element.getUniqueName().getSubDomain();
            if (subdomain.equals("Dictionaries")) {
                return 4;
            }
            if (subdomain.equals("Dictionary")) {
                return 5;
            }
        }
        return super.category(object);
    }
}

