/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.projectbrowser.services;

import com.sap.dictionary.projectbrowser.ProjectBrowserPlugin;
import com.sap.ide.metamodel.dictionary.services.ServicesEclipse;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.util.SelenaElementUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class ServicesProjectBrowser {
    public static final String NATURE_ID_WEBDYNPRO = "com.sap.ide.webdynpro.archivebuilder.WebDynproNature";

    private static boolean hasDictionaryNature(Element element) {
        String projectName = element.getModel().getUniqueName().getName();
        return ServicesEclipse.projectHasDictionaryNature((String)projectName);
    }

    public static boolean isValidDictionaryProject(Element element) {
        return ServicesProjectBrowser.hasDictionaryNature(element);
    }

    public static boolean isValidDictionaryProject(Element[] elements) {
        boolean hasDDNature = false;
        int i = 0;
        while (i < elements.length) {
            if (!ServicesProjectBrowser.hasDictionaryNature(elements[i])) {
                return false;
            }
            hasDDNature = true;
            ++i;
        }
        return hasDDNature;
    }

    public static boolean elementBelongsToValidProject(Element element) {
        if (!(element instanceof Entity)) {
            return false;
        }
        Model selenaModel = ((Entity)element).getModel();
        if (selenaModel == null) {
            return false;
        }
        if (!SelenaElementUtil.isProjectModelUniqueName((UniqueName)selenaModel.getUniqueName())) {
            return false;
        }
        return ServicesProjectBrowser.isValidDictionaryProject(element);
    }

    public static boolean elementsBelongToValidProject(Element[] elements) {
        int i = 0;
        while (i < elements.length) {
            if (!ServicesProjectBrowser.elementBelongsToValidProject(elements[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean hasWebDynproNature(Element element) {
        String projectName = element.getModel().getUniqueName().getName();
        IProject eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IProjectNature nature = null;
        try {
            nature = eclipseProject.getNature(NATURE_ID_WEBDYNPRO);
            if (nature != null) {
                return true;
            }
        }
        catch (CoreException e) {
            ProjectBrowserPlugin.tracer.error("get nature", (Throwable)e);
        }
        return false;
    }
}

