/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.projectbrowser.actions;

import com.sap.dictionary.projectbrowser.ProjectBrowserPlugin;
import com.sap.dictionary.projectbrowser.actions.PBBaseAction;
import com.sap.dictionary.tools.tsmodel.dictionary.actions.EditDbViewInput;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.dictionary.tools.tsmodel.dictionary.utils.MetamodelServices;
import com.sap.dictionary.tools.ui.image.DictionaryImage;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.DtDbView;
import com.sap.ide.metamodel.dictionary.services.ServicesEclipse;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.extension.action.IElementSingleAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class PbEditDbViewAction
implements IElementSingleAction {
    private String text = "";

    public PbEditDbViewAction() {
    }

    public PbEditDbViewAction(String text) {
        this.text = text;
    }

    public ICategory getCategory() {
        Image image = SapIdeUtilImages.getSapImage((ISapImage)DictionaryImage.ICON_DB_VIEW);
        return Category.createDisplayableCategory((ICategory)PBBaseAction.getMainDefaultCategory(), (String)"ddic:Edit", (String)"Edit", (String)"Edit", (Image)image);
    }

    public boolean isAvailable(Element element) {
        if (element == null) {
            return false;
        }
        if (element instanceof Entity) {
            Entity entity = (Entity)element;
            String metaClass = entity.getPropertyValue("$metaclass");
            boolean enable = false;
            if (metaClass != null) {
                enable = metaClass.equals("DDDbView");
            }
            return enable;
        }
        return false;
    }

    public boolean isEnabled(Element element) {
        if (element == null) {
            return false;
        }
        return element instanceof Entity;
    }

    public void run(Element element) {
        IWorkbenchWindow dwindow;
        IWorkbenchPage page;
        if (element == null) {
            return;
        }
        if (element instanceof Entity && (page = (dwindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()).getActivePage()) != null) {
            String projectName = element.getModel().getUniqueName().getName();
            DataSourceManager manager = DataSourceManager.getDataSourceManager((String)projectName);
            DtDbView view = (DtDbView)manager.getDevelopmentObject(element.getUniqueName());
            IEditorReference[] ref = page.getEditorReferences();
            int j = 0;
            while (j < ref.length) {
                IEditorInput input = ref[j].getEditor(false).getEditorInput();
                if (input instanceof EditDbViewInput) {
                    if (((EditDbViewInput)input).dictDbView == view) {
                        try {
                            page.openEditor(input, "com.sap.dictionary.tools.dbvieweditor.MultiPageEditor");
                            return;
                        }
                        catch (PartInitException e) {
                            ProjectBrowserPlugin.tracer.error("open editor", (Throwable)e);
                        }
                    }
                } else if (input instanceof IFileEditorInput) {
                    DtDictionaryRoot lDictRoot;
                    IFile file = ((IFileEditorInput)input).getFile();
                    String lFileName = file.getFullPath().removeFileExtension().lastSegment();
                    IProject project = file.getProject();
                    String lProjectName = project.getName();
                    if (ServicesEclipse.projectHasDictionaryNature((String)lProjectName) && (lDictRoot = MetamodelServices.getDictionaryRoot((String)lProjectName)).hasView("", lFileName)) {
                        try {
                            DtDbView lview = lDictRoot.getView("", lFileName);
                            if (lview == view) {
                                try {
                                    page.openEditor(input, "com.sap.dictionary.tools.dbvieweditor.MultiPageEditor");
                                    return;
                                }
                                catch (PartInitException e) {
                                    ProjectBrowserPlugin.tracer.error("open editor", (Throwable)e);
                                }
                            }
                        }
                        catch (LoadException e) {
                            ProjectBrowserPlugin.tracer.error("open editor", (Throwable)e);
                        }
                    }
                }
                ++j;
            }
            try {
                page.openEditor((IEditorInput)new EditDbViewInput(MetamodelServices.getMetamodel((String)projectName), MetamodelServices.getDictionaryRoot((String)projectName), view), "com.sap.dictionary.tools.dbvieweditor.MultiPageEditor", true);
            }
            catch (PartInitException e) {
                ProjectBrowserPlugin.tracer.error("open editor", (Throwable)e);
            }
        }
    }
}

