/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.projectbrowser.actions;

import com.sap.dictionary.projectbrowser.ProjectBrowserPlugin;
import com.sap.dictionary.tools.archivebuilder.DictionaryProjectWizard;
import com.sap.ide.metamodel.core.actions.contextmenu.ActionCategories;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.extension.action.IElementMultiAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PBRepairAction
implements IElementMultiAction {
    public ICategory getCategory() {
        return Category.createDisplayableCategory((ICategory)ActionCategories.getMainRepairCategory(), (String)"ddic:Repair", (String)"Project Structure and Classpath", (String)"Project Structure and Classpath", null);
    }

    public boolean isAvailable(Element[] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof Entity) {
                String projectName = elements[i].getModel().getUniqueName().getName();
                IProject eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                IProjectNature nature = null;
                try {
                    nature = eclipseProject.getNature("com.sap.ide.webdynpro.archivebuilder.WebDynproNature");
                    if (nature != null) {
                        return false;
                    }
                }
                catch (CoreException e) {
                    ProjectBrowserPlugin.tracer.error("get nature", (Throwable)e);
                }
                Entity entity = (Entity)elements[i];
                String metaClass = entity.getPropertyValue("$metaclass");
                boolean enable = false;
                if (metaClass != null) {
                    enable = metaClass.equals("Model");
                }
                if (!enable) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isEnabled(Element[] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        int i = 0;
        if (i < elements.length) {
            return elements[i] instanceof Entity;
        }
        return true;
    }

    public void run(Element[] elements) {
        if (elements == null) {
            return;
        }
        boolean ret = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"Repair", (String)"Do you want to correct the classpath settings of the selected project(s)?");
        if (ret) {
            int i = 0;
            while (i < elements.length) {
                IJavaProject jp;
                IProject eclipseProject;
                String projectName = elements[i].getModel().getUniqueName().getName();
                if (projectName != null && projectName.length() > 0 && (eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) != null && elements[i] instanceof Entity && (jp = JavaCore.create((IProject)eclipseProject)) != null) {
                    DictionaryProjectWizard.addSourcePaths((IJavaProject)jp, (boolean)true);
                }
                ++i;
            }
        }
    }
}

